/*-------------------------------------*/
/*  Global Control Services            */
/*  (c) 2002 SAP AG                    */
/*-------------------------------------*/
  
/*----------------------------------------------------------------------*/
/*  General                                                             */
/*----------------------------------------------------------------------*/
// domainrelaxing
  // domainrelaxing
  
  /*var  strDomainRelaxScript  = '<S'+'CRIPT> var liBehindFirstDot = document.domain.indexOf( "." ) + 1;';
       strDomainRelaxScript += 'if (liBehindFirstDot > 0) {';
       strDomainRelaxScript += 'document.domain = document.domain.substr( liBehindFirstDot );';
       strDomainRelaxScript += '}</S'+'CRIPT>';
  */
  strDomainRelaxScript  = "";
  var docBody = null;  
//------------------------------------------------------------------------------

//----------------------------------------------------------------------------
//  Popup Object                                                        
//----------------------------------------------------------------------------
//Events provided by this Object 
// onbeforerender  = use that event to set other positions than the precalculated;
// onblur          = fired when the popup blurs, use to hide it
//----------------------------------------------------------------------------

//consts enums 
  
//----------------------------------------------------------------------------
// sapPopupSizeBehavior used with attribute o.sizebehaviour
// o.sizebehaviour.USER    - you can set the size of the popup, 
//                           use o.size.width,o.size.height
//                         
// o.sizebehaviour.CONTENT - the popup will automatically adjust to the the
//                           size of its content
//----------------------------------------------------------------------------
  sapPopupSizeBehavior     = { CONTENT : "CONTENT", USER : "USER" };
//----------------------------------------------------------------------------
if(ur_system.emptyhoverurl==null) ur_system.emptyhoverurl = ur_system.mimepath+"emptyhover.html";
document.write("<div id='urFrames'><iframe id=\"sapPopupMainId_X0\" name=\"sapPopupMainId_X0\" src=\""+ur_system.emptyhoverurl+"\" style=\"z-index:1001;display:block;position:absolute;top:-5000;width:0;height:0\"  frameborder=\"0\" border=\"no\" scrolling=\"no\" tabindex=\"-1\"></iframe></div>");
  
//----------------------------------------------------------------------------
// sapPopupPositionBehavior used with attribute o.positionbehaviour
// o.positionbehaviour.MENULEFT      - popup shows left aligned under the 
//                                     source element.
// o.positionbehaviour.MENURIGHT     - popup shows right aligned under the 
//                                     source element.
// o.positionbehaviour.BROWSERCENTER - popup shows centered in the browser 
//                                     window. 
// o.positionbehaviour.USER          - you can set the position
//                                     use o.position.left, o.position.top
//----------------------------------------------------------------------------
  
  sapPopupPositionBehavior = { MENULEFT : "MENULEFT", MENURIGHT : "MENURIGHT", BROWSERCENTER : "BROWSERCENTER", USER : "USER", SUBMENU : "SUBMENU",EVENT:"EVENT" }
//----------------------------------------------------------------------------

  var sapPopupMainId = "sapPopupMainId_X";

//Variables
  var sapPopupStore = new Array(); 
  var sapOpenLevel  = false; 
  
/*----------------------------------------------------------------------*/
/*  Constructor                                                         */
/*----------------------------------------------------------------------*/
// desc : create a new popup
// in   : sourcewindow   : DOM window object - caller window
//        stylesheets    : Array             - stylesheet urls to use in the popup
//        contentobject  : DOM element       - that contains the html to show in the popup
//        sourceobject   : DOM element       - source element to align the popup
//        sourceevent    : DOM event object  - fired on the sourceobject to position the popup
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
  function sapPopup(sourcewindow,stylesheets,contentobject,sourceobject,sourceevent,level) {
    //Attributes
    this.level = level;
    this.sizebehaviour = sapPopupSizeBehavior.CONTENT;
    this.positionbehavior = sapPopupPositionBehavior.MENULEFT;
    
    this.position = { left: -1, top: -1, right: -1, bottom: -1 };
    this.size     = { width: -1, height: -1 };
    if (document.getElementById(sapPopupMainId+(level+1))==null) {
    	 var oFramesContainer = document.getElementsByTagName("BODY").item(0);
    	 for (var f=level+1;f<level+3;f++) {
    	 	 var oFrame = document.createElement("IFRAME");
    	 	 oFrame.setAttribute("id",sapPopupMainId+(f));
    	 	 oFrame.setAttribute("name",sapPopupMainId+(f));
    	 	 oFrame.setAttribute("src",ur_system.emptyhoverurl);
    	 	 oFrame.setAttribute("style","width:0;height:0;z-index:1001;display:block;position:absolute;top:-5000;");
    	 	 oFrame.setAttribute("tabindex","-1");
    	 	 oFrame.setAttribute("frameborder","0");
    	 	 oFrame.setAttribute("border","no");
    	 	 oFrame.setAttribute("scrolling","no");
    	   oFramesContainer.appendChild(oFrame);
    	 }
    }
    
    this.frame = { object: document.getElementById(sapPopupMainId+level), 
                   window: window.frames[sapPopupMainId+level]};
    
    this.content = { html: contentobject.innerHTML,
                     size: contentobject.childNodes[0] };
    //store information about the source of that popuprequest
    this.source = { event:sourceevent, 
                    object:sourceobject, 
                    window: sourcewindow, 
                    document:sourcewindow.document, 
                    body: sourcewindow.document.getElementsByTagName("BODY").item(0) };
    
    this.canrender   = true;
    this.domainrelax = true;
    this.scrolling   = true; 
    this.stylesheets = stylesheets;

    //Methods
    this.write   = sapPopup_write;
    this.show    = sapPopup_show;
    this.showOld = sapPopup_showOld;
    this.hide    = sapPopup_hide;
    this.poscalc = sapPopup_poscalc;
    
    //Events
    this.onbeforerender  = null;
    this.onblur          = null;
        
    //define a global variable with the body element for all popups once
    if (!docBody) docBody = window.document.getElementsByTagName("BODY")[0];

    //if relative urls are used for styles try to absolute them
    for (var n=0; n<this.stylesheets.length;n++) {
      this.stylesheets[n]=relativeToAbsolutePath(this.stylesheets[n],sourcewindow.location.href);
    }

    //set a variable inside sourcewindow to itself, used to refer events back
    this.source.window.me = this.source.window;
	  if (this.source.window.ur_system.domainrelaxing==this.source.window.sapUrDomainRelaxing.MINIMAL) {
	    strDomainRelaxScript  = "<s"+"cript>var hostname = document.domain;if( !(/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}$/.test(hostname)) ) {var posBehindFirstDot = hostname.indexOf(\".\") + 1;if (posBehindFirstDot>0) {document.domain=hostname.substr(posBehindFirstDot);}};</scri"+"pt>";
	  } else {
	      if (this.source.window.ur_system.domainrelaxing==this.source.window.sapUrDomainRelaxing.MAXIMAL){
	      strDomainRelaxScript  = "<s"+"cript>try { while(document.domain.indexOf(\".\")>0) { document.domain = document.domain.substr(document.domain.indexOf(\".\")+1); }} catch(e) {}};</scri"+"pt>";
	    }
	  }
    
    sapPopupStore[this.level] = this;
    return this; 
 }
 

/*----------------------------------------------------------------------*/
/*  Methods                                                               */
/*----------------------------------------------------------------------*/
//----------------------------------------------------------------------------
// method write
//----------------------------------------------------------------------------
// desc : writes the popup into its iframe
//        internal use only
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_write(bDoNotAutoFocus) {
  //potentially this is faster with dom operations but what about relaxing domains?
  strContent = "<html><head>";
  //add domain relaxing
  if (this.domainrelax) strContent += strDomainRelaxScript;
  if( bDoNotAutoFocus )
		strContent += "<sc"+"ript>me=parent.sapPopupStore["+this.level+"].source.window;mylevel="+this.level+";</scr"+"ipt>";
	else
		strContent += "<sc"+"ript>me=parent.sapPopupStore["+this.level+"].source.window; window.focus();mylevel="+this.level+";</scr"+"ipt>";
      
  //add the content and the rest
  strContent+= "</head><body class='urBdyStd' scroll=";
  strContent+= this.scrolling?"'no'":"'auto'";
  if(this.object!=null && this.object.getAttribute("ct")!="ComboBox"){  
		strContent+= " onload='parent.sapUrMapi_PopupMenu_setEvents(parent.sapPopupStore["+this.level+"],1);'";
		if (this.level==0) {
			strContent+= " onfocus='parent.sapUrMapi_PopupMenu_setEvents(parent.sapPopupStore["+this.level+"],2);' onblur='if ((parent.sapPopupStore[mylevel]) && (!parent.sapOpenLevel)) {parent.sapPopupStore[mylevel].onblur();}'";
		} else {
			strContent+= " onfocus='parent.sapUrMapi_PopupMenu_setEvents(parent.sapPopupStore["+this.level+"],2);' onblur='if ((parent.sapPopupStore[mylevel]) && (!parent.sapOpenLevel)) {parent.sapPopupStore[mylevel].onblur();}'";
		}
	}
  strContent+= " style='margin:0;border:none;'>"+this.content.html+"</body></html>";
  //write it!
  //this.frame.window.document.open();
  this.frame.window.document.write(strContent);
  this.frame.window.document.close();

  //add stylesheets 
  for (var n=0; n<this.stylesheets.length;n++) {
    var newLink = this.frame.window.document.createElement("LINK");
    newLink.setAttribute("href",this.stylesheets[n]);
    newLink.setAttribute("type","text/css");
    newLink.setAttribute("rel","stylesheet");
    this.frame.window.document.getElementsByTagName("HEAD")[0].appendChild(newLink);
  }

}

var intLeftFramePx;
var intTopFramePx;

//----------------------------------------------------------------------------
// method poscalc
//----------------------------------------------------------------------------
// desc : calculates the position of the popup depending on 
//        - sizebehaviour
//        - positionbehavior
//        changes the position if right or/and bottom might be 
//        not in the visible area to ensure the whole popup is visible
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_poscalc() {
  //set the size of the frame depending on its content
  if (this.sizebehaviour==sapPopupSizeBehavior.CONTENT) {
    this.size.width  = this.content.size.offsetWidth;
    this.size.height = this.content.size.offsetHeight;
  } else {
    if ((this.size.width<=0) || (this.size.height<=0)) {
      showError("Please set\n   int sapPopup.size.width\n   int sapPopup.size.height\n to a value > 0.");
      this.canrender = false
    }
  } 
  //find relative position to sourceobject;
  var sourceoffset    = getAbsolutePosition(this.source.object);
  var sourcesize      = getElementSize(this.source.object);
  //event object is available
  if ( this.positionbehavior.indexOf("MENU")>-1) {
      this.position.left = sourceoffset.left;
      this.position.top  = sourceoffset.top + sourcesize.height;
      if (this.positionbehavior == sapPopupPositionBehavior.MENURIGHT) {
	      this.position.left = this.position.left + sourcesize.width - this.size.width;
      }
      
      if (this.positionbehavior == sapPopupPositionBehavior.SUBMENU) {
	    this.position.left = this.position.left + sourcesize.width;
	    this.position.top  = this.position.top - sourcesize.height;
        if (this.level>0) { 
          this.position.left = this.position.left+sapPopupStore[this.level-1].position.left;
          this.position.top = this.position.top+sapPopupStore[this.level-1].position.top;
        } 
      }
      //calculate right and bottom 
      this.position = setPosBottomRight(window, this.position, this.size)
      
      // if submenue does not fit on usual place,
      // try to position on other side of parent menu,
      // but only, of there is enough space available
      var setsubmenubelow=false;
      if (this.positionbehavior == sapPopupPositionBehavior.SUBMENU) {
        if (this.position.right<0) {
          if (this.position.left-(sourcesize.width)+7-this.size.width>window.pageXOffset) {
            this.position.left=this.position.left-(sourcesize.width)+7-this.size.width;
          } else {
            this.position.top = this.position.top + sourcesize.height;
            setsubmenubelow=true;
          }
          //calculate right and bottom 
          this.position = setPosBottomRight(window, this.position, this.size)
        } 
      }     
    
      //reposition horizontally
      if (this.position.right<0) this.position.left  = window.innerWidth + window.pageXOffset - this.size.width;
      if (this.position.left-window.pageXOffset<0) this.position.left  = 0 + window.pageXOffset;
      // reposition vertically
      if (this.position.bottom<0) {											 //too bottom
        if (this.positionbehavior == sapPopupPositionBehavior.SUBMENU) {
          if (setsubmenubelow) 
            this.position.top = this.position.top - sourcesize.height - this.size.height; 
          else  
            this.position.top = this.position.top + sourcesize.height - this.size.height; 
        }  
        if ((this.positionbehavior == sapPopupPositionBehavior.MENULEFT) ||
            (this.positionbehavior == sapPopupPositionBehavior.MENURIGHT)) {
          this.position.top = this.position.top - sourcesize.height - this.size.height;  
        }
      }  
      if (this.position.top-window.pageYOffset<0) this.position.top  = 0 + window.pageYOffset;
        
      //recalculate right and bottom according to changed values
      this.position = setPosBottomRight(window, this.position, this.size)
      
   } else if ( this.positionbehavior == sapPopupPositionBehavior.BROWSERCENTER ) {
	  this.position.left = Math.floor((window.innerWidth/2)-(this.size.width/2)) + this.source.window.pageXOffset;
	  this.position.top  = Math.floor((window.innerHeight/2)-(this.size.height/2)) + this.source.window.pageYOffset;
      this.position.right   = window.innerWidth  - this.position.left - this.size.width + window.pageXOffset;
	  this.position.bottom  = window.innerHeight - this.position.top  - this.size.height + window.pageYOffset;
	  
  } else if (this.positionbehavior == sapPopupPositionBehavior.EVENT) {
	  this.position.left = this.source.event.pageX+window.pageXOffset;
	  this.position.top  = this.source.event.pageY+window.pageYOffset;
      this.position.right   = window.innerWidth  - this.position.left - this.size.width + window.pageXOffset;
      this.position.bottom  = window.innerHeight - this.position.top  - this.size.height + window.pageYOffset;
      
      //repositioning
      if (this.position.right<0) this.position.left  = this.position.left - this.size.width;
      if (this.position.bottom<0) this.position.top  = this.position.top - this.size.height;
      if (this.position.left-window.pageXOffset<0) this.position.left  = 0 + window.pageXOffset;
      if (this.position.top-window.pageYOffset<0) this.position.top  = 0 + window.pageYOffset;
	  //recalculate right and bottom
      this.position = setPosBottomRight(window, this.position, this.size)
   } else if ((this.position.top<0) || (this.position.left<0)) {
      showError("Please set\n   int sapPopup.position.left\n   int sapPopup.position.top\n to a value > 0.");
      this.canrender = false
  }
  if ((this.position.left-window.pageXOffset<0) || (this.position.right<0)) {
     this.position.left  = 0 + window.pageXOffset;
  }
  if ((this.position.top-window.pageYOffset<0) || (this.position.bottom<0)){
      if (this.canrender) this.scrolling=true;
      this.position.top  = 0 + window.pageYOffset;
  }
}
//----------------------------------------------------------------------------
// method show
//----------------------------------------------------------------------------
// desc : shows the popup
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_show(noRecalc,bDoNotAutoFocus) {
  //creating another child 
  sapOpenLevel = true;
  this.poscalc();
  if (this.onbeforerender) { if (!this.onbeforerender(this)) return; }
  if (!this.canrender) { showError("Cannot render Popup. Sizes and positions are not set."); return; }
  try {  	
		if (this.frame.window.mylevel==null) {
		  this.write(bDoNotAutoFocus);
		} else {
		  this.frame.window.document.getElementsByTagName("BODY").item(0).innerHTML=this.content.html;
		  window.sapUrMapi_PopupMenu_setEvents(this,1);
		}
  } catch (e){
    this.write(bDoNotAutoFocus);
  }
  //show the menu
  
  this.frame.object.style.left   = this.position.left;
  this.frame.object.style.top    = this.position.top;
  this.frame.object.style.width  = this.size.width;
  this.frame.object.style.height = this.size.height;

  activePopup = this;
  this.oldresize = window.onresize;
  //window.onresize = top.hidePopups;
  return true;
}
//----------------------------------------------------------------------------
// method showOld
//----------------------------------------------------------------------------
// desc : shows the popup, does not calculate the position and does not
//        write the content
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_showOld() {
  sapOpenLevel = true;
  this.frame.object.style.left   = this.position.left;
  this.frame.object.style.top    = this.position.top;
  this.frame.object.style.width  = this.size.width;
  this.frame.object.style.height = this.size.height;
  activePopup = this;
  this.oldresize = window.onresize;
  return true;
}
//----------------------------------------------------------------------------
// method hide
//----------------------------------------------------------------------------
// desc : hides the popup
// in   : none
// out  : none 
// brw  : NN6>
//----------------------------------------------------------------------------
function sapPopup_hide() {
  //hide the menu
  this.frame.object.style.top="-5001";
  if (this.level<sapPopupStore.length-1) {
  	sapPopupStore[this.level+1].hide();
  }
  sapPopupStore[this.level] = null; 
  var sapPopNew = new Array();
  for (var n=0;n<sapPopupStore.length;n++) {
  	if (sapPopupStore[n]!=null) {
  		sapPopNew[sapPopNew.length]=sapPopupStore[n];
  	}
  }
  sapPopupStore = sapPopNew;
  return true;
}
function hidePopupMenu(level) {
  if (sapPopupStore[0]) {
    sapPopupStore[0].hide();
  }
}

/*----------------------------------------------------------------------*/
/*  Helpers                                                             */
/*----------------------------------------------------------------------*/
//----------------------------------------------------------------------------
// function setPosBottomRight
//----------------------------------------------------------------------------
// desc : returns Right and Bottom  relative from a oBody DOM Body
// in   : oWindow  - window object, oPos - object - Position Object , oSize
// out  : oPos   - object Position Object
// brw  : NN6>
//----------------------------------------------------------------------------
function setPosBottomRight ( oWindow, oPos, oSize) {
  oPos.right   = oWindow.innerWidth - oPos.left - oSize.width + oWindow.pageXOffset;
  oPos.bottom  = oWindow.innerHeight - oPos.top - oSize.height + oWindow.pageYOffset;
  return oPos;
}   

//----------------------------------------------------------------------------
// function getAbsolutePosition
//----------------------------------------------------------------------------
// desc : returns position object x.left, x.right and x.top from a dom element 
//        absolute to the left, right and top borders of the document. 
// in   : obj  - object
// out  : position - object 
// brw  : left and top: IE5+, NN6+  right: IE5+
//----------------------------------------------------------------------------
function getAbsolutePosition (obj) {
  if (obj)
	  return sapUrMapi_getAbsolutePosition (obj);
}  

//----------------------------------------------------------------------------
// function getElementSize
//----------------------------------------------------------------------------
// desc : returns size object .width and .height on a dom element
// in   : obj  - object
// out  : size - object 
// brw  : IE5>, NN6>
//----------------------------------------------------------------------------
function getElementSize (obj) {
  if (obj)
	  return { height : obj.offsetHeight, width: obj.offsetWidth };
}

//----------------------------------------------------------------------------
// function relativeToAbsolutePath
//----------------------------------------------------------------------------
// desc : returns the absolute url of strRel from an absolute url strAbs
// in   : strRel - string
//        strAbs - string
// out  : absolute path - string 
// brw  : IE5>, NN6>
//----------------------------------------------------------------------------
function relativeToAbsolutePath(strRel,strAbs) {
  if (strRel.lastIndexOf("./")==-1) {
	if((strRel.indexOf("http://") !=-1) && (strRel.indexOf(".css"))) return strRel;

  	if(strRel.indexOf("/") == 0) {
  		strRel = strRel.substr(1);
  	}
  
  	if (strAbs.indexOf("?")!=-1) {
  		var strAbs = strAbs.substring(0,strAbs.indexOf("?"));
  	}
  
  	var urlParts = strAbs.split("//");
  	var domain = urlParts[1].substring(0,urlParts[1].indexOf("/"));
  	var strAbsPath = urlParts[0] + "//" + domain + "/";
  
    	strNewAbsPath = strAbsPath + strRel;
    	return strNewAbsPath;
    }
    else {
  	  if (strAbs.indexOf("?")==-1) {
  		var strRelDots      = strRel.substring(0,strRel.lastIndexOf("./")+2);
  		var strAbsPath      = strAbs.substring(0,strAbs.lastIndexOf("/"));
  	  }
  	  else {
  		var strRelDots      = strRel.substring(0,strRel.lastIndexOf("./")+2);
  		var strAbsPath      = strAbs.substring(0,strAbs.indexOf("?"));
  		var strAbsPath      = strAbsPath.substring(0,strAbsPath.lastIndexOf("/"));
  	  }
  }
  while(strRelDots.lastIndexOf("..")>-1) { //erase all double dots
    strAbsPath = strAbsPath.substring(0,strAbsPath.lastIndexOf("/")); 
    strRelDots = strRelDots.substring(0,strRelDots.lastIndexOf(".."))+"/";
  }
  if (strRelDots.lastIndexOf("./")>-1) {
    //erase last dots slash
    strRelDots = strRelDots.substring(0,strRelDots.lastIndexOf("./"))+"/";
    if (strRelDots.lastIndexOf("./")>-1) { 
      showError (strRel+" is not a valid relative url.");
    }
  }
  //build absolut path
  strNewAbsPath = strAbsPath + strRelDots + strRel.substring(strRel.lastIndexOf("./")+2,strRel.length);
  return strNewAbsPath;
}  
//----------------------------------------------------------------------------
// function showError
//----------------------------------------------------------------------------
// desc : shows an error text strTxt in an alert window could be replaces 
//        in the futur to display nicer messages
// in   : strTxt - string
// out  : none 
// brw  : IE5>, NN6>
//----------------------------------------------------------------------------
function showError(strTxt) {
  alert("Error:"+strTxt);
}
  


      var ptrActiveXArray=new Array();
      function ptrRegisterActiveXComponent(sourceWindow,enable,ptrFunction)
      {
        for(var i=0;i<ptrActiveXArray.length;i++){
          var item=ptrActiveXArray[i];
          if(item.sourceWindow==sourceWindow && item.enable==enable){
            item.isActive=true;
            item.ptrFunction=ptrFunction;
            break;
          }
        }
        if(i>=ptrActiveXArray.length){
          ptrActiveXArray[ptrActiveXArray.length]={sourceWindow:sourceWindow,
                                                                       enable:enable,
                                                                       ptrFunction:ptrFunction,
                                                                       isActive:true};
        }
      }

      function ptrUnregisterActiveXComponent(sourceWindow)
      {
        for(var i=0;i<ptrActiveXArray.length;i++){
          var item=ptrActiveXArray[i];
          if(item.sourceWindow==sourceWindow){
            item.isActive=false;
          }
        }
      }

      function ptrGetPopupWindow()
      {
        var rtrPopup=window;
        var parentWindow=window;
        while(parentWindow!=parentWindow.parent){
          parentWindow=parentWindow.parent;
          if(typeof(parentWindow.ptrBlendOpacity)!="undefined"&&typeof(parentWindow.ptrBlendOpacity)!="unknown"){
            rtrPopup=parentWindow;
          }
        }
        return rtrPopup;
      }

      var ptrPopup=ptrGetPopupWindow();
      window.addEventListener("load",ptrAppendImage,false);

      function ptrCancelAction()
      {
        return false; 
      }

      function ptrAppendImage()
      {
        if(typeof ptrCancelAction=="undefined")return;

        var div1x1ImageObj=document.getElementById("div1x1Image");
        if(div1x1ImageObj!=null)
          return;
        var documentBody=document.getElementsByTagName("BODY")[0];
	var divBlock=document.createElement("DIV");
        divBlock.id="div1x1Image";
        divBlock.style.position="absolute";
        //divBlock.style.backgroundColor="#999999";
        divBlock.style.MozOpacity=0.5;
        divBlock.style.left="0";
        divBlock.style.top="0";
        divBlock.style.display="none";
        divBlock.style.width="100%";
        divBlock.style.height="100%";
        divBlock.style.zIndex="4999";
        divBlock.addEventListener("click",ptrCenterPopupWindow,false);
        divBlock.addEventListener("contextmenu",ptrCancelAction,false);
	var imageBlock=document.createElement("IMG");
        imageBlock.src=ur_system.mimepath+"1x1.gif";
        imageBlock.style.width="100%";
        imageBlock.style.height="100%";
        imageBlock.addEventListener("contextmenu",ptrCancelAction,false);
        imageBlock.addEventListener("mousedown",ptrCancelAction,false);
        divBlock.appendChild(imageBlock);
        documentBody.appendChild(divBlock);

	var divBlockMove=document.createElement("DIV");
        divBlockMove.id="div1x1MoveImage";
        divBlockMove.className="urTxtEmph";
        divBlockMove.style.width="100%";
        divBlockMove.style.height="18px";
        divBlockMove.style.zIndex="5999";
        divBlockMove.style.display="none";
        divBlockMove.style.position="absolute";
        divBlockMove.style.fontSize="11px";
        divBlockMove.style.color="#FFFFFF";
        divBlockMove.style.backgroundColor="#999999";
        divBlockMove.style.left="0";
        divBlockMove.style.top="0";
        divBlockMove.style.overflow="hidden";
        divBlockMove.style.paddingTop="2px";
        divBlockMove.style.paddingLeft="5px";
        documentBody.appendChild(divBlockMove);
      }

      var ptrBlendOpacity=40;
      var ptrPopupArray=new Array();

      function ptrCenterPopupWindow()
      {
        var left=0,top=0;
        if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          var winWidth=document.body.offsetWidth;
          if(winWidth<document.body.clientWidth)winWidth=document.body.clientWidth;
          var winHeight=document.body.offsetHeight;
          if(winHeight<document.body.clientHeight)winHeight=document.body.clientHeight;
          left=document.body.scrollLeft+(winWidth-ptrPopupArray[ptrPopupArray.length-1].MIDWidth)/2;
          top=document.body.scrollTop+(winHeight-ptrPopupArray[ptrPopupArray.length-1].MIDHeight)/2;
        }
        else{
          left=ptrPopupArray[ptrPopupArray.length-2].left+30;
          top=ptrPopupArray[ptrPopupArray.length-2].top+30;
        } 
        ptrPopupArray[ptrPopupArray.length-1].left=left;
        ptrPopupArray[ptrPopupArray.length-1].top=top;

        ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.window.document.getElementById('iframePopupDivHeaderA').focus();

        var iframePopupObj = ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.object;
        iframePopupObj.style.left = ptrPopupArray[ptrPopupArray.length-1].left;
        iframePopupObj.style.top = ptrPopupArray[ptrPopupArray.length-1].top;
        if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null){
          var iframeInnerPopupObj = ptrPopupArray[ptrPopupArray.length-1].oInnerPopup.frame.object;
          iframeInnerPopupObj.style.left = ptrPopupArray[ptrPopupArray.length-1].left+2;
          iframeInnerPopupObj.style.top = ptrPopupArray[ptrPopupArray.length-1].top+23;
          if(ptrPopupArray[ptrPopupArray.length-1].type.length>0){
            iframeInnerPopupObj.style.left=ptrPopupArray[ptrPopupArray.length-1].left+2+50;
          }
        }
      }

      var ptrFrameTimeout=false;

      function ptrResizeBlockImage()
      {
        if(ptrPopupArray.length==0 || ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modless"){
          window.removeEventListener("resize",ptrResizeBlockImage,false);
          return;
        }
        var bodyScrollHeight=0;
        var bodyScrollWidth=0;
        var bodyClientHeight=0;
        var bodyClientWidth=0;

        bodyScrollHeight=document.body.scrollHeight;
        bodyScrollWidth=document.body.scrollWidth;
        bodyClientHeight=document.body.clientHeight;
        bodyClientWidth=document.body.clientWidth;
        var div1x1ImageObj = document.getElementById("div1x1Image");
        div1x1ImageObj.style.height=bodyScrollHeight>bodyClientHeight?bodyScrollHeight:bodyClientHeight;
        div1x1ImageObj.style.width=bodyScrollWidth>bodyClientWidth?bodyScrollWidth:bodyClientWidth;
      }

      var ptrInitialLevel=0;
      function ptrShowPopupWindow(sourceWindow,width,height,url,title,text,style,type,logout,mode,resize,modless,popupId,isFix,hasCloseButton,sourceFocusId,hasTimeout)
      {
        var ptrLevel=sapPopupStore.length;
        if(typeof hasTimeout=="undefined"){
          hasTimeout=false;
          if(ptrLevel<ptrInitialLevel)
            ptrLevel=ptrInitialLevel;
        }
        if(typeof sourceFocusId=="undefined"){
          sourceFocusId="";
        }

        if (document.getElementById(sapPopupMainId+(ptrLevel+2))==null){
          var oFramesContainer = document.getElementById("urFrames");
          if(oFramesContainer==null){
            alert("Webdynpro (ABAP) error\n\nWhat happened?\nCalling the Webdynpro page was terminated due to an error.\nError type: oFramesContainer==null");
            ptrFrameTimeout=false;
            return;
          }
          for (var f=ptrLevel;f<ptrLevel+3;f++) {
            if (document.getElementById(sapPopupMainId+(f))!=null)
              continue;
            var oFrame = document.createElement("IFRAME");
            oFrame.setAttribute("id",sapPopupMainId+(f));
            oFrame.setAttribute("name",sapPopupMainId+(f));
            oFrame.setAttribute("src",ur_system.emptyhoverurl);
            oFrame.setAttribute("style","width:0;height:0;z-index:1001;display:block;position:absolute;top:-5000;");
            oFrame.setAttribute("frameBorder","0");
            oFrame.setAttribute("border","no");
            oFrame.setAttribute("scrolling","auto");
            oFramesContainer.appendChild(oFrame);
          }
          ptrFrameTimeout=true;
          ptrInitialLevel=ptrLevel+2;
        }
        else{
          try{
            for (var f=ptrLevel;f<ptrLevel+3;f++) {
              window.frames[sapPopupMainId+f].window.document.domain;
            }
          }
          catch(e){
            ptrFrameTimeout=false;
            return;
          }
        }

        var urlArray=sourceWindow.location.href.split("/");
        if(url.split("/")[0].toLowerCase()!="http:"&&url.split("/")[0].toLowerCase()!="https:"){
          if(url.length>0 && url.indexOf("/")==-1){
            var appUrl=sourceWindow.location.href.substr(0,sourceWindow.location.href.indexOf(urlArray[urlArray.length-1]));
            url=appUrl+url;
          }
          else if(url.length>0 && url.indexOf("/")==0){
            var urlArray=sourceWindow.location.href.split("/");
            url=urlArray[0]+"//"+urlArray[2]+url;
          }
          else if(url.length>0 && url.substr(0,4)!="http"){
            var relativeUrl=url;
            var absoluteUrl=sourceWindow.location.href;
            var questionMarkPos=absoluteUrl.indexOf("?");
            if(questionMarkPos!=-1){
              absoluteUrl=absoluteUrl.substr(0,questionMarkPos);
            }
            var lastSlashPos=absoluteUrl.lastIndexOf("/");
            absoluteUrl=absoluteUrl.substr(0,lastSlashPos);
            while(relativeUrl.indexOf("../")==0){
              relativeUrl=relativeUrl.substr(3);
              lastSlashPos=absoluteUrl.lastIndexOf("/");
              absoluteUrl=absoluteUrl.substr(0, lastSlashPos);
            }
            url=absoluteUrl+"/"+relativeUrl;
          }
        }

        if(ptrFrameTimeout==true && hasTimeout==false){
          window.setTimeout(function(){ptrShowPopupWindow(sourceWindow,width,height,url,title,text,style,type,logout,mode,resize,modless,popupId,isFix,hasCloseButton,sourceFocusId,true);},0);
          return;
        }
        ptrFrameTimeout=false;
        ptrInitialLevel=0;

        if(ptrPopupArray.length>0 && modless==true){
          if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"||
              ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modal"){
            alert("Permission denied!\n\nModeless Dialog over Modal Dialog(s).");
            return;
          }
        }
        var div1x1ImageObj = document.getElementById("div1x1Image");
        if(div1x1ImageObj==null){
          ptrAppendImage();
          div1x1ImageObj = document.getElementById("div1x1Image");
        }
        //Block ActiveX Controls...
        for(var i=0;i<ptrActiveXArray.length;i++){
          var item=ptrActiveXArray[i];
          if(item.isActive==true && item.enable==false){
            try{
              item.ptrFunction();
            }
            catch(e){}
          }
        }

        var dialogMode="";
        if(modless==true){
          dialogMode="modless";
        }
        else if(ptrPopupArray.length==0||ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modless"){
          dialogMode="startModal";
        }
        else{
          dialogMode="modal";
        }

        ptrPopupArray[ptrPopupArray.length]={sourceWindow:sourceWindow,
                                             left:0,
                                             top:0,
                                             width:0,
                                             MIDWidth:0,
                                             height:0,
                                             MIDHeight:0,
                                             oPopup:null,
                                             isInitial:true,
                                             style:style,
                                             oInnerPopup:null,
                                             sourceFocusId:sourceFocusId,
                                             mode:"MAX",
                                             isFix:isFix,
                                             type:type,
                                             overflow:ptrPopup.document.body.style.overflow,
                                             showDialog:true,
                                             dialogMode:dialogMode,
                                             popupId:ptrPopupArray.length};

        var urlArray=window.location.href.split("/");
        var appUrl=window.location.href.substr(0,window.location.href.indexOf(urlArray[2])+urlArray[2].length);

        var urlMimepathArray=ur_system.stylepath.split("/");
        if(urlMimepathArray[0].toLowerCase()=="http:"||urlMimepathArray[0].toLowerCase()=="https:"){
          appUrl="";
        }

        var stylepathUrl=ur_system.stylepath;
        var stylepathArray=ur_system.stylepath.split("/");
        if(stylepathArray[stylepathArray.length-2]!="ur"){
          stylepathUrl+="ur/";
        }

        var stylesheets=new Array();
        stylesheets[stylesheets.length]=appUrl+stylepathUrl+"ur_dia_"+ur_system.browser_abbrev+".css";

        var iLevel=-1;
        for (var n=0;n<ptrPopupArray.length;n++) {
          iLevel++;
          if(ptrPopupArray[n].oInnerPopup!=null)iLevel++;
        }
        if(sapPopupStore.length>iLevel)
          iLevel=sapPopupStore.length;
        ptrPopupArray[ptrPopupArray.length-1].oPopup = new sapPopup(window,stylesheets,div1x1ImageObj,null,null,iLevel);
        ptrPopupArray[ptrPopupArray.length-1].oPopup.mouseover=true;
        if(popupId.length>0){
          ptrPopupArray[ptrPopupArray.length-1].popupId=popupId;
        }

        var oPopup=ptrPopupArray[ptrPopupArray.length-1].oPopup;
        var iframePopupObj=oPopup.frame.object;
        iframePopupObj.style.zIndex=4999+2*ptrPopupArray.length;
        oPopup.size.height=height;
        oPopup.size.width=width;
        iframePopupObj.style.width=width;
        iframePopupObj.style.height=height;

        var bodyScrollHeight=0;
        var bodyScrollWidth=0;
        var bodyClientHeight=0;
        var bodyClientWidth=0;
        var bodyScrollLeft=0;
        var bodyScrollTop=0;
        var left=0;
        var top=0;

        bodyScrollHeight=document.body.scrollHeight;
        bodyScrollWidth=document.body.scrollWidth;
        bodyClientHeight=document.body.clientHeight;
        bodyClientWidth=document.body.clientWidth;
        bodyScrollTop=document.body.scrollTop;
        bodyScrollLeft=document.body.scrollLeft;

        if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          div1x1ImageObj.style.height=bodyScrollHeight>bodyClientHeight?bodyScrollHeight:bodyClientHeight;
          div1x1ImageObj.style.width=bodyScrollWidth>bodyClientWidth?bodyScrollWidth:bodyClientWidth;
          div1x1ImageObj.style.display="block";
          div1x1ImageObj.style.cursor="progress";//progress wait
          ptrPopup.document.body.style.overflow="hidden";

          window.addEventListener("resize",ptrResizeBlockImage,false);
        }

        if(ptrPopupArray.length==1&&ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modless"){
          left=bodyScrollLeft+10;
          top=bodyScrollTop+10;
        }
        else if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          left=bodyScrollLeft+(bodyClientWidth-width)/2;
          top=bodyScrollTop+(bodyClientHeight-height)/2;
        }
        else{
          left=ptrPopupArray[ptrPopupArray.length-2].left+30;
          top=ptrPopupArray[ptrPopupArray.length-2].top+30;
        }
        if(ptrPopupArray.length>1 && ptrPopupArray[ptrPopupArray.length-1].dialogMode=="modal"){
          ptrPopupArray[ptrPopupArray.length-2].oPopup.frame.object.style.zIndex=
           parseInt(ptrPopupArray[ptrPopupArray.length-2].oPopup.frame.object.style.zIndex)-100;
          if(ptrPopupArray[ptrPopupArray.length-2].oInnerPopup!=null)
            ptrPopupArray[ptrPopupArray.length-2].oInnerPopup.frame.object.style.zIndex=
             parseInt(ptrPopupArray[ptrPopupArray.length-2].oPopup.frame.object.style.zIndex)+1;
        }
        else if(ptrPopupArray.length>1 && ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal"){
          for(var i=0;i<=ptrPopupArray.length-2;i++){
            ptrPopupArray[i].oPopup.frame.object.style.zIndex=
             parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)-100;
            if(ptrPopupArray[ptrPopupArray.length-2].oInnerPopup!=null)
              ptrPopupArray[i].oInnerPopup.frame.object.style.zIndex=
               parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)+1;
          }
        }

        ptrPopupArray[ptrPopupArray.length-1].left=left;
        ptrPopupArray[ptrPopupArray.length-1].top=top;
        ptrPopupArray[ptrPopupArray.length-1].width=width;
        ptrPopupArray[ptrPopupArray.length-1].height=height;

        oPopup.size.left=left;
        oPopup.size.top=top;

        iframePopupObj.style.left=0;
        iframePopupObj.style.top=-5000;
        oPopup.frame.object.style.display="none";
        width=110;
        height=110;

        var windowIframePopupObj=ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.window;

        var strDocument = "<html><head>";

        var strRelaxScript="";
        if (ur_system.domainrelaxing==sapUrDomainRelaxing.MINIMAL) {
          strRelaxScript  = "<s"+"cript>try{parent.document.domain} catch(e){var hostname = document.domain; var posBehindFirstDot = hostname.indexOf(\".\") + 1;if (posBehindFirstDot>0) {document.domain=hostname.substr(posBehindFirstDot);}};</scri"+"pt>";
        } 
        else if (ur_system.domainrelaxing==sapUrDomainRelaxing.MAXIMAL){
          strRelaxScript  = "<s"+"cript>try {parent.document.domain} catch(e){var nameparts=document.domain.split(\".\"); if (nameparts.length > 2) document.domain = nameparts.slice(nameparts.length - 2).join(\".\"); };</scri"+"pt>";
        }
        if(ur_system.domainrelaxing!=sapUrDomainRelaxing.NONE)
          strDocument += strRelaxScript;
        for(var n=0;n<oPopup.stylesheets.length;n++) {
          strDocument+= "<link rel=\"stylesheet\" href=\""+oPopup.stylesheets[n]+"\">";
        }
        strDocument += "<sc"+"ript>var me=null;if(parent.sapPopupStore["+oPopup.level+"]){me=parent.sapPopupStore["+oPopup.level+"].source.window;}"+"</sc"+"ript>";
        strDocument += "<st"+"yle>";
          strDocument += ".urPopFrameMax{background-position:center;background-repeat:no-repeat;cursor:pointer;height:20px;}";
          strDocument += ".urPopFrameMid{background-position:center;background-repeat:no-repeat;cursor:pointer;height:20px;}";
          strDocument += ".urPopFrameClose{background-position:center;background-repeat:no-repeat;cursor:pointer;height:20px;}";
          strDocument += ".urPopFrameResizeHide{width:22px;height:17px;}";
          strDocument += ".urPopFrameResize{width:22px;height:17px;background-position:right bottom;cursor:nw-resize;background-repeat:no-repeat;}";
          strDocument += ".urPopWaveBottom{background-repeat:repeat-x;width:100%;}";
          strDocument += ".urPopWaveMid{background-repeat:no-repeat;width:40px;}";
          strDocument += ".urPopWaveTop{background-repeat:repeat-x;}";
          strDocument += ".urPopIconWarning{background-position:center;background-repeat:no-repeat;}";
          strDocument += ".urPopIconInformation{background-position:center;background-repeat:no-repeat;}";
          strDocument += ".urPopIconQuestion{background-position:center;background-repeat:no-repeat;}";
          strDocument += ".urPopIconSuccess{background-position:center;background-repeat:no-repeat;}";
          strDocument += ".urPopIconError{background-position:center;background-repeat:no-repeat;}";
          strDocument += ".urPopIconStopp{background-position:center;background-repeat:no-repeat;}";
          strDocument += ".urPopFont{font-size:11px;}";
          strDocument += ".urPopBdyStd{overflow:hidden;margin:0px;}";
          strDocument += ".urPopFrame1{border-width:1px;border-style:solid;cursor:default;font-size:11px;}";
          strDocument += ".urPopFrame2{border-width:1px;border-style:solid;cursor:default;font-size:11px;}";
          strDocument += ".urPopTitleArea{border-width:0px 0px 1px 0px;border-style:solid;cursor:default;height:21px;padding:0px 1px 0px 5px}";
          strDocument += ".urPopTitle{vertical-align:top;padding-top:1px;font-weight:bold;font-style:normal;font-size:11px;white-space:nowrap;overflow:hidden;}";
          strDocument += ".urPopTxtStd{font-size:11px;font-style:normal;}";
          strDocument += ".urPopTbarImg{width:1px;height:1em}";
          strDocument += ".urPopTbarItmBtn{vertical-align:top;padding:0 0 0 1px}";
          strDocument += ".urPopTbarBtnStd{font-size:11px;vertical-align:top;border-style:solid;border-width:1px;cursor:pointer;font-weight:normal;height:14px;padding:0px 4px 0px 5px;text-align:center;text-decoration:none;white-space:nowrap}";
          strDocument += ".urPopTitleAreaHeader{cursor:default;padding-top:2px}";
          strDocument += ".urPopTitleAreaResize{padding:0px 0px 0px 2px;width:16px;}";
          strDocument += ".urPopTitleAreaClose{padding:0px 2px 0px 2px;width:16px;}";
          strDocument += ".urPopIconArea{text-align:center;width:32px;padding-left:22px;padding-right:18px;}";
        strDocument += "</st"+"yle>";
        strDocument += "</head>";
        strDocument += "<body id=\"iframePopupBody\" oncontextmenu=\"return false;\" class=\"urPopBdyStd urPopFont\">";

        width=width-2;
        height=height-2;

        var headerWidth=width-60<60?width:width-60;
        strDocument += "<a href=\"javascript:void(0)\" tabindex=\"0\" onfocus=\"document.getElementById('iframePopupDivHeaderA').focus();\"></a>";
        strDocument += "<div id=\"iframePopupDivOuterFrame1\" class=\"urPopFrame1\" style=\"width:"+width+";height:"+height+";\">";
        width=width-2;
        height=height-2;
        strDocument += "<div id=\"iframePopupDivOuterFrame2\" class=\"urPopFrame2\" style=\"width:"+width+";height:"+height+";\">";
        strDocument += "<div id=\"iframePopupDivHeader\" class=\"urPopTitleArea\">";
        strDocument +=  "<table width='100%' class=\"urPopFont\" cellspacing='0' cellpadding='0' border='0'><tr>";
        strDocument +=  "<td class='urPopTitleAreaHeader' onmousedown='me.ptrStartPopup(event,"+(ptrPopupArray.length-1)+","+mode+");return false;'";
        if(resize==true){
          strDocument += " ondblclick=\"me.ptrToggleModalDialog(event,"+(ptrPopupArray.length-1)+",document.getElementById('ptrPopupToggleIconId'));return false;\"";
        }
        strDocument +=  "><div id=\"iframePopupDivHeaderText\" class=\"urPopTitle urPopFont\" style='width:"+headerWidth+";' title='"+title+"'><a href='javascript:void(0);' tabindex='0' id='iframePopupDivHeaderA'></a>&nbsp;"+title+"</div></td>";
        if(resize==true){
          strDocument += "<td align='right' class='urPopTitleAreaResize urPopFrameMax' id='ptrPopupToggleIconId' mode='MAX'>";
          strDocument += "<a tabindex='0' href='javascript:me.ptrToggleModalDialog(null,"+(ptrPopupArray.length-1)+",document.getElementById(\"ptrPopupToggleIconId\"))'><img src='"+ur_system.mimepath+"1x1.gif' style='width:16px;height:16px' border='0'></a></td>";
        }
        if(hasCloseButton==true){
          strDocument +=  "<td align='right' class='urPopTitleAreaClose urPopFrameClose'><a tabindex=\"0\" id=\"headerCancel\" href=\"javascript:me.ptrHideModalDialog(null,'CANCEL',"+(ptrPopupArray.length-1)+")\"><img src='"+ur_system.mimepath+"1x1.gif' style='width:16px;height:16px' border='0'></a></td>";
        }
        strDocument +=  "</tr></table>";
        strDocument += "</div>";

        height-=50;
        width-=4;

        if(url.length>0){
          var arr=new Array();
          ptrPopupArray[ptrPopupArray.length-1].oInnerPopup = new sapPopup(window,arr,div1x1ImageObj,null,null,iLevel+1);
          var oInnerPopup=ptrPopupArray[ptrPopupArray.length-1].oInnerPopup;
          var iframeInnerPopupObj=oInnerPopup.frame.object;
          iframeInnerPopupObj.style.zIndex=parseInt(iframePopupObj.style.zIndex)+1;

          oInnerPopup.size.height=height;
          oInnerPopup.size.width=width;
          iframeInnerPopupObj.style.width="50px";
          iframeInnerPopupObj.style.height="50px";

          oInnerPopup.size.left=left+2;
          oInnerPopup.size.top=top+23;
          if(isFix==true)
            oInnerPopup.frame.object.style.display="block";
          else
            oInnerPopup.frame.object.style.display="none";
          iframeInnerPopupObj.style.left=0;
          iframeInnerPopupObj.style.top=-5000;

          var windowIframeInnerPopupObj=ptrPopupArray[ptrPopupArray.length-1].oInnerPopup.frame.window;
          var strContent = "<html><head>";
          if(ur_system.domainrelaxing!=sapUrDomainRelaxing.NONE)
            strContent += strRelaxScript;

          strContent += "</head>";
          strContent += "<body id=\"ptrBodyLoading\" oncontextmenu=\"return false;\" style=\"background:white !important;margin:0;overflow:hidden\">";
          strContent += "<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" style=\"height:100%;width:100%;\">";
          strContent += "<tbody><tr><td align=\"center\" style=\"font-family:Arial\"><span style=\"font-size:0.8em\">Loading...</span></table>";
          strContent += "<sc"+"ript>window.setTimeout(function(){location.href='"+url+"';},0);"+"</sc"+"ript>";
          strContent += "</body></html>";
          windowIframeInnerPopupObj.document.clear();
          windowIframeInnerPopupObj.document.write(strContent);
          windowIframeInnerPopupObj.document.close();
        }

        var messageIconClass="";
        if(type.length>0){
          if(type=="PTR_WARNING")
            messageIconClass="urPopIconWarning";
          else if(type=="PTR_INFORMATION")
            messageIconClass="urPopIconInformation";
          else if(type=="PTR_QUESTION")
            messageIconClass="urPopIconQuestion";
          else if(type=="PTR_SUCCESS")
            messageIconClass="urPopIconSuccess";
          else if(type=="PTR_ERROR")
            messageIconClass="urPopIconError";
          else if(type=="PTR_STOP"||type=="PTR_STOPP")
            messageIconClass="urPopIconStopp";
        }

        if(messageIconClass.length>0){
          strDocument += "<table style='height:"+(height-1)+";' cellspacing='0' cellpadding='0' border='0'><tr>";
          strDocument += "<td tabindex='0' class='urPopIconArea "+messageIconClass+"' style='width:32px'><img src='"+ur_system.mimepath+"1x1.gif' style='width:32px;height:32px' alt=''></td>";
          if(url.length==0){
            strDocument += "<td>";
            strDocument += "<div id='iframePopupDivInnerFrame' style='overflow:auto;'>";
            strDocument += "<table class='urPopFont' style='height:100%;' cellspacing='0' cellpadding='0' border='0'><tr><td><div class='urPopTxtStd urPopFont'>"+text+"</div></td></tr></table>";
            strDocument += "</div></td>";
          }
          else{
            strDocument += "<td><div id=\"iframePopupDivInnerFrame\">";
            if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null){
              strDocument += "<a href='javascript:void(0)' tabindex=\"0\" onfocus=\"me.ptrPopupArray["+(ptrPopupArray.length-1)+"].oInnerPopup.frame.window.document.getElementById('ptrFocusStart2').focus();\"></a>";
            }
            strDocument += "</div></td>";
          }
          strDocument += "</tr></table>";
        }
        else{
          strDocument += "<div id=\"iframePopupDivInnerFrame\" style='height:"+(height-1)+";width:"+width+";overflow:auto'>";
          if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null){
            strDocument += "<a href='javascript:void(0)' tabindex=\"0\" onfocus=\"me.ptrPopupArray["+(ptrPopupArray.length-1)+"].oInnerPopup.frame.window.document.getElementById('ptrFocusStart2').focus();\"></a>";
          }
          if(url.length==0){
            strDocument += "<table class='urPopFont' cellspacing='0' cellpadding='0' border='0' style='height:"+(height-1)+";'><tr><td style='padding:16px 22px 16px 22px'><div class='urPopTxtStd urPopFont'>"+text+"</div></td></tr></table>";
          }
          strDocument+="</div>";
        }

        if(url.length>0){
          strDocument += "<a href='javascript:void(0);' tabindex=\"0\" id=\"ptrToolbar\"></a>";
        }

        /*
        ptrMessageBox Styles:
        PTR_ABORTRETRYIGNORE :The messagebox contains Abort, Retry, and Ignore buttons.
        PTR_OK               :The messagebox contains OK button.
        PTR_NONE             :The messagebox contains Cancel button.
        PTR_CLOSE            :The messagebox contains Close button.
        PTR_OKCANCEL         :The messagebox contains OK and Cancel buttons.
        PTR_RETRYCANCEL      :The messagebox contains Retry and Cancel buttons.
        PTR_YESNO            :The messagebox contains Yes and No buttons.
        PTR_YESNOCANCEL      :The messagebox contains Yes, No, and Cancel buttons.
        */
        if(typeof(style)=="number" || (typeof(style)=="string" && style.length>0)){
          strDocument += '<table id="ptrToolbarArea" style="height:29px;width:100%" cellpadding="0" border="0" cellspacing="0" class="urPopTbarWhl urPopFont">';
          strDocument += '<tr>';
          strDocument += '<td valign="top" nowrap class="urPopWaveBottom"><img border="0" style="height:1px;width:22px" src="'+ur_system.mimepath+'1x1.gif">';
          strDocument += '<td valign="top" nowrap class="urPopWaveMid"><img border="0" style="height:1px;width:40px" src="'+ur_system.mimepath+'1x1.gif">';
          strDocument += '<td nowrap class="urPopWaveTop" style="width:15px;"><img border="0" style="height:1px;width:15px" src="'+ur_system.mimepath+'1x1.gif">';
          strDocument += '<td valign="middle" align="right" nowrap class="urPopWaveTop">';
          strDocument += '<table id="ptrToolbarTable" cellpadding="0" border="0" cellspacing="0" class="urPopFont"><tr><td valign="top" nowrap style="padding-top:4px" id="ptrToolbarContent">';
          if(typeof(style)=="number"){
            for(var i=0;i<style;i++){
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"BUTTON_"+i,"");
            }
          }
          else{
            if(style=="PTR_ABORTRETRYIGNORE")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"ABORT","Abort");
            if(style=="PTR_CLOSE")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"CLOSE","Close");
            if(style=="PTR_ABORTRETRYIGNORE"||style=="PTR_RETRYCANCEL")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"RETRY","Retry");
            if(style=="PTR_ABORTRETRYIGNORE")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"IGNORE","Ignore");
            if(style=="PTR_OK"||style=="PTR_OKCANCEL")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"OK","OK");
            if(style=="PTR_YESNO"||style=="PTR_YESNOCANCEL")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"YES","Yes");
            if(style=="PTR_YESNO"||style=="PTR_YESNOCANCEL")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"NO","No");
            if(style=="PTR_OKCANCEL"||style=="PTR_RETRYCANCEL"||style=="PTR_YESNOCANCEL")
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"CANCEL","Cancel");
          }
          strDocument += '</table>';
          if(resize==true){
            strDocument += '<td nowrap style="width:22px;" class="urPopWaveTop" valign="bottom" align="right">';
            strDocument += '<div id="ptrPopupResizeIconId" class="urPopFrameResize" onmousedown="if(this.className!=\'urPopFrameResize\')return false;me.ptrStartPopup(event,'+(ptrPopupArray.length-1)+',false,true);return false;"><img src="'+ur_system.mimepath+'1x1.gif" style="width:17px;height:17px"></div>';
          }
          else{
            strDocument += '<td nowrap style="width:22px;" class="urPopWaveTop"><img border="0" style="height:1px;width:22px" src="'+ur_system.mimepath+'1x1.gif">';
          }
          strDocument += '</table>';
        }
        strDocument += "</div></div><a href='javascript:void(0)' tabindex=\"0\" onfocus=\"try{document.getElementById('iframePopupDivHeaderA').focus();}catch(e){}\"></a>";

        strDocument += "</body></html>";

        windowIframePopupObj.document.clear();
        windowIframePopupObj.document.write(strDocument);
        windowIframePopupObj.document.close();

        if(url.length==0){
          window.setTimeout(function(){ptrInitModalDialog(sourceWindow.ptrDialogObj);},0);
        }

        if(ptrPopupArray[ptrPopupArray.length-1].dialogMode=="startModal" && url.length==0){
          var blendTimer=logout==true?70:40;
          ptrBlenLogoff(blendTimer);
        }
      }

      function ptrToolbarButton(index,id,text)
      {
        var strDocument = '<span class="urPopTbarItmBtn" id="'+id+'-r" show="true" cancollapse="false">';
        strDocument += '<a tabindex="0" onmouseover="window.status=\'\';return true;" href="javascript:void(0);" onclick="me.ptrHideModalDialog(event,\''+id+'\','+index+');" ';
        strDocument += 'class="urPopTbarBtnStd urPopFont" id="'+id+'" ct="ToolbarButton" title="'+text+'">';
        strDocument += '<span style="white-space:nowrap;">'+text+'</span>';
        strDocument += '</a>';
        strDocument += '</span>';
        return strDocument;
      }

      var ptrToggle=false;
      function ptrBlenLogoff(blend)
      {
        if(typeof blend=="undefined")
          blend=ptrBlendOpacity;
        var div1x1ImageObj = document.getElementById("div1x1Image");
        div1x1ImageObj.style.MozOpacity=blend/100.0;
        div1x1ImageObj.style.backgroundColor="#FFFFFF";
      }

      function ptrMessageBox(sourceWindow,text,title,style,type)
      {
        if(typeof(type)=="undefined"||type.length==0)type="";
        ptrShowModalDialog(sourceWindow,text,title,style,type);
      }

      function ptrModalDialogUrl(sourceWindow,url,title,style,width,height)
      {
        if(typeof(style)=="string" && style.length==0){
          style="PTR_OKCANCEL";
        }
        if(typeof(title)=="undefined")title="&nbsp;";
        if(title.length==0)title="SAP Modal Dialog";
        if(typeof(width)=="undefined"||(typeof(width)=="number" && width==0)||typeof(width)=="string")width=400;
        if(typeof(height)=="undefined"||(typeof(height)=="number" && height==0)||typeof(height)=="string")height=200;
        ptrShowModalDialog(sourceWindow,'',title,style,'',width,height,url,false,false,true,false,'',true);
      }

      function ptrModalDialogWdr(sourceWindow,popupId,url,title,style,type,width,height,hasCloseButton)
      {
        if(typeof(style)=="string" && style.length==0){
          style="PTR_OKCANCEL";
        }
        if(typeof(title)=="undefined")title="&nbsp;";
        if(title.length==0)title="SAP Web Dynpro";
        if(typeof(type)=="undefined")type='';
        if(typeof(width)=="undefined"||(typeof(width)=="number" && width==0)||typeof(width)=="string")width=400;
        if(typeof(height)=="undefined"||(typeof(height)=="number" && height==0)||typeof(height)=="string")height=200;
        if(typeof(hasCloseButton)!="boolean")hasCloseButton=true;
        ptrShowModalDialog(sourceWindow,'',title,style,type,width,height,url,false,false,true,false,popupId,false,hasCloseButton);
      }

      function ptrModelessDialogUrl(sourceWindow,url,title,style,width,height)
      {
        ptrModlessDialogUrl(sourceWindow,url,title,style,width,height);
      }

      function ptrModelessDialogWdr(sourceWindow,popupId,url,title,style,width,height,hasCloseButton)
      {
        ptrModlessDialogWdr(sourceWindow,popupId,url,title,style,width,height,hasCloseButton);
      }

      function ptrDialogWdr(isModal,sourceWindow,popupId,url,title,style,type,width,height,hasCloseButton)
      {
        if(typeof(isModal)=="boolean" && isModal==true){
          ptrModalDialogWdr(sourceWindow,popupId,url,title,style,type,width,height,hasCloseButton);
        }
        else{
          ptrModlessDialogWdr(sourceWindow,popupId,url,title,style,width,height,hasCloseButton);
        }
      }

      function ptrModlessDialogUrl(sourceWindow,url,title,style,width,height)
      {
        if(typeof(style)=="string" && style.length==0){
          style="PTR_OKCANCEL";
        }
        if(typeof(title)=="undefined")title="&nbsp;";
        if(title.length==0)title="SAP Modless Dialog";
        if(typeof(width)=="undefined"||(typeof(width)=="number" && width==0)||typeof(width)=="string")width=400;
        if(typeof(height)=="undefined"||(typeof(height)=="number" && height==0)||typeof(height)=="string")height=200;
        ptrShowModalDialog(sourceWindow,'',title,style,'',width,height,url,false,true,true,true,'',true);
      }

      function ptrModlessDialogWdr(sourceWindow,popupId,url,title,style,width,height,hasCloseButton)
      {
        if(typeof(style)=="string" && style.length==0){
          style="PTR_OKCANCEL";
        }
        if(typeof(title)=="undefined")title="&nbsp;";
        if(title.length==0)title="SAP Web Dynpro";
        if(typeof(width)=="undefined"||(typeof(width)=="number" && width==0)||typeof(width)=="string")width=400;
        if(typeof(height)=="undefined"||(typeof(height)=="number" && height==0)||typeof(height)=="string")height=200;
        if(typeof(hasCloseButton)!="boolean")hasCloseButton=true;
        ptrShowModalDialog(sourceWindow,'',title,style,'',width,height,url,false,true,true,true,popupId,true,hasCloseButton);
      }

      function ptrModalDialog(sourceWindow,text,title,style,width,height)
      {
        ptrShowModalDialog(sourceWindow,text,title,style,'',width,height,'',false,false,true);
      }

      function ptrLogout(sourceWindow,text,title)
      {
        ptrShowModalDialog(sourceWindow,text,title,"PTR_YESNO","PTR_QUESTION",400,200,'',true,true);
      }

      function ptrShowModalDialog(sourceWindow,text,title,style,type,width,height,url,logout,mode,resize,modless,popupId,isFix,hasCloseButton)
      {
        if(typeof(sourceWindow)!="object")
          return;

        if(typeof(text)=="undefined"){
          text="Your request is beeing processed!";
        }
        if(typeof(title)=="undefined"){
          title="Please wait...";
        }
        if(typeof(style)=="undefined"){
          style="PTR_OK";
        }
        if(typeof(type)=="undefined"){
          type="";
        }
        if(typeof(width)=="undefined"){
          width=400;
        }
        if(typeof(height)=="undefined"){
          height=200;
        }
        if(typeof(url)=="undefined"){
          url="";
        }
        if(typeof(logout)=="undefined"){
          logout=false;
        }
        if(typeof(mode)=="undefined"){
          mode=false;
        }
        if(typeof(resize)=="undefined"){
          resize=false;
        }
        if(typeof(modless)=="undefined"){
          modless=false;
        }
        if(typeof(popupId)=="undefined"){
          popupId="";
        }
        if(typeof(isFix)=="undefined"){
          isFix=false;
        }
        if(typeof(hasCloseButton)=="undefined"){
          hasCloseButton=true;
        }

        ptrShowPopupWindow(sourceWindow,width,height,url,title,text,style,type,logout,mode,resize,modless,popupId,isFix,hasCloseButton);
      }

      function ptrToggleModalDialog(event,index,imgObj)
      {
        if(imgObj.getAttribute("mode")=="MAX"){
          ptrToggle=true;
        }
        var windowIframePopupObj=ptrPopupArray[index].oPopup.frame.window;
        var iframePopupDivHeaderTextObj=windowIframePopupObj.document.getElementById("iframePopupDivHeader");
        var div1x1MoveImageObj=document.getElementById("div1x1MoveImage");
        div1x1MoveImageObj.innerHTML=windowIframePopupObj.document.getElementById("iframePopupDivHeaderText").innerHTML;
          
        var height=iframePopupDivHeaderTextObj.clientHeight;
        var leftStart=0,leftEnd=0;     
        var rightStart=0,rightEnd=0;     
        var topStart=0,topEnd=0; 
        leftEnd=document.body.scrollLeft;
        leftStart=ptrPopupArray[index].left;
 
        widthEnd=document.body.clientWidth;
        widthStart=ptrPopupArray[index].MIDWidth;
        topEnd=document.body.scrollTop;
        topStart=ptrPopupArray[index].top; 

        window.setTimeout(function(){ptrStartModalDialogAnimation(imgObj,div1x1MoveImageObj,10,leftStart,leftEnd,widthStart,widthEnd,topStart,topEnd,height);},0);
      }

      function ptrStartModalDialogAnimation(imgObj,div1x1MoveImageObj,countAnimation,leftStart,leftEnd,widthStart,widthEnd,topStart,topEnd,height)
      {
        var left=0;
        var width=0;
        var top=0;
        var countAnimationBasis=parseInt(countAnimation)+1;

        div1x1MoveImageObj.style.display="block";

        var factor=imgObj.getAttribute("mode")=="MAX"?countAnimationBasis-countAnimation:countAnimation;
        if(countAnimation>0){
          left=leftStart-parseInt(((leftStart-leftEnd)/countAnimationBasis)*factor);
        }
        else if(imgObj.getAttribute("mode")=="MAX"){
          left=leftEnd;
        }
        else{
          left=leftStart;
        }

        if(countAnimation>0){
          width=widthStart-parseInt(((widthStart-widthEnd)/countAnimationBasis)*factor);
        }
        else if(imgObj.getAttribute("mode")=="MAX"){
          width=widthEnd;
        }
        else{
          width=widthStart;
        }

        if(countAnimation>0){
          top=topStart-parseInt(((topStart-topEnd)/countAnimationBasis)*factor);
        }
        else if(imgObj.getAttribute("mode")=="MAX"){
          top=topEnd;
        }
        else{
          top=topStart;
        }

        div1x1MoveImageObj.style.top=top;
        div1x1MoveImageObj.style.left=left;
        div1x1MoveImageObj.style.width=width;
        div1x1MoveImageObj.style.height=height;

        countAnimation--;
        if(countAnimation>=0){
          window.setTimeout(function(){ptrStartModalDialogAnimation(imgObj,div1x1MoveImageObj,countAnimation,leftStart,leftEnd,widthStart,widthEnd,topStart,topEnd,height);},0);
        }
        else{
          window.setTimeout(function(){ptrInitModalDialog(null,imgObj);},0);
          ptrToggle=false;
        }        
      }

      function ptrResizeModalDialog(popupId,style,translationObj)
      {
        var currentIndex=ptrPopupArray.length-1;
        if(typeof(translationObj)!="object"){
          translationObj=new Object;
        }
        if(typeof(popupId)=="string" && popupId.length>0){
          for(var i=0;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].popupId==popupId){
              currentIndex=i;
              translationObj.popupId=popupId;
            }
          }
        }

        if(ptrPopupArray[currentIndex].oInnerPopup==null){
          return;
        }
        var ptrBodyLoadingObj=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.body;
        if(ptrBodyLoadingObj.id=="ptrBodyLoading"){
          return;
        }
        if(ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.body.className.indexOf("urPopBdyEmp")<0){
          ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.body.className=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.body.className+" urPopBdyEmp";
        }
        var imgObj=ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupToggleIconId");
        if(ptrPopupArray[currentIndex].oInnerPopup!=null){
          ptrCheckFocus(currentIndex);
        }

        if(typeof(style)=="number"){
          if(typeof(ptrPopupArray[currentIndex].style)!="number" || ptrPopupArray[currentIndex].style!=style){
            ptrPopupArray[currentIndex].style=style;
            var strDocument="";
            for(var i=0;i<style;i++){
              strDocument += ptrToolbarButton(ptrPopupArray.length-1,"BUTTON_"+i,"");
            }
            ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrToolbarContent").innerHTML=strDocument;
          }
        }
        if(imgObj.getAttribute("mode")=="MAX"){
          ptrInitModalDialog(translationObj,null,true);
        }
      }

      function ptrTranslateLabel(trans,obj)
      {
        if(typeof(trans)!="undefined"&&obj!=null){
          if(typeof(trans.title)!="undefined"||typeof(trans.tooltip)!="undefined"){
            obj.title=typeof(trans.title)!="undefined"?trans.title:trans.tooltip;
          }
          var html="";
          if(typeof(trans.image)=="object" && typeof(trans.image.src)=="string"){
            html='<img border="0" align="absmiddle" src="'+trans.image.src+'" alt="';
            if(typeof(trans.image.alt)=="string"){
              html+=trans.image.alt;
            }
            else{
              html+=trans.image.src;
            }
            html+='">&nbsp;';
          }
          obj.innerHTML=html+'<span style="white-space:nowrap;">'+trans.text+'</span>';
        }
      }

      function ptrInitModalDialogLabels(translationObj,currentIndex)
      {
        var popupWindow=ptrPopupArray[currentIndex].oPopup.frame.window;

        if(typeof(ptrPopupArray[currentIndex].style)=="number"){
          for(var i=0;i<ptrPopupArray[currentIndex].style;i++){
            ptrTranslateLabel(translationObj["BUTTON_"+i],popupWindow.document.getElementById("BUTTON_"+i));
          }
        }
        else{
          ptrTranslateLabel(translationObj.ABORT,popupWindow.document.getElementById("ABORT"));
          ptrTranslateLabel(translationObj.CLOSE,popupWindow.document.getElementById("CLOSE"));
          ptrTranslateLabel(translationObj.RETRY,popupWindow.document.getElementById("RETRY"));
          ptrTranslateLabel(translationObj.IGNORE,popupWindow.document.getElementById("IGNORE"));
          ptrTranslateLabel(translationObj.OK,popupWindow.document.getElementById("OK"));
          ptrTranslateLabel(translationObj.YES,popupWindow.document.getElementById("YES"));
          ptrTranslateLabel(translationObj.NO,popupWindow.document.getElementById("NO"));
          ptrTranslateLabel(translationObj.CANCEL,popupWindow.document.getElementById("CANCEL"));
        }

        if(typeof(translationObj.title)!="undefined"){
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("iframePopupDivHeaderText").innerHTML="<a href='javascript:void(0);' tabindex='0' id='iframePopupDivHeaderA'></a>&nbsp;"+translationObj.title;
        }
      }

      function ptrSetTitle(popupId,title)
      {
        var currentIndex=null;
        for(var i=0;i<ptrPopupArray.length;i++){
          if(ptrPopupArray[i].popupId==popupId){
            currentIndex=i;
            break;
          }
        }
        if(currentIndex==null)return;
        ptrInitModalDialogLabels({title:title},currentIndex);
      }

      function ptrGetWinRefById(popupId)
      {
          var urlWindow=null;
          for(var i=0;i<ptrPopupArray.length;i++){
            if(popupId==ptrPopupArray[i].popupId){
              urlWindow=ptrPopupArray[i].oInnerPopup.frame.window;
              break;
            }
          }
          return urlWindow;
      }

      function ptrInitDialogByWindow(urlWindow)
      {
          ptrInitModalDialog({popupId:ptrGetPopupId(urlWindow)});
      }

      function ptrInitDialogById(popupId)
      {
          ptrInitModalDialog({popupId:popupId});
      }

      function ptrGetPopupId(urlWindow)
      {
          var popupId=null;
          for(var i=0;i<ptrPopupArray.length;i++){
            if(urlWindow==ptrPopupArray[i].oInnerPopup.frame.window){
              popupId=ptrPopupArray[i].popupId;
              break;
            }
          }
          return popupId;
      }

      function ptrInitModalDialog(translationObj,toggleObj,resize)
      {
        if(ptrPopupArray.length==0)return;

        var currentIndex=ptrPopupArray.length-1;
        var isFix=ptrPopupArray[currentIndex].isFix;
        if(typeof(translationObj)!="undefined" && translationObj!=null){
          if(typeof(translationObj.popupId)!="undefined"){
            for(var i=0;i<ptrPopupArray.length;i++){
              if(ptrPopupArray[i].popupId==translationObj.popupId){
                currentIndex=i;
                isFix=ptrPopupArray[currentIndex].isFix;
              }
            }
          }
          ptrInitModalDialogLabels(translationObj,currentIndex);
          if(typeof(translationObj.sourceFocusId)=="string"){
            ptrPopupArray[currentIndex].sourceFocusId=translationObj.sourceFocusId;
          }
        }

        if(typeof(toggleObj)=="undefined"){
          toggleObj=null;
        }

        if(typeof(resize)=="undefined"){
          resize=false;
        }

        if(ptrPopupArray[currentIndex].dialogMode=="modless"){
          var zIndex=parseInt(ptrPopupArray[currentIndex].oPopup.frame.object.style.zIndex);
          for(var i=0;i<ptrPopupArray.length-1;i++){
            if(parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)>zIndex){
              zIndex=parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex);
              currentIndex=i;
              isFix=ptrPopupArray[currentIndex].isFix;
            }
          }
        }

        ptrPopupArray[currentIndex].isInitial=false;

        var sourceWindow=ptrPopupArray[currentIndex].sourceWindow;
        var iframeWindow=null;
        if(ptrPopupArray[currentIndex].oInnerPopup!=null){
          iframeWindow=ptrPopupArray[currentIndex].oInnerPopup.frame.window;
          iframeWindow.sourceWindow=sourceWindow;
          if(iframeWindow.document.body.className.indexOf("urPopBdyEmp")<0){
            iframeWindow.document.body.className=iframeWindow.document.body.className+" urPopBdyEmp";
          }
        }

        if(toggleObj==null && ptrPopupArray[currentIndex].oPopup.frame.object.style.display=="block" && resize==false && isFix==false){
          return iframeWindow;
        }

        ptrPopupArray[currentIndex].oPopup.frame.object.style.left="-5000px";
        ptrPopupArray[currentIndex].oPopup.frame.object.style.top="-5000px";
        ptrPopupArray[currentIndex].oPopup.frame.object.style.display="block";
        if(iframeWindow!=null){
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left="-5000px";
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.top="-5000px";
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.display="block";
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.scrolling="auto";
        }

        var left=0;
        var top=0;
        var width=0;
        var height=0;

        var windowIframePopupObj=ptrPopupArray[currentIndex].oPopup.frame.window;
        var iframePopupDivOuterFrame1Obj=windowIframePopupObj.document.getElementById("iframePopupDivOuterFrame1");
        var iframePopupDivOuterFrame2Obj=windowIframePopupObj.document.getElementById("iframePopupDivOuterFrame2");
        var iframePopupDivHeaderTextObj=windowIframePopupObj.document.getElementById("iframePopupDivHeaderText");
        var iframePopupDivInnerFrameObj=windowIframePopupObj.document.getElementById("iframePopupDivInnerFrame");

        var showSrollbars=false;

        if(iframeWindow!=null){
          width=iframeWindow.document.body.scrollWidth;
        }
        else{
          width=ptrPopupArray[currentIndex].width;
        }
          
        if(ptrPopupArray[currentIndex].isFix==true){
          width=ptrPopupArray[currentIndex].width;
        }

        var winWidth=document.body.offsetWidth;
        if(winWidth<document.body.clientWidth)winWidth=document.body.clientWidth;

        if(toggleObj!=null && toggleObj.getAttribute("mode")=="MAX"){
          width=document.body.clientWidth;
        }
        else if(toggleObj!=null && toggleObj.getAttribute("mode")=="MID"){
          width=ptrPopupArray[currentIndex].MIDWidth;
        }
        else if(toggleObj==null){
          if(width<ptrPopupArray[currentIndex].width){
            width=ptrPopupArray[currentIndex].width;
          }
          if(width>winWidth-24){
            width=winWidth-24;
          }
          width+=4;
          var widthToolbar=ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrToolbarTable").scrollWidth+4+22+40+15+22;
          if(width<widthToolbar)width=widthToolbar;
          if(width<ptrPopupArray[currentIndex].width)width=ptrPopupArray[currentIndex].width;
        }
        if(toggleObj==null && ptrPopupArray[currentIndex].type.length>0){
          width+=72;
        }

        if(width>=ptrPopupArray[currentIndex].width||width>=winWidth-24){
          showSrollbars=true;
        }
 
        if(toggleObj!=null && toggleObj.getAttribute("mode")=="MAX"){
          left=document.body.scrollLeft;
        }
        else if(toggleObj!=null && toggleObj.getAttribute("mode")=="MID"){
          left=ptrPopupArray[currentIndex].left;
        }
        else if(toggleObj==null){
          if(resize==true){
            left=ptrPopupArray[currentIndex].left;
          }
          else if(ptrPopupArray.length==1&&ptrPopupArray[currentIndex].dialogMode=="modless"){
            left=document.body.scrollLeft+10;
          }
          else if(ptrPopupArray[currentIndex].dialogMode=="modless"){
            if(winWidth>(ptrPopupArray[currentIndex-1].left+ptrPopupArray[currentIndex-1].MIDWidth+width))
              left=ptrPopupArray[currentIndex-1].left+ptrPopupArray[currentIndex-1].MIDWidth;
            else
              left=document.body.scrollLeft+10;
          }          
          else if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
            left=document.body.scrollLeft+(winWidth-width)/2;
            for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
              if(ptrPopupArray[i].isInitial==false)
                ptrPopupArray[i].left=left+(i-currentIndex)*30;
            }
          }
          else{
            left=0;
            for(var i=0;i<=currentIndex;i++){
              if(ptrPopupArray[i].dialogMode=="startModal"){
                left=ptrPopupArray[i].left;
              }
              else if(left>0){
                left+=30;
              }
            }
          }
        }

        if(toggleObj==null){    
          ptrPopupArray[currentIndex].left=left;
          ptrPopupArray[currentIndex].MIDWidth=width;
        }

        ptrPopupArray[currentIndex].oPopup.size.left=left;
        ptrPopupArray[currentIndex].oPopup.size.width=width;

        ptrPopupArray[currentIndex].oPopup.frame.object.style.left=left;
        ptrPopupArray[currentIndex].oPopup.frame.object.style.width=width;

        width=width-2;

        iframePopupDivOuterFrame1Obj.style.width=width;
        width=width-2;
        iframePopupDivOuterFrame2Obj.style.width=width;
        iframePopupDivHeaderTextObj.style.width=width-50;
        if(iframeWindow!=null){
          iframePopupDivInnerFrameObj.style.width=width-4;
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.width=width;
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left=left+2;
          if(ptrPopupArray[currentIndex].type.length>0){
            ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left=parseInt(ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.left)+72;
            ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.width=parseInt(ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.width)-72;
          }
        }
        else if(ptrPopupArray[currentIndex].type.length>0){
          iframePopupDivInnerFrameObj.style.width=width-72;
        }
        else{
          iframePopupDivInnerFrameObj.style.width=width;
        }

        if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
          for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].isInitial==false){
              ptrPopupArray[i].oPopup.size.left=ptrPopupArray[i].left;
              ptrPopupArray[i].oPopup.frame.object.style.left=ptrPopupArray[i].left;
              if(iframeWindow!=null){
                ptrPopupArray[i].oInnerPopup.frame.object.style.left=ptrPopupArray[i].left+2;
              }
            }
          }
        }

        if(ptrPopupArray[currentIndex].isFix==true){
          height=ptrPopupArray[currentIndex].height;
        }
        else if(iframeWindow!=null){
          height=iframeWindow.document.body.scrollHeight;
        }
        else{
          height=ptrPopupArray[currentIndex].height;
        }

        var winHeight=document.body.offsetHeight;
        if(winHeight<document.body.clientHeight)winHeight=document.body.clientHeight;

        if(toggleObj!=null && toggleObj.getAttribute("mode")=="MAX"){
          height=document.body.clientHeight;
        }
        else if(toggleObj!=null && toggleObj.getAttribute("mode")=="MID"){
          height=ptrPopupArray[currentIndex].MIDHeight;
        }
        else if(toggleObj==null){
          if(height<ptrPopupArray[currentIndex].height){
            height=ptrPopupArray[currentIndex].height;
          }
          if(height>winHeight-66){
            height=winHeight-66;
          }
          height+=46;
          if(height<ptrPopupArray[currentIndex].height)height=ptrPopupArray[currentIndex].height;
        }
        if(height>=ptrPopupArray[currentIndex].height||height>=winHeight-66){
          showSrollbars=true;
        }

        if(toggleObj!=null && toggleObj.getAttribute("mode")=="MAX"){
          top=document.body.scrollTop;
        }
        else if(toggleObj!=null && toggleObj.getAttribute("mode")=="MID"){
          top=ptrPopupArray[currentIndex].top;
        }
        else if(toggleObj==null){          
          if(resize==true){
            top=ptrPopupArray[currentIndex].top;
          }
          else if(ptrPopupArray.length==1&&ptrPopupArray[currentIndex].dialogMode=="modless"){
            top=document.body.scrollTop+10;
          }
          else if(ptrPopupArray[currentIndex].dialogMode=="modless"){
            if(winWidth>(ptrPopupArray[currentIndex-1].left+ptrPopupArray[currentIndex-1].MIDWidth+width))
              top=ptrPopupArray[currentIndex-1].top;
            else
              top=ptrPopupArray[currentIndex-1].top+ptrPopupArray[currentIndex-1].MIDHeight;
          }          
          else if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
            top=document.body.scrollTop+(winHeight-height)/2;
            for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
              if(ptrPopupArray[i].isInitial==false)
                ptrPopupArray[i].top=top+(i-currentIndex)*30;
            }
          }
          else{
            top=0;
            for(var i=0;i<=currentIndex;i++){
              if(ptrPopupArray[i].dialogMode=="startModal"){
                top=ptrPopupArray[i].top;
              }
              else if(top>0){
                top+=30;
              }
            }
          }
        }

        if(toggleObj==null){
          ptrPopupArray[currentIndex].top=top;
          ptrPopupArray[currentIndex].MIDHeight=height;
        }

        ptrPopupArray[currentIndex].oPopup.size.top=top;
        ptrPopupArray[currentIndex].oPopup.size.height=height;

        ptrPopupArray[currentIndex].oPopup.frame.object.style.top=top;
        ptrPopupArray[currentIndex].oPopup.frame.object.style.height=height;

        height=height-2;

        iframePopupDivOuterFrame1Obj.style.height=height;
        height=height-2;
        iframePopupDivOuterFrame2Obj.style.height=height;
        iframePopupDivInnerFrameObj.style.height=height-51;
        if(iframeWindow!=null){
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.height=height-51;
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.style.top=top+24;
        }

        if(ptrPopupArray[currentIndex].dialogMode=="startModal"){
          for(var i=currentIndex+1;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].isInitial==false){
              ptrPopupArray[i].oPopup.size.top=ptrPopupArray[i].top;
              ptrPopupArray[i].oPopup.frame.object.style.top=ptrPopupArray[i].top;
              if(iframeWindow!=null){
                ptrPopupArray[i].oInnerPopup.frame.object.style.top=ptrPopupArray[i].top+23;
              }
            }
          }
        }

        if(iframeWindow!=null && showSrollbars==false){
          ptrPopupArray[currentIndex].oInnerPopup.frame.object.scrolling="no";
        }

        if(toggleObj!=null){
          var div1x1MoveImageObj=document.getElementById("div1x1MoveImage");
          div1x1MoveImageObj.style.display="none";  
        }
        if(toggleObj!=null && toggleObj.getAttribute("mode")=="MAX"){
          toggleObj.setAttribute("mode","MID");
          ptrPopupArray[currentIndex].mode="MID";
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupResizeIconId").className="urPopFrameResizeHide";
          toggleObj.className="urPopTitleAreaResize urPopFrameMid";         
        }
        else if(toggleObj!=null && toggleObj.getAttribute("mode")=="MID"){
          toggleObj.setAttribute("mode","MAX");
          ptrPopupArray[currentIndex].mode="MAX";
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById("ptrPopupResizeIconId").className="urPopFrameResize";
          toggleObj.className="urPopTitleAreaResize urPopFrameMax";
        }

        if(toggleObj==null && ptrPopupArray[currentIndex].dialogMode=="startModal" && resize==false){
          ptrBlenLogoff();
        }

        if(toggleObj==null && currentIndex==ptrPopupArray.length-1){
          ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById('iframePopupDivHeaderA').focus();
        }
        if(toggleObj==null && ptrPopupArray[currentIndex].oInnerPopup!=null){
          ptrCheckFocus(currentIndex);
        }

        return iframeWindow;
      }

      function ptrCheckFocus(currentIndex)
      { 
        var documentBody=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.body;
        if(ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.getElementById("ptrFocusStart2")==null){
          var spanFocusStart2=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.createElement('A');
          spanFocusStart2.id="ptrFocusStart2";
          spanFocusStart2.tabIndex="0";
          //spanFocusStart2.addEventListener("focus",function(){ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.getElementById('go').focus();},false);
          spanFocusStart2.href='javascript:void(0);';
          documentBody.insertBefore(spanFocusStart2,documentBody.childNodes[0]);
        }
        if(ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.getElementById("ptrFocusStart1")==null){
          var spanFocusStart1=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.createElement('A');
          spanFocusStart1.id="ptrFocusStart1";
          spanFocusStart1.tabIndex="0";
          spanFocusStart1.href='javascript:void(0);';
          spanFocusStart1.addEventListener("focus",function(){ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById('iframePopupDivHeaderA').focus();},false);
          documentBody.insertBefore(spanFocusStart1,documentBody.childNodes[0]);
        }
        if(ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.getElementById("ptrFocusEnd")==null){
          var spanFocusEnd=ptrPopupArray[currentIndex].oInnerPopup.frame.window.document.createElement('A');
          spanFocusEnd.id="ptrFocusEnd";
          spanFocusEnd.tabIndex="0";
          spanFocusEnd.href='javascript:void(0);';
          spanFocusEnd.addEventListener("focus",function(){ptrPopup.ptrPopupArray[currentIndex].oPopup.frame.window.document.getElementById('ptrToolbar').focus();},false);
          documentBody.appendChild(spanFocusEnd);
        }
      }

      function ptrGetSourceWindow(urlWindow)
      {
        var currentIndex=ptrPopupArray.length-1;
        if(typeof(urlWindow)!="undefined"){
          for(var i=0;i<ptrPopupArray.length;i++){
            if(urlWindow==ptrPopupArray[i].oInnerPopup.frame.window){
              currentIndex=i;
            }
          }
        }
        var sourceWindow=ptrPopupArray[currentIndex].sourceWindow;
        return sourceWindow;
      }

      function ptrCloseModalDialog(popupId,okCode)
      {
        if(typeof(okCode)=="undefined"){
          okCode="";
        }
        var currentIndex=ptrPopupArray.length-1;
        if(typeof(popupId)!="undefined" && popupId.length>0){
          for(var i=0;i<ptrPopupArray.length;i++){
            if(ptrPopupArray[i].popupId==popupId){
              currentIndex=i;
            }
          }
        }

        ptrHideModalDialog(null,okCode,currentIndex);
      }

      function ptrHideModalDialog(event,id,index)
      {
        if(typeof index=="undefined")index=ptrPopupArray.length-1;
        if(typeof ptrPopupArray=="undefined"||ptrPopupArray.length==0)return;
        var close=true;
        if(ptrPopupArray[index].oInnerPopup!=null){
          var iframeInnerPopupWindow=ptrPopupArray[index].oInnerPopup.frame.window;
          try{
            close=iframeInnerPopupWindow.ptrOnHideModalDialog(id);
          }
          catch(e){};
        }
        var sourceWindow=ptrPopupArray[index].sourceWindow; 
        try{
          close=sourceWindow.ptrOnHideModalDialog(id);
        }
        catch(e){};
        if(close==true){
          //Unblock ActiveX Controls...
          for(var i=0;i<ptrActiveXArray.length;i++){
            var item=ptrActiveXArray[i];
            if(item.isActive==true && item.enable==true){
              try{
                item.ptrFunction();
              }
              catch(e){}
            }
          }

          if(ptrPopupArray[index].dialogMode=="startModal"||ptrPopupArray[index].dialogMode=="modless"){
            try{
              if(typeof(ptrPopupArray[index].sourceFocusId)=="string" && ptrPopupArray[index].sourceFocusId.length>0){
                sourceWindow.document.getElementById(ptrPopupArray[index].sourceFocusId).focus();
              }
            }catch(e){}
          }

          var div1x1ImageObj = document.getElementById("div1x1Image");
          if(ptrPopupArray[index].dialogMode=="startModal"){
            div1x1ImageObj.style.cursor="default";
            div1x1ImageObj.style.backgroundColor="";
            div1x1ImageObj.style.display="none";
            ptrPopup.document.body.style.overflow=ptrPopupArray[index].overflow;
          }
          ptrPopupArray[index].oPopup.frame.object.style.top="-5001"; 
          ptrPopupArray[index].oPopup.frame.object.style.left="0px";
          ptrPopupArray[index].oPopup.frame.object.style.width="10px";
          if(ptrPopupArray[index].oInnerPopup!=null){
            ptrPopupArray[index].oInnerPopup.frame.object.style.top="-5001"; 
            ptrPopupArray[index].oInnerPopup.frame.object.style.left="0px";
            ptrPopupArray[index].oInnerPopup.frame.object.style.width="10px";
          }
          
          if(ptrPopupArray[index].dialogMode=="startModal"||
              ptrPopupArray[index].dialogMode=="modal"||
               (ptrPopupArray[index].dialogMode=="modless"&&index==ptrPopupArray.length-1)){
            if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null)
              sapPopupStore.pop();
            sapPopupStore.pop();
            ptrPopupArray.pop();
            while(ptrPopupArray.length>0&&ptrPopupArray[ptrPopupArray.length-1].showDialog==false){
              if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null)
                sapPopupStore.pop();
              sapPopupStore.pop();
              ptrPopupArray.pop();
            }
          }
          else if(ptrPopupArray[index].dialogMode=="modless"&&index!=ptrPopupArray.length-1){
            ptrPopupArray[index].showDialog=false;
          }
          if(ptrPopupArray.length>0 && ptrPopupArray[ptrPopupArray.length-1].dialogMode!="modless"){
            var iframePopupObj=ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.object;
            iframePopupObj.style.zIndex=4999+2*ptrPopupArray.length;
            if(ptrPopupArray[ptrPopupArray.length-1].oInnerPopup!=null){
              var iframeInnerPopupObj=ptrPopupArray[ptrPopupArray.length-1].oInnerPopup.frame.object;
              iframeInnerPopupObj.style.zIndex=parseInt(iframePopupObj.style.zIndex)+1;
            }
            try{ptrPopupArray[ptrPopupArray.length-1].oPopup.frame.window.document.getElementById('iframePopupDivHeaderA').focus();}catch(e){}
          }
        }
      }

      function ptrStartPopup(event,index,mode,resize)
      {
        if(ptrPopupArray[index].dialogMode=="modless" && ptrPopupArray.length>0){
          var iframePopupObj1=ptrPopupArray[index].oPopup.frame.object;
          var zIndex1=parseInt(iframePopupObj1.style.zIndex);
          var iframePopupObj2=null;
          var zIndex2=0;
          var topIndex=0;
          for(var i=0;i<ptrPopupArray.length;i++){
            if(parseInt(ptrPopupArray[i].oPopup.frame.object.style.zIndex)>zIndex2){
              iframePopupObj2=ptrPopupArray[i].oPopup.frame.object;
              zIndex2=parseInt(iframePopupObj2.style.zIndex);
              topIndex=i;
            }
          }
          if(index!=topIndex){
            iframePopupObj1.style.zIndex=zIndex2;
            iframePopupObj2.style.zIndex=zIndex1;

            var iframeInnerPopupObj1=ptrPopupArray[index].oInnerPopup.frame.object;
            var iframeInnerPopupObj2=ptrPopupArray[topIndex].oInnerPopup.frame.object;
            iframeInnerPopupObj1.style.zIndex=parseInt(iframePopupObj1.style.zIndex)+1;
            iframeInnerPopupObj2.style.zIndex=parseInt(iframePopupObj2.style.zIndex)+1;
          }
        }

        if(ptrPopupArray[index].mode=="MID")
          return false;

        if(typeof(mode)!="boolean"){
          mode=false;
        }
        if(typeof(resize)!="boolean"){
          resize=false;
        }

        var iframePopupObj=ptrPopupArray[index].oPopup.frame.object;
        var windowIframePopupObj=ptrPopupArray[index].oPopup.frame.window;

        var iframeInnerPopupObj=null;
        var windowIframeInnerPopupObj=null;
        if(ptrPopupArray[index].oInnerPopup!=null){
          iframeInnerPopupObj=ptrPopupArray[index].oInnerPopup.frame.object;
          windowIframeInnerPopupObj=ptrPopupArray[index].oInnerPopup.frame.window;
        }

        var target=event.target;

        var iframePopupDivOuterFrame1Obj=windowIframePopupObj.document.getElementById("iframePopupDivOuterFrame1");
        var iframePopupDivOuterFrame2Obj=windowIframePopupObj.document.getElementById("iframePopupDivOuterFrame2");
        var iframePopupDivHeaderTextObj=windowIframePopupObj.document.getElementById("iframePopupDivHeaderText");
        var iframePopupDivInnerFrameObj=windowIframePopupObj.document.getElementById("iframePopupDivInnerFrame");

        var data = {
          target:target,
          startX:parseInt(iframePopupObj.style.left),
          startY:parseInt(iframePopupObj.style.top),
          startW:parseInt(iframePopupObj.style.width),
          startH:parseInt(iframePopupObj.style.height),
          x:event.screenX,
          y:event.screenY,
          iframePopupObj:iframePopupObj,
          windowIframePopupObj:windowIframePopupObj,
          windowIframeInnerPopupObj:windowIframeInnerPopupObj,
          iframeInnerPopupObj:iframeInnerPopupObj,
          event:event,
          index:index,
          mode:mode
        };
        ptrStartPopup.data=data;

        windowIframePopupObj.document.documentElement.addEventListener("mousemove",ptrMovePopup,true);
        windowIframePopupObj.document.documentElement.addEventListener("mouseup",ptrEndPopup,true);
        if(windowIframeInnerPopupObj!=null){
          windowIframeInnerPopupObj.document.documentElement.addEventListener("mousemove",ptrMovePopup,true);
          windowIframeInnerPopupObj.document.documentElement.addEventListener("mouseup",ptrEndPopup,true);
        }
        document.documentElement.addEventListener("mousemove",ptrMovePopup,true);
        document.documentElement.addEventListener("mouseup",ptrEndPopup,true);

        if(resize==true){
          var dataResize = {
            windowIframePopupBody:ptrPopupArray[index].oInnerPopup!=null?ptrPopupArray[index].oInnerPopup.frame.window.document.body:null,
            iframePopupDivOuterFrame1Obj:iframePopupDivOuterFrame1Obj,
            iframePopupDivOuterFrame2Obj:iframePopupDivOuterFrame2Obj,
            iframePopupDivOuterFrameWidth:parseInt(iframePopupDivOuterFrame1Obj.style.width),
            iframePopupDivOuterFrameHeight:parseInt(iframePopupDivOuterFrame1Obj.style.height),

            iframePopupDivHeaderTextObj:iframePopupDivHeaderTextObj,
            iframePopupDivHeaderTextWidth:parseInt(iframePopupDivHeaderTextObj.style.width),

            iframePopupDivInnerFrameObj:iframePopupDivInnerFrameObj,
            iframePopupDivInnerFrameWidth:parseInt(iframePopupDivInnerFrameObj.style.width),
            iframePopupDivInnerFrameHeight:parseInt(iframePopupDivInnerFrameObj.style.height)
          };
          ptrStartPopup.dataResize=dataResize;
        }
      }

      function ptrMovePopup(event)
      {
        event.cancelBubble=true;

        var data=ptrStartPopup.data;
        if(typeof(data)!="object") return;

        var dataResize=ptrStartPopup.dataResize;

        if(typeof(dataResize)=="object" && dataResize!=null){
          if(data.iframeInnerPopupObj!=null)
            data.iframeInnerPopupObj.scrolling="auto";
          var width=data.startW+data.event.screenX-data.x;
          if(width>90){
            data.iframePopupObj.style.width=data.startW+data.event.screenX-data.x;
            if(data.iframeInnerPopupObj!=null){
              data.iframeInnerPopupObj.style.width=data.startW+data.event.screenX-data.x-4;
              if(ptrPopupArray[data.index].type.length>0){
                ptrPopupArray[data.index].oInnerPopup.frame.object.style.width=parseInt(data.iframePopupObj.style.width)-54;
              }
            }

            dataResize.iframePopupDivOuterFrame1Obj.style.width=dataResize.iframePopupDivOuterFrameWidth+data.event.screenX-data.x;
            dataResize.iframePopupDivOuterFrame2Obj.style.width=dataResize.iframePopupDivOuterFrameWidth+data.event.screenX-data.x-2;
            dataResize.iframePopupDivInnerFrameObj.style.width=dataResize.iframePopupDivInnerFrameWidth+data.event.screenX-data.x;

            dataResize.iframePopupDivHeaderTextObj.style.width=dataResize.iframePopupDivHeaderTextWidth+data.event.screenX-data.x;
          }
        }
        else{
          data.iframePopupObj.style.left=data.startX+data.event.screenX-data.x;
          if(data.iframeInnerPopupObj!=null){
            data.iframeInnerPopupObj.style.left=parseInt(data.iframePopupObj.style.left)+2;
            if(ptrPopupArray[data.index].type.length>0){
              ptrPopupArray[data.index].oInnerPopup.frame.object.style.left=parseInt(data.iframePopupObj.style.left)+72;
            }
          }
        }
        if(data.mode==true){
          var width=document.body.clientWidth-ptrPopupArray[data.index].MIDWidth;
          if(parseInt(data.iframePopupObj.style.left)<1){
            data.iframePopupObj.style.left=1;
            if(data.iframeInnerPopupObj!=null){
              data.iframeInnerPopupObj.style.left=parseInt(data.iframePopupObj.style.left)+2;
              if(ptrPopupArray[data.index].type.length>0){
                ptrPopupArray[data.index].oInnerPopup.frame.object.style.left=parseInt(data.iframePopupObj.style.left)+72;
              }
            }
          }
          if(data.iframePopupObj.style.left>width){
            data.iframePopupObj.style.left=width;
            if(data.iframeInnerPopupObj!=null){
              data.iframeInnerPopupObj.style.left=parseInt(data.iframePopupObj.style.left)+2;
              if(ptrPopupArray[data.index].type.length>0){
                ptrPopupArray[data.index].oInnerPopup.frame.object.style.left=parseInt(data.iframePopupObj.style.left)+72;
              }
            }
          }
        }
        ptrPopupArray[data.index].left=parseInt(data.iframePopupObj.style.left);

        if(typeof(dataResize)=="object" && dataResize!=null){
          var height=data.startH+data.event.screenY-data.y;
          if(height>90){
            data.iframePopupObj.style.height=data.startH+data.event.screenY-data.y;
            if(data.iframeInnerPopupObj!=null)
              data.iframeInnerPopupObj.style.height=data.startH+data.event.screenY-data.y-55;

            dataResize.iframePopupDivOuterFrame1Obj.style.height=dataResize.iframePopupDivOuterFrameHeight+data.event.screenY-data.y;
            dataResize.iframePopupDivOuterFrame2Obj.style.height=dataResize.iframePopupDivOuterFrameHeight+data.event.screenY-data.y-2;
            dataResize.iframePopupDivInnerFrameObj.style.height=dataResize.iframePopupDivInnerFrameHeight+data.event.screenY-data.y;
          }
        }
        else{
          data.iframePopupObj.style.top=data.startY+data.event.screenY-data.y;
          if(data.iframeInnerPopupObj!=null)
            data.iframeInnerPopupObj.style.top=parseInt(data.iframePopupObj.style.top)+24;
        }
        if(data.mode==true){
          var height=document.body.clientHeight-30;
          if(parseInt(data.iframePopupObj.style.top)<1){
            data.iframePopupObj.style.top=1;
            if(data.iframeInnerPopupObj!=null)
              data.iframeInnerPopupObj.style.top=parseInt(data.iframePopupObj.style.top)+24;
          }
          if(data.iframePopupObj.style.top>height){
            data.iframePopupObj.style.top=height;
            if(data.iframeInnerPopupObj!=null)
              data.iframeInnerPopupObj.style.top=parseInt(data.iframePopupObj.style.top)+24;
          }
        }
        ptrPopupArray[data.index].top=parseInt(data.iframePopupObj.style.top);
      }

      function ptrEndPopup()
      {
        if(typeof(ptrStartPopup.data)!="object")
          return;

        var windowIframePopupObj=ptrStartPopup.data.windowIframePopupObj;
        windowIframePopupObj.document.documentElement.removeEventListener("mousemove",ptrMovePopup,true);
        windowIframePopupObj.document.documentElement.removeEventListener("mouseup",ptrEndPopup,true);
        var windowIframeInnerPopupObj=ptrStartPopup.data.windowIframeInnerPopupObj;
        if(windowIframeInnerPopupObj!=null){
          windowIframeInnerPopupObj.document.documentElement.removeEventListener("mousemove",ptrMovePopup,true);
          windowIframeInnerPopupObj.document.documentElement.removeEventListener("mouseup",ptrEndPopup,true);
        }
        document.documentElement.removeEventListener("mousemove",ptrMovePopup,true);
        document.documentElement.removeEventListener("mouseup",ptrEndPopup,true);

        ptrStartPopup.data=null;
        if(typeof(ptrStartPopup.dataResize)=="object" && ptrStartPopup.dataResize!=null)
          ptrStartPopup.dataResize=null;
      }
