// -----------------------------------------------------------------------------
// SAP Domain Relaxation
//
// Stripped down version, that only does auto relaxation
// Can be used for static resources, or pages that only are be used
// as part of an application
//
// There is a bug in Internet Explorer, that causes domain relaxation
// to fail intermittently, when the domain, where content is loaded from is
// the same as the relaxed domain of the parent
// (e.g. relaxed to wdf.sap.corp, iframe url http://wdf.sap.corp/....)
// -----------------------------------------------------------------------------

function ur_autorelax() {
  var hostname = location.hostname,
      nameparts = hostname.split("."),
      partslength = nameparts.length,
      reference = "parent",
      maxrelax = 2;
  
  // if hostname is an ip address don't try to relax
  if (/^(\d|\.)+$/.test(hostname)) return true;

  // if hostname has no domain part don't relax
  if (partslength == 1) return true;
  
  // enhance maxrelax for two level TLD (e.g. co.uk)
  if (nameparts[partslength - 1].length == 2 &&
      nameparts[partslength - 2].length == 2) {
    maxrelax = 3;
  } 

  // check if already reached maxrelax
  if (partslength <= maxrelax) return true;

  // if there is no parent window, use opener instead	
  if (window[reference] == window) reference = "opener";

  // try until correct one is found or maximal relaxation reached
  try {
    window[reference].location.href;
    return true;
  }
  catch (e) {};
  var testdomain;
  for (var i = 0; i <= partslength - maxrelax; i++) {
    testdomain = nameparts.slice(i).join(".");
    try {
      document.domain = testdomain;
      window[reference].location.href;
      return;
    }
    catch (e) {};
  }
}
ur_autorelax();
