/*
 * Olap_2.java
 *
 * Copyright 2004-2006 by SAP AG. All Rights Reserved.
 * SAP, R/3, mySAP, mySAP.com, xApps, xApp, SAP NetWeaver, and other SAP 
 * products and services mentioned herein as well as their respective logos 
 * are trademarks or registered trademarks of SAP AG in Germany and in several 
 * other countries all over the world. All other product and service names 
 * mentioned are the trademarks of their respective companies. Data contained 
 * in this document serves informational purposes only. National product 
 * specifications may vary.
 *
 * These materials are subject to change without notice. These materials are 
 * provided by SAP AG and its affiliated companies ("SAP Group") for 
 * informational purposes only, without representation or warranty of any kind, 
 * and SAP Group shall not be liable for errors or omissions with respect to 
 * the materials. The only warranties for SAP Group products and services are 
 * those that are set forth in the express warranty statements accompanying 
 * such products and services, if any. Nothing herein should be construed as 
 * constituting an additional warranty.
 */
package com.sap.ip.bi.sdk.samples;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sap.exception.IBaseException;
import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.samples.servlet.MinimalServletContainer;

/**
 * Direct Execution of MDX statement -
 *
 * Demonstrates how to retrieve a result set by directly executing an
 * MDX statement, then shows how to display the result set as an
 * HTML table.
 *
 * View the HTML rendered by this servlet in the following file:
 * [SDK archive]/docs/examples/olap_2.result.html
 *
 * @author  SAP
 * @version 3.50
 * @since   3.50
 */
public class Olap_2 extends HttpServlet {
  private final static String CONTENT_TYPE = "text/html";

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
  }

  public void doGet(
    HttpServletRequest request,
    HttpServletResponse response)
    throws ServletException, IOException {

    response.setContentType(CONTENT_TYPE);
    PrintWriter out = response.getWriter();

    out.println(Helpers.getDocTypeDefinition());
    out.println("<html>");
    out.println("<head><title>Olap_2</title>");
    out.println(Helpers.getStyleSheetDefinition());
    out.println("</head><body>");

    try {

      // ********************************************************
      // Connect to a data source.
      // ********************************************************
      IBIConnection connection =
        Helpers.connectToXMLADatasource(out);
      IBIOlap olap = connection.getOlap();

      // ********************************************************
      // Execute the MDX statement and retrieve the data set
      // using the execute method of the IBIOlap interface.
      // ********************************************************
      String mdxStatement =
        "SELECT "
          + "{[Measures].[0D_QUANT_B],[Measures].[0D_COSTVALS]} ON COLUMNS, "
          + "NON EMPTY [0D_SALE_ORG].MEMBERS ON ROWS FROM [$0D_SD_C03] "
          + "WHERE ([0D_VTYPE].[010],[0D_VERSION].[000],[0D_DIV].[7])";
      IBIDataSet dataset = olap.execute(mdxStatement);

      // ********************************************************
      // Render the data set.
      // ********************************************************
      // Display the MDX statement.
      out.println(
        "<p><b>MDX Statement that was executed:</b><br> "
          + "<span class=\"code\">"
          + mdxStatement
          + "</span>"
          + "</p>");

      // Render table.
      Helpers.renderDataset(out, dataset, false);

    } 
    // Catch errors.
    catch (Exception e) {
      // $JL-EXC$
      e.printStackTrace();
      if (e instanceof IBaseException)
        out.println("Error: " +
                ((IBaseException)e).getNestedLocalizedMessage());
      else  
        out.println("Error: " + e.getMessage());        
    }
    out.println("</body>");
    out.println("</html>");
  }

  public void destroy() {
  }

  public static void main(String[] args) {
    if (args.length == 1) {
      MinimalServletContainer.executeServlet(new Olap_2(), args[0]);
    } else {
      MinimalServletContainer.executeServlet(new Olap_2(), System.out);
    }
  }

}
