/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.odbo.impl;

import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Connection;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Fields;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Recordset;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.olap.BISAPVariableConstants;
import com.sap.ip.bi.sdk.dac.connector.olap.BIVariant;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.connector.olap.OlapMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.AttributeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.BISAPVariableObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.CubeObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.DimensionObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelBasedHierarchyObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.LevelObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.MeasureObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.OlapSchemaObject;
import com.sap.ip.bi.sdk.dac.connector.olap.schema.SchemaObject;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;

class OdboMDRConnection
extends CommonMDRConnection {
    private Locale locale;
    private Connection connection = null;
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$OdboMDRConnection == null ? (class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$OdboMDRConnection = OdboMDRConnection.class$("com.sap.ip.bi.sdk.dac.connector.odbo.impl.OdboMDRConnection")) : class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$OdboMDRConnection).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private static String[][] MANDATORY_PROPERTY = new String[][]{{"MEMBER_CAPTION", "1", "0", "0", "DATA_TYPE", "A label or caption associated with the member", null, null, "Member caption"}, {"MEMBER_NAME", "1", "0", "0", "DATA_TYPE", "Name of the member", null, null, "Member name"}, {"MEMBER_UNIQUE_NAME", "1", "0", "0", "DATA_TYPE", "Unique name of the member", null, null, "Member unique name"}};
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$OdboMDRConnection;

    public OdboMDRConnection(Connection connection, BIOlapDataSourceType dataSourceType) throws BIResourceException {
        super(connection.getConnectionInfo(), dataSourceType);
        loc.entering("OdboMDRConnection()");
        this.connection = connection;
        ((OlapMDRConnection)this).connectionInfo = connection.getConnectionInfo();
        this.locale = ((OlapMDRConnection)this).connectionInfo.getLocale();
        loc.exiting();
    }

    public void assertLoadSchemas() throws BIResourceException {
        loc.entering("assertLoadSchemas()");
        if (this.metaStore.getSchema().isEmpty()) {
            this.assertFindSchema(null);
        }
        loc.exiting();
    }

    public void assertLoadCubes() throws BIResourceException {
        loc.entering("assertLoadCubes()");
        Iterator i = this.metaStore.getSchema().values().iterator();
        while (i.hasNext()) {
            SchemaObject schema = (SchemaObject)i.next();
            if (!this.metaStore.getCube(schema).isEmpty()) continue;
            String schemaName = MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)schema.getCatalogName(), (String)schema.getSchemaName());
            this.assertFindCube(schemaName, null);
        }
        loc.exiting();
    }

    public void assertLoadCubes(SchemaObject schema) throws BIResourceException {
        loc.entering("assertLoadCubes(SchemaObject schema)");
        if (!this.metaStore.getCube(schema).isEmpty()) {
            loc.exiting();
            return;
        }
        this.assertFindCube(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)schema.getCatalogName(), (String)schema.getSchemaName()), null);
        loc.exiting();
    }

    public void assertLoadCubeDimensionAssoc(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertLoadCubeDimensionAssoc(OlapSchemaObject obj)");
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        Object dimensionUName = null;
        if (obj != null) {
            if (obj instanceof CubeObject) {
                if (!this.metaStore.getDimension((CubeObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((CubeObject)obj).getCatalogName();
                schemaName = ((CubeObject)obj).getSchemaName();
                cubeName = ((CubeObject)obj).getCubeName();
            } else if (obj instanceof DimensionObject) {
                if (!this.metaStore.getDimensionofCube((DimensionObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((DimensionObject)obj).getCatalogName();
                schemaName = ((DimensionObject)obj).getSchemaName();
                cubeName = ((DimensionObject)obj).getCubeName();
            } else {
                throw new BIRuntimeException(this.locale, "sdk.dac.connector_1021");
            }
        }
        try {
            Recordset rs = this.connection.openSchema(33, new String[]{catalogName, null, cubeName, null, null});
            rs.moveFirst();
            while (!rs.isEOF()) {
                DimensionObject dimObj = this.newDimensionObject(rs);
                rs.moveNext();
            }
        }
        catch (Exception ex) {
            throw new BIResourceException(this.locale, "sdk.dac.connector_1104", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        loc.exiting();
    }

    public void assertLoadLevelBasedHierarchies(DimensionObject dimension) throws BIResourceException {
        if (!this.metaStore.getHierarchy(dimension).isEmpty()) {
            return;
        }
        this.assertFindHierarchy(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)dimension.getCatalogName(), (String)dimension.getSchemaName()), dimension.getCubeName(), dimension.getDimensionName(), null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void assertLoadHierarchyLevelAssoc(OlapSchemaObject obj) throws BIResourceException {
        loc.entering("assertLoadHierarchyLevelAssoc(OlapSchemaObject obj)");
        String catalogName = null;
        String schemaName = null;
        String cubeName = null;
        String dimensionUName = null;
        Object hierarchyUName = null;
        if (obj != null) {
            if (obj instanceof LevelBasedHierarchyObject) {
                if (!this.metaStore.getLevel((LevelBasedHierarchyObject)obj).isEmpty()) {
                    return;
                }
                catalogName = ((LevelBasedHierarchyObject)obj).getCatalogName();
                schemaName = ((LevelBasedHierarchyObject)obj).getSchemaName();
                cubeName = ((LevelBasedHierarchyObject)obj).getCubeName();
                dimensionUName = ((LevelBasedHierarchyObject)obj).getDimensionUniqueName();
            } else {
                if (!(obj instanceof LevelObject)) throw new BIRuntimeException(this.locale, "sdk.dac.connector_1021");
                if (!this.metaStore.getLevelofHierarchy((LevelObject)obj).isEmpty()) {
                    loc.exiting();
                    return;
                }
                catalogName = ((LevelObject)obj).getCatalogName();
                schemaName = ((LevelObject)obj).getSchemaName();
                dimensionUName = ((LevelObject)obj).getDimensionUniqueName();
            }
        } else if (!this.metaStore.getDimension().isEmpty()) {
            loc.exiting();
            return;
        }
        try {
            Recordset rs = this.connection.openSchema(35, new String[]{catalogName, schemaName, cubeName, dimensionUName, null, null});
            rs.moveFirst();
            while (!rs.isEOF()) {
                LevelObject levelObj = this.newLevelObject(rs);
                rs.moveNext();
            }
        }
        catch (Exception ex) {
            throw new BIResourceException(this.locale, "sdk.dac.connector_1104", new Object[]{ex.getMessage()}, (Throwable)ex);
        }
        loc.exiting();
    }

    public void assertLoadMeasures(CubeObject cube) throws BIResourceException {
        if (!this.metaStore.getMeasure(cube).isEmpty()) {
            return;
        }
        this.assertFindMeasure(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)cube.getCatalogName(), (String)cube.getSchemaName()), cube.getCubeName(), null);
    }

    public void assertLoadSAPVariables(CubeObject cube) throws BIResourceException {
        if (!this.metaStore.getSAPVariable(cube).isEmpty()) {
            return;
        }
        this.assertFindSAPVariable(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)cube.getCatalogName(), (String)cube.getSchemaName()), cube.getCubeName(), null);
    }

    private void setVariable(BISAPVariableObject sapVariableObject, Fields fields) {
        sapVariableObject.setVariableGUID(fields.getItem(BISAPVariableConstants.VARIABLE_UID).getString());
        sapVariableObject.setVariableCaption(fields.getItem(BISAPVariableConstants.VARIABLE_CAPTION).getString());
        sapVariableObject.setVariableOrdinal(fields.getItem(BISAPVariableConstants.VARIABLE_ORDINAL).getInt());
        sapVariableObject.setVariableType(fields.getItem(BISAPVariableConstants.VARIABLE_TYPE).getShort());
        sapVariableObject.setDataType(fields.getItem(BISAPVariableConstants.DATA_TYPE).getString());
        sapVariableObject.setCharacterMaximumLength(fields.getItem(BISAPVariableConstants.CHARACTER_MAXIMUM_LENGTH).getLong());
        sapVariableObject.setVariableProcessingType(fields.getItem(BISAPVariableConstants.VARIABLE_PROCESSING_TYPE).getInt());
        sapVariableObject.setVariableSelectionType(fields.getItem(BISAPVariableConstants.VARIABLE_SELECTION_TYPE).getInt());
        sapVariableObject.setVariableEntryType(fields.getItem(BISAPVariableConstants.VARIABLE_ENTRY_TYPE).getInt());
        sapVariableObject.setReferenceDimension(fields.getItem(BISAPVariableConstants.REFERENCE_DIMENSION).getString());
        sapVariableObject.setReferenceHierarchy(fields.getItem(BISAPVariableConstants.REFERENCE_HIERARCHY).getString());
        sapVariableObject.setDefaultLow(fields.getItem(BISAPVariableConstants.DEFAULT_LOW).getVariant());
        sapVariableObject.setDefaultLowCap(fields.getItem(BISAPVariableConstants.DEFAULT_LOW_CAP).getString());
        sapVariableObject.setDefaultHighCap(fields.getItem(BISAPVariableConstants.DEFAULT_HIGH_CAP).getString());
        sapVariableObject.setDescription(fields.getItem("DESCRIPTION").getString());
    }

    public void assertLoadAttributes(DimensionObject dimension) throws BIResourceException {
        loc.entering("assertLoadAttributes(DimensionObject dimension)");
        if (this.metaStore.getAttribute(dimension).isEmpty()) {
            Recordset rs = this.connection.openSchema(37, new String[]{dimension.getCatalogName(), dimension.getSchemaName(), dimension.getCubeName(), dimension.getDimensionUniqueName(), null, null, null, null, null});
            rs.moveFirst();
            int i = 0;
            while (i < rs.getRecordCount()) {
                this.newAttributeObject(rs, dimension);
                rs.moveNext();
                ++i;
            }
            int i2 = 0;
            while (i2 < MANDATORY_PROPERTY.length) {
                AttributeObject attrObj = new AttributeObject(dimension.getCatalogName(), dimension.getSchemaName(), dimension.getCubeName(), dimension.getDimensionUniqueName(), null, null, null, MANDATORY_PROPERTY[i2][0], MANDATORY_PROPERTY[i2][1]);
                attrObj.setCharacterMaximumLength(MANDATORY_PROPERTY[i2][2]);
                attrObj.setCharacterOctetLength(MANDATORY_PROPERTY[i2][3]);
                attrObj.setDataType(MANDATORY_PROPERTY[i2][4]);
                attrObj.setDescription(MANDATORY_PROPERTY[i2][5]);
                attrObj.setNumericPrecision(MANDATORY_PROPERTY[i2][6]);
                attrObj.setNumericScale(MANDATORY_PROPERTY[i2][7]);
                attrObj.setPropertyCaption(MANDATORY_PROPERTY[i2][8]);
                if (!this.metaStore.containsAttribute(attrObj)) {
                    this.metaStore.addAttribute(attrObj, (OlapSchemaObject)dimension);
                }
                ++i2;
            }
        }
        loc.exiting();
    }

    public List assertFindSchema(String schemaName) throws BIResourceException {
        loc.entering("assertFindSchema(String schemaName)");
        ArrayList<SchemaObject> schemas = new ArrayList<SchemaObject>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        Recordset rs = this.connection.openSchema(1, new String[]{lCatalogName});
        rs.moveFirst();
        while (!rs.isEOF()) {
            SchemaObject schema = this.newSchemaObject(rs);
            schemas.add(schema);
            rs.moveNext();
        }
        loc.exiting();
        return schemas;
    }

    public List assertFindCube(String schemaName, String cubeName) throws BIResourceException {
        loc.entering("assertFindCube(String schemaName, String cubeName)");
        this.assertLoadSchemas();
        ArrayList<CubeObject> cubes = new ArrayList<CubeObject>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        Recordset rs = this.connection.openSchema(32, new String[]{lCatalogName, lSchemaName, null});
        boolean chkCubeName = false;
        if (cubeName != null && cubeName.length() != 0) {
            chkCubeName = true;
        }
        rs.moveFirst();
        while (!rs.isEOF()) {
            CubeObject cube = this.newCubeObject(rs);
            if (chkCubeName && !cubeName.equalsIgnoreCase(rs.getFields().getItem("CUBE_NAME").getString())) {
                rs.moveNext();
                continue;
            }
            cubes.add(cube);
            rs.moveNext();
        }
        loc.exiting();
        return cubes;
    }

    public List assertFindDimension(String schemaName, String cubeName, String dimensionName) throws BIResourceException {
        loc.entering("assertFindDimension()");
        ArrayList<DimensionObject> dimensions = new ArrayList<DimensionObject>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        Recordset rs = this.connection.openSchema(33, new String[]{lCatalogName, lSchemaName, cubeName, null, null});
        boolean checkDimensionNam = false;
        if (dimensionName != null && dimensionName.length() != 0) {
            checkDimensionNam = true;
        }
        rs.moveFirst();
        while (!rs.isEOF()) {
            DimensionObject dimension = this.newDimensionObject(rs);
            if (checkDimensionNam && !dimensionName.equalsIgnoreCase(dimension.getDimensionName())) {
                rs.moveNext();
                continue;
            }
            dimensions.add(dimension);
            rs.moveNext();
        }
        loc.exiting();
        return dimensions;
    }

    public List assertFindMeasure(String schemaName, String cubeName, String measureName) throws BIResourceException {
        loc.entering("assertFindMeasure()");
        boolean checkMeasureNam = false;
        if (measureName != null && measureName.length() != 0) {
            checkMeasureNam = true;
        }
        ArrayList<MeasureObject> measures = new ArrayList<MeasureObject>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        Recordset rs = this.connection.openSchema(36, new String[]{lCatalogName, lSchemaName, cubeName, null, null});
        rs.moveFirst();
        while (!rs.isEOF()) {
            MeasureObject measure = this.newMeasureObject(rs);
            if (checkMeasureNam && !measureName.equalsIgnoreCase(rs.getFields().getItem("MEASURE_NAME").getString())) {
                rs.moveNext();
                continue;
            }
            measures.add(measure);
            rs.moveNext();
        }
        loc.exiting();
        return measures;
    }

    public List assertFindSAPVariable(String schemaName, String cubeName, String variableName) throws BIResourceException {
        loc.entering("assertFindSAPVariable()");
        boolean checkVariableNam = false;
        if (variableName != null && variableName.length() != 0) {
            checkVariableNam = true;
        }
        ArrayList<BISAPVariableObject> variables = new ArrayList<BISAPVariableObject>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        Recordset rs = this.connection.openSchema(-1, new String[]{lCatalogName, lSchemaName, cubeName}, BISAPVariableConstants.MDSCHEMA_SAP_VARIABLES);
        rs.moveFirst();
        while (!rs.isEOF()) {
            BISAPVariableObject variable = this.newSAPVariableObject(rs);
            if (checkVariableNam && !variableName.equalsIgnoreCase(rs.getFields().getItem(BISAPVariableConstants.VARIABLE_NAME).getString())) {
                rs.moveNext();
                continue;
            }
            variables.add(variable);
            rs.moveNext();
        }
        loc.exiting();
        return variables;
    }

    public List assertFindHierarchy(String schemaName, String cubeName, String dimensionName, String hierarchyName) throws BIResourceException {
        loc.entering("assertFindHierarchy()");
        ArrayList<LevelBasedHierarchyObject> hierarchies = new ArrayList<LevelBasedHierarchyObject>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        String dimensionUName = MetadataNameConverter.dimensionNameToDimensionUniqueName((String)dimensionName);
        boolean checkHryNam = false;
        if (hierarchyName != null && hierarchyName.length() != 0) {
            checkHryNam = true;
        }
        Recordset rs = this.connection.openSchema(34, new String[]{lCatalogName, lSchemaName, cubeName, dimensionUName, null, null});
        rs.moveFirst();
        while (!rs.isEOF()) {
            LevelBasedHierarchyObject hierarchy = this.newLevelBasedHierarchyObject(rs);
            if (checkHryNam && !hierarchyName.equalsIgnoreCase(rs.getFields().getItem("HIERARCHY_NAME").getString()) && !MetadataNameConverter.dimensionNameToDimensionUniqueName((String)dimensionName).equalsIgnoreCase(rs.getFields().getItem("HIERARCHY_UNIQUE_NAME").getString())) {
                rs.moveNext();
                continue;
            }
            hierarchies.add(hierarchy);
            rs.moveNext();
        }
        loc.exiting();
        return hierarchies;
    }

    public List assertFindLevel(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName) throws BIResourceException {
        loc.entering("assertFindLevel()");
        boolean checkLvlNam = false;
        if (levelName != null && levelName.length() != 0) {
            checkLvlNam = true;
        }
        ArrayList<LevelObject> levels = new ArrayList<LevelObject>();
        String lCatalogName = MetadataNameConverter.schemaNameToCatalogName((Locale)this.locale, (String)schemaName);
        String lSchemaName = MetadataNameConverter.schemaNameToSchemaName((Locale)this.locale, (String)schemaName);
        String dimensionUName = this.dimensionNameToDimensionUniqueName(dimensionName);
        String hierarchyUName = this.hierarchyNameToHierarchyUniqueName(lCatalogName, lSchemaName, cubeName, dimensionUName, hierarchyName);
        Recordset rs = this.connection.openSchema(35, new String[]{lCatalogName, lSchemaName, cubeName, dimensionUName, hierarchyUName, levelName, null});
        rs.moveFirst();
        while (!rs.isEOF()) {
            LevelObject level = this.newLevelObject(rs);
            if (checkLvlNam && !levelName.equalsIgnoreCase(rs.getFields().getItem("LEVEL_NAME").getString())) {
                rs.moveNext();
                continue;
            }
            levels.add(level);
            rs.moveNext();
        }
        loc.exiting();
        return levels;
    }

    private DimensionObject newDimensionObject(Recordset rs) {
        loc.entering("newDimensionObject(Recordset rs)");
        DimensionObject dimension = new DimensionObject(rs.getFields().getItem("CATALOG_NAME").getString(), "", rs.getFields().getItem("CUBE_NAME").getString(), rs.getFields().getItem("DIMENSION_UNIQUE_NAME").getString());
        if (!this.metaStore.containsDimension(dimension)) {
            dimension.setDimensionName(rs.getFields().getItem("DIMENSION_NAME").getString());
            dimension.setDefaultHierarchy(rs.getFields().getItem("DEFAULT_HIERARCHY").getString());
            dimension.setDimensionCaption(rs.getFields().getItem("DIMENSION_CAPTION").getString());
            dimension.setDimensionCardinality(String.valueOf((int)rs.getFields().getItem("DIMENSION_CARDINALITY").getDouble()));
            dimension.setDimensionGuid(rs.getFields().getItem("DIMENSION_GUID").getString());
            dimension.setDimensionOrdinal(String.valueOf((int)rs.getFields().getItem("DIMENSION_ORDINAL").getDouble()));
            dimension.setDimensionType(String.valueOf(rs.getFields().getItem("DIMENSION_TYPE").getShort()));
            dimension.setDescription(rs.getFields().getItem("DESCRIPTION").getString());
            this.metaStore.addDimension(dimension);
        }
        loc.exiting();
        return (DimensionObject)this.metaStore.getDimension().get(dimension.toString());
    }

    private CubeObject newCubeObject(Recordset rs) {
        loc.entering("newCubeObject(Recordset rs)");
        CubeObject cube = new CubeObject(rs.getFields().getItem("CATALOG_NAME").getString(), "", rs.getFields().getItem("CUBE_NAME").getString());
        if (!this.metaStore.containsCube(cube)) {
            cube.setCreatedOn(rs.getFields().getItem("CREATED_ON").getString());
            cube.setCubeGuid(rs.getFields().getItem("CUBE_GUID").getString());
            cube.setCubeType(rs.getFields().getItem("CUBE_TYPE").getString());
            cube.setDataUpdatedBy(rs.getFields().getItem("DATA_UPDATED_BY").getString());
            cube.setDescription(rs.getFields().getItem("DESCRIPTION").getString());
            Date date = rs.getFields().getItem("LAST_DATA_UPDATE").getDate();
            if (date != null) {
                cube.setLastDataUpdate(date.toString());
            }
            if ((date = rs.getFields().getItem("LAST_SCHEMA_UPDATE").getDate()) != null) {
                cube.setLastSchemaUpdate(date.toString());
            }
            this.metaStore.addCube(cube);
        }
        loc.exiting();
        return (CubeObject)this.metaStore.getCube().get(cube.toString());
    }

    private SchemaObject newSchemaObject(Recordset rs) {
        loc.entering("newSchemaObject(Recordset rs)");
        SchemaObject schema = new SchemaObject(rs.getFields().getItem("CATALOG_NAME").getString(), "");
        if (!this.metaStore.containsSchema(schema)) {
            schema.setDescription(rs.getFields().getItem("DESCRIPTION").getString());
            this.metaStore.addSchema(schema);
        }
        loc.exiting();
        return (SchemaObject)this.metaStore.getSchema().get(schema.toString());
    }

    private LevelBasedHierarchyObject newLevelBasedHierarchyObject(Recordset rs) {
        loc.entering("newLevelBasedHierarchyObject(Recordset rs)");
        LevelBasedHierarchyObject hierarchy = new LevelBasedHierarchyObject(rs.getFields().getItem("CATALOG_NAME").getString(), rs.getFields().getItem("SCHEMA_NAME").getString(), rs.getFields().getItem("CUBE_NAME").getString(), rs.getFields().getItem("DIMENSION_UNIQUE_NAME").getString(), rs.getFields().getItem("HIERARCHY_UNIQUE_NAME").getString());
        if (!this.metaStore.containsHierarchy(hierarchy)) {
            hierarchy.setCubeName(rs.getFields().getItem("CUBE_NAME").getString());
            hierarchy.setAllMember(rs.getFields().getItem("ALL_MEMBER").getString());
            hierarchy.setDefaultMember(rs.getFields().getItem("DEFAULT_MEMBER").getString());
            hierarchy.setDimensionType(String.valueOf(rs.getFields().getItem("DIMENSION_TYPE").getShort()));
            hierarchy.setHierarchyCaption(rs.getFields().getItem("HIERARCHY_CAPTION").getString());
            hierarchy.setHierarchyCardinality(String.valueOf((int)rs.getFields().getItem("HIERARCHY_CARDINALITY").getDouble()));
            hierarchy.setHierarchyGuid(rs.getFields().getItem("HIERARCHY_GUID").getString());
            hierarchy.setHierarchyName(rs.getFields().getItem("HIERARCHY_NAME").getString());
            hierarchy.setDescription(rs.getFields().getItem("DESCRIPTION").getString());
            this.metaStore.addHierarchy(hierarchy);
        }
        loc.exiting();
        return (LevelBasedHierarchyObject)this.metaStore.getHierarchy().get(hierarchy.toString());
    }

    private LevelObject newLevelObject(Recordset rs) {
        loc.entering("newLevelObject(Recordset rs)");
        Fields fields = rs.getFields();
        LevelObject level = new LevelObject(fields.getItem("CATALOG_NAME").getString(), "", fields.getItem("CUBE_NAME").getString(), fields.getItem("DIMENSION_UNIQUE_NAME").getString(), fields.getItem("HIERARCHY_UNIQUE_NAME").getString(), fields.getItem("LEVEL_UNIQUE_NAME").getString(), (int)fields.getItem("LEVEL_NUMBER").getDouble());
        if (!this.metaStore.containsLevel(level)) {
            level.setCubeName(fields.getItem("CUBE_NAME").getString());
            level.setLevelCadinality(String.valueOf((int)fields.getItem("LEVEL_CARDINALITY").getDouble()));
            level.setLevelCaption(fields.getItem("LEVEL_CAPTION").getString());
            level.setLevelGuid(fields.getItem("LEVEL_GUID").getString());
            level.setLevelName(fields.getItem("LEVEL_NAME").getString());
            level.setLevelNumber((int)fields.getItem("LEVEL_NUMBER").getDouble());
            level.setLevelType(String.valueOf(fields.getItem("LEVEL_TYPE").getInt()));
            level.setDescription(fields.getItem("DESCRIPTION").getString());
            this.metaStore.addLevel(level);
        }
        loc.exiting();
        return (LevelObject)this.metaStore.getLevel().get(level.toString());
    }

    private AttributeObject newAttributeObject(Recordset rs, DimensionObject dimension) {
        loc.entering("newAttributeObject(Recordset rs,  \tDimensionObject dimension)");
        Fields fields = rs.getFields();
        AttributeObject attrObj = new AttributeObject(fields.getItem("CATALOG_NAME").getString(), "", fields.getItem("CUBE_NAME").getString(), fields.getItem("DIMENSION_UNIQUE_NAME").getString(), fields.getItem("HIERARCHY_UNIQUE_NAME").getString(), fields.getItem("LEVEL_UNIQUE_NAME").getString(), fields.getItem("MEMBER_UNIQUE_NAME").getString(), fields.getItem("PROPERTY_NAME").getString(), String.valueOf(fields.getItem("PROPERTY_TYPE").getShort()));
        if (!this.metaStore.containsAttribute(attrObj)) {
            attrObj.setCharacterMaximumLength(String.valueOf(fields.getItem("CHARACTER_MAXIMUM_LENGTH").getInt()));
            attrObj.setCharacterOctetLength(String.valueOf(fields.getItem("CHARACTER_OCTET_LENGTH").getInt()));
            attrObj.setDataType(String.valueOf(fields.getItem("DATA_TYPE").getInt()));
            attrObj.setDescription(String.valueOf(fields.getItem("DESCRIPTION").getInt()));
            attrObj.setNumericPrecision(String.valueOf(fields.getItem("NUMERIC_PRECISION").getInt()));
            attrObj.setNumericScale(String.valueOf(fields.getItem("NUMERIC_SCALE").getShort()));
            attrObj.setPropertyCaption(fields.getItem("PROPERTY_CAPTION").getString());
            this.metaStore.addAttribute(attrObj, (OlapSchemaObject)dimension);
        }
        loc.exiting();
        return (AttributeObject)this.metaStore.getAttribute().get(attrObj.toString());
    }

    private MeasureObject newMeasureObject(Recordset rs) {
        loc.entering("newMeasureObject(Recordset rs)");
        Fields fields = rs.getFields();
        MeasureObject measure = new MeasureObject(fields.getItem("CATALOG_NAME").getString(), "", fields.getItem("CUBE_NAME").getString(), fields.getItem("MEASURE_UNIQUE_NAME").getString());
        if (!this.metaStore.containsMeasure(measure)) {
            measure.setMeasureName(fields.getItem("MEASURE_NAME").getString());
            measure.setMeasureCaption(fields.getItem("MEASURE_CAPTION").getString());
            measure.setMeasureGuid(fields.getItem("MEASURE_GUID").getString());
            measure.setMeasureAggregator(String.valueOf(fields.getItem("MEASURE_AGGREGATOR").getInt()));
            measure.setDataType(String.valueOf(fields.getItem("DATA_TYPE").getInt()));
            measure.setNumericPrecision(String.valueOf(fields.getItem("NUMERIC_PRECISION").getInt()));
            measure.setNumericScale(String.valueOf(fields.getItem("NUMERIC_SCALE").getShort()));
            measure.setMeasureUnits(fields.getItem("MEASURE_UNITS").getString());
            measure.setDescription(fields.getItem("DESCRIPTION").getString());
            this.metaStore.addMeasure(measure);
        }
        loc.exiting();
        return (MeasureObject)this.metaStore.getMeasure().get(measure.toString());
    }

    private BISAPVariableObject newSAPVariableObject(Recordset rs) {
        loc.entering("newSAPVariableObject(Recordset rs)");
        Fields fields = rs.getFields();
        BISAPVariableObject variable = new BISAPVariableObject(fields.getItem("SCHEMA_NAME").getString(), "", fields.getItem("CUBE_NAME").getString(), fields.getItem(BISAPVariableConstants.VARIABLE_NAME).getString());
        if (!this.metaStore.containsSAPVariable(variable)) {
            this.setVariable(variable, fields);
            this.metaStore.addSAPVariable(variable);
        }
        loc.exiting();
        return (BISAPVariableObject)this.metaStore.getSAPVariable().get(variable.toString());
    }

    private String hierarchyNameToHierarchyUniqueName(String catalog, String schema, String cube, String dimensionUName, String hierarchy) {
        String hierarchyUName;
        block2: {
            hierarchyUName = null;
            if (MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUName).equals(hierarchy)) {
                return dimensionUName;
            }
            if (hierarchy == null || dimensionUName == null) break block2;
            Recordset rshie = this.connection.openSchema(34, new String[]{catalog, schema, cube, dimensionUName, hierarchy, null});
            rshie.moveFirst();
            if (!rshie.isEOF()) {
                hierarchyUName = rshie.getFields().getItem("HIERARCHY_UNIQUE_NAME").getString();
            }
        }
        return hierarchyUName;
    }

    protected IBIMember findMember(String catalogName, String schemaName, String cubeName, String dimensionUName, String hierarchyUName, String memberCaption, BIVariant defaultValue) throws BIResourceException {
        return this.connection.getObjectFinder().findMemberFirst(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)catalogName, (String)schemaName), cubeName, MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUName), MetadataNameConverter.hierarchyUniqueNametoHierarchyName((String)hierarchyUName), null, null, null);
    }

    protected LevelBasedHierarchy findHierarchyFirst(String catalogName, String schemaName, String cubeName, String dimensionUName, String hierarchyUName) throws BIResourceException {
        return this.connection.getObjectFinder().findHierarchyFirst(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)catalogName, (String)schemaName), cubeName, MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUName), MetadataNameConverter.hierarchyUniqueNametoHierarchyName((String)hierarchyUName));
    }

    protected Dimension findDimensionFirst(String catalogName, String schemaName, String cubeName, String dimensionUName) throws BIResourceException {
        return this.connection.getObjectFinder().findDimensionFirst(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)catalogName, (String)schemaName), cubeName, MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

