/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.odbo.impl;

import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionDetails;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.odbo.OdboConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOCommon;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.ADOMDCellSet;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Field;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Fields;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.OdboMDRConnection;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.OdboMDRConnectionRelational;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Recordset;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.connector.olap.BITreeOperator;
import com.sap.ip.bi.sdk.dac.connector.olap.BIVariant;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.CommonRelationalConnection;
import com.sap.ip.bi.sdk.dac.connector.olap.MetadataNameConverter;
import com.sap.ip.bi.sdk.dac.olap.query.IBIMemberFactory;
import com.sap.ip.bi.sdk.dac.olap.query.IBIQueryFactory;
import com.sap.ip.bi.sdk.dac.olap.query.member.IBIMember;
import com.sap.ip.bi.sdk.dac.relational.query.IBIQueryExecute;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.dac.result.IBIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSet;
import com.sap.ip.bi.sdk.dac.result.impl.BIResultSetData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIAxisCursor;
import com.sap.ip.bi.sdk.dac.result.impl.IBIColumnMetaData;
import com.sap.ip.bi.sdk.dac.result.impl.IBIResultSetData;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.exception.BIRuntimeException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.ip.bi.sdk.util.impl.BILogonLanguage;
import com.sap.ip.bi.sdk.util.impl.IBIMonitor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.analysis.olap.Dimension;
import org.omg.cwm.analysis.olap.Hierarchy;
import org.omg.cwm.analysis.olap.Level;
import org.omg.cwm.analysis.olap.LevelBasedHierarchy;
import org.omg.cwm.objectmodel.core.CorePackage;
import org.omg.cwm.objectmodel.core.ModelElement;

public class Connection
extends CommonRelationalConnection
implements IBIConnectionDetails,
IBIQueryExecute {
    private IBIOlap olap = null;
    private IBIQueryFactory queryFactory = null;
    private Properties properties;
    private static Attributes attributes = null;
    private String _conStr;
    private String _userID = "";
    private String _passWD = "";
    private long _openOption = -1L;
    private ADOMDCellSet _cellSet = null;
    private static IBIDataSet dataSet;
    private static IBIColumnMetaData[] cellMeta;
    private static IBIResultSetData cellData;
    private static IBIAxisCursor rowCursor;
    private static IBIAxisCursor colCursor;
    private static BIColumnMetaData[] rowMeta;
    private static BIColumnMetaData[] colMeta;
    private static IBIResultSetData rowData;
    private static IBIResultSetData colData;
    private boolean newInstance = false;
    private final boolean AUTOCOMMIT = true;
    private final boolean NOCOMMIT = false;
    private HashMap taggedValueMap = new HashMap();
    private ADOCommon adoCommon;
    private CorePackage corePackage = null;
    private static final Location loc;
    private static final Category cat;
    private IBIMonitor monitor;
    private LocalTransaction trans = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$Connection;

    private Connection() {
        loc.entering("Connection()");
        this.adoCommon = new ADOCommon();
        loc.exiting();
    }

    private Connection(Properties prop) {
        if (prop != null) {
            loc.entering("Constructor(" + ((Hashtable)prop).toString() + ")");
        } else {
            loc.entering("Constructor(null)");
        }
        this.adoCommon = new ADOCommon(prop);
        this.properties = new Properties();
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            ((Hashtable)this.properties).put(key, prop.getProperty(key));
        }
        this._conStr = prop.getProperty(OdboConnectionConstants.CONNECTION_STRING.toString());
        loc.exiting();
    }

    public Connection(String conStr) {
        loc.entering("Connection(String conStr)");
        this.adoCommon = new ADOCommon(conStr);
        this._conStr = conStr;
        loc.exiting();
    }

    public static Connection connect(String connString) throws ResourceException {
        loc.entering("connect()");
        Connection c = new Connection(connString);
        c.connectODBO();
        loc.exiting();
        return c;
    }

    public static Connection connect(Properties props) throws ResourceException {
        loc.entering("connect()");
        Connection c = new Connection(props);
        ((CommonConnection)c).connectionInfo = c.new ConnectionInfo();
        c.connectODBO();
        loc.exiting();
        return c;
    }

    private void connectODBO() throws ResourceException {
        this.adoCommon.connect(((CommonConnection)this).connectionInfo);
    }

    public IBIConnectionInfo getConnectionInfo() throws BIResourceException {
        if (((CommonConnection)this).connectionInfo == null) {
            throw new BIResourceException(Locale.getDefault(), "sdk_0000");
        }
        return ((CommonConnection)this).connectionInfo;
    }

    public void connectMdr() throws BIResourceException {
        loc.entering("connectMdr()");
        try {
            ((CommonConnection)this).mdr = new OdboMDRConnection(this, this.getDataSourceType());
            this.trans = ((CommonConnection)this).mdr.getLocalTransaction();
            this.trans.begin();
        }
        catch (ResourceException ex) {
            throw new BIResourceException(((CommonConnection)this).connectionInfo.getLocale(), "sdk.dac.connector.mmr_1000", (Throwable)ex);
        }
        loc.exiting();
    }

    public BIOlapDataSourceType getDataSourceType() {
        String conStr = this._conStr.toUpperCase();
        if (conStr.indexOf("MDRMSAP") > 0) {
            return BIOlapDataSourceType.SAP_BW;
        }
        if (conStr.indexOf("MSOLAP") > 0) {
            return BIOlapDataSourceType.MS_OLAP;
        }
        return BIOlapDataSourceType.OTHER;
    }

    public void close() throws BIResourceException {
        loc.entering("close()");
        ((CommonConnection)this).connectionInfo = null;
        try {
            if (((CommonConnection)this).mdr != null) {
                if (this.trans != null) {
                    this.trans.rollback();
                }
                ((CommonConnection)this).mdr.close();
                ((CommonConnection)this).mdr = null;
            }
        }
        catch (ResourceException ex) {
            loc.errorT("sdk.dac.connector_1103");
            throw new BIRuntimeException(((CommonConnection)this).connectionInfo.getLocale(), "sdk.dac.connector_1103", (Throwable)ex);
        }
        this.adoCommon.close();
        loc.exiting();
    }

    public String getProperty(String key) {
        loc.entering("getProperty(String key)");
        loc.exiting();
        return this.properties.getProperty(key);
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static Connection createConnection(Properties prop) {
        return new Connection(prop);
    }

    public boolean isAlive() throws BIResourceException {
        return true;
    }

    public Attributes getAttributes() {
        if (attributes == null) {
            attributes = new Attributes();
        }
        return attributes;
    }

    public void open() throws BIResourceException {
        this.adoCommon.open(this._conStr, this._userID, this._passWD, this._openOption);
    }

    public void open(String conStr) throws BIResourceException {
        this._conStr = conStr;
        this.open();
    }

    public void open(String conStr, String userID) throws BIResourceException {
        this._conStr = conStr;
        this._userID = userID;
        this.open();
    }

    public void open(String conStr, String userID, String passWD) throws BIResourceException {
        this._conStr = conStr;
        this._userID = userID;
        this._passWD = passWD;
        this.open();
    }

    public void open(String conStr, String userID, String passWD, long option) throws BIResourceException {
        this._conStr = conStr;
        this._userID = userID;
        this._passWD = passWD;
        this._openOption = option;
        this.open();
    }

    public String getConnectionString() {
        return this._conStr;
    }

    public void setConnectionString(String conStr) {
        this._conStr = conStr;
    }

    public IBIDataSet getDataSet(String commandString) throws BIResourceException {
        com.sap.ip.bi.sdk.dac.result.impl.IBIDataSet rs = this.adoCommon.getDataSet(commandString);
        return rs;
    }

    private void toPrimitive(BIVariant variant) {
    }

    public Recordset openSchema(int schema, String[] restrictions, String schemaID) {
        return this.adoCommon.openSchema(schema, restrictions, schemaID);
    }

    public Recordset openSchema(int schema) {
        return this.adoCommon.openSchema(schema);
    }

    public Recordset openSchema(int schema, String[] restrictions) {
        return this.adoCommon.openSchema(schema, restrictions);
    }

    public IBIOlapObjectFinder getObjectFinder() throws BIResourceException {
        if (((CommonConnection)this).objectFinder == null) {
            if (this.queryFactory == null) {
                this.queryFactory = this.olap.getQueryFactory();
            }
            ((CommonConnection)this).objectFinder = new ObjectFinder(this.queryFactory);
        }
        return ((CommonConnection)this).objectFinder;
    }

    protected void connectMDRRelational() throws BIResourceException {
        try {
            this.mdrRelational = new OdboMDRConnectionRelational((CommonConnection)this, ((CommonConnection)this).connectionInfo);
            this.outerMostRelational = this.mdrRelational.connect();
        }
        catch (ResourceException ex) {
            throw new BIResourceException(((CommonConnection)this).connectionInfo.getLocale(), "sdk.dac.connector.mmr_1000", (Throwable)ex);
        }
    }

    public void setOlap(IBIOlap olap) {
        if (this.olap == null) {
            this.olap = olap;
        }
    }

    public IBIQueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        rowMeta = null;
        colMeta = null;
        rowData = null;
        colData = null;
        loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$Connection == null ? (class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$Connection = Connection.class$("com.sap.ip.bi.sdk.dac.connector.odbo.impl.Connection")) : class$com$sap$ip$bi$sdk$dac$connector$odbo$impl$Connection).getName());
        cat = BILoggingSetup.CONNECTION.getCategory();
        System.loadLibrary("sapbiado");
    }

    private class ObjectFinder
    extends CommonConnection.AbstractObjectFinder
    implements IBIOlapObjectFinder {
        IBIQueryFactory queryFactory = null;

        private ObjectFinder(IBIQueryFactory queryFac) {
            super((CommonConnection)Connection.this);
            this.queryFactory = queryFac;
        }

        public List findMember(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            String hierarchyUName = this.getHierarchyUniqueName(schemaName, cubeName, dimensionName, hierarchyName);
            return this.findMember(MetadataNameConverter.schemaNameToCatalogName((Locale)((CommonConnection)Connection.this).connectionInfo.getLocale(), (String)schemaName), MetadataNameConverter.schemaNameToSchemaName((Locale)((CommonConnection)Connection.this).connectionInfo.getLocale(), (String)schemaName), cubeName, MetadataNameConverter.dimensionNameToDimensionUniqueName((String)dimensionName), hierarchyUName, MetadataNameConverter.dimensionLevelNametoLevelUniqueName((String)dimensionName, (String)levelName), null, memberName, null, null, null, treeOperator == null ? null : treeOperator.toString(), false);
        }

        private String getHierarchyUniqueName(String schemaName, String cubeName, String dimensionName, String hierarchyName) throws BIResourceException {
            String hierarchyUName = null;
            if (hierarchyName != null) {
                LevelBasedHierarchy hierarchy = this.findHierarchyFirst(schemaName, cubeName, dimensionName, hierarchyName);
                Collection tvs = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)hierarchy);
                hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tvs);
            } else {
                hierarchyUName = MetadataNameConverter.dimensionNametoHierarchyUniqueName((String)dimensionName);
            }
            return hierarchyUName;
        }

        public List findMember(Level level, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            Collection tvs = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)level);
            return this.findMember(Connection.super.getSchemaAttribute("CATALOG_NAME", tvs), Connection.super.getSchemaAttribute("SCHEMA_NAME", tvs), Connection.super.getSchemaAttribute("CUBE_NAME", tvs), Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tvs), Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tvs), Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tvs), Connection.super.getSchemaAttribute("LEVEL_NUMBER", tvs), memberName, null, null, null, treeOperator.toString(), false);
        }

        private List findMember(String catalogName, String schemaName, String cubeName, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, String levelNumber, String memberName, String memberUniqueName, String memberCaption, String memberType, String treeOperator, boolean findFirst) throws BIResourceException {
            Connection.super.assertConnectedToMDR();
            ArrayList<IBIMember> members = new ArrayList<IBIMember>();
            IBIMemberFactory memberFactory = null;
            try {
                memberFactory = this.queryFactory.getMemberFactory();
            }
            catch (Exception e) {
                throw new BIResourceException(((CommonConnection)Connection.this).connectionInfo.getLocale(), (Throwable)e);
            }
            HashMap fixProperty = new HashMap();
            Recordset rs = Connection.this.openSchema(38, new String[]{catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, levelUniqueName, levelNumber, memberName, memberUniqueName, memberCaption, memberType, treeOperator});
            rs.moveFirst();
            while (!rs.isEOF()) {
                MetadataHelper.ReadValuesIntoMap(fixProperty, rs);
                String memberNameLocal = fixProperty.get("MEMBER_NAME").toString();
                Dimension dim = this.findDimensionFirst(MetadataNameConverter.schemaNameFromSchemaAndCatalogName((String)catalogName, (String)schemaName), cubeName, MetadataNameConverter.dimensionUniqueNametoDimensionName((String)dimensionUniqueName));
                IBIMember member = null;
                try {
                    member = memberFactory.createMember(dim, memberNameLocal, null, fixProperty);
                }
                catch (BIOlapQueryException e) {
                    throw new BIResourceException(((CommonConnection)Connection.this).connectionInfo.getLocale(), cat, 500, loc, "sdk.dac.connector.olap_1005", (Throwable)e);
                }
                members.add(member);
                if (findFirst) break;
                rs.moveNext();
            }
            return members;
        }

        public IBIMember findMemberFirst(Level level, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            Collection tvs = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)level);
            return this.findMemberFirst(Connection.super.getSchemaAttribute("CATALOG_NAME", tvs), Connection.super.getSchemaAttribute("SCHEMA_NAME", tvs), Connection.super.getSchemaAttribute("CUBE_NAME", tvs), Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tvs), Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tvs), Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tvs), Connection.super.getSchemaAttribute("LEVEL_NUMBER", tvs), memberName, null, null, null, treeOperator.toString());
        }

        public IBIMember findMemberFirst(String schemaName, String cubeName, String dimensionName, String hierarchyName, String levelName, String memberName, BITreeOperator treeOperator) throws BIResourceException {
            String hierarchyUName = this.getHierarchyUniqueName(schemaName, cubeName, dimensionName, hierarchyName);
            return this.findMemberFirst(MetadataNameConverter.schemaNameToCatalogName((Locale)((CommonConnection)Connection.this).connectionInfo.getLocale(), (String)schemaName), MetadataNameConverter.schemaNameToSchemaName((Locale)((CommonConnection)Connection.this).connectionInfo.getLocale(), (String)schemaName), cubeName, MetadataNameConverter.dimensionNameToDimensionUniqueName((String)dimensionName), hierarchyUName, MetadataNameConverter.dimensionLevelNametoLevelUniqueName((String)dimensionName, (String)levelName), null, memberName, null, null, null, treeOperator == null ? null : treeOperator.toString());
        }

        private IBIMember findMemberFirst(String catalogName, String schemaName, String cubeName, String dimensionUniqueName, String hierarchyUniqueName, String levelUniqueName, String levelNumber, String memberName, String memberUniqueName, String memberCaption, String memberType, String treeOperator) throws BIResourceException {
            List memberList = this.findMember(catalogName, schemaName, cubeName, dimensionUniqueName, hierarchyUniqueName, levelUniqueName, levelNumber, memberName, memberUniqueName, memberCaption, memberType, treeOperator, true);
            if (memberList != null & memberList.size() > 0) {
                return (IBIMember)memberList.get(0);
            }
            return null;
        }

        public IBIResultSet findMemberData(List restrictions, List selectedAttributes) throws BIResourceException {
            loc.entering("Enter getMemberData.");
            Connection.super.assertConnectedToMDR();
            Cube cube = null;
            Dimension dimension = null;
            Hierarchy hierarchy = null;
            Level level = null;
            String catName = null;
            String schName = null;
            String cubeName = null;
            String dimensionUName = null;
            String hierarchyUName = null;
            String levelUName = null;
            String levelNumber = null;
            String memberName = null;
            String memberUName = null;
            String memberCaption = null;
            String memberType = null;
            String treeOperator = null;
            Object item = null;
            BIResultSet resultSet = null;
            Collection tags = null;
            BIResultSetData resultSetData = null;
            BIColumnMetaData[] columnMetadata = null;
            ArrayList<String[]> data = new ArrayList<String[]>();
            if (restrictions != null) {
                Iterator i = restrictions.iterator();
                while (i.hasNext()) {
                    item = i.next();
                    if (item instanceof Cube) {
                        cube = item;
                        tags = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)cube);
                        catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Dimension) {
                        dimension = item;
                        tags = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)dimension);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME", tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Hierarchy) {
                        hierarchy = item;
                        tags = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)hierarchy);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME".toString(), tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME", tags);
                        continue;
                    }
                    if (item instanceof Level) {
                        level = item;
                        tags = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)level);
                        if (catName == null) {
                            catName = Connection.super.getSchemaAttribute("CATALOG_NAME".toString(), tags);
                        }
                        if (schName == null) {
                            schName = Connection.super.getSchemaAttribute("SCHEMA_NAME", tags);
                        }
                        if (cubeName == null) {
                            cubeName = Connection.super.getSchemaAttribute("CUBE_NAME", tags);
                        }
                        if (dimensionUName == null) {
                            dimensionUName = Connection.super.getSchemaAttribute("DIMENSION_UNIQUE_NAME", tags);
                        }
                        hierarchyUName = Connection.super.getSchemaAttribute("HIERARCHY_UNIQUE_NAME".toString(), tags);
                        levelUName = Connection.super.getSchemaAttribute("LEVEL_UNIQUE_NAME", tags);
                        levelNumber = Connection.super.getSchemaAttribute("LEVEL_NUMBER", tags);
                        continue;
                    }
                    if (item instanceof IBIMember) {
                        IBIMember member = item;
                        tags = ((CommonConnection)Connection.this).mdr.getTaggedValue((ModelElement)member);
                        memberName = Connection.super.getSchemaAttribute("MEMBER_NAME", tags);
                        memberUName = Connection.super.getSchemaAttribute("MEMBER_UNIQUE_NAME", tags);
                        memberCaption = Connection.super.getSchemaAttribute("MEMBER_CAPTION", tags);
                        memberType = Connection.super.getSchemaAttribute("MEMBER_TYPE", tags);
                        continue;
                    }
                    if (!(item instanceof BITreeOperator)) continue;
                    treeOperator = ((BITreeOperator)item).toString();
                }
            }
            loc.debugT("Before get Recordset from odbo.");
            loc.debugT("CatalogName::" + catName + " SchemaName::" + schName + " CubeName::" + cubeName + " DimesionUName::" + dimensionUName + " HierarchyUName::" + hierarchyUName + " levelUName::" + levelUName + " levelNumber::" + levelNumber + " memberName::" + memberName + " memberUName::" + memberUName + " memberCaption::" + memberCaption + " memberType::" + memberType + " treeOperator::" + treeOperator);
            Recordset rs = Connection.this.openSchema(38, new String[]{catName, schName, cubeName, dimensionUName, hierarchyUName, levelUName, levelNumber, memberName, memberUName, memberCaption, memberType, treeOperator});
            loc.debugT("After get Recordset from odbo.");
            resultSetData = new BIResultSetData(((CommonConnection)Connection.this).connectionInfo, data);
            rs.moveFirst();
            int j = 0;
            while (j < rs.getRecordCount()) {
                data.add(MetadataHelper.ReadValues(rs, selectedAttributes, true));
                rs.moveNext();
                ++j;
            }
            columnMetadata = MetadataHelper.CreateColumnsMetaData(((CommonConnection)Connection.this).connectionInfo, selectedAttributes);
            try {
                resultSet = new BIResultSet(((CommonConnection)Connection.this).connectionInfo, (IBIResultSetData)resultSetData, (IBIColumnMetaData[])columnMetadata);
            }
            catch (SQLException e) {
                cat.errorT(loc, "sdk.dac.connector_1053");
                throw new BIResourceException(((CommonConnection)Connection.this).connectionInfo.getLocale(), "sdk.dac.connector_1053", (Throwable)e);
            }
            loc.exiting();
            return resultSet;
        }
    }

    private static class MetadataHelper {
        private static final BIColumnMetaData[] dataColumns = new BIColumnMetaData[]{new BIColumnMetaData(null, 12, "CATALOG_NAME"), new BIColumnMetaData(null, 12, "SCHEMA_NAME"), new BIColumnMetaData(null, 12, "CUBE_NAME"), new BIColumnMetaData(null, 12, "DIMENSION_UNIQUE_NAME"), new BIColumnMetaData(null, 12, "HIERARCHY_UNIQUE_NAME"), new BIColumnMetaData(null, 12, "LEVEL_UNIQUE_NAME"), new BIColumnMetaData(null, 4, "LEVEL_NUMBER"), new BIColumnMetaData(null, 12, "MEMBER_NAME"), new BIColumnMetaData(null, 12, "MEMBER_UNIQUE_NAME"), new BIColumnMetaData(null, 4, "MEMBER_ORDINAL"), new BIColumnMetaData(null, 4, "MEMBER_TYPE"), new BIColumnMetaData(null, 12, "MEMBER_GUID"), new BIColumnMetaData(null, 12, "MEMBER_CAPTION"), new BIColumnMetaData(null, 4, "CHILDREN_CARDINALITY"), new BIColumnMetaData(null, 4, "PARENT_LEVEL"), new BIColumnMetaData(null, 12, "PARENT_UNIQUE_NAME"), new BIColumnMetaData(null, 4, "PARENT_COUNT"), new BIColumnMetaData(null, 12, "DESCRIPTION")};

        private MetadataHelper() {
        }

        private static String[] ReadValues(Recordset rs, List selection, boolean bFixNullStrings) throws BIResourceException {
            try {
                String[] result = new String[selection != null ? selection.size() : dataColumns.length];
                int outputIdx = 0;
                Fields fields = rs.getFields();
                int i = 0;
                while (i < dataColumns.length) {
                    String columnName = dataColumns[i].getColumnName();
                    String value = null;
                    if (selection == null || selection.contains(columnName)) {
                        Field ff = fields.getItem(columnName);
                        if (ff != null) {
                            switch (ff.getType()) {
                                case 0: {
                                    value = String.valueOf(ff.getInt());
                                    break;
                                }
                                case 3: {
                                    value = String.valueOf((int)ff.getDouble());
                                    break;
                                }
                                default: {
                                    value = ff.getString();
                                }
                            }
                        }
                        result[outputIdx++] = bFixNullStrings && value == null ? "" : value;
                    }
                    ++i;
                }
                return result;
            }
            catch (SQLException e1) {
                throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1104", (Throwable)e1);
            }
        }

        private static void ReadValuesIntoMap(HashMap properies, Recordset rs) throws BIResourceException {
            try {
                String[] values = MetadataHelper.ReadValues(rs, null, false);
                int i = 0;
                while (i < dataColumns.length) {
                    properies.put(dataColumns[i].getColumnName(), values[i]);
                    ++i;
                }
            }
            catch (SQLException e1) {
                throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1104", (Throwable)e1);
            }
        }

        private static BIColumnMetaData[] CreateColumnsMetaData(IBIConnectionInfo connectionInfo, List selection) throws BIResourceException {
            try {
                BIColumnMetaData[] columns = new BIColumnMetaData[selection != null ? selection.size() : dataColumns.length];
                int outputIdx = 0;
                int i = 0;
                while (i < dataColumns.length) {
                    BIColumnMetaData data = dataColumns[i];
                    if (selection == null || selection.contains(data.getColumnName())) {
                        columns[outputIdx++] = new BIColumnMetaData(connectionInfo, data.getColumnType(), data.getColumnName());
                    }
                    ++i;
                }
                return columns;
            }
            catch (SQLException e1) {
                throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1104", (Throwable)e1);
            }
        }
    }

    public class Attributes {
        private String EISProductName = "";
        private String EISProductVersion = "";
        private String userName = "";

        protected Attributes() {
        }

        public String getEISProductName() {
            return this.EISProductName;
        }

        public String getEISProductVersion() {
            return this.EISProductVersion;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    private class ConnectionInfo
    implements IBIConnectionInfo {
        Locale locale = null;
        String user = null;

        private ConnectionInfo() {
            this.user = Connection.this.properties.getProperty(BIConnectionConstants.USERNAME.toString());
            this.locale = BILogonLanguage.getLocale((String)Connection.this.properties.getProperty(BIConnectionConstants.LANGUAGE.toString()));
        }

        public String getUser() {
            if (((CommonConnection)Connection.this).mdr != null) {
                return this.user;
            }
            return "";
        }

        public Locale getLocale() {
            if (((CommonConnection)Connection.this).mdr == null) {
                return this.locale;
            }
            return Locale.getDefault();
        }
    }
}

