/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.odbo;

import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.connector.IBIOlapObjectFinder;
import com.sap.ip.bi.sdk.dac.connector.capabilities.IBIBwCapabilities;
import com.sap.ip.bi.sdk.dac.connector.impl.BIOlap;
import com.sap.ip.bi.sdk.dac.connector.impl.IBIConnectionInfo;
import com.sap.ip.bi.sdk.dac.connector.odbo.OdboConnection;
import com.sap.ip.bi.sdk.dac.connector.odbo.impl.Connection;
import com.sap.ip.bi.sdk.dac.connector.olap.BIOlapDataSourceType;
import com.sap.ip.bi.sdk.dac.olap.query.assoc.AssocPackage;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.BIMdxGenerator;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.IBIMdxGenerator;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.BIParserFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.bw.BIBwParserFactory;
import com.sap.ip.bi.sdk.dac.olap.query.impl.mdx.sub.msolap.BIMsOlapParserFactory;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.dac.result.IBIDataSet;
import com.sap.ip.bi.sdk.exception.BIOlapQueryException;
import com.sap.ip.bi.sdk.exception.BIResourceException;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.List;
import java.util.Locale;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import org.omg.cwm.analysis.olap.Cube;
import org.omg.cwm.objectmodel.core.CorePackage;

public class OdboOlap
extends BIOlap
implements IBIBwCapabilities {
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboOlap == null ? (class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboOlap = OdboOlap.class$("com.sap.ip.bi.sdk.dac.connector.odbo.OdboOlap")) : class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboOlap).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    private OdboConnection m_connection;
    private Connection connection;
    private CorePackage corePackage = null;
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboOlap;

    public OdboOlap(OdboConnection adoConn) throws BIResourceException {
        loc.entering("OdboOlap()");
        this.m_connection = adoConn;
        if (this.m_connection == null) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1101");
        }
        this.connection = this.m_connection.getConnection();
        this.connection.setOlap((IBIOlap)this);
        loc.exiting();
    }

    public Boolean supports(IBIOlap.Supports feature) {
        if (feature == IBIOlap.Supports.BW_CAPABILITIES && this.getDataSourceType() == BIOlapDataSourceType.SAP_BW) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List getSchema() throws BIResourceException {
        return this.connection.getSchema();
    }

    public List getCube() throws BIResourceException {
        return this.connection.getCube();
    }

    public RefPackage getTopLevelPackage() throws BIResourceException {
        return this.connection.getTopLevelPackage();
    }

    public IBIConnectionInfo getConnectionInfo() throws ResourceException {
        return this.connection.getConnectionInfo();
    }

    public IBIOlapObjectFinder getObjectFinder() throws BIResourceException {
        return this.connection.getObjectFinder();
    }

    public List getSapVariables(Cube cube) throws BIResourceException {
        AssocPackage assocPackage = (AssocPackage)this.getTopLevelPackage().refPackage("com.sap.ip.bi.sdk.dac.olap.query.assoc");
        return assocPackage.getIBICubeOwnsSapVariable().getSapVariable(cube);
    }

    public IBIDataSet execute(Object nativeQuery) throws BIResourceException {
        loc.entering("execute(Object nativeQuery)");
        IBIDataSet dataset = null;
        if (!(nativeQuery instanceof String)) {
            throw new BIResourceException(this.connection.getConnectionInfo().getLocale(), "sdk.dac.connector_1010", new Object[]{nativeQuery == null ? "<null>" : nativeQuery.getClass().getName()});
        }
        try {
            dataset = this.connection.getDataSet((String)nativeQuery);
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1018", (Throwable)e);
        }
        loc.exiting();
        return dataset;
    }

    public IBIDataSet executeInternal(Object queryParser) throws BIResourceException {
        loc.entering("execute(Object nativeQuery, Object queryParser)");
        IBIDataSet dataset = null;
        try {
            dataset = this.execute(((IBIMdxGenerator)queryParser).getMdxExpression());
            dataset = ((IBIMdxGenerator)queryParser).doPostProcessing(dataset);
        }
        catch (Exception e) {
            throw new BIResourceException(Locale.getDefault(), "sdk.dac.connector_1018", (Throwable)e);
        }
        loc.exiting();
        return dataset;
    }

    public Object transform(Object queryParser) throws BIResourceException {
        String mdx = null;
        try {
            mdx = ((IBIMdxGenerator)queryParser).getMdxExpression();
        }
        catch (BIOlapQueryException e) {
            throw new BIResourceException(Locale.getDefault(), (Throwable)e);
        }
        return mdx;
    }

    public Object createQueryParser(IBIQuery query) {
        BIOlapDataSourceType olapDataSourceType = this.getDataSourceType();
        if (olapDataSourceType == BIOlapDataSourceType.SAP_BW) {
            return BIMdxGenerator.createMdxGenerator((IBIQuery)query, (BIParserFactory)BIBwParserFactory.getInstance(), (IBIOlap)this);
        }
        if (olapDataSourceType == BIOlapDataSourceType.MS_OLAP) {
            return BIMdxGenerator.createMdxGenerator((IBIQuery)query, (BIParserFactory)BIMsOlapParserFactory.getInstance(), (IBIOlap)this);
        }
        return BIMdxGenerator.createMdxGenerator((IBIQuery)query, (BIParserFactory)BIParserFactory.getInstance(), (IBIOlap)this);
    }

    public BIOlapDataSourceType getDataSourceType() {
        return this.connection.getDataSourceType();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

