/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.bi.sdk.dac.connector.odbo;

import com.sap.ip.bi.sdk.dac.connector.impl.BIConnectionConstants;
import com.sap.ip.bi.sdk.dac.connector.odbo.OdboConnectionConstants;
import com.sap.ip.bi.sdk.util.BILoggingSetup;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.resource.cci.ConnectionSpec;
import javax.resource.spi.ConnectionRequestInfo;

public class OdboConnectionProperties
implements ConnectionSpec,
ConnectionRequestInfo,
Serializable,
Cloneable {
    private static final Location loc = Location.getLocation((String)(class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboConnectionProperties == null ? (class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboConnectionProperties = OdboConnectionProperties.class$("com.sap.ip.bi.sdk.dac.connector.odbo.OdboConnectionProperties")) : class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboConnectionProperties).getName());
    private static final Category cat = BILoggingSetup.CONNECTION.getCategory();
    protected Properties m_properties = new Properties();
    static /* synthetic */ Class class$com$sap$ip$bi$sdk$dac$connector$odbo$OdboConnectionProperties;

    public OdboConnectionProperties() {
    }

    public OdboConnectionProperties(Properties properties) {
        loc.entering("OdboConnectionProperties(Properties properties)");
        Enumeration keys = ((Hashtable)properties).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.setProperty(key, properties.getProperty(key));
        }
        loc.exiting();
    }

    public OdboConnectionProperties(String username, String password, String connString, String language) {
        this.setProperty(Parameter.USER.name, username);
        this.setProperty(Parameter.PASSWD.name, password);
        this.setProperty(Parameter.CONNSTR.name, connString);
        this.setProperty(Parameter.LANGUAGE.name, language);
    }

    protected final void setProperty(String key, String value) {
        if (((Hashtable)this.m_properties).get(key) != null) {
            ((Hashtable)this.m_properties).remove(key);
        }
        if (value != null) {
            this.m_properties.setProperty(key, value);
        }
    }

    protected final String getProperty(String key) {
        return this.m_properties.getProperty(key);
    }

    public Object clone() {
        return new OdboConnectionProperties(this.m_properties);
    }

    public String getUserName() {
        return this.getProperty(Parameter.USER.name);
    }

    public void setUserName(String user) {
        this.setProperty(Parameter.USER.name, user);
    }

    public String getPassword() {
        return this.getProperty(Parameter.PASSWD.name);
    }

    public void setPassword(String password) {
        this.setProperty(Parameter.PASSWD.name, password);
    }

    public String getConnString() {
        return this.getProperty(Parameter.CONNSTR.name);
    }

    public void setConnString(String connString) {
        this.setProperty(Parameter.CONNSTR.name, connString);
    }

    public String getLogonAsUserID() {
        return this.getProperty(Parameter.LOGONASUSERID.name);
    }

    public void setLogonAsUserID(String value) {
        this.setProperty(Parameter.LOGONASUSERID.name, value);
    }

    public String getLogonAsUserDomain() {
        return this.getProperty(Parameter.LOGONASUSERDOMAIN.name);
    }

    public void setLogonAsUserDomain(String value) {
        this.setProperty(Parameter.LOGONASUSERDOMAIN.name, value);
    }

    public String getLogonAsUserPassword() {
        return this.getProperty(Parameter.LOGONASUSERPASSWORD.name);
    }

    public void setLogonAsUserPassword(String value) {
        this.setProperty(Parameter.LOGONASUSERPASSWORD.name, value);
    }

    public String getLanguage() {
        return this.getProperty(Parameter.LANGUAGE.name);
    }

    public void setLauguage(String language) {
        this.setProperty(Parameter.LANGUAGE.name, language);
    }

    public int hashCode() {
        loc.entering("hashCode()");
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < Parameter.m_num_parameters) {
            String value;
            Parameter p = Parameter.m_parameters[i];
            if (p != null && (value = this.m_properties.getProperty(p.name)) != null) {
                sb.append(value);
            }
            ++i;
        }
        loc.exiting();
        return sb.toString().hashCode();
    }

    public boolean equals(Object other) {
        loc.entering("equals(java.lang.Object other)");
        if (other == null || !(other instanceof OdboConnectionProperties)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        OdboConnectionProperties obj = (OdboConnectionProperties)other;
        if (((Hashtable)this.m_properties).size() != ((Hashtable)obj.m_properties).size()) {
            return false;
        }
        boolean is_equal = true;
        Enumeration keys = ((Hashtable)this.m_properties).keys();
        while (keys.hasMoreElements() && is_equal) {
            String key = (String)keys.nextElement();
            String value1 = this.m_properties.getProperty(key);
            String value2 = obj.m_properties.getProperty(key);
            if (value1 == null && value2 != null) {
                is_equal = false;
                continue;
            }
            if (value1 != null && value2 == null) {
                is_equal = false;
                continue;
            }
            if (value1.equals(value2)) continue;
            is_equal = false;
        }
        loc.exiting();
        return is_equal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Parameter
    implements Serializable {
        protected static Parameter[] m_parameters = new Parameter[5];
        public static final Parameter USER = new Parameter(BIConnectionConstants.USERNAME);
        public static final Parameter PASSWD = new Parameter(BIConnectionConstants.PASSWORD);
        public static final Parameter CONNSTR = new Parameter(OdboConnectionConstants.CONNECTION_STRING);
        public static final Parameter LOGONASUSERID = new Parameter(OdboConnectionConstants.LOGON_AS_USER_ID);
        public static final Parameter LOGONASUSERDOMAIN = new Parameter(OdboConnectionConstants.LOGON_AS_USER_DOMAIN);
        public static final Parameter LOGONASUSERPASSWORD = new Parameter(OdboConnectionConstants.LOGON_AS_USER_PASSWORD);
        public static final Parameter LANGUAGE = new Parameter(BIConnectionConstants.LANGUAGE);
        private static int m_num_parameters = 0;
        public final String name;

        protected Parameter(BIConnectionConstants name) {
            this(name.toString());
        }

        protected Parameter(String name) {
            Parameter parameter = this;
            synchronized (parameter) {
                loc.entering("Parameter(String name)");
                this.name = name;
                if (m_parameters.length < ++m_num_parameters) {
                    Parameter[] old = m_parameters;
                    m_parameters = new Parameter[m_num_parameters];
                    System.arraycopy(old, 0, m_parameters, 0, old.length);
                }
                Parameter.m_parameters[Parameter.m_num_parameters - 1] = this;
                loc.exiting();
            }
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Parameter)) {
                return false;
            }
            return this.name.equals(((Parameter)other).name);
        }
    }
}

