/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.AggregationKind;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Feature;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.Namespace;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import javax.jmi.model.TypedElement;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefAssociationLink;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.jmi.reflect.RefStruct;

public class XmiWriter
implements javax.jmi.xmi.XmiWriter {
    private static final char QUOTE = '\'';
    private static final String INDENT = "  ";
    private static final int INDENT_LENGTH = "  ".length();
    private static final int MAX = 70;
    private static final String XMI_VERSION = "1.2";
    private static final String EXPORTER_NAME = "SAP Meta Model Repository";
    private static final String EXPORTER_VERSION = "1.0";
    private Map namespaces = new HashMap();
    private PrintStream stream;
    private boolean hasContent = true;
    private boolean hasCharacters = false;
    private String indentSpaces = "";
    private int charsCount = 0;
    private Map writtenInstances = new HashMap();
    private int instancesCounter = 0;
    private Set processedPackages = new HashSet();
    private Map instanceAttributes_cache = new HashMap();
    private Map classAttributes_cache = new HashMap();
    private Map references_cache = new HashMap();
    private Map structureFields_cache = new HashMap();
    private Map labelPrefix_cache = new HashMap();
    private boolean collectionWriting = false;
    private Set objectsToWrite = null;
    private List objectsToWriteAsCollection = null;
    private String xmiVersion = "1.2";
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$xmi$XmiWriter == null ? (class$com$sap$ip$mmr$xmi$XmiWriter = XmiWriter.class$("com.sap.ip.mmr.xmi.XmiWriter")) : class$com$sap$ip$mmr$xmi$XmiWriter);
    private IConnection connection;
    static /* synthetic */ Class class$com$sap$ip$mmr$xmi$XmiWriter;

    public XmiWriter() {
        this.connection = null;
    }

    public XmiWriter(IConnection connection) {
        this.connection = connection;
    }

    public void init() {
        this.hasContent = true;
        this.hasCharacters = true;
        this.indentSpaces = "";
        this.charsCount = 0;
        this.collectionWriting = false;
        this.namespaces = new HashMap();
        this.writtenInstances = new HashMap();
        this.processedPackages = new HashSet();
        this.instancesCounter = 0;
        this.instanceAttributes_cache = new HashMap();
        this.classAttributes_cache = new HashMap();
        this.references_cache = new HashMap();
        this.labelPrefix_cache = new HashMap();
    }

    public void write(OutputStream os, RefPackage extent, String xmiVersion) throws IOException {
        long time = System.currentTimeMillis();
        this.init();
        if (xmiVersion != null) {
            this.xmiVersion = xmiVersion;
        }
        this.stream = new PrintStream(os);
        this.processedPackages.clear();
        this.findNamespaces(extent);
        this.writeDocument(extent);
        this.stream.flush();
        this.stream.close();
        time = System.currentTimeMillis() - time;
    }

    public void write(OutputStream os, Collection objects, String xmiVersion) throws IOException {
        RefPackage extent;
        this.init();
        this.collectionWriting = true;
        if (xmiVersion != null) {
            this.xmiVersion = xmiVersion;
        }
        this.stream = new PrintStream(os);
        this.processedPackages.clear();
        this.objectsToWrite = new HashSet();
        this.objectsToWriteAsCollection = new ArrayList();
        if (objects == null || objects.size() == 0) {
            extent = null;
        } else {
            Iterator iter = objects.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (!(obj instanceof RefObject)) {
                    throw new JmiException("2142", new Object[]{obj.getClass().getName()});
                }
                RefFeatured outermost = ((RefObject)obj).refOutermostComposite();
                this.objectsToWrite.add(outermost);
                this.objectsToWriteAsCollection.add(outermost);
            }
            extent = ((RefObject)this.objectsToWriteAsCollection.get(0)).refOutermostPackage();
            boolean findNs = true;
            if (this.connection != null && this.connection.getConnectionSpec().getProperties().containsKey("noNamespaces")) {
                findNs = false;
            }
            if (findNs) {
                this.findNamespaces(extent);
            }
        }
        this.writeDocument(extent);
        this.stream.flush();
        this.stream.close();
    }

    public void write(OutputStream stream, RefPackage extent) {
        try {
            this.write(stream, extent, null);
        }
        catch (IOException e) {
            throw new JmiException("0003", new Object[]{e.toString()});
        }
    }

    private void findNamespaces(RefPackage pkg) {
        Iterator iter;
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        RefObject o = pkg.refMetaObject();
        if (o == null || !(o instanceof Namespace)) {
            return;
        }
        Namespace metaObject = (Namespace)o;
        String name = XmiWriter.getTagValue((ModelElement)metaObject, "org.omg.xmi.namespace");
        if (name != null) {
            iter = metaObject.getQualifiedName().iterator();
            String fqName = (String)iter.next();
            while (iter.hasNext()) {
                fqName = fqName.concat(".").concat((String)iter.next());
            }
            this.namespaces.put(fqName, name);
        }
        this.processedPackages.add(pkg);
        iter = pkg.refAllPackages().iterator();
        while (iter.hasNext()) {
            this.findNamespaces((RefPackage)iter.next());
        }
    }

    public static String getTagValue(ModelElement element, String tagId) {
        List tags = ((ModelPackage)element.refOutermostPackage()).getAttachesTo().getTag(element);
        Tag tag = null;
        Iterator it = tags.iterator();
        while (it.hasNext()) {
            Tag temp;
            Object obj = it.next();
            if (!(obj instanceof Tag) || !tagId.equals((temp = (Tag)obj).getTagId())) continue;
            tag = temp;
            break;
        }
        if (tag == null) {
            return null;
        }
        List values = tag.getValues();
        if (values.size() == 0) {
            return null;
        }
        return (String)values.iterator().next();
    }

    private void cacheContainedElements(MofClass mofClass) {
        LinkedList temp = new LinkedList();
        List superClasses = mofClass.allSupertypes();
        Namespace namespace = null;
        Iterator it = superClasses.iterator();
        while (it.hasNext()) {
            namespace = (Namespace)it.next();
            temp.addAll(namespace.getContents());
        }
        temp.addAll(mofClass.getContents());
        ArrayList<RefObject> instanceAttributes = new ArrayList<RefObject>();
        ArrayList<RefObject> classAttributes = new ArrayList<RefObject>();
        ArrayList<RefObject> references = new ArrayList<RefObject>();
        it = temp.iterator();
        while (it.hasNext()) {
            Association assoc;
            RefObject refObject = (RefObject)it.next();
            if (!(refObject instanceof Feature)) continue;
            boolean instanceLevel = ((Feature)refObject).getScope().equals(ScopeKindEnum.INSTANCE_LEVEL);
            if (refObject instanceof Attribute && !((Attribute)refObject).isDerived()) {
                if (instanceLevel) {
                    instanceAttributes.add(refObject);
                    continue;
                }
                classAttributes.add(refObject);
                continue;
            }
            if (!(refObject instanceof Reference) || (assoc = (Association)((Reference)refObject).getReferencedEnd().getContainer()).isDerived()) continue;
            references.add(refObject);
        }
        this.instanceAttributes_cache.put(mofClass, instanceAttributes);
        this.classAttributes_cache.put(mofClass, classAttributes);
        this.references_cache.put(mofClass, references);
    }

    private List instanceAttributes(MofClass mofClass) {
        List list = (List)this.instanceAttributes_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.instanceAttributes_cache.get(mofClass);
        }
        return list;
    }

    private List classAttributes(MofClass mofClass) {
        List list = (List)this.classAttributes_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.classAttributes_cache.get(mofClass);
        }
        return list;
    }

    private List references(MofClass mofClass) {
        List list = (List)this.references_cache.get(mofClass);
        if (list == null) {
            this.cacheContainedElements(mofClass);
            list = (List)this.references_cache.get(mofClass);
        }
        return list;
    }

    public List structureFields(StructureType type) {
        ArrayList fields = (ArrayList)this.structureFields_cache.get(type);
        if (fields != null) {
            return fields;
        }
        fields = new ArrayList();
        Iterator content = type.getContents().iterator();
        while (content.hasNext()) {
            Object element = content.next();
            if (!(element instanceof StructureField)) continue;
            fields.add(element);
        }
        this.structureFields_cache.put(type, fields);
        return fields;
    }

    public String labelPrefix(EnumerationType type) {
        String prefix = (String)this.labelPrefix_cache.get(type);
        if (prefix != null) {
            return prefix;
        }
        prefix = XmiWriter.getTagValue((ModelElement)type, "org.omg.xmi.enumerationUnprefix");
        if (prefix == null) {
            prefix = "";
        }
        this.labelPrefix_cache.put(type, prefix);
        return prefix;
    }

    private void write(String text) {
        this.stream.print(text);
    }

    private void writeln() {
        this.stream.println();
        this.charsCount = 0;
    }

    private String replaceSpecialChars(String s) {
        int length = s.length();
        char[] chars = new char[6 * length];
        int n = 0;
        block7: for (int x = 0; x < length; ++x) {
            char c = s.charAt(x);
            switch (c) {
                case '&': {
                    chars[n] = 38;
                    chars[++n] = 97;
                    chars[++n] = 109;
                    chars[++n] = 112;
                    chars[++n] = 59;
                    ++n;
                    continue block7;
                }
                case '\'': {
                    chars[n] = 38;
                    chars[++n] = 97;
                    chars[++n] = 112;
                    chars[++n] = 111;
                    chars[++n] = 115;
                    chars[++n] = 59;
                    ++n;
                    continue block7;
                }
                case '\"': {
                    chars[n] = 38;
                    chars[++n] = 113;
                    chars[++n] = 117;
                    chars[++n] = 111;
                    chars[++n] = 116;
                    chars[++n] = 59;
                    ++n;
                    continue block7;
                }
                case '<': {
                    chars[n] = 38;
                    chars[++n] = 108;
                    chars[++n] = 116;
                    chars[++n] = 59;
                    ++n;
                    continue block7;
                }
                case '>': {
                    chars[n] = 38;
                    chars[++n] = 103;
                    chars[++n] = 116;
                    chars[++n] = 59;
                    ++n;
                    continue block7;
                }
                default: {
                    chars[n] = c;
                    ++n;
                }
            }
        }
        return new String(chars, 0, n);
    }

    private void startElement(String name) {
        if (!this.hasContent && !this.hasCharacters) {
            this.write(">");
            this.writeln();
        }
        this.hasContent = false;
        this.hasCharacters = false;
        this.write(this.indentSpaces);
        this.write("<" + name);
        this.charsCount += name.length() + 1;
        this.indentSpaces = this.indentSpaces + INDENT;
    }

    private void endElement(String name) {
        this.indentSpaces = this.indentSpaces.substring(0, this.indentSpaces.length() - INDENT_LENGTH);
        if (this.hasContent) {
            this.write(this.indentSpaces);
            this.write("</" + name + ">");
        } else if (this.hasCharacters) {
            this.write("</" + name + ">");
        } else {
            this.write("/>");
        }
        this.writeln();
        this.hasContent = true;
    }

    private void addAttribute(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        value = this.replaceSpecialChars(value);
        if (this.charsCount > 70) {
            this.writeln();
            this.write(this.indentSpaces);
        } else {
            this.write(" ");
            ++this.charsCount;
        }
        this.write(name + " = " + '\'' + value + '\'');
        this.charsCount += name.length() + value.length() + 5;
    }

    private void characters(String text) {
        text = this.replaceSpecialChars(text);
        if (!this.hasContent) {
            this.write(">");
        }
        this.write(text);
        this.hasCharacters = true;
    }

    protected boolean isXmiSAPVersion() {
        return this.xmiVersion.indexOf("SAP_") == 0;
    }

    private String getXmiId(RefObject obj) {
        Record rec = (Record)this.writtenInstances.get(obj);
        if (rec == null) {
            String xmiId;
            if (this.isXmiSAPVersion()) {
                xmiId = obj.refMofId();
            } else {
                ++this.instancesCounter;
                xmiId = "a" + this.instancesCounter;
            }
            rec = new Record(xmiId, false);
            this.writtenInstances.put(obj, rec);
        }
        return rec.xmiId;
    }

    private void markWritten(RefObject obj) {
        Record rec = (Record)this.writtenInstances.get(obj);
        rec.isWritten = true;
    }

    private void writeDocument(RefPackage pkg) {
        this.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        this.write(Utilities.SystemLineSeparator);
        this.startElement("XMI");
        this.addAttribute("xmi.version", this.xmiVersion);
        this.writeNamespaces();
        this.addAttribute("timestamp", new Date().toString());
        this.startElement("XMI.header");
        this.startElement("XMI.documentation");
        this.startElement("XMI.exporter");
        this.characters(EXPORTER_NAME);
        this.endElement("XMI.exporter");
        this.startElement("XMI.exporterVersion");
        this.characters(EXPORTER_VERSION);
        this.endElement("XMI.exporterVersion");
        this.endElement("XMI.documentation");
        this.endElement("XMI.header");
        this.startElement("XMI.content");
        if (!this.collectionWriting) {
            this.processedPackages.clear();
            this.writePackage(pkg);
            this.processedPackages.clear();
            this.writeStaticAttributes(pkg);
        } else {
            this.writeObjects();
        }
        this.processedPackages.clear();
        boolean writeAssoc = true;
        if (this.isXmiSAPVersion()) {
            writeAssoc = false;
        }
        if (this.connection != null && this.connection.getConnectionSpec().getProperties().containsKey("noAssociationWithoutReference")) {
            writeAssoc = false;
        }
        if (writeAssoc) {
            this.writeAssociations(pkg);
        }
        this.endElement("XMI.content");
        this.endElement("XMI");
    }

    private void writeNamespaces() {
        HashMap<String, String> temp = new HashMap<String, String>();
        Iterator iter = this.namespaces.entrySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next().getValue();
            if (temp.get(name) != null) continue;
            temp.put(name, name);
            this.addAttribute("xmlns:" + name, "org.omg.xmi.namespace." + name);
        }
    }

    private void writePackage(RefPackage pkg) {
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        Iterator classes = pkg.refAllClasses().iterator();
        while (classes.hasNext()) {
            RefClass proxy = (RefClass)classes.next();
            Iterator instances = proxy.refAllOfClass().iterator();
            while (instances.hasNext()) {
                RefObject obj = (RefObject)instances.next();
                if (obj == null || !obj.equals(obj.refOutermostComposite())) continue;
                this.writeInstance(obj);
            }
        }
        this.processedPackages.add(pkg);
        Iterator containedPackages = pkg.refAllPackages().iterator();
        while (containedPackages.hasNext()) {
            this.writePackage((RefPackage)containedPackages.next());
        }
    }

    private void writeObjects() {
        Iterator iter = this.objectsToWriteAsCollection.iterator();
        while (iter.hasNext()) {
            this.writeInstance((RefObject)iter.next());
        }
    }

    private void writeInstance(RefObject obj) {
        String method = "writeInstance(RefObject obj)";
        RefClass proxy = obj.refClass();
        ModelElement element = (ModelElement)obj.refMetaObject();
        if (element == null) {
            RepositoryServer.getCategory().errorT(location, "writeInstance(RefObject obj)", MMRResourceAccessor.getInstance().getMessageText("3011"), new Object[]{obj});
            return;
        }
        String name = this.qualifiedName(element);
        String xmiId = this.getXmiId(obj);
        this.markWritten(obj);
        this.startElement(name);
        this.addAttribute("xmi.id", xmiId);
        Iterator attrs = this.instanceAttributes((MofClass)proxy.refMetaObject()).iterator();
        ArrayList<Attribute> attrsInContent = new ArrayList<Attribute>();
        ArrayList<Attribute> attrsWithCData = new ArrayList<Attribute>();
        while (attrs.hasNext()) {
            Object value;
            Attribute attr = (Attribute)attrs.next();
            boolean isMultivalued = XmiWriter.isMultivalued((StructuralFeature)attr);
            try {
                value = obj.refGetValue((RefObject)attr);
            }
            catch (Exception e) {
                RepositoryServer.getCategory().errorT(location, "writeInstance(RefObject obj)", MMRResourceAccessor.getInstance().getMessageText("2059"), new Object[]{((ModelElement)obj.refMetaObject()).getQualifiedName(), attr.getName()});
                value = Boolean.FALSE;
            }
            Object valueToWrite = value;
            if (value == null) continue;
            if (isMultivalued) {
                Collection col = (Collection)value;
                if (col.isEmpty()) continue;
                if (col.size() > 1) {
                    attrsInContent.add(attr);
                    continue;
                }
                valueToWrite = col.iterator().next();
            }
            Classifier type = attr.getType();
            while (type instanceof AliasType) {
                type = ((AliasType)type).getType();
            }
            if (!(type instanceof PrimitiveType) && !(type instanceof EnumerationType)) {
                attrsInContent.add(attr);
                continue;
            }
            if (this.requiresCData(attr, valueToWrite.toString())) {
                attrsWithCData.add(attr);
                continue;
            }
            this.writeValueInAttr((TypedElement)attr, valueToWrite);
        }
        this.addSAPAttributes(obj);
        Iterator iterCData = attrsWithCData.iterator();
        while (iterCData.hasNext()) {
            Attribute attr = (Attribute)iterCData.next();
            this.writeValueInAttrAsCData((TypedElement)attr, obj.refGetValue((RefObject)attr));
        }
        Iterator iter = attrsInContent.iterator();
        while (iter.hasNext()) {
            Attribute attr = (Attribute)iter.next();
            this.writeValueInContent(attr, obj.refGetValue((RefObject)attr));
        }
        if (!this.isXmiSAPVersion()) {
            Iterator refs = this.references((MofClass)proxy.refMetaObject()).iterator();
            while (refs.hasNext()) {
                Reference ref = (Reference)refs.next();
                this.writeReference(obj, ref);
            }
        }
        this.endElement(name);
    }

    private void addSAPAttributes(RefObject obj) {
        if (obj instanceof IModelElement) {
            IModelElement me = (IModelElement)obj;
            this.addAttribute("___createdAt", me.getCreatedAt());
            this.addAttribute("___createdBy", me.getCreatedBy());
            this.addAttribute("___lastChangedAt", me.getLastChangedAt());
            this.addAttribute("___lastChangedBy", me.getLastChangedBy());
            this.addAttribute("___release", me.getRelease());
            this.addAttribute("___deprecated", String.valueOf(me.getDeprecated()));
        } else if (obj instanceof IMMRObject) {
            IMMRObject mmro = (IMMRObject)obj;
            this.addAttribute("___createdAt", mmro.get___CreatedAt());
            this.addAttribute("___createdBy", mmro.get___CreatedBy());
            this.addAttribute("___lastChangedAt", mmro.get___LastChangedAt());
            this.addAttribute("___lastChangedBy", mmro.get___LastChangedBy());
            this.addAttribute("___release", mmro.get___Release());
            this.addAttribute("___deprecated", String.valueOf(mmro.get___Deprecated()));
        }
    }

    private boolean requiresCData(Attribute attr, String value) {
        if (value == null) {
            return false;
        }
        boolean flag = false;
        if (value.length() > 50) {
            flag = true;
        }
        block7: for (int i = 0; i < value.length() && !flag; ++i) {
            switch (value.charAt(i)) {
                case '&': {
                    flag = true;
                    continue block7;
                }
                case '\'': {
                    flag = true;
                    continue block7;
                }
                case '\"': {
                    flag = true;
                    continue block7;
                }
                case '<': {
                    flag = true;
                    continue block7;
                }
                case '>': {
                    flag = true;
                }
            }
        }
        return flag;
    }

    private void writeInstanceRef(RefObject obj) {
        String method = "writeInstanceRef(RefObject obj)";
        if (obj == null) {
            return;
        }
        if (obj.refMetaObject() == null) {
            RepositoryServer.getCategory().errorT(location, "writeInstanceRef(RefObject obj)", MMRResourceAccessor.getInstance().getMessageText("3011"), new Object[]{obj});
            return;
        }
        String name = this.qualifiedName((ModelElement)obj.refMetaObject());
        String xmiId = this.getXmiId(obj);
        this.startElement(name);
        this.addAttribute("xmi.idref", xmiId);
        this.endElement(name);
    }

    private void writeValueInAttr(TypedElement attr, Object value) {
        String asText;
        String name = attr.getName();
        Classifier type = attr.getType();
        if (type instanceof EnumerationType) {
            String prefix = this.labelPrefix((EnumerationType)type);
            asText = value.toString().substring(prefix.length());
        } else {
            asText = value.toString();
        }
        this.addAttribute(name, asText);
    }

    private void writeValueInAttrAsCData(TypedElement attr, Object value) {
        if (attr == null || value == null) {
            return;
        }
        String name = this.qualifiedName((ModelElement)attr);
        if (value instanceof String) {
            this.startElement(name);
            this.write("><![CDATA[" + value + "]]>");
            this.hasCharacters = true;
            this.endElement(name);
        } else if (value instanceof Collection) {
            Collection col = (Collection)value;
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.startElement(name);
                this.write("><![CDATA[" + iter.next().toString() + "]]>");
                this.hasCharacters = true;
                this.endElement(name);
            }
        } else {
            this.startElement(name);
            this.write("><![CDATA[" + value.toString() + "]]>");
            this.hasCharacters = true;
            this.endElement(name);
        }
    }

    private void writeValueInContent(Attribute attr, Object value) {
        ArrayList<Object> values;
        if (attr == null || value == null) {
            return;
        }
        String name = this.qualifiedName((ModelElement)attr);
        Classifier type = attr.getType();
        while (type instanceof AliasType) {
            type = ((AliasType)type).getType();
        }
        boolean isMultivalued = false;
        if (attr instanceof StructuralFeature) {
            isMultivalued = XmiWriter.isMultivalued((StructuralFeature)attr);
        }
        if (isMultivalued) {
            values = (ArrayList<Object>)value;
        } else {
            values = new ArrayList<Object>();
            values.add(value);
        }
        Iterator iter = values.iterator();
        if (type instanceof StructureType) {
            this.startElement(name);
            while (iter.hasNext()) {
                this.writeStructure((StructureType)type, (RefStruct)iter.next());
            }
            this.endElement(name);
        } else if (type instanceof MofClass) {
            this.startElement(name);
            while (iter.hasNext()) {
                RefObject obj = (RefObject)iter.next();
                this.writeInstance(obj);
            }
            this.endElement(name);
        } else if (type instanceof PrimitiveType) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                this.startElement(name);
                this.characters(obj.toString());
                this.endElement(name);
            }
        } else if (type instanceof EnumerationType) {
            while (iter.hasNext()) {
                Object obj = iter.next();
                this.startElement(name);
                String prefix = this.labelPrefix((EnumerationType)type);
                String label = obj.toString().substring(prefix.length());
                this.addAttribute("xmi.value", label);
                this.endElement(name);
            }
        } else {
            throw new JmiException("2143", new Object[]{type.getName()});
        }
    }

    private void writeStructure(StructureType type, RefStruct value) {
        Iterator iter = this.structureFields(type).iterator();
        while (iter.hasNext()) {
            StructureField field = (StructureField)iter.next();
            Classifier fieldType = field.getType();
            while (fieldType instanceof AliasType) {
                fieldType = ((AliasType)fieldType).getType();
            }
            Object fieldValue = value.refGetValue(field.getName());
            this.startElement("XMI.field");
            if (fieldType instanceof MofClass) {
                this.writeInstance((RefObject)fieldValue);
            } else if (fieldType instanceof StructureType) {
                this.writeStructure((StructureType)fieldType, (RefStruct)fieldValue);
            } else if (fieldType instanceof PrimitiveType) {
                this.characters(fieldValue.toString());
            }
            this.endElement("XMI.field");
        }
    }

    private void writeReference(RefObject obj, Reference ref) {
        Iterator iter;
        ArrayList<Object> values;
        if (obj == null || ref == null) {
            return;
        }
        AggregationKind kind = ref.getReferencedEnd().getAggregation();
        if (AggregationKindEnum.COMPOSITE.equals((Object)kind)) {
            return;
        }
        kind = ref.getExposedEnd().getAggregation();
        boolean isComposite = AggregationKindEnum.COMPOSITE.equals((Object)kind);
        Object temp = obj.refGetValue((RefObject)ref);
        if (temp == null) {
            return;
        }
        if (XmiWriter.isMultivalued((StructuralFeature)ref)) {
            values = (ArrayList<Object>)temp;
        } else {
            values = new ArrayList<Object>();
            values.add(temp);
        }
        if (values.isEmpty()) {
            return;
        }
        if (this.collectionWriting) {
            boolean found = false;
            iter = values.iterator();
            while (iter.hasNext()) {
                if (!this.isInClosure((RefObject)iter.next())) continue;
                found = true;
                break;
            }
            if (!found) {
                return;
            }
        }
        String name = this.qualifiedName((ModelElement)ref);
        this.startElement(name);
        iter = values.iterator();
        while (iter.hasNext()) {
            RefObject endValue = (RefObject)iter.next();
            if (isComposite) {
                this.writeInstance(endValue);
                continue;
            }
            this.writeInstanceRef(endValue);
        }
        this.endElement(name);
    }

    private void writeStaticAttributes(RefPackage pkg) {
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        Iterator iter = pkg.refAllClasses().iterator();
        while (iter.hasNext()) {
            RefClass proxy = (RefClass)iter.next();
            Iterator attrs = this.classAttributes((MofClass)proxy.refMetaObject()).iterator();
            while (attrs.hasNext()) {
                Attribute attr = (Attribute)attrs.next();
                this.writeValueInContent(attr, proxy.refGetValue((RefObject)attr));
            }
        }
        this.processedPackages.add(pkg);
        Iterator containedPackages = pkg.refAllPackages().iterator();
        while (containedPackages.hasNext()) {
            this.writeStaticAttributes((RefPackage)containedPackages.next());
        }
    }

    private void writeAssociations(RefPackage pkg) {
        if (this.processedPackages.contains(pkg)) {
            return;
        }
        Iterator iter = pkg.refAllAssociations().iterator();
        while (iter.hasNext()) {
            RefAssociation proxy = (RefAssociation)iter.next();
            Association assoc = (Association)proxy.refMetaObject();
            if (assoc == null || assoc.isDerived() || assoc.getName().compareTo("RefAssociation") == 0) continue;
            boolean aLinkWritten = false;
            String name = this.qualifiedName((ModelElement)assoc);
            AssociationEnd end1 = null;
            AssociationEnd end2 = null;
            Iterator content = assoc.getContents().iterator();
            while (content.hasNext()) {
                Object obj = content.next();
                if (!(obj instanceof AssociationEnd)) continue;
                if (end1 == null) {
                    end1 = (AssociationEnd)obj;
                    continue;
                }
                end2 = (AssociationEnd)obj;
                break;
            }
            MofClass type1 = (MofClass)end1.getType();
            MofClass type2 = (MofClass)end2.getType();
            if (this.referenceExists(type1, end2) || this.referenceExists(type2, end1)) continue;
            boolean isNavigable1 = end1.isNavigable();
            boolean isNavigable2 = end2.isNavigable();
            boolean isComposite1 = AggregationKindEnum.COMPOSITE.equals((Object)end1.getAggregation());
            boolean isComposite2 = AggregationKindEnum.COMPOSITE.equals((Object)end2.getAggregation());
            HashMap<MofClass, Boolean> cache_1 = new HashMap<MofClass, Boolean>();
            HashMap<MofClass, Boolean> cache_2 = new HashMap<MofClass, Boolean>();
            Iterator links = proxy.refAllLinks().iterator();
            while (links.hasNext()) {
                Boolean flag;
                RefAssociationLink link = (RefAssociationLink)links.next();
                RefObject value_1 = link.refFirstEnd();
                RefObject value_2 = link.refSecondEnd();
                if (this.collectionWriting && this.isInClosure(value_1) && this.isInClosure(value_2)) continue;
                if (isNavigable1) {
                    type1 = (MofClass)value_1.refMetaObject();
                    flag = (Boolean)cache_1.get(type1);
                    if (flag == null) {
                        flag = this.referenceExists(type1, end1) ? Boolean.TRUE : Boolean.FALSE;
                        cache_1.put(type1, flag);
                    }
                    if (flag == Boolean.TRUE) continue;
                }
                if (isNavigable2) {
                    type2 = (MofClass)value_2.refMetaObject();
                    flag = (Boolean)cache_2.get(type2);
                    if (flag == null) {
                        flag = this.referenceExists(type2, end2) ? Boolean.TRUE : Boolean.FALSE;
                        cache_2.put(type2, flag);
                    }
                    if (flag == Boolean.TRUE) continue;
                }
                if (!aLinkWritten) {
                    this.startElement(name);
                    aLinkWritten = true;
                }
                if (isComposite2) {
                    this.writeInstance(value_1);
                } else {
                    this.writeInstanceRef(value_1);
                }
                if (isComposite1) {
                    this.writeInstance(value_2);
                    continue;
                }
                this.writeInstanceRef(value_2);
            }
            if (!aLinkWritten) continue;
            this.endElement(name);
        }
        this.processedPackages.add(pkg);
        Iterator containedPackages = pkg.refAllPackages().iterator();
        while (containedPackages.hasNext()) {
            this.writeAssociations((RefPackage)containedPackages.next());
        }
    }

    private boolean referenceExists(MofClass mofClass, AssociationEnd assocEnd) {
        if (!assocEnd.isNavigable()) {
            return false;
        }
        Iterator references = this.references(mofClass).iterator();
        while (references.hasNext()) {
            Reference ref = (Reference)references.next();
            AssociationEnd end = ref.getReferencedEnd();
            if (!end.equals(assocEnd)) continue;
            return true;
        }
        return false;
    }

    private boolean isInClosure(RefObject obj) {
        if (obj == null || this.objectsToWrite == null) {
            return false;
        }
        return this.objectsToWrite.contains(obj.refOutermostComposite());
    }

    private String qualifiedName(ModelElement element) {
        String namespace;
        if (element == null) {
            return null;
        }
        Iterator iter = element.getQualifiedName().iterator();
        String name = (String)iter.next();
        while (iter.hasNext()) {
            name = name.concat(".").concat((String)iter.next());
        }
        int index = name.lastIndexOf(46);
        String pName = name.substring(0, index);
        String sName = name.substring(index + 1, name.length());
        if (!(element instanceof MofClass) && (index = pName.lastIndexOf(46)) != -1) {
            pName = pName.substring(0, index);
            sName = name.substring(index + 1, name.length());
        }
        if ((namespace = (String)this.namespaces.get(pName)) != null) {
            return namespace + ":" + sName;
        }
        return name;
    }

    private static boolean isMultivalued(StructuralFeature feature) {
        MultiplicityType multType = feature.getMultiplicity();
        return multType.getUpper() != 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Record {
        String xmiId;
        boolean isWritten;

        Record(String xmiId, boolean isWritten) {
            this.xmiId = xmiId;
            this.isWritten = isWritten;
        }
    }
}

