/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.xmi.XmiContent;
import com.sap.ip.mmr.xmi.XmiContext;
import com.sap.ip.mmr.xmi.XmiElement;
import java.util.ArrayList;
import java.util.List;
import javax.jmi.model.Classifier;
import javax.jmi.reflect.RefObject;
import org.xml.sax.Attributes;

public class XmiDataTypeElement
extends XmiElement {
    private boolean typeCodeReading = false;
    private Node node = null;
    private String xmiId;
    private int docId;
    private String annotation = null;

    public XmiDataTypeElement(XmiElement parent, XmiContext context, String name, Attributes attrs) {
        super(parent, context);
        this.xmiId = attrs.getValue("xmi.id");
        this.annotation = attrs.getValue("annotation");
        this.docId = context.getCurrentDocId();
    }

    public XmiElement startSubElement(String qName, Attributes attrs) {
        if (!this.typeCodeReading) {
            if (qName.endsWith("typeCode")) {
                this.typeCodeReading = true;
            }
            return this;
        }
        if (this.node == null && !qName.equals("XMI.CorbaTypeCode")) {
            throw new JmiException("2125", new Object[]{qName});
        }
        this.node = new Node(qName, attrs, this.node);
        this.node.annotation = this.annotation;
        return this;
    }

    public XmiElement endElement(String qName) {
        if (this.typeCodeReading) {
            if (this.node.parent != null) {
                this.node = this.node.parent;
            } else {
                this.typeCodeReading = false;
            }
            return this;
        }
        if (!qName.endsWith("DataType")) {
            return this;
        }
        Classifier typeEquivalent = this.context.resolveCorbaType(this.node);
        if (this.xmiId != null) {
            this.context.putReference(this.docId, this.xmiId, (RefObject)typeEquivalent);
        }
        if (!(this.parent instanceof XmiContent)) {
            this.parent.receiveValue(typeEquivalent);
        }
        return this.parent;
    }

    public static class Node {
        public Node parent;
        public List subnodes = new ArrayList();
        public String name;
        public String tcName;
        public String annotation = null;

        public Node(String name, Attributes attrs, Node parent) {
            this.parent = parent;
            this.name = name;
            this.tcName = attrs.getValue("xmi.tcName");
            if (parent != null) {
                parent.addSubNode(this);
            }
        }

        public void addSubNode(Node subNode) {
            this.subnodes.add(subNode);
        }

        public Node firstSubNode() {
            return (Node)this.subnodes.get(0);
        }
    }
}

