/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.m1layer.RefObjectImpl;
import com.sap.ip.mmr.xmi.UnresolvedReference;
import com.sap.ip.mmr.xmi.XmiAssociationElement;
import com.sap.ip.mmr.xmi.XmiClassLevelAttribute;
import com.sap.ip.mmr.xmi.XmiContext;
import com.sap.ip.mmr.xmi.XmiElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Association;
import javax.jmi.model.Attribute;
import javax.jmi.model.StructuralFeature;
import javax.jmi.reflect.RefClass;
import javax.jmi.reflect.RefObject;
import org.xml.sax.Attributes;

public class XmiContent
extends XmiElement {
    private Attribute attr = null;
    private RefClass refClass = null;
    private List values;

    public XmiContent(XmiElement parent, XmiContext context) {
        super(parent, context);
    }

    public XmiElement startSubElement(String qName, Attributes attrs) {
        Object ref = this.context.resolveElementName(qName);
        if (ref instanceof RefClass) {
            return this.context.resolveInstanceOrReference(this, qName, attrs);
        }
        if (ref instanceof Attribute) {
            RefClass readRefClass = (RefClass)this.context.resolveElementName(qName.substring(0, qName.lastIndexOf(".")));
            if (ref != this.attr || this.refClass != readRefClass) {
                if (this.attr != null) {
                    this.setAttributeValue();
                }
                this.attr = (Attribute)ref;
                this.refClass = readRefClass;
                this.values = new ArrayList();
            }
            return new XmiClassLevelAttribute(this, this.context, this.attr, attrs);
        }
        if (ref instanceof Association) {
            return new XmiAssociationElement(this, this.context, (Association)ref);
        }
        throw new JmiException("2108", new Object[]{qName});
    }

    public XmiElement endElement(String qName) {
        if (this.attr != null) {
            this.setAttributeValue();
        }
        if (this.context.getCurrentDocId() == 0 && !this.context.allReferencesResolved()) {
            if (this.context.isSAPXmiVersion()) {
                List list = this.context.getUnresolvedRefIds();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    String mofId = (String)iter.next();
                    RefObjectImpl ro = new RefObjectImpl();
                    ro.set___MofId(mofId);
                    this.context.putReference(this.context.getCurrentDocId(), mofId, ro);
                }
            } else {
                String badRef = this.context.getUnresolvedRefId();
                throw new JmiException("2109", new Object[]{badRef});
            }
        }
        return this.parent;
    }

    public void receiveValue(Object value) {
        if (this.attr == null) {
            throw new JmiException("2110");
        }
        if (value instanceof List) {
            this.values.addAll((List)value);
        } else {
            this.values.add(value);
        }
    }

    private void setAttributeValue() {
        Object value;
        ArrayList list = new ArrayList();
        Iterator iter = this.values.iterator();
        while (iter.hasNext()) {
            value = iter.next();
            if (value instanceof UnresolvedReference && (value = ((UnresolvedReference)value).getValue()) == null) {
                throw new JmiException("2111", new Object[]{this.attr.getName()});
            }
            list.add(value);
        }
        if (XmiContext.isMultivalued((StructuralFeature)this.attr)) {
            value = list;
        } else {
            if (list.size() != 1) {
                throw new JmiException("2112", new Object[]{this.attr.getName()});
            }
            value = list.get(0);
        }
        this.refClass.refSetValue((RefObject)this.attr, value);
        this.attr = null;
        this.refClass = null;
        this.values = null;
    }
}

