/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.xmi;

import com.sap.ip.mmr.foundation.JmiException;
import com.sap.ip.mmr.xmi.ReferencesCounter;
import com.sap.ip.mmr.xmi.UnresolvedReference;
import com.sap.ip.mmr.xmi.XmiContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Reference;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;

public class ReferenceHandler
implements ReferencesCounter {
    private RefObject obj;
    private Reference ref;
    private List values = new ArrayList();
    private int unresolvedRefsCounter = 0;
    private XmiContext context;

    public ReferenceHandler(Reference ref, RefObject obj, List args, XmiContext context) {
        this.obj = obj;
        this.ref = ref;
        this.context = context;
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            Object value = iter.next();
            if (value instanceof UnresolvedReference) {
                Object val = ((UnresolvedReference)value).getValue();
                if (val != null) {
                    value = val;
                } else {
                    ((UnresolvedReference)value).setOwner(this);
                }
            }
            this.values.add(value);
        }
        if (this.unresolvedRefsCounter == 0) {
            this.setReference();
        }
    }

    public void increaseUnresolvedRefs() {
        ++this.unresolvedRefsCounter;
    }

    public void decreaseUnresolvedRefs() {
        --this.unresolvedRefsCounter;
        if (this.unresolvedRefsCounter == 0) {
            this.setReference();
        }
    }

    private void setReference() {
        RefPackage refPackage;
        AssociationEnd end = this.ref.getReferencedEnd();
        if (end == null) {
            throw new JmiException("2102", new Object[]{this.ref.getName()});
        }
        Association association = (Association)end.getContainer();
        boolean isFirst = false;
        Iterator iter = association.getContents().iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof AssociationEnd)) continue;
            isFirst = me.equals(end);
            break;
        }
        if ((refPackage = (RefPackage)this.context.findProxy((ModelElement)association)) == null) {
            throw new JmiException("2103", new Object[]{association.getName()});
        }
        RefAssociation refAssoc = refPackage.refAssociation((RefObject)association);
        if (refAssoc == null) {
            throw new JmiException("2104", new Object[]{association.getName()});
        }
        iter = this.values.iterator();
        while (iter.hasNext()) {
            RefObject secondObj;
            Object value = iter.next();
            RefObject endValue = value instanceof UnresolvedReference ? (RefObject)((UnresolvedReference)value).getValue() : (RefObject)value;
            RefObject firstObj = isFirst ? endValue : this.obj;
            boolean exists = refAssoc.refLinkExists(firstObj, secondObj = isFirst ? this.obj : endValue);
            if (exists) continue;
            refAssoc.refAddLink(firstObj, secondObj);
        }
    }
}

