/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;

public class XMIImport {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$XMIImport == null ? (class$com$sap$ip$mmr$tools$XMIImport = XMIImport.class$("com.sap.ip.mmr.tools.XMIImport")) : class$com$sap$ip$mmr$tools$XMIImport);
    static final int LAYER_2_AND_SER = 20;
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$XMIImport;

    public static void main(String[] args) {
        XMIImport xmiImport = new XMIImport();
        String fileName = null;
        String srcDir = "./";
        String dstDir = null;
        int mofLayer = 2;
        String extendName = null;
        int dbType = -1;
        boolean verbose = false;
        int nargs = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                XMIImport.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            String value = XMIImport.getValue(args[i]);
            if (param == null) {
                XMIImport.writeUsage();
                return;
            }
            ++nargs;
            if (param.compareToIgnoreCase("srcdir") == 0) {
                srcDir = value;
                continue;
            }
            if (param.compareToIgnoreCase("filename") == 0) {
                fileName = value;
                continue;
            }
            if (param.compareToIgnoreCase("dstdir") == 0) {
                dstDir = value;
                continue;
            }
            if (param.compareToIgnoreCase("layer") == 0) {
                mofLayer = new Integer(value);
                continue;
            }
            if (param.compareToIgnoreCase("extendName") == 0) {
                extendName = value;
                continue;
            }
            if (param.compareToIgnoreCase("dbType") == 0) {
                dbType = XMIImport.getDBType(value);
                continue;
            }
            if (param.compareToIgnoreCase("verbose") != 0) continue;
            verbose = true;
        }
        if (nargs == 0 || fileName == null) {
            XMIImport.writeUsage();
            return;
        }
        if (mofLayer < 1 || mofLayer > 20) {
            XMIImport.writeUsage();
            return;
        }
        xmiImport.start(srcDir, fileName, dstDir, null, mofLayer, extendName, dbType, null, verbose);
    }

    public static int getDBType(String value) {
        int dbType = -1;
        if (value.compareToIgnoreCase("no") == 0) {
            dbType = 0;
        }
        return dbType;
    }

    public static String getValue(String arg) {
        String value = null;
        int index = arg.indexOf(61);
        if (index >= 0) {
            value = arg.substring(index + 1);
        }
        return value;
    }

    public static String getParameter(String arg) {
        String param = null;
        int index = arg.indexOf(61);
        param = index < 0 ? arg.substring(1) : arg.substring(1, index);
        return param;
    }

    public static void writeUsage() {
        System.err.println("Usage: XMIImport [-options]");
        System.err.println("where options include:");
        System.err.println("    -srcdir=<source directory with XMI files>");
        System.err.println("    -filename=<name of XMI file relative to srcdir>");
        System.err.println("    -dstdir=<destination directory for Repository>");
        System.err.println("    -layer=[1|2], 1: metadata, 2: models");
        System.err.println("    -extendName=<name of extend>");
        System.err.println("    -dbType=[no]");
        System.err.println("    -verbose");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean start(String srcDir, String filenameRel, String dstDir, Collection inputStreams, int mofLayer, String extendName, int dbType, Connection cxIn, boolean verbose) {
        boolean flag = true;
        String filename = null;
        if (srcDir != null && filenameRel != null) {
            filename = (srcDir = srcDir.replace('\\', '/')).charAt(srcDir.length() - 1) != '/' ? srcDir + '/' + filenameRel : srcDir + filenameRel;
        }
        try {
            Connection cx;
            block32: {
                LocalTransaction lt;
                block30: {
                    ConnectionSpec cxs = new ConnectionSpec();
                    cxs.setDbType(dbType);
                    Log log = Utilities.getUtilities().getConsoleLog();
                    if (verbose) {
                        log.setEffectiveSeverity(300);
                    } else {
                        log.setEffectiveSeverity(400);
                    }
                    cxs.setLog(log);
                    if (dstDir != null) {
                        Workspace ws = new Workspace("XMIImport");
                        ws.setPath(dstDir);
                        if (dbType == 0) {
                            ws.setReadOnly(true);
                        } else {
                            ws.setReadOnly(false);
                        }
                        cxs.getWorkspacesM1().clear();
                        cxs.getWorkspacesM1().add(ws);
                        cxs.getWorkspacesM2().add(ws);
                    }
                    ConnectionFactory cxf = new ConnectionFactory();
                    cx = null;
                    cx = cxIn != null ? cxIn : cxf.getConnection(cxs);
                    RefPackage refPackage = null;
                    switch (mofLayer) {
                        case 1: {
                            refPackage = cx.getTopLevelPackageM1();
                            break;
                        }
                        case 2: {
                            refPackage = cx.getTopLevelPackageM2();
                            break;
                        }
                        default: {
                            System.err.println("Invalid MOF layer: " + mofLayer);
                            return false;
                        }
                    }
                    if (extendName != null) {
                        refPackage = refPackage.refPackage(extendName);
                    }
                    lt = cx.getLocalTransaction();
                    try {
                        try {
                            block29: {
                                lt.begin();
                                try {
                                    if (filename != null) {
                                        cx.read(filename, refPackage);
                                        break block29;
                                    }
                                    if (inputStreams != null) {
                                        Iterator iter = inputStreams.iterator();
                                        while (iter.hasNext()) {
                                            InputStream is = (InputStream)iter.next();
                                            BufferedInputStream bis = new BufferedInputStream(is);
                                            cx.read(bis, null, refPackage);
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    System.err.println(e);
                                    flag = false;
                                }
                                catch (MalformedXMIException e) {
                                    System.err.println((Object)e);
                                    flag = false;
                                }
                            }
                            Object var22_25 = null;
                            if (!flag) break block30;
                        }
                        catch (Exception e) {
                            Repository.category.errorT(location, e.toString());
                            Object var22_26 = null;
                            if (flag) {
                                lt.commit();
                                String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                                HashMap<String, String> p = new HashMap<String, String>();
                                p.put("srcpath", null);
                                if (dstDir != null) {
                                    p.put("dstpath", dstDir);
                                }
                                p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                                cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
                                lt.commit();
                                break block32;
                            } else {
                                lt.rollback();
                            }
                            break block32;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_27 = null;
                        if (!flag) {
                            lt.rollback();
                            throw throwable;
                        }
                        lt.commit();
                        String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                        HashMap<String, String> p = new HashMap<String, String>();
                        p.put("srcpath", null);
                        if (dstDir != null) {
                            p.put("dstpath", dstDir);
                        }
                        p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                        cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
                        lt.commit();
                        throw throwable;
                    }
                    lt.commit();
                    String className = "com.sap.ip.mmr.m2layer.tasks.TaskGenerator";
                    HashMap<String, String> p = new HashMap<String, String>();
                    p.put("srcpath", null);
                    if (dstDir != null) {
                        p.put("dstpath", dstDir);
                    }
                    p.put("taskClassName", "com.sap.ip.mmr.m2layer.tasks.TaskGenerator");
                    cx.runTask("com.sap.ip.mmr.m2layer.tasks.TaskGenerator", p);
                    lt.commit();
                    break block32;
                }
                lt.rollback();
            }
            if (cxIn != null) return flag;
            cx.close();
            return flag;
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
        return flag;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

