/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.jmi.model.ModelElement;
import javax.jmi.model.ModelPackage;
import javax.jmi.model.MofPackage;
import javax.jmi.model.NameNotResolvedException;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;

public class XMIExport {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$XMIExport == null ? (class$com$sap$ip$mmr$tools$XMIExport = XMIExport.class$("com.sap.ip.mmr.tools.XMIExport")) : class$com$sap$ip$mmr$tools$XMIExport);
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$XMIExport;

    public static void main(String[] args) {
        XMIExport xmiExport = new XMIExport();
        if (args.length < 3) {
            System.err.println("Usage: XMIExport [filename] [qualified name | top] [MOF level]");
            return;
        }
        String fileName = args[0];
        String qualifiedName = args[1];
        int mofLayer = 2;
        try {
            mofLayer = Integer.parseInt(args[2]);
        }
        catch (Exception e) {
            mofLayer = 2;
        }
        String xmiVersion = "1.2";
        xmiExport.start(fileName, qualifiedName, mofLayer, xmiVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String filename, String qualifiedName, int mofLayer, String xmiVersion) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
        }
        catch (IOException e) {
            Repository.category.errorT(location, e.toString());
            return;
        }
        try {
            ConnectionSpec cxs = new ConnectionSpec();
            ConnectionFactory cxf = new ConnectionFactory();
            Connection cx = null;
            cx = cxf.getConnection(cxs);
            ArrayList<ModelElement> objects = null;
            ModelPackage extend = null;
            if (qualifiedName == null || qualifiedName.compareToIgnoreCase("top") == 0) {
                switch (mofLayer) {
                    case 2: {
                        extend = cx.getTopLevelPackageM2();
                        break;
                    }
                    case 1: {
                        extend = cx.getTopLevelPackageM1();
                        break;
                    }
                }
                if (extend == null) {
                    System.err.println("XMIExport: MOF Level not supported or no extend found.");
                    return;
                }
            } else {
                ModelElement o = null;
                objects = new ArrayList<ModelElement>();
                switch (mofLayer) {
                    case 2: {
                        MofPackage top = cx.getMofPackageRootM2();
                        try {
                            o = top.resolveQualifiedName(Utilities.getUtilities().decodeQualifiedName(qualifiedName));
                            if (o == null) break;
                            objects.add(o);
                        }
                        catch (NameNotResolvedException e) {}
                        break;
                    }
                }
                if (o != null) {
                    objects.add(o);
                }
                if (objects.size() < 1) {
                    System.err.println("XMIExport: No objects found.");
                    return;
                }
            }
            LocalTransaction lt = cx.getLocalTransaction();
            try {
                lt.begin();
                try {
                    if (extend != null) {
                        cx.write((OutputStream)fos, (RefPackage)extend, xmiVersion);
                    } else if (objects != null && objects.size() > 0) {
                        cx.write((OutputStream)fos, objects, xmiVersion);
                    }
                }
                catch (IOException e) {
                    Repository.category.errorT(location, e.toString());
                    lt.commit();
                    return;
                }
            }
            catch (Exception e) {
                Repository.category.errorT(location, e.toString());
            }
            finally {
                lt.commit();
            }
            cx.close();
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
        try {
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            Repository.category.errorT(location, e.toString());
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

