/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.tools.XMIImport;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.StreamLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.ModelPackage;
import javax.jmi.reflect.RefPackage;
import javax.jmi.xmi.MalformedXMIException;
import javax.resource.ResourceException;
import javax.resource.cci.LocalTransaction;

public class RunTask {
    private String sourcepath;
    private String destpath;
    private String className;
    private String classPath;
    private boolean verbose = false;
    private boolean debug = false;
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$RunTask == null ? (class$com$sap$ip$mmr$tools$RunTask = RunTask.class$("com.sap.ip.mmr.tools.RunTask")) : class$com$sap$ip$mmr$tools$RunTask);
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$RunTask;

    public static void main(String[] args) {
        RunTask rt = new RunTask();
        int nargs = 0;
        for (int i = 0; i < args.length; ++i) {
            String value;
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                RunTask.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            ++nargs;
            if (param.compareToIgnoreCase("srcpath") == 0) {
                value = XMIImport.getValue(args[i]);
                rt.setSourcepath(value);
                continue;
            }
            if (param.compareToIgnoreCase("dstpath") == 0) {
                value = XMIImport.getValue(args[i]);
                rt.setDestpath(value);
                continue;
            }
            if (param.compareToIgnoreCase("className") == 0) {
                value = XMIImport.getValue(args[i]);
                rt.setClassName(value);
                continue;
            }
            if (param.compareToIgnoreCase("classPath") == 0) {
                value = XMIImport.getValue(args[i]);
                rt.setClassPath(value);
                continue;
            }
            if (param.compareToIgnoreCase("verbose") == 0) {
                rt.setVerbose(true);
                continue;
            }
            if (param.compareToIgnoreCase("debug") != 0) continue;
            rt.setDebug(true);
        }
        Log log = Utilities.getUtilities().getConsoleLog();
        rt.execute(log);
    }

    public static void writeUsage() {
        System.err.println("Usage: GenerateJMI [-options]");
        System.err.println("where options include:");
        System.err.println("    -srcpath=<source directory with XMI files or Jar file>");
        System.err.println("    -dstpath=<destination directory for Repository>");
        System.err.println("    -className=<name of the class representing the task to run>");
        System.err.println("    -classPath=<path to jars>");
        System.err.println("    -verbose");
        System.err.println("    -debug");
    }

    public String execute() {
        return this.execute(null);
    }

    public String execute(Log log) {
        Log newLog = null;
        if (this.sourcepath == null && this.destpath == null) {
            RunTask.writeUsage();
        }
        if (this.sourcepath == null) {
            String msg = "[RunTask] sourcepath not specified";
            System.err.println(msg);
            return msg;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos, true);
        newLog = log == null ? Utilities.getUtilities().getConsoleLog(ps) : log;
        if (newLog != null) {
            if (this.isDebug()) {
                newLog.setEffectiveSeverity(100);
                location.setEffectiveSeverity(100);
            } else if (this.isVerbose()) {
                newLog.setEffectiveSeverity(300);
                location.setEffectiveSeverity(300);
            } else {
                newLog.setEffectiveSeverity(400);
                location.setEffectiveSeverity(400);
            }
        }
        return this.connectAndGenerate(newLog, baos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String connectAndGenerate(Log log, ByteArrayOutputStream baos) {
        String logStr = "RunTask executed ok.";
        location.infoT("Connecting Model Repository ...");
        location.infoT("Checking source path: " + this.getSourcepath());
        File file = null;
        String msg = null;
        String path = "";
        List paths = Utilities.getUtilities().splitClassPath(this.getSourcepath());
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            String p = (String)iter.next();
            if (p == null) continue;
            file = new File(p);
            if (!file.exists()) {
                msg = "[RunTask] The source file/path doesn't exist: " + this.getSourcepath();
                System.err.println(msg);
                iter.remove();
            } else {
                path = path + p;
            }
            if (!iter.hasNext()) continue;
            path = path + Utilities.SystemPathSeparator;
        }
        try {
            Connection cx;
            block30: {
                LocalTransaction lt;
                block28: {
                    location.infoT("Opening connection to MMR ...");
                    ConnectionSpec cxs = new ConnectionSpec();
                    Workspace workspace = new Workspace("[default]");
                    if (file != null && file.isDirectory()) {
                        workspace.setPath(file.getAbsolutePath());
                    } else {
                        workspace.setPath(this.destpath);
                    }
                    cxs.getWorkspacesM1().add(workspace);
                    cxs.getWorkspacesM2().add(workspace);
                    if (log != null) {
                        cxs.setLog(log);
                    }
                    ConnectionFactory cxf = new ConnectionFactory();
                    cx = cxf.getConnection(cxs);
                    ModelPackage refPackage = cx.getTopLevelPackageM2();
                    location.infoT("Start local transaction ...");
                    lt = cx.getLocalTransaction();
                    try {
                        try {
                            lt.begin();
                            if (!(file == null || file.isDirectory() || file.getName().indexOf(".xml") <= 0 && file.getName().indexOf(".xmi") <= 0)) {
                                try {
                                    if (this.verbose) {
                                        location.infoT("Reading XMI file: " + path + " ...");
                                    }
                                    cx.read(path, (RefPackage)refPackage);
                                }
                                catch (IOException e) {
                                    Repository.category.errorT(location, e.toString());
                                    String string = e.toString();
                                    Object var18_21 = null;
                                    if (this.verbose) {
                                        location.infoT("Commit ...");
                                    }
                                    lt.commit();
                                    if (this.verbose) {
                                        location.infoT("Running task '" + this.className + "' ...");
                                    }
                                    HashMap<String, String> p = new HashMap<String, String>();
                                    p.put("srcpath", path);
                                    p.put("dstpath", this.getDestpath());
                                    p.put("taskClassName", this.className);
                                    p.put("classpath", this.classPath);
                                    cx.runTask(this.className, p);
                                    return string;
                                }
                                catch (MalformedXMIException e) {
                                    Repository.category.errorT(location, e.toString());
                                    String string = e.toString();
                                    Object var18_22 = null;
                                    if (this.verbose) {
                                        location.infoT("Commit ...");
                                    }
                                    lt.commit();
                                    if (this.verbose) {
                                        location.infoT("Running task '" + this.className + "' ...");
                                    }
                                    HashMap<String, String> p = new HashMap<String, String>();
                                    p.put("srcpath", path);
                                    p.put("dstpath", this.getDestpath());
                                    p.put("taskClassName", this.className);
                                    p.put("classpath", this.classPath);
                                    cx.runTask(this.className, p);
                                    return string;
                                }
                            }
                            Object var18_23 = null;
                            if (!this.verbose) break block28;
                        }
                        catch (Exception e) {
                            Repository.category.errorT(location, e.toString());
                            Object var18_24 = null;
                            if (this.verbose) {
                                location.infoT("Commit ...");
                            }
                            lt.commit();
                            if (this.verbose) {
                                location.infoT("Running task '" + this.className + "' ...");
                            }
                            HashMap<String, String> p = new HashMap<String, String>();
                            p.put("srcpath", path);
                            p.put("dstpath", this.getDestpath());
                            p.put("taskClassName", this.className);
                            p.put("classpath", this.classPath);
                            cx.runTask(this.className, p);
                            break block30;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var18_25 = null;
                        if (this.verbose) {
                            location.infoT("Commit ...");
                        }
                        lt.commit();
                        if (this.verbose) {
                            location.infoT("Running task '" + this.className + "' ...");
                        }
                        HashMap<String, String> p = new HashMap<String, String>();
                        p.put("srcpath", path);
                        p.put("dstpath", this.getDestpath());
                        p.put("taskClassName", this.className);
                        p.put("classpath", this.classPath);
                        cx.runTask(this.className, p);
                        throw throwable;
                    }
                    location.infoT("Commit ...");
                }
                lt.commit();
                if (this.verbose) {
                    location.infoT("Running task '" + this.className + "' ...");
                }
                HashMap<String, String> p = new HashMap<String, String>();
                p.put("srcpath", path);
                p.put("dstpath", this.getDestpath());
                p.put("taskClassName", this.className);
                p.put("classpath", this.classPath);
                cx.runTask(this.className, p);
            }
            if (this.verbose) {
                location.infoT("Close connection to Model Repository ...");
            }
            cx.close();
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
        if (this.verbose) {
            location.infoT("done.");
        }
        if (!(log instanceof StreamLog)) return logStr;
        return baos.toString();
    }

    public String getDestpath() {
        return this.destpath;
    }

    public String getSourcepath() {
        return this.sourcepath;
    }

    public void setDestpath(String destpath) {
        this.destpath = destpath;
    }

    public void setSourcepath(String sourcepath) {
        this.sourcepath = sourcepath;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String string) {
        this.classPath = string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

