/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.PersistenceFS;
import com.sap.ip.mmr.persistence.PersistenceJar;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.Collection;

public class JarOrDirectoryCheck {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$JarOrDirectoryCheck == null ? (class$com$sap$ip$mmr$tools$JarOrDirectoryCheck = JarOrDirectoryCheck.class$("com.sap.ip.mmr.tools.JarOrDirectoryCheck")) : class$com$sap$ip$mmr$tools$JarOrDirectoryCheck);
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$JarOrDirectoryCheck;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Path to jar or directory is missing!");
            return;
        }
        String path = args[0];
        ConnectionSpec cxs = new ConnectionSpec();
        ConnectionFactory cxf = new ConnectionFactory();
        try {
            Connection cx = cxf.getConnection(cxs);
            PersistenceFS p = null;
            File f = new File(path);
            if (f.isDirectory()) {
                Workspace ws = new Workspace(path);
                ws.setPath(path);
                p = new PersistenceFS(RepositoryServer.getRepositoryServer(), ws);
            } else {
                p = new PersistenceJar(RepositoryServer.getRepositoryServer(), path);
            }
            Collection c = p.checkPersistence(cx);
            if (c == null || c.size() == 0) {
                System.out.println("Jar content is consistent.");
            } else {
                System.err.println("Jar content is inconsistent!");
            }
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

