/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.tools;

import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ILocalTransaction;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.Association;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.tools.XMIImport;
import com.sap.tc.logging.Location;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.Reference;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.resource.ResourceException;

public class CheckConsistency {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$tools$CheckConsistency == null ? (class$com$sap$ip$mmr$tools$CheckConsistency = CheckConsistency.class$("com.sap.ip.mmr.tools.CheckConsistency")) : class$com$sap$ip$mmr$tools$CheckConsistency);
    private IConnection cx;
    private PrintWriter writer;
    static /* synthetic */ Class class$com$sap$ip$mmr$tools$CheckConsistency;

    public CheckConsistency(String path, OutputStream os) {
        this.writer = os != null ? new PrintWriter(os) : new PrintWriter(System.out);
        ConnectionSpec cxs = new ConnectionSpec();
        cxs.setComponentClassLoader(this.getClass().getClassLoader());
        cxs.setLog(Utilities.getUtilities().getConsoleLog());
        ConnectionFactory cxf = new ConnectionFactory();
        try {
            this.cx = cxf.getConnection(cxs);
            cxs.getWorkspacesM2().addAll(this.cx.getWorkspacesAvailableM2());
            cxs.getWorkspacesM1().addAll(this.cx.getWorkspacesAvailableM1());
            if (path != null) {
                Workspace w = new Workspace(path);
                w.setPath(path);
                cxs.getWorkspacesM2().add(w);
                RepositoryServer.getRepositoryServer().registerWorkspace(w, 2);
                cxs.getWorkspacesM1().add(w);
                RepositoryServer.getRepositoryServer().registerWorkspace(w, 1);
            }
        }
        catch (ResourceException e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    public void close() {
        if (this.cx != null) {
            try {
                this.cx.close();
            }
            catch (ResourceException e) {
                Repository.category.errorT(location, e.toString());
            }
        }
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }

    public static void main(String[] args) {
        String path = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') {
                System.err.println("Parameter must start with a - sign: " + args[i]);
                System.err.println("");
                CheckConsistency.writeUsage();
                return;
            }
            String param = XMIImport.getParameter(args[i]);
            String value = XMIImport.getValue(args[i]);
            if (param == null) {
                CheckConsistency.writeUsage();
                return;
            }
            if (param.compareToIgnoreCase("path") != 0) continue;
            path = value;
        }
        CheckConsistency cc = new CheckConsistency(path, System.out);
        cc.check();
    }

    public static void writeUsage() {
        System.err.println("Usage: CheckConsistency [-options]");
        System.err.println("where options include:");
        System.err.println("    -path=[path to jar or folder]");
    }

    public void check() {
        this.check(1);
        this.check(2);
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(int mofLayer) {
        switch (mofLayer) {
            case 1: {
                this.writer.println("================");
                this.writer.println("M1 Metadata  ...");
                this.writer.println("================");
                break;
            }
            case 2: {
                this.writer.println("");
                this.writer.println("=================");
                this.writer.println("M2 Metamodels  ...");
                this.writer.println("=================");
            }
        }
        try {
            ILocalTransaction lt = (ILocalTransaction)this.cx.getLocalTransaction();
            try {
                lt.begin();
                this.writer.println("Reading all instances ...");
                List listInstances = null;
                switch (mofLayer) {
                    case 1: {
                        listInstances = this.cx.getRepository().queryM1(null, null, false);
                        break;
                    }
                    case 2: {
                        listInstances = this.cx.getRepository().queryM2(null, null, false);
                    }
                }
                this.writer.println("   # instances read = " + listInstances.size());
                HashMap<String, RefBaseObject> mapInstances = new HashMap<String, RefBaseObject>();
                this.writer.println("Verifying constraints ...");
                Iterator iter = listInstances.iterator();
                while (iter.hasNext()) {
                    RefBaseObject rbo = (RefBaseObject)iter.next();
                    mapInstances.put(rbo.refMofId(), rbo);
                    Collection col = rbo.refVerifyConstraints(true);
                    if (col == null) {
                        this.writer.println("   ok " + rbo.refMofId());
                        continue;
                    }
                    this.writer.println("   !failed " + rbo.refMofId() + col.toString());
                }
                HashSet<String> mofIdsReferenced = new HashSet<String>();
                HashSet<AssociationsOfObject> aoos = new HashSet<AssociationsOfObject>();
                this.writer.println("Reading associations ...");
                iter = listInstances.iterator();
                while (iter.hasNext()) {
                    RefBaseObject rbo = (RefBaseObject)iter.next();
                    AssociationsOfObject aoo = this.cx.getRepository().selectAssoc(mofLayer, null, rbo.refMofId());
                    if (aoo == null) {
                        this.writer.println("   !Can't read associations of " + rbo.refMofId());
                        continue;
                    }
                    this.writer.println("   ok " + rbo.refMofId());
                    aoos.add(aoo);
                }
                this.writer.println("Checking associations ...");
                iter = aoos.iterator();
                while (iter.hasNext()) {
                    AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
                    boolean isOk = true;
                    Iterator iF = aoo.getMofIdsForward().iterator();
                    while (iF.hasNext()) {
                        Association a = (Association)iF.next();
                        mofIdsReferenced.add(a.getMofId2());
                        if (a.getMofId1().compareTo(aoo.getMofId()) != 0) {
                            this.writer.println("   !First MOF ID " + a.getMofId1() + " not equal to " + aoo.getMofId());
                            isOk = false;
                        }
                        if (mapInstances.containsKey(a.getMofId2())) continue;
                        this.writer.println("   !No instance for forward MOF ID " + a.getMofId2() + " of " + aoo.getMofId());
                        isOk = false;
                    }
                    Iterator iB = aoo.getMofIdsBackward().iterator();
                    while (iB.hasNext()) {
                        Association a = (Association)iB.next();
                        mofIdsReferenced.add(a.getMofId2());
                        if (a.getMofId1().compareTo(aoo.getMofId()) != 0) {
                            this.writer.println("   !First MOF ID " + a.getMofId1() + " not equal to " + aoo.getMofId());
                            isOk = false;
                        }
                        if (mapInstances.containsKey(a.getMofId2())) continue;
                        this.writer.println("   !No instance for backward MOF ID " + a.getMofId2() + " of " + aoo.getMofId());
                        isOk = false;
                    }
                    if (!isOk) continue;
                    this.writer.println("   ok associations of " + aoo.getMofId());
                }
                this.writer.println("Checking non-referenced instances ...");
                boolean isOk = true;
                iter = listInstances.iterator();
                while (iter.hasNext()) {
                    RefBaseObject rbo = (RefBaseObject)iter.next();
                    if (mofIdsReferenced.contains(rbo.refMofId())) continue;
                    this.writer.println("   !instance not referenced " + rbo.toString());
                    isOk = false;
                }
                if (isOk) {
                    this.writer.println("   all instances are referenced");
                }
                this.writer.println("Checking consistency of associations ...");
                Iterator iter1 = aoos.iterator();
                while (iter1.hasNext()) {
                    AssociationsOfObject aoo = (AssociationsOfObject)iter1.next();
                    isOk = true;
                    RefBaseObject rbo = (RefBaseObject)mapInstances.get(aoo.getMofId());
                    RefObject metaObject = rbo.refMetaObject();
                    if (metaObject == null) {
                        this.writer.println("   !Can't read meta object of instance " + rbo.toString());
                    } else if (!(metaObject instanceof MofClass)) {
                        this.writer.println("   !Meta object of instance is of unexpected type " + metaObject.getClass().getName());
                    } else {
                        MofClass mc = (MofClass)metaObject;
                        Iterator iter2 = Utilities.getUtilities().getAllContent((ModelElement)mc).iterator();
                        while (iter2.hasNext()) {
                            Association a;
                            Iterator iter3;
                            int n;
                            Object o = iter2.next();
                            if (!(o instanceof Reference)) continue;
                            Reference reference = (Reference)o;
                            AssociationEnd aeReferenced = reference.getReferencedEnd();
                            javax.jmi.model.Association association = (javax.jmi.model.Association)aeReferenced.getContainer();
                            AssociationEnd ae1 = null;
                            AssociationEnd ae2 = null;
                            String associationQn = null;
                            switch (mofLayer) {
                                case 1: {
                                    associationQn = Utilities.getUtilities().encodeQualifiedName(association.getQualifiedName());
                                    break;
                                }
                                case 2: {
                                    associationQn = association.getName();
                                }
                            }
                            Iterator j = association.getContents().iterator();
                            while (j.hasNext()) {
                                Object o_ = j.next();
                                if (!(o_ instanceof AssociationEnd)) continue;
                                if (ae1 == null) {
                                    ae1 = (AssociationEnd)o_;
                                    continue;
                                }
                                if (ae2 != null) continue;
                                ae2 = (AssociationEnd)o_;
                            }
                            if (aeReferenced.equals(ae1)) {
                                n = 0;
                                iter3 = aoo.getMofIdsBackward().iterator();
                                while (iter3.hasNext()) {
                                    a = (Association)iter3.next();
                                    if (associationQn.compareTo(a.getAssociationId()) != 0) continue;
                                    ++n;
                                }
                                if (n < aeReferenced.getMultiplicity().getLower()) {
                                    this.writer.println("   !too few associations found in " + aoo.getMofId() + " of kind " + association.getName() + "." + aeReferenced.getName() + ", " + rbo.toString());
                                    isOk = false;
                                }
                                if (n <= aeReferenced.getMultiplicity().getUpper() || aeReferenced.getMultiplicity().getUpper() <= 0) continue;
                                this.writer.println("   !too many associations found in " + aoo.getMofId() + " of kind " + association.getName() + "." + aeReferenced.getName() + ", " + rbo.toString());
                                isOk = false;
                                continue;
                            }
                            n = 0;
                            iter3 = aoo.getMofIdsForward().iterator();
                            while (iter3.hasNext()) {
                                a = (Association)iter3.next();
                                if (associationQn.compareTo(a.getAssociationId()) != 0) continue;
                                ++n;
                            }
                            if (n < aeReferenced.getMultiplicity().getLower()) {
                                this.writer.println("   !too few associations found in " + aoo.getMofId() + " of kind " + association.getName() + "." + aeReferenced.getName() + ", " + rbo.toString());
                                isOk = false;
                            }
                            if (n <= aeReferenced.getMultiplicity().getUpper() || aeReferenced.getMultiplicity().getUpper() <= 0) continue;
                            this.writer.println("   !too many associations found in " + aoo.getMofId() + " of kind " + association.getName() + "." + aeReferenced.getName() + ", " + rbo.toString());
                            isOk = false;
                        }
                    }
                    if (!isOk) continue;
                    this.writer.println("   ok association consistency of " + aoo.getMofId());
                }
                this.writer.println("done.");
            }
            finally {
                lt.rollback();
            }
        }
        catch (Exception e) {
            Repository.category.errorT(location, e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

