/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence.check;

import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.persistence.check.FileExistenceCheck;
import com.sap.ip.mmr.persistence.check.IPersistencyCheck;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.util.ArrayList;
import java.util.Collection;

public final class ModelVerifier {
    private final Location location;
    private final IConnection conn;

    public ModelVerifier(IConnection conn) {
        if (conn == null) {
            throw new NullPointerException("BiDirectionalAssociationCheck: conn is null");
        }
        this.conn = conn;
        this.location = Location.getLocation(this.getClass());
        this.initTracing();
    }

    private void initTracing() {
        Log log = Utilities.getUtilities().getConsoleLog();
        log.setEffectiveSeverity(0);
        this.location.addLog(log);
        this.location.setEffectiveSeverity(0);
        String loc_bi = "com.sap.ip.mmr.persistence.check";
        this.setTracing("com.sap.ip.mmr.persistence.check", log);
    }

    private void setTracing(String location, Log log) {
        Location loc = Location.getLocation((String)location);
        loc.addLog(log);
        loc.setEffectiveSeverity(0);
    }

    public Collection run(Workspace ws) {
        IPersistencyCheck[] checks = this.getChecks(ws);
        ArrayList col = null;
        this.location.infoT("Running checks for workspace " + ws.toString());
        for (int i = 0; i < checks.length; ++i) {
            IPersistencyCheck check = checks[i];
            this.location.infoT("Executing check " + check.getDescription());
            Collection c = check.run();
            if (c == null || c.size() == 0) {
                this.location.infoT("Passed test successfully " + check.getDescription());
                continue;
            }
            this.location.errorT("Test failed " + check.getDescription());
            if (col == null) {
                col = new ArrayList();
            }
            col.addAll(c);
        }
        return col;
    }

    public IPersistencyCheck[] getChecks(Workspace ws) {
        return new IPersistencyCheck[]{new FileExistenceCheck(this.conn, ws)};
    }
}

