/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence.check;

import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.Association;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.persistence.check.AbstractSnippetCheck;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.jmi.reflect.RefBaseObject;

public class FileExistenceCheck
extends AbstractSnippetCheck {
    private Set mofIdsInstances = new HashSet();
    private Map associationFiles = new HashMap();
    private IConnection connection;

    public FileExistenceCheck(IConnection connection, Workspace workspace) {
        super(workspace);
        this.connection = connection;
    }

    public String getDescription() {
        return "File existence check";
    }

    public Collection run() {
        ArrayList col1 = this.checkSnippetRecursive(new File(this.workspace.getPath()));
        Collection col2 = this.checkAssociations();
        if (col2 != null && col2.size() > 0) {
            if (col1 == null) {
                col1 = new ArrayList();
            }
            col1.addAll(col2);
        }
        return col1;
    }

    protected Collection checkSnippet(File file, File folder) {
        String SUFFIX_XML = ".xml";
        String SUFFIX_PROPERTIES = ".properties";
        ArrayList<IConnection.CheckResult> col = null;
        if (file.getName().endsWith(".xml")) {
            IConnection.CheckResult cr;
            File f;
            String name;
            String nameWithoutSuffix = file.getName().substring(0, file.getName().length() - ".xml".length());
            if (nameWithoutSuffix.endsWith("_I")) {
                name = nameWithoutSuffix.substring(0, nameWithoutSuffix.length() - "_I".length());
                this.mofIdsInstances.add(name);
                f = new File(folder.getAbsoluteFile() + File.separator + name + "_A" + ".xml");
                if (!f.exists()) {
                    this.addMissingInstance(col, f);
                }
                if ((f = new File(folder.getAbsoluteFile() + File.separator + name + "_D" + ".xml")).exists()) {
                    cr = new IConnection.CheckResult(1);
                    cr.setObjectsInError(new Object[]{f});
                    if (col == null) {
                        col = new ArrayList();
                    }
                    col.add(cr);
                }
            }
            if (nameWithoutSuffix.endsWith("_A")) {
                name = nameWithoutSuffix.substring(0, nameWithoutSuffix.length() - "_A".length());
                try {
                    this.associationFiles.put(file, AssociationsOfObject.decodeAssocXML(this.connection, RepositoryServer.getRepositoryFS().readFileContent(file.getAbsolutePath())));
                }
                catch (Exception e) {
                    cr = new IConnection.CheckResult(3);
                    cr.setObjectsInError(new Object[]{file});
                    if (col == null) {
                        col = new ArrayList<IConnection.CheckResult>();
                    }
                    col.add(cr);
                }
                f = new File(folder.getAbsoluteFile() + File.separator + name + "_I" + ".xml");
                if (!f.exists()) {
                    this.addMissingInstance(col, f);
                }
            }
        }
        return col;
    }

    private Collection checkAssociations() {
        Collection col = null;
        Iterator i = this.associationFiles.keySet().iterator();
        while (i.hasNext()) {
            RefBaseObject rbo;
            Association a;
            File file = (File)i.next();
            AssociationsOfObject aoo = (AssociationsOfObject)this.associationFiles.get(file);
            Iterator j = aoo.getMofIdsForward().iterator();
            while (j.hasNext()) {
                a = (Association)j.next();
                if (!this.mofIdsInstances.contains(a.getMofId1()) && (rbo = this.connection.getRepository().selectM1(a.getMofId1(), false)) == null) {
                    this.addMissingAssociation(col, file, a.getMofId1());
                }
                if (this.mofIdsInstances.contains(a.getMofId2()) || (rbo = this.connection.getRepository().selectM1(a.getMofId2(), false)) != null) continue;
                this.addMissingAssociation(col, file, a.getMofId2());
            }
            j = aoo.getMofIdsBackward().iterator();
            while (j.hasNext()) {
                a = (Association)j.next();
                if (!this.mofIdsInstances.contains(a.getMofId1()) && (rbo = this.connection.getRepository().selectM1(a.getMofId1(), false)) == null) {
                    this.addMissingAssociation(col, file, a.getMofId1());
                }
                if (this.mofIdsInstances.contains(a.getMofId2()) || (rbo = this.connection.getRepository().selectM1(a.getMofId2(), false)) != null) continue;
                this.addMissingAssociation(col, file, a.getMofId2());
            }
        }
        return col;
    }

    private void addMissingInstance(Collection col, File file) {
        IConnection.CheckResult cr = new IConnection.CheckResult(0);
        cr.setObjectsInError(new Object[]{file});
        if (col == null) {
            col = new ArrayList<IConnection.CheckResult>();
        }
        col.add(cr);
    }

    private void addMissingAssociation(Collection col, File file, String mofId) {
        IConnection.CheckResult cr = new IConnection.CheckResult(2);
        cr.setObjectsInError(new Object[]{file, mofId});
        if (col == null) {
            col = new ArrayList<IConnection.CheckResult>();
        }
        col.add(cr);
    }
}

