/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence;

import com.sap.ip.mmr.persistence.IResourceChangeListener;
import java.util.Properties;

public class Workspace
implements Comparable {
    public static final String PROPERTY_USE_CACHE = "MMR_USE_CACHE";
    public static final String PARAMETER_PATH = "path";
    public static final String DEFAULT = "[default]";
    private String name = "";
    private String description = "";
    private boolean readOnly = false;
    private Properties properties = new Properties();
    private IResourceChangeListener resourceChangeListener;

    public Workspace(String name) {
        this.name = name;
    }

    public Object clone() throws CloneNotSupportedException {
        Workspace ws = new Workspace(this.name);
        ws.name = this.name;
        ws.description = this.description;
        ws.readOnly = this.readOnly;
        ws.properties = (Properties)this.properties.clone();
        return ws;
    }

    public String toString() {
        return "Workspace(name='" + this.name + "',description='" + this.description + "')\n";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.properties.getProperty(PARAMETER_PATH);
    }

    public void setPath(String path) {
        if (path != null) {
            this.properties.setProperty(PARAMETER_PATH, path);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object arg0) {
        boolean flag = false;
        if (arg0 instanceof Workspace) {
            Workspace ws = (Workspace)arg0;
            if (this.getName().compareTo(ws.getName()) == 0) {
                flag = true;
            }
        } else if (arg0 instanceof String && this.getName().compareTo((String)arg0) == 0) {
            flag = true;
        }
        return flag;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean b) {
        this.readOnly = b;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public int compareTo(Object arg0) {
        int res = 0;
        if (arg0 instanceof String) {
            res = this.getName().compareTo((String)arg0);
        } else if (arg0 instanceof Workspace) {
            res = this.getName().compareTo(((Workspace)arg0).getName());
        }
        if (res < -1) {
            res = -1;
        } else if (res > 1) {
            res = 1;
        }
        return res;
    }

    public IResourceChangeListener getResourceChangeListener() {
        return this.resourceChangeListener;
    }

    public void setResourceChangeListener(IResourceChangeListener listener) {
        this.resourceChangeListener = listener;
    }
}

