/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence;

import com.sap.ip.mmr.foundation.HashMapBidirectional;

public class Tlogo {
    private static final char DELIMITER = '.';
    private static HashMapBidirectional tlogoQn = new HashMapBidirectional();
    private String tlogo;
    private String objnm;
    private char objvers;

    public Tlogo(String tlogo, String objnm, char objvers) {
        this.tlogo = tlogo;
        this.objnm = objnm;
        this.setObjvers(objvers);
    }

    public static void putTlogoAndQualifiedName(String tlogo, String qualifiedName) {
        tlogoQn.put(tlogo, qualifiedName);
    }

    public static String convertQualifiedNameToTlogo(String qualifiedName) {
        return (String)tlogoQn.getBackward(qualifiedName);
    }

    public static String convertTlogoToQualifiedName(String tlogo) {
        return (String)tlogoQn.getForward(tlogo);
    }

    public static String getTlogoOfKey(String key) {
        int n;
        String tlogo = null;
        if (key != null && (n = key.indexOf(46)) > 0) {
            tlogo = key.substring(0, n);
        }
        return tlogo;
    }

    public static String getObjnmOfKey(String key) {
        String objnm = null;
        if (key != null) {
            int n = key.indexOf(46);
            int m = key.lastIndexOf(46);
            if (n > 0 && m > 0 && n + 1 < m) {
                objnm = key.substring(n + 1, m);
            }
        }
        return objnm;
    }

    public static char getObjversOfKey(String key) {
        int n;
        String objvers = null;
        if (key != null && (n = key.lastIndexOf(46)) > 0) {
            objvers = key.substring(n + 1);
        }
        return objvers.charAt(0);
    }

    public String getKey() {
        return this.tlogo + '.' + this.objnm + '.' + this.objvers;
    }

    public String toString() {
        return this.getKey();
    }

    public String getObjnm() {
        return this.objnm;
    }

    public String getTlogo() {
        return this.tlogo;
    }

    public void setObjnm(String objnm) {
        this.objnm = objnm;
    }

    public void setTlogo(String tlogo) {
        this.tlogo = tlogo;
    }

    public char getObjvers() {
        return this.objvers;
    }

    public void setObjvers(char objvers) {
        this.objvers = Character.toUpperCase(objvers);
    }
}

