/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IPersistence;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.ClassLoaderFactory;
import com.sap.ip.mmr.foundation.ClassLoaderMMR;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.ListInstanceInfo;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.PersistenceDefault;
import com.sap.ip.mmr.persistence.PersistenceJar;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.RefObject;

public class PersistenceJarMulti
extends PersistenceDefault {
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$persistence$PersistenceJarMulti == null ? (class$com$sap$ip$mmr$persistence$PersistenceJarMulti = PersistenceJarMulti.class$("com.sap.ip.mmr.persistence.PersistenceJarMulti")) : class$com$sap$ip$mmr$persistence$PersistenceJarMulti);
    private List pcs = new LinkedList();
    protected Set classPaths = new HashSet();
    static /* synthetic */ Class class$com$sap$ip$mmr$persistence$PersistenceJarMulti;

    public PersistenceJarMulti(IRepositoryServer repositoryServer) {
        super(repositoryServer);
        String method = "PersistenceJarMulti(IRepositoryServer repositoryServer)";
        location.entering("PersistenceJarMulti(IRepositoryServer repositoryServer)");
        this.determinePaths();
        location.exiting("PersistenceJarMulti(IRepositoryServer repositoryServer)");
    }

    private Iterator iteratorForConnection(IConnection con, int mofLayer) {
        return this.pcs.iterator();
    }

    private final void determinePaths() {
        String[] names = new String[]{"MMR_M2", "MMR_M2/IndexTypeInformation.properties", "MMR_M1", "MMR_M1/IndexTypeInformation.properties"};
        String method = "determinePaths()";
        location.entering("determinePaths()");
        ClassLoaderMMR cl = ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this.repositoryServer, null);
        for (int i = 0; i < names.length; ++i) {
            try {
                this.addPaths(this.classPaths, cl.getResources(names[i]));
                continue;
            }
            catch (IOException e) {
                Repository.category.errorT(location, e.toString());
            }
        }
        Iterator iter = this.classPaths.iterator();
        while (iter.hasNext()) {
            String jarPath = (String)iter.next();
            PersistenceJar pj = new PersistenceJar(this.repositoryServer, jarPath);
            this.pcs.add(pj);
        }
        location.exiting("determinePaths()");
    }

    protected void addPaths(Set set, Enumeration enumeration) {
        String method = "addPaths(Set set, Enumeration enum)";
        String PREFIX_FILE = "file:";
        while (enumeration.hasMoreElements()) {
            int idx2;
            File f;
            URL url_ = (URL)enumeration.nextElement();
            String url = url_.getPath();
            url = URLDecoder.decode(url);
            if ((url = url.replace('\\', '/')) == null) continue;
            int idx1 = 0;
            if (url.indexOf("file:") == 0) {
                idx1 = "file:".length();
            }
            if (!(f = new File(url = (idx2 = url.indexOf(33)) >= 0 ? url.substring(idx1, idx2) : url.substring(idx1))).exists()) {
                url = url.substring(1);
            }
            if ((f = new File(url)).exists()) {
                set.add(f.getAbsolutePath());
                continue;
            }
            RepositoryServer.getCategory().errorT(location, "addPaths(Set set, Enumeration enum)", MMRResourceAccessor.getInstance().getMessageText("3008"), new Object[]{url_.getPath()});
        }
    }

    public void addClassPath(IConnection connection, String path) {
        String[] names = new String[]{"MMR_M2", "MMR_M2/IndexTypeInformation.properties", "MMR_M1", "MMR_M1/IndexTypeInformation.properties"};
        String method = "addClassPath(IConnection connection, String path";
        if (!this.classPaths.contains(path)) {
            File f = new File(path);
            if (!f.exists()) {
                return;
            }
            JarFile jar = null;
            try {
                jar = new JarFile(f, true);
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(location, "addClassPath(IConnection connection, String path", e.toString());
                return;
            }
            if (jar == null) {
                return;
            }
            boolean found = false;
            for (int i = 0; i < names.length && !found; ++i) {
                ZipEntry ze = jar.getEntry(names[i]);
                if (ze == null) continue;
                found = true;
            }
            try {
                jar.close();
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(location, "addClassPath(IConnection connection, String path", e.toString());
                return;
            }
            if (!found) {
                return;
            }
            this.classPaths.add(path);
            PersistenceJar pj = new PersistenceJar(this.repositoryServer, path);
            this.pcs.add(pj);
        }
    }

    public void addClassPaths(IConnection connection, List paths) {
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            if (this.classPaths.contains(path)) continue;
            this.classPaths.add(path);
            PersistenceJar pj = new PersistenceJar(this.repositoryServer, path);
            this.pcs.add(pj);
        }
    }

    public void addLog(Log log) {
    }

    public void removeLog(Log log) {
    }

    public void connectionClosed(IConnection connection) throws BaseException, BaseRuntimeException {
        Iterator i = this.iteratorForConnection(connection, -1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            pfs.connectionClosed(connection);
        }
    }

    public Collection deleteM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.deleteM1(connection, objects);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        return colFailed;
    }

    public void deleteM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            pfs.deleteM1All(connection);
        }
    }

    public boolean deleteM1Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.deleteM1Assoc(connection, mofIds)) continue;
            res = false;
        }
        return res;
    }

    public Collection deleteM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.deleteM2(connection, modelElements);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        return colFailed;
    }

    public void deleteM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            pfs.deleteM2All(connection);
        }
    }

    public boolean deleteM2Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.deleteM2Assoc(connection, mofIds)) continue;
            res = false;
        }
        return res;
    }

    public void finalizer() throws BaseException, BaseRuntimeException {
        Iterator i = this.pcs.iterator();
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            pfs.finalizer();
        }
    }

    public Hierarchy getHierarchyM0(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext() && hier == null) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Hierarchy h = pfs.getHierarchyM0(connection, mofId);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Hierarchy getHierarchyM0ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext() && hier == null) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Hierarchy h = pfs.getHierarchyM0ByName(connection, name);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Hierarchy getHierarchyM1(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext() && hier == null) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Hierarchy h = pfs.getHierarchyM1(connection, mofId);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Hierarchy getHierarchyM1ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext() && hier == null) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Hierarchy h = pfs.getHierarchyM1ByName(connection, name);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Set getWorkspaces() {
        HashSet set = new HashSet();
        Iterator iter = this.pcs.iterator();
        while (iter.hasNext()) {
            PersistenceJar p = (PersistenceJar)iter.next();
            Set s = p.getWorkspaces();
            if (s == null) continue;
            set.addAll(s);
        }
        return set;
    }

    public List getWorkspacesAvailableM1(IConnection connection) {
        LinkedList list = new LinkedList();
        Iterator i = this.iteratorForConnection(connection, -1);
        while (i.hasNext()) {
            PersistenceJar p = (PersistenceJar)i.next();
            List l = p.getWorkspacesAvailableM1(connection);
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    public List getWorkspacesAvailableM2(IConnection connection) {
        LinkedList list = new LinkedList();
        Iterator i = this.iteratorForConnection(connection, -1);
        while (i.hasNext()) {
            PersistenceJar p = (PersistenceJar)i.next();
            List l = p.getWorkspacesAvailableM2(connection);
            if (l == null) continue;
            list.addAll(l);
        }
        return list;
    }

    public boolean initialize() throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.pcs.iterator();
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.initialize()) continue;
            flag = false;
        }
        return flag;
    }

    public Collection insertM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.insertM1(connection, objects);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        return colFailed;
    }

    public boolean insertM1Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.insertM1Assoc(connection, aoos)) continue;
            res = false;
        }
        return res;
    }

    public Collection insertM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.insertM2(connection, modelElements);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        return colFailed;
    }

    public boolean insertM2Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.insertM2Assoc(connection, aoos)) continue;
            res = false;
        }
        return res;
    }

    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        LinkedList list = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            List l = pfs.queryM1(connection, qualifiedNameOfType, filters, includeSubTypes);
            if (l == null || l.size() <= 0) continue;
            if (list == null) {
                list = new LinkedList();
            }
            list.addAll(l);
        }
        return list;
    }

    public List queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        LinkedList list = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            List l = pfs.queryM2(connection, qualifiedNameOfType, filters, includeSubTypes);
            if (l == null || l.size() <= 0) continue;
            if (list == null) {
                list = new LinkedList();
            }
            list.addAll(l);
        }
        return list;
    }

    public Collection resolveFilesM1(IConnection connection, RefObject rbo) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.resolveFilesM1(connection, rbo);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public Collection resolveFilesM2(IConnection connection, ModelElement modelElement) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.resolveFilesM2(connection, modelElement);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public ModelElement resolveQualifiedNameM2(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        ModelElement me = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext() && me == null) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            try {
                ModelElement me_ = pfs.resolveQualifiedNameM2(connection, qualifiedName);
                if (me_ == null) continue;
                me = me_;
            }
            catch (BaseException e) {
                me = null;
            }
            catch (BaseRuntimeException e) {
                me = null;
            }
        }
        return me;
    }

    public Collection selectM1(IConnection connection, Collection mofIdsOrObjects, boolean forUpdate) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.selectM1(connection, mofIdsOrObjects, forUpdate);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public Collection selectM1AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.selectM1AllOfClass(connection, qualifiedName);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public ListInstanceInfo selectM1InstanceInfos(IConnection connection, List qualifiedName, String pattern) throws BaseException, BaseRuntimeException {
        ListInstanceInfo col = new ListInstanceInfo();
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            ListInstanceInfo c = pfs.selectM1InstanceInfos(connection, qualifiedName, pattern);
            if (c == null || c.size() <= 0) continue;
            col.addAll(c);
        }
        return col;
    }

    public Collection selectM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.selectM1All(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public AssociationsOfObject selectM1Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        AssociationsOfObject aoo = null;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext() && aoo == null) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            AssociationsOfObject a = pfs.selectM1Assoc(connection, associationId, mofId);
            if (a == null) continue;
            aoo = a;
        }
        return aoo;
    }

    public Collection selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.selectM2(connection, mofIdsOrModelElements, forUpdate);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public Collection selectM2AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.selectM2AllOfClass(connection, qualifiedName);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public Collection selectM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.selectM2All(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public AssociationsOfObject selectM2Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        AssociationsOfObject aoo = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext() && aoo == null) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            AssociationsOfObject a = pfs.selectM2Assoc(connection, associationId, mofId);
            if (a == null) continue;
            aoo = a;
        }
        return aoo;
    }

    public Collection selectM2TopLevelPackages(IConnection connection) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            Collection c = pfs.selectM2TopLevelPackages(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public boolean transactionBegin(IConnection connection) throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.iteratorForConnection(connection, -1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.transactionBegin(connection)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean transactionCommit(IConnection connection) throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.iteratorForConnection(connection, -1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.transactionCommit(connection)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean transactionRollback(IConnection connection) throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.iteratorForConnection(connection, -1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.transactionRollback(connection)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean writeHierarchyM0(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.writeHierarchyM0(connection, hierarchy)) continue;
            res = false;
        }
        return res;
    }

    public boolean writeHierarchyM1(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1);
        while (i.hasNext()) {
            PersistenceJar pfs = (PersistenceJar)i.next();
            if (pfs.writeHierarchyM1(connection, hierarchy)) continue;
            res = false;
        }
        return res;
    }

    public Collection getWorkspaceAttributeDescriptions() {
        LinkedList col = new LinkedList();
        Iterator i = this.pcs.iterator();
        while (i.hasNext()) {
            IPersistence pc = (IPersistence)i.next();
            Collection c = pc.getWorkspaceAttributeDescriptions();
            if (c == null || c.size() <= 0) continue;
            col.addAll(c);
        }
        return col;
    }

    public Collection checkPersistence(IConnection connection) {
        ArrayList col = null;
        Iterator i = this.pcs.iterator();
        while (i.hasNext()) {
            IPersistence pc = (IPersistence)i.next();
            Collection c = pc.checkPersistence(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new ArrayList();
            }
            col.addAll(c);
        }
        return col;
    }

    public boolean registerWorkspace(Workspace workspace, int mofLayer) {
        if (!this.classPaths.contains(workspace.getPath())) {
            PersistenceJar pj = new PersistenceJar(this.repositoryServer, workspace.getPath());
            this.pcs.add(pj);
        }
        return true;
    }

    public void workspaceContentHasChanged(IConnection connection, Workspace workspace) {
        Iterator i = this.pcs.iterator();
        while (i.hasNext()) {
            IPersistence pc = (IPersistence)i.next();
            pc.workspaceContentHasChanged(connection, workspace);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

