/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.ClassLoaderFactory;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.persistence.PersistenceFS;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.AttributesValues;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;

public class PersistenceJar
extends PersistenceFS {
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$persistence$PersistenceJar == null ? (class$com$sap$ip$mmr$persistence$PersistenceJar = PersistenceJar.class$("com.sap.ip.mmr.persistence.PersistenceJar")) : class$com$sap$ip$mmr$persistence$PersistenceJar);
    static /* synthetic */ Class class$com$sap$ip$mmr$persistence$PersistenceJar;

    public PersistenceJar(IRepositoryServer repositoryServer, String jarPath) {
        super(repositoryServer, null);
        String method = "PersistenceJar(IRepositoryServer repositoryServer, String jarPath)";
        location.entering("PersistenceJar(IRepositoryServer repositoryServer, String jarPath)");
        this.workspace = new Workspace("JAR " + jarPath);
        this.workspace.setPath(jarPath);
        this.workspace.setDescription("Workspace used to read the Jar '" + jarPath + "'");
        this.workspace.setReadOnly(true);
        this.initCache();
        location.exiting("PersistenceJar(IRepositoryServer repositoryServer, String jarPath)");
    }

    public void addLog(Log log) {
    }

    public void removeLog(Log log) {
    }

    public Collection insertM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        return null;
    }

    public boolean writeModelElement(IConnection connection, IModelElement me) {
        return true;
    }

    public boolean writeModelElement(IConnection connection, IModelElement me, boolean serializedOnly) {
        this.persistenceFSCache.writeInstance(connection, this.workspace, (RefBaseObject)me);
        return true;
    }

    public boolean writeRefObject(IConnection connection, RefObject ro) {
        this.persistenceFSCache.writeInstance(connection, this.workspace, (RefBaseObject)ro);
        return true;
    }

    public boolean writeRefObject(IConnection connection, RefObject ro, boolean serializedOnly) {
        return true;
    }

    public Collection deleteM2(IConnection connection, Collection modelElements) {
        return null;
    }

    public Collection selectM2AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        List mofIds = this.selectM2AllOfClassMofIds(connection, qualifiedName);
        return this.selectM2(connection, mofIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List selectM2AllOfClassMofIds(IConnection connection, List qualifiedName) {
        block12: {
            method = "selectM2AllOfClassMofIds(IConnection connection,List qualifiedName)";
            PersistenceJar.location.entering("selectM2AllOfClassMofIds(IConnection connection,List qualifiedName)");
            mofIds = new LinkedList<String>();
            if (qualifiedName == null) {
                return mofIds;
            }
            pathPrefix = "MMR_M2/" + Utilities.getUtilities().encodeQualifiedName(qualifiedName).replace('.', '/');
            f = new File(this.workspace.getPath());
            if (f.exists() == false) return mofIds;
            if (!f.isFile()) {
                return mofIds;
            }
            jar = null;
            try {
                jar = new JarFile(f, true);
                enum = jar.entries();
                while (enum.hasMoreElements()) {
                    je = enum.nextElement();
                    if (je.getName().indexOf(pathPrefix) != 0 || (idx = (name = je.getName().substring(pathPrefix.length() + 1)).indexOf(".xml")) <= 0 || (idx1 = (mofId = name.substring(0, idx)).indexOf("_I")) <= 0) continue;
                    mofIds.add(mofId.substring(0, idx1));
                }
                var15_15 = null;
                if (jar == null) break block12;
                ** GOTO lbl50
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2AllOfClassMofIds(IConnection connection,List qualifiedName)", MMRResourceAccessor.getInstance().getMessageText(connection, "3006"), new Object[]{this.workspace.getPath()});
                var15_16 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2AllOfClassMofIds(IConnection connection,List qualifiedName)", e1.toString());
                    }
                }
                break block12;
            }
            {
                catch (Throwable var14_21) {
                    var15_17 = null;
                    if (jar == null) throw var14_21;
                    ** try [egrp 2[TRYBLOCK] [4 : 290->298)] { 
lbl44:
                    // 1 sources

                    jar.close();
                    throw var14_21;
lbl46:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2AllOfClassMofIds(IConnection connection,List qualifiedName)", e1.toString());
                    }
                    throw var14_21;
                }
lbl50:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 290->298)] { 
lbl51:
                // 1 sources

                jar.close();
lbl53:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2AllOfClassMofIds(IConnection connection,List qualifiedName)", e1.toString());
            }
        }
        PersistenceJar.location.exiting();
        return mofIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Collection selectM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        block12: {
            method = "selectM2All(IConnection connection)";
            PersistenceJar.location.entering("selectM2All(IConnection connection)");
            mofIds = new LinkedList<E>();
            f = new File(this.workspace.getPath());
            if (!f.exists() || !f.isFile()) {
                return mofIds;
            }
            jar = null;
            try {
                jar = new JarFile(f, true);
                this.findMofIdsRecursive(jar, "MMR_M2/", this.typeInformationM2, mofIds);
                var8_6 = null;
                ** if (jar == null) goto lbl-1000
            }
            catch (Throwable var7_13) {
                var8_8 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2All(IConnection connection)", e1.toString());
                    }
                }
                throw var7_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    jar.close();
                }
                catch (IOException e1) {
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2All(IConnection connection)", e1.toString());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException e) {
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2All(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3006"), new Object[]{this.workspace.getPath()});
                    var8_7 = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM2All(IConnection connection)", e1.toString());
                        }
                    }
                }
            }
        }
        PersistenceJar.location.exiting();
        return this.selectM2(connection, mofIds, false);
    }

    protected byte[] getFileContent(IConnection connection, String path) {
        String method = "getFileContent(String path)";
        location.entering("getFileContent(String path)");
        byte[] data = null;
        InputStream is = ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this.repositoryServer, connection).getResourceAsStream(path);
        ZipFile jar = null;
        if (is == null) {
            try {
                ZipEntry ze;
                jar = new JarFile(this.workspace.getPath());
                if (jar != null && (ze = ((JarFile)jar).getEntry(path)) != null) {
                    is = ((JarFile)jar).getInputStream(ze);
                    this.persistenceFSCache.getTimeStamps(connection, this.workspace).put(path.replace('\\', '/'), String.valueOf(ze.getTime()));
                }
            }
            catch (IOException e) {
                is = null;
            }
        }
        if (is != null) {
            data = this.getBytesOfInputStream(is);
        }
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException e1) {
                RepositoryServer.getCategory().errorT(location, "getFileContent(String path)", e1.toString());
            }
        }
        location.exiting();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] getBytesOfInputStream(InputStream is) {
        byte[] bytes;
        block9: {
            String method = "getBytesOfInputStream(InputStream is)";
            location.entering("getBytesOfInputStream(InputStream is)");
            bytes = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int size = 4096;
            byte[] data = new byte[4096];
            int n = 0;
            while (n >= 0) {
                n = is.read(data, 0, 4096);
                if (n <= 0) continue;
                baos.write(data, 0, n);
            }
            bytes = baos.toByteArray();
            Object var9_9 = null;
            try {
                is.close();
                baos.close();
            }
            catch (IOException e1) {
                Repository.category.errorT(location, e1.toString());
            }
            break block9;
            {
                catch (IOException e) {
                    bytes = null;
                    Repository.category.errorT(location, "getBytesOfInputStream(InputStream is)", e.toString());
                    Object var9_10 = null;
                    try {
                        is.close();
                        baos.close();
                    }
                    catch (IOException e1) {
                        Repository.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    is.close();
                    baos.close();
                }
                catch (IOException e1) {
                    Repository.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        location.exiting();
        return bytes;
    }

    public boolean insertM2Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        String method = "insertM2Assoc(IConnection connection, Map aoos)";
        location.entering("insertM2Assoc(IConnection connection, Map aoos)");
        Iterator iter = aoos.values().iterator();
        while (iter.hasNext()) {
            AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
            Collection c = new LinkedList<String>();
            c.add(aoo.getMofId());
            try {
                c = this.repositoryServer.selectM2(connection, c, false);
            }
            catch (BaseRuntimeException e) {
                RepositoryServer.getCategory().errorT(location, "insertM2Assoc(IConnection connection, Map aoos)", e.toString());
            }
            catch (BaseException e) {
                RepositoryServer.getCategory().errorT(location, "insertM2Assoc(IConnection connection, Map aoos)", e.toString());
            }
            if (c.size() < 1) continue;
            ModelElement me = (ModelElement)c.iterator().next();
            this.persistenceFSCache.writeAoo(connection, this.workspace, this.createFileNameAssociations(this.getStorageDir((RefBaseObject)me), aoo.getMofId()), aoo);
        }
        location.exiting();
        return true;
    }

    public Collection insertM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        return null;
    }

    public Collection deleteM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        return null;
    }

    public Collection selectM1AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        List mofIds = this.selectM1AllOfClassMofIds(connection, qualifiedName);
        return this.selectM1(connection, mofIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List selectM1AllOfClassMofIds(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        block11: {
            method = "selectM1AllOfClassMofIds(IConnection connection,List qualifiedName)";
            PersistenceJar.location.entering("selectM1AllOfClassMofIds(IConnection connection,List qualifiedName)");
            mofIds = new LinkedList<String>();
            pathPrefix = "MMR_M1/" + Utilities.getUtilities().encodeQualifiedName(qualifiedName).replace('.', '/') + '/';
            f = new File(this.workspace.getPath());
            if (f.exists() == false) return mofIds;
            if (!f.isFile()) {
                return mofIds;
            }
            jar = null;
            try {
                jar = new JarFile(f, true);
                enum = jar.entries();
                while (enum.hasMoreElements()) {
                    je = enum.nextElement();
                    if (je.getName().indexOf(pathPrefix) != 0 || (idx = (name = je.getName().substring(pathPrefix.length())).indexOf(".xml")) <= 0 || (idx1 = (mofId = name.substring(0, idx)).indexOf("_I")) <= 0) continue;
                    mofIds.add(mofId.substring(0, idx1));
                }
                var15_15 = null;
                if (jar == null) break block11;
                ** GOTO lbl48
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1AllOfClassMofIds(IConnection connection,List qualifiedName)", MMRResourceAccessor.getInstance().getMessageText(connection, "3006"), new Object[]{this.workspace.getPath()});
                var15_16 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1AllOfClassMofIds(IConnection connection,List qualifiedName)", e1.toString());
                    }
                }
                break block11;
            }
            {
                catch (Throwable var14_21) {
                    var15_17 = null;
                    if (jar == null) throw var14_21;
                    ** try [egrp 2[TRYBLOCK] [4 : 286->294)] { 
lbl42:
                    // 1 sources

                    jar.close();
                    throw var14_21;
lbl44:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1AllOfClassMofIds(IConnection connection,List qualifiedName)", e1.toString());
                    }
                    throw var14_21;
                }
lbl48:
                // 1 sources

                ** try [egrp 2[TRYBLOCK] [4 : 286->294)] { 
lbl49:
                // 1 sources

                jar.close();
lbl51:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1AllOfClassMofIds(IConnection connection,List qualifiedName)", e1.toString());
            }
        }
        PersistenceJar.location.exiting();
        return mofIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Collection selectM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        block12: {
            method = "selectM1All(IConnection connection)";
            PersistenceJar.location.entering("selectM1All(IConnection connection)");
            mofIds = new LinkedList<E>();
            f = new File(this.workspace.getPath());
            if (!f.exists() || !f.isFile()) {
                return mofIds;
            }
            jar = null;
            try {
                jar = new JarFile(f, true);
                this.findMofIdsRecursive(jar, "MMR_M1/", this.typeInformationM1, mofIds);
                var8_6 = null;
                ** if (jar == null) goto lbl-1000
            }
            catch (Throwable var7_13) {
                var8_8 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1All(IConnection connection)", e1.toString());
                    }
                }
                throw var7_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    jar.close();
                }
                catch (IOException e1) {
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1All(IConnection connection)", e1.toString());
                }
            }
lbl-1000:
            // 2 sources

            {
                break block12;
                catch (IOException e) {
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1All(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3006"), new Object[]{this.workspace.getPath()});
                    var8_7 = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.getCategory().errorT(PersistenceJar.location, "selectM1All(IConnection connection)", e1.toString());
                        }
                    }
                }
            }
        }
        PersistenceJar.location.exiting();
        return this.selectM1(connection, mofIds, false);
    }

    public boolean insertM1Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        String method = "insertM1Assoc(IConnection connection, Map aoos)";
        location.entering("insertM1Assoc(IConnection connection, Map aoos)");
        Iterator iter = aoos.values().iterator();
        while (iter.hasNext()) {
            AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
            Collection c = new LinkedList<String>();
            c.add(aoo.getMofId());
            try {
                c = this.repositoryServer.selectM1(connection, c, false);
            }
            catch (BaseRuntimeException e) {
                RepositoryServer.getCategory().errorT(location, "insertM1Assoc(IConnection connection, Map aoos)", e.toString());
            }
            catch (BaseException e) {
                RepositoryServer.getCategory().errorT(location, "insertM1Assoc(IConnection connection, Map aoos)", e.toString());
            }
            if (c.size() < 1) continue;
            RefObject ro = (RefObject)c.iterator().next();
            this.persistenceFSCache.writeAoo(connection, this.workspace, this.createFileNameAssociations(this.getStorageDir((RefBaseObject)ro), aoo.getMofId()), aoo);
        }
        location.exiting();
        return true;
    }

    public void deleteM2All(IConnection connection) throws BaseException, BaseRuntimeException {
    }

    public void deleteM1All(IConnection connection) throws BaseException, BaseRuntimeException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void collectQualifiedNamesM2(IConnection connection) {
        block16: {
            method = "collectQualifiedNamesM2(IConnection connection)";
            PersistenceJar.location.entering("collectQualifiedNamesM2(IConnection connection)");
            if (this.qualifiedNamesM2.size() > 0) break block16;
            f = new File(this.workspace.getPath());
            if (f.exists() == false) return;
            if (!f.isFile()) {
                return;
            }
            jar = null;
            try {
                jar = new JarFile(f, true);
                n = 0;
                enum = jar.entries();
                while (enum.hasMoreElements() && n == 0) {
                    je = enum.nextElement();
                    if (je.isDirectory() || je.getName().indexOf("MMR_M2") != 0) continue;
                    ++n;
                }
                if (n > 0) {
                    je = jar.getJarEntry(this.getFilenameQualifiedNames(connection, 2));
                    if (je == null) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectQualifiedNamesM2(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3007"), new Object[]{this.getFilenameQualifiedNames(connection, 2), jar.getName()});
                    } else {
                        try {
                            bis = new BufferedInputStream(jar.getInputStream(je));
                            this.qualifiedNamesM2.load(bis);
                            bis.close();
                        }
                        catch (IOException e) {
                            RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectQualifiedNamesM2(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3009"), new Object[]{je, jar});
                            e.printStackTrace(System.err);
                        }
                    }
                }
                var10_11 = null;
                if (jar == null) break block16;
                ** GOTO lbl63
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectQualifiedNamesM2(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3006"), new Object[]{this.workspace.getPath()});
                var10_12 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectQualifiedNamesM2(IConnection connection)", e1.toString());
                    }
                }
                break block16;
            }
            {
                catch (Throwable var9_17) {
                    var10_13 = null;
                    if (jar == null) throw var9_17;
                    ** try [egrp 3[TRYBLOCK] [5 : 340->348)] { 
lbl57:
                    // 1 sources

                    jar.close();
                    throw var9_17;
lbl59:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectQualifiedNamesM2(IConnection connection)", e1.toString());
                    }
                    throw var9_17;
                }
lbl63:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [5 : 340->348)] { 
lbl64:
                // 1 sources

                jar.close();
lbl66:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectQualifiedNamesM2(IConnection connection)", e1.toString());
            }
        }
        PersistenceJar.location.exiting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map collectTypeInformationM2(IConnection connection) {
        block14: {
            method = "collectTypeInformationM2(IConnection connection)";
            PersistenceJar.location.entering("collectTypeInformationM2(IConnection connection)");
            if (this.typeInformationM2.size() > 0) break block14;
            f = new File(this.workspace.getPath());
            if (f.exists() == false) return this.typeInformationM2;
            if (!f.isFile()) {
                return this.typeInformationM2;
            }
            jar = null;
            try {
                jar = new JarFile(f, true);
                n = 0;
                enum = jar.entries();
                while (enum.hasMoreElements() && n == 0) {
                    je = enum.nextElement();
                    if (je.isDirectory() || je.getName().indexOf("MMR_M2") != 0) continue;
                    ++n;
                }
                if (n > 0 && (je = jar.getJarEntry(this.getFilenameTypeInformation(connection, 2))) != null) {
                    try {
                        bis = new BufferedInputStream(jar.getInputStream(je));
                        this.typeInformationM2.load(bis);
                        bis.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM2(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3009"), new Object[]{je, jar});
                    }
                }
                var10_11 = null;
                if (jar == null) break block14;
                ** GOTO lbl57
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM2(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3006"), new Object[]{this.workspace.getPath()});
                var10_12 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM2(IConnection connection)", e1.toString());
                    }
                }
                break block14;
            }
            {
                catch (Throwable var9_17) {
                    var10_13 = null;
                    if (jar == null) throw var9_17;
                    ** try [egrp 3[TRYBLOCK] [5 : 291->299)] { 
lbl51:
                    // 1 sources

                    jar.close();
                    throw var9_17;
lbl53:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM2(IConnection connection)", e1.toString());
                    }
                    throw var9_17;
                }
lbl57:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [5 : 291->299)] { 
lbl58:
                // 1 sources

                jar.close();
lbl60:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM2(IConnection connection)", e1.toString());
            }
        }
        PersistenceJar.location.exiting();
        return this.typeInformationM2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map collectTypeInformationM1(IConnection connection) {
        block14: {
            method = "collectTypeInformationM1(IConnection connection)";
            PersistenceJar.location.entering("collectTypeInformationM1(IConnection connection)");
            if (this.typeInformationM1.size() > 0) break block14;
            f = new File(this.workspace.getPath());
            if (f.exists() == false) return this.typeInformationM1;
            if (!f.isFile()) {
                return this.typeInformationM1;
            }
            jar = null;
            try {
                jar = new JarFile(f, true);
                n = 0;
                enum = jar.entries();
                while (enum.hasMoreElements() && n == 0) {
                    je = enum.nextElement();
                    if (je.isDirectory() || je.getName().indexOf("MMR_M1") != 0) continue;
                    ++n;
                }
                if (n > 0 && (je = jar.getJarEntry(this.getFilenameTypeInformation(connection, 1))) != null) {
                    try {
                        bis = new BufferedInputStream(jar.getInputStream(je));
                        this.typeInformationM1.load(bis);
                        bis.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM1(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3009"), new Object[]{je, jar});
                    }
                }
                var10_11 = null;
                if (jar == null) break block14;
                ** GOTO lbl57
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM1(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3006"), new Object[]{this.typeInformationM1});
                var10_12 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM1(IConnection connection)", e1.toString());
                    }
                }
                break block14;
            }
            {
                catch (Throwable var9_17) {
                    var10_13 = null;
                    if (jar == null) throw var9_17;
                    ** try [egrp 3[TRYBLOCK] [5 : 288->296)] { 
lbl51:
                    // 1 sources

                    jar.close();
                    throw var9_17;
lbl53:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM1(IConnection connection)", e1.toString());
                    }
                    throw var9_17;
                }
lbl57:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [5 : 288->296)] { 
lbl58:
                // 1 sources

                jar.close();
lbl60:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "collectTypeInformationM1(IConnection connection)", e1.toString());
            }
        }
        PersistenceJar.location.exiting();
        return this.typeInformationM1;
    }

    protected String getPath(Map map, String workspacePath, String mofId, int pathType) {
        String method = "getPath(...)";
        location.entering("getPath(...)");
        String dir = null;
        if (map == this.typeInformationM2) {
            dir = "MMR_M2";
        } else if (map == this.typeInformationM1) {
            dir = "MMR_M1";
        } else {
            return null;
        }
        String type = (String)map.get(mofId);
        if (type == null) {
            return null;
        }
        String suffix = null;
        String suffixType = ".xml";
        switch (pathType) {
            case 1: {
                suffix = "_I";
                break;
            }
            case 2: {
                suffix = "_A";
                break;
            }
            case 3: {
                suffix = "_D";
                break;
            }
            default: {
                suffix = "_I";
            }
        }
        location.exiting();
        return dir + "/" + type.replace('.', '/') + "/" + mofId + suffix + suffixType;
    }

    protected void findMofIdsRecursive(JarFile jar, String dir, Map map, LinkedList list) {
        String method = "findMofIdsRecursive(JarFile jar ...)";
        location.entering("findMofIdsRecursive(JarFile jar ...)");
        String dirSearch = "MMR_M2";
        if (map == this.typeInformationM1) {
            dirSearch = "MMR_M1";
        }
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            String name;
            int idx2;
            JarEntry je = enumeration.nextElement();
            if (je.getName().indexOf(dir) != 0 || (idx2 = (name = je.getName()).lastIndexOf(".xml")) <= 0 || (idx2 = name.lastIndexOf("_I")) <= 0) continue;
            String path = je.getName().replace('\\', '/');
            int idx1 = path.lastIndexOf(47);
            String mofId = name.substring(idx1 + 1, idx2);
            int idx0 = path.indexOf(dirSearch) + dirSearch.length() + 1;
            if (idx0 < 0 || idx1 < 0 || idx0 >= idx1) continue;
            String type = path.substring(idx0, idx1).replace('/', '.');
            map.put(mofId, type);
            list.add(mofId);
        }
        location.exiting();
    }

    public static void getInstancesDeleted(JarFile jar, Collection mofIdsDeletedM2, Collection mofIdsDeletedM1) {
        String method = "getInstancesDeleted(JarFile jar ...)";
        location.entering("getInstancesDeleted(JarFile jar ...)");
        Enumeration<JarEntry> enumeration = jar.entries();
        while (enumeration.hasMoreElements()) {
            String name;
            int idx2;
            JarEntry je = enumeration.nextElement();
            int idxDirM2 = je.getName().indexOf("MMR_M2");
            int idxDirM1 = je.getName().indexOf("MMR_M1");
            if (idxDirM1 != 0 && idxDirM2 != 0 || (idx2 = (name = je.getName()).lastIndexOf(".xml")) <= 0 || (idx2 = name.lastIndexOf("_D")) <= 0) continue;
            String path = je.getName().replace('\\', '/');
            int idx1 = path.lastIndexOf(47);
            String mofId = name.substring(idx1 + 1, idx2);
            if (idxDirM1 == 0) {
                mofIdsDeletedM1.add(mofId);
                continue;
            }
            if (idxDirM2 != 0) continue;
            mofIdsDeletedM2.add(mofId);
        }
        location.exiting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttributesValues getAttributesValuesM1(IConnection connection) {
        block13: {
            method = "getAttributesValuesM1(IConnection connection)";
            PersistenceJar.location.entering("getAttributesValuesM1(IConnection connection)");
            if (this.attributesValuesM1 != null) break block13;
            this.attributesValuesM1 = new AttributesValues();
            f = new File(this.workspace.getPath());
            jar = null;
            try {
                jar = new JarFile(f, true);
                ze = jar.getEntry(this.getFilenameSearch(connection, 1));
                if (ze != null) {
                    try {
                        data = this.getBytesOfInputStream(jar.getInputStream(ze));
                        if (data != null) {
                            this.attributesValuesM1.xmlImport(data);
                        }
                    }
                    catch (IOException e) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM1(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3009"), new Object[]{ze, jar});
                    }
                }
                var8_9 = null;
                if (jar == null) break block13;
                ** GOTO lbl47
            }
            catch (IOException e) {
                var8_10 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM1(IConnection connection)", e1.toString());
                    }
                }
                break block13;
            }
            {
                catch (Throwable var7_15) {
                    var8_11 = null;
                    if (jar == null) throw var7_15;
                    ** try [egrp 3[TRYBLOCK] [5 : 173->181)] { 
lbl41:
                    // 1 sources

                    jar.close();
                    throw var7_15;
lbl43:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM1(IConnection connection)", e1.toString());
                    }
                    throw var7_15;
                }
lbl47:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [5 : 173->181)] { 
lbl48:
                // 1 sources

                jar.close();
lbl50:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM1(IConnection connection)", e1.toString());
            }
        }
        PersistenceJar.location.exiting();
        return this.attributesValuesM1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected AttributesValues getAttributesValuesM2(IConnection connection) {
        block13: {
            method = "getAttributesValuesM2(IConnection connection)";
            PersistenceJar.location.entering("getAttributesValuesM2(IConnection connection)");
            if (this.attributesValuesM2 != null) break block13;
            this.attributesValuesM2 = new AttributesValues();
            f = new File(this.workspace.getPath());
            jar = null;
            try {
                jar = new JarFile(f, true);
                ze = jar.getEntry(this.getFilenameSearch(connection, 2));
                if (ze != null) {
                    try {
                        data = this.getBytesOfInputStream(jar.getInputStream(ze));
                        if (data != null) {
                            this.attributesValuesM2.xmlImport(data);
                        }
                    }
                    catch (IOException e) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM2(IConnection connection)", MMRResourceAccessor.getInstance().getMessageText(connection, "3009"), new Object[]{ze, jar});
                    }
                }
                var8_9 = null;
                if (jar == null) break block13;
                ** GOTO lbl47
            }
            catch (IOException e) {
                var8_10 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM2(IConnection connection)", e1.toString());
                    }
                }
                break block13;
            }
            {
                catch (Throwable var7_15) {
                    var8_11 = null;
                    if (jar == null) throw var7_15;
                    ** try [egrp 3[TRYBLOCK] [5 : 173->181)] { 
lbl41:
                    // 1 sources

                    jar.close();
                    throw var7_15;
lbl43:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM2(IConnection connection)", e1.toString());
                    }
                    throw var7_15;
                }
lbl47:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [5 : 173->181)] { 
lbl48:
                // 1 sources

                jar.close();
lbl50:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "getAttributesValuesM2(IConnection connection)", e1.toString());
            }
        }
        PersistenceJar.location.exiting();
        return this.attributesValuesM2;
    }

    public void connectionClosed(IConnection connection) throws BaseException, BaseRuntimeException {
        this.transactionCommit(null);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void finalizer() throws BaseException, BaseRuntimeException {
    }

    public boolean transactionBegin(IConnection connection) throws BaseException, BaseRuntimeException {
        return true;
    }

    public boolean transactionCommit(IConnection connection) throws BaseException, BaseRuntimeException {
        return true;
    }

    public boolean transactionRollback(IConnection connection) throws BaseException, BaseRuntimeException {
        return true;
    }

    public void updateQualifiedNames(IConnection connection, String sourceDir, String destDir) {
    }

    public void updateSearchData(IConnection connection, String sourceDir, String destDir) {
    }

    public void updateTypeInformation(IConnection connection, String sourceDir, String destDir) {
    }

    protected boolean writeHierarchy(IConnection connection, int mofLayer, Hierarchy hierarchy) {
        return true;
    }

    public boolean writeHierarchyM0(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        return true;
    }

    public boolean writeHierarchyM1(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        return true;
    }

    public List getWorkspacesAvailableM1(IConnection connection) {
        return this.getWorkspacesAvailable(connection);
    }

    public List getWorkspacesAvailableM2(IConnection connection) {
        return this.getWorkspacesAvailable(connection);
    }

    private List getWorkspacesAvailable(IConnection connection) {
        LinkedList<Workspace> workspacesAvailable = new LinkedList<Workspace>();
        workspacesAvailable.add(this.workspace);
        return workspacesAvailable;
    }

    public boolean deregisterWorkspace(Workspace workspace, int mofLayer) {
        return true;
    }

    public boolean registerWorkspace(Workspace workspace, int mofLayer) {
        return false;
    }

    public Collection getWorkspaceAttributeDescriptions() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection checkPersistence(IConnection connection) {
        block66: {
            block65: {
                method = "checkPersistence()";
                col = null;
                f = new File(this.workspace.getPath());
                if (!f.exists()) {
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "1004"), new Object[]{this.workspace.getPath(), "checkPersistence()"});
                    return col;
                }
                hasM2Content = false;
                hasM1Content = false;
                indexM1TypeInformation = null;
                indexM2TypeInformation = null;
                indexM2QualifiedName = null;
                avM1 = null;
                avM2 = null;
                jar = null;
                try {
                    jar = new JarFile(f, true);
                    enum = jar.entries();
                    while (enum.hasMoreElements()) {
                        je = enum.nextElement();
                        if (je.isDirectory()) continue;
                        dirName = this.getDirectoryOfJarEntry(je.getName());
                        if (dirName == null) {
                            dirName = "";
                        }
                        if (je.getName().indexOf("IndexQualifiedName.properties") > 0) {
                            if (dirName.compareTo("MMR_M2") != 0) continue;
                            if (indexM2QualifiedName == null) {
                                indexM2QualifiedName = new Properties();
                            }
                            prop = new Properties();
                            prop.load(new BufferedInputStream(jar.getInputStream(je)));
                            indexM2QualifiedName.putAll(prop);
                            hasM2Content = true;
                            continue;
                        }
                        if (je.getName().indexOf("IndexSearch.xml") > 0) {
                            if (dirName.compareTo("MMR_M1") == 0) {
                                if (avM1 == null) {
                                    avM1 = new AttributesValues();
                                }
                                avM1.xmlImport(this.getBytesOfInputStream(jar.getInputStream(je)));
                                hasM1Content = true;
                                continue;
                            }
                            if (dirName.compareTo("MMR_M2") != 0) continue;
                            if (avM2 == null) {
                                avM2 = new AttributesValues();
                            }
                            avM2.xmlImport(this.getBytesOfInputStream(jar.getInputStream(je)));
                            hasM2Content = true;
                            continue;
                        }
                        if (je.getName().indexOf("IndexTypeInformation.properties") > 0) {
                            if (dirName.compareTo("MMR_M1") == 0) {
                                if (indexM1TypeInformation == null) {
                                    indexM1TypeInformation = new Properties();
                                }
                                indexM1TypeInformation.load(new BufferedInputStream(jar.getInputStream(je)));
                                hasM1Content = true;
                                continue;
                            }
                            if (dirName.compareTo("MMR_M2") != 0) continue;
                            if (indexM2TypeInformation == null) {
                                indexM2TypeInformation = new Properties();
                            }
                            indexM2TypeInformation.load(new BufferedInputStream(jar.getInputStream(je)));
                            hasM2Content = true;
                            continue;
                        }
                        if (je.getName().indexOf(".xml") <= 0) continue;
                        if (je.getName().indexOf("_I") > 0) {
                            mofId = this.getMofIdOfJarEntry(je.getName(), "_I");
                            if (mofId == null) continue;
                            if (dirName.compareTo("MMR_M1") == 0) {
                                hasM1Content = true;
                                continue;
                            }
                            if (dirName.compareTo("MMR_M2") != 0) continue;
                            hasM2Content = true;
                            continue;
                        }
                        if (je.getName().indexOf("_A") <= 0 || (mofId = this.getMofIdOfJarEntry(je.getName(), "_A")) == null) continue;
                        if (dirName.compareTo("MMR_M1") == 0) {
                            hasM1Content = true;
                            continue;
                        }
                        if (dirName.compareTo("MMR_M2") != 0) continue;
                        hasM2Content = true;
                    }
                    var18_20 = null;
                    if (jar == null) break block65;
                    ** GOTO lbl105
                }
                catch (IOException e) {
                    Repository.category.errorT(PersistenceJar.location, e.toString());
                    var18_20 = null;
                    if (jar != null) {
                        try {
                            jar.close();
                        }
                        catch (IOException e1) {
                            RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
                        }
                    }
                    break block65;
                }
                {
                    catch (Throwable var17_24) {
                        var18_21 = null;
                        if (jar == null) throw var17_24;
                        ** try [egrp 2[TRYBLOCK] [4 : 646->654)] { 
lbl99:
                        // 1 sources

                        jar.close();
                        throw var17_24;
lbl101:
                        // 1 sources

                        catch (IOException e1) {
                            RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
                        }
                        throw var17_24;
                    }
lbl105:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [4 : 646->654)] { 
lbl106:
                    // 1 sources

                    jar.close();
lbl108:
                    // 1 sources

                    catch (IOException e1) {}
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
                }
            }
            if (!hasM1Content) break block66;
            if (indexM1TypeInformation == null) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM1TypeInformation is missing"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"indexM1TypeInformation"});
                if (col == null) {
                    col = new ArrayList<IConnection.CheckResult>();
                }
                col.add(cr);
            }
            if (avM1 == null) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"avM1 is missing"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"avM1"});
                if (col == null) {
                    col = new ArrayList<E>();
                }
                col.add(cr);
            }
            if (col != null) break block66;
            try {
                jar = new JarFile(f, true);
                enum = jar.entries();
                while (enum.hasMoreElements()) {
                    je = enum.nextElement();
                    if (je.isDirectory()) continue;
                    dirName = this.getDirectoryOfJarEntry(je.getName());
                    if (dirName == null) {
                        dirName = "";
                    }
                    if (je.getName().indexOf(".xml") <= 0 || je.getName().indexOf("_I") <= 0 || (mofId = this.getMofIdOfJarEntry(je.getName(), "_I")) == null || dirName.compareTo("MMR_M1") != 0 || indexM1TypeInformation.containsKey(mofId)) continue;
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"mofId " + mofId + " missing in indexM1TypeInformation"});
                    cr = new IConnection.CheckResult(0);
                    cr.setObjectsInError(new Object[]{"typeInformationM1", mofId});
                    if (col == null) {
                        col = new ArrayList<E>();
                    }
                    col.add(cr);
                }
                var21_26 = null;
                if (jar == null) break block66;
                ** GOTO lbl179
            }
            catch (IOException e) {
                Repository.category.errorT(PersistenceJar.location, e.toString());
                var21_26 = null;
                if (jar != null) {
                    try {
                        jar.close();
                    }
                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
                    }
                }
                break block66;
            }
            {
                catch (Throwable var20_30) {
                    var21_27 = null;
                    if (jar == null) throw var20_30;
                    ** try [egrp 5[TRYBLOCK] [9 : 1130->1138)] { 
lbl173:
                    // 1 sources

                    jar.close();
                    throw var20_30;
lbl175:
                    // 1 sources

                    catch (IOException e1) {
                        RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
                    }
                    throw var20_30;
                }
lbl179:
                // 1 sources

                ** try [egrp 5[TRYBLOCK] [9 : 1130->1138)] { 
lbl180:
                // 1 sources

                jar.close();
lbl182:
                // 1 sources

                catch (IOException e1) {}
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
            }
        }
        if (hasM2Content == false) return col;
        if (indexM2TypeInformation == null) {
            RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM2TypeInformation is missing"});
            cr = new IConnection.CheckResult(0);
            cr.setObjectsInError(new Object[]{"indexM2TypeInformation"});
            if (col == null) {
                col = new ArrayList<E>();
            }
            col.add(cr);
        }
        if (indexM2QualifiedName == null) {
            RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM2QualifiedName is missing"});
            cr = new IConnection.CheckResult(0);
            cr.setObjectsInError(new Object[]{"indexM2QualifiedName"});
            if (col == null) {
                col = new ArrayList<E>();
            }
            col.add(cr);
        }
        if (avM2 == null) {
            RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"avM2 is missing"});
            cr = new IConnection.CheckResult(0);
            cr.setObjectsInError(new Object[]{"avM2"});
            if (col == null) {
                col = new ArrayList<E>();
            }
            col.add(cr);
        }
        if (col == null) {
            map = new HashMap<String, String>();
            i = indexM2QualifiedName.keySet().iterator();
            while (i.hasNext()) {
                qn = (String)i.next();
                mofId = (String)indexM2QualifiedName.get(qn);
                map.put(mofId, qn);
            }
            i = indexM2TypeInformation.keySet().iterator();
            while (i.hasNext()) {
                mofId = (String)i.next();
                if (map.containsKey(mofId)) {
                    map.remove(mofId);
                    continue;
                }
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"mofId " + mofId + " is missing in indexM2QualifiedName"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"indexM2TypeInformation", mofId});
                if (col == null) {
                    col = new ArrayList<E>();
                }
                col.add(cr);
            }
            if (map.size() > 0) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM2QualifiedName contains data which is missing in indexM2TypeInformation"});
            }
        }
        if (col != null) return col;
        try {
            jar = new JarFile(f, true);
            enum = jar.entries();
            while (enum.hasMoreElements()) {
                je = enum.nextElement();
                if (je.isDirectory()) continue;
                dirName = this.getDirectoryOfJarEntry(je.getName());
                if (dirName == null) {
                    dirName = "";
                }
                if (je.getName().indexOf(".xml") <= 0 || je.getName().indexOf("_I") <= 0 || (mofId = this.getMofIdOfJarEntry(je.getName(), "_I")) == null || dirName.compareTo("MMR_M2") != 0 || indexM2TypeInformation.containsKey(mofId)) continue;
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"mofId " + mofId + " missing in indexM2TypeInformation"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"indexM2TypeInformation", mofId});
                if (col == null) {
                    col = new ArrayList<E>();
                }
                col.add(cr);
            }
            var24_31 = null;
            if (jar == null) return col;
            ** GOTO lbl-1000
        }
        catch (IOException e) {
            Repository.category.errorT(PersistenceJar.location, e.toString());
            var24_32 = null;
            if (jar == null) return col;
            try {
                jar.close();
                return col;
            }
            catch (IOException e1) {
                RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
                return col;
            }
        }
        {
            catch (Throwable var23_37) {
                var24_33 = null;
                if (jar == null) throw var23_37;
                ** try [egrp 8[TRYBLOCK] [14 : 1977->1985)] { 
lbl284:
                // 1 sources

                jar.close();
                throw var23_37;
lbl286:
                // 1 sources

                catch (IOException e1) {
                    RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
                }
                throw var23_37;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (IOException e1) {}
            RepositoryServer.getCategory().errorT(PersistenceJar.location, "checkPersistence()", e1.toString());
            return col;
            jar.close();
            return col;
        }
    }

    private String getDirectoryOfJarEntry(String name) {
        String dir = null;
        if (name != null) {
            int idx1 = name.indexOf("MMR_M2");
            if (idx1 == 0) {
                dir = "MMR_M2";
            } else {
                idx1 = name.indexOf("MMR_M1");
                if (idx1 == 0) {
                    dir = "MMR_M1";
                }
            }
        }
        return dir;
    }

    private String getMofIdOfJarEntry(String name, String suffix) {
        String mofId = null;
        if (name != null) {
            int idx1 = name.lastIndexOf(47);
            mofId = idx1 >= 0 ? name.substring(idx1 + 1) : name;
            int idx2 = mofId.indexOf(suffix);
            mofId = idx2 < 0 ? null : mofId.substring(0, idx2);
        }
        return mofId;
    }

    protected String getComponentNameMeasurement(Workspace w) {
        return "PersistenceJar::" + w.getName();
    }

    protected String getDirectorySearch(IConnection connection, int layer) {
        String dir = null;
        switch (layer) {
            case 1: {
                dir = "MMR_M1";
                break;
            }
            case 2: {
                dir = "MMR_M2";
                break;
            }
            default: {
                return null;
            }
        }
        return dir;
    }

    protected String getFilenameTypeInformation(IConnection connection, int layer) {
        String fname = this.getDirectoryTypeInformation(connection, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexTypeInformation.properties";
    }

    protected String getDirectoryTypeInformation(IConnection connection, int layer) {
        String dir = null;
        switch (layer) {
            case 1: {
                dir = "MMR_M1";
                break;
            }
            case 2: {
                dir = "MMR_M2";
                break;
            }
            default: {
                return null;
            }
        }
        return dir;
    }

    protected String getFilenameQualifiedNames(IConnection connection, int layer) {
        String fname = this.getDirectoryQualifiedNames(connection, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexQualifiedName.properties";
    }

    protected String getDirectoryQualifiedNames(IConnection connection, int layer) {
        String dir = null;
        switch (layer) {
            case 1: {
                dir = "MMR_M1";
                break;
            }
            case 2: {
                dir = "MMR_M2";
            }
        }
        return dir;
    }

    protected String getFilenameSearch(IConnection connection, int layer) {
        String fname = this.getDirectorySearch(connection, layer);
        if (fname == null) {
            return null;
        }
        return fname + '/' + "IndexSearch.xml";
    }

    public Set getWorkspaces() {
        HashSet<Workspace> set = new HashSet<Workspace>();
        set.add(this.workspace);
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

