/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IPersistence;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.ListInstanceInfo;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.PersistenceDefault;
import com.sap.ip.mmr.persistence.PersistenceFS;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.ModelElement;
import javax.jmi.reflect.RefObject;

public class PersistenceFSMultiWS
extends PersistenceDefault {
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$persistence$PersistenceFSMultiWS == null ? (class$com$sap$ip$mmr$persistence$PersistenceFSMultiWS = PersistenceFSMultiWS.class$("com.sap.ip.mmr.persistence.PersistenceFSMultiWS")) : class$com$sap$ip$mmr$persistence$PersistenceFSMultiWS);
    private Map pcs = new HashMap();
    static /* synthetic */ Class class$com$sap$ip$mmr$persistence$PersistenceFSMultiWS;

    public PersistenceFSMultiWS(IRepositoryServer repositoryServer) {
        super(repositoryServer);
        String method = "PersistenceFSMultiWS(IRepositoryServer repositoryServer)";
        location.entering("PersistenceFSMultiWS(IRepositoryServer repositoryServer)");
        String path = RepositoryServer.getConfiguration().getRepositoryHomeDir();
        Workspace ws = new Workspace("[default]_M1");
        ws.setDescription("Workspace used to read the default filesystem");
        ws.setPath(path);
        this.registerWorkspace(ws, 1);
        ws = new Workspace("[default]_M2");
        ws.setDescription("Workspace used to read the default filesystem");
        ws.setPath(path);
        this.registerWorkspace(ws, 2);
        location.exiting("PersistenceFSMultiWS(IRepositoryServer repositoryServer)");
    }

    private Iterator iteratorForConnection(IConnection con) {
        LinkedList<Object> l = new LinkedList<Object>();
        HashSet<PersistenceFS> set = new HashSet<PersistenceFS>();
        if (con == null || con.getConnectionSpec() == null) {
            Iterator i = this.pcs.values().iterator();
            while (i.hasNext()) {
                PersistenceFS pfs = (PersistenceFS)i.next();
                set.add(pfs);
                set.add(pfs);
            }
            l.addAll(set);
        } else {
            if (con.getConnectionSpec().getWorkspacesM1() != null) {
                set.addAll(con.getConnectionSpec().getWorkspacesM1());
            }
            if (con.getConnectionSpec().getWorkspacesM2() != null) {
                set.addAll(con.getConnectionSpec().getWorkspacesM2());
            }
            Iterator i = set.iterator();
            while (i.hasNext()) {
                Workspace w = (Workspace)i.next();
                if (!this.pcs.containsKey(w.getName())) continue;
                l.add(this.pcs.get(w.getName()));
            }
        }
        return l.iterator();
    }

    private Iterator iteratorForConnection(IConnection con, int mofLayer, boolean forRead) {
        LinkedList l = new LinkedList();
        Iterator i = null;
        if (mofLayer == 1) {
            i = con.getConnectionSpec().getWorkspacesM1().iterator();
        } else if (mofLayer == 2) {
            i = con.getConnectionSpec().getWorkspacesM2().iterator();
        }
        if (i != null) {
            while (i.hasNext()) {
                Workspace w = (Workspace)i.next();
                if (!forRead) {
                    if (w.isReadOnly() || !this.pcs.containsKey(w.getName())) continue;
                    l.add(this.pcs.get(w.getName()));
                    continue;
                }
                if (!this.pcs.containsKey(w.getName())) continue;
                l.add(this.pcs.get(w.getName()));
            }
        }
        return l.iterator();
    }

    public void addLog(Log log) {
    }

    public void removeLog(Log log) {
    }

    public void connectionClosed(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "connectionClosed(IConnection connection)";
        location.entering("connectionClosed(IConnection connection)");
        Iterator i = this.iteratorForConnection(connection);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            pfs.connectionClosed(connection);
        }
        location.exiting();
    }

    public Collection deleteM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 1, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.deleteM1(connection, objects);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        return colFailed;
    }

    public void deleteM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        Iterator i = this.iteratorForConnection(connection, 1, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            pfs.deleteM1All(connection);
        }
    }

    public boolean deleteM1Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.deleteM1Assoc(connection, mofIds)) continue;
            res = false;
        }
        return res;
    }

    public Collection deleteM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 2, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.deleteM2(connection, modelElements);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        return colFailed;
    }

    public void deleteM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        Iterator i = this.iteratorForConnection(connection, 2, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            pfs.deleteM2All(connection);
        }
    }

    public boolean deleteM2Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 2, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.deleteM2Assoc(connection, mofIds)) continue;
            res = false;
        }
        return res;
    }

    public boolean deregisterWorkspace(Workspace workspace, int mofLayer) {
        if (this.pcs.containsKey(workspace.getName())) {
            this.pcs.remove(workspace.getName());
            return true;
        }
        return false;
    }

    public void finalizer() throws BaseException, BaseRuntimeException {
        Iterator i = this.pcs.values().iterator();
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            pfs.finalizer();
        }
    }

    public Hierarchy getHierarchyM0(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext() && hier == null) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Hierarchy h = pfs.getHierarchyM0(connection, mofId);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Hierarchy getHierarchyM0ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext() && hier == null) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Hierarchy h = pfs.getHierarchyM0ByName(connection, name);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Hierarchy getHierarchyM1(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext() && hier == null) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Hierarchy h = pfs.getHierarchyM1(connection, mofId);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Hierarchy getHierarchyM1ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        Hierarchy hier = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext() && hier == null) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Hierarchy h = pfs.getHierarchyM1ByName(connection, name);
            if (h == null) continue;
            hier = h;
        }
        return hier;
    }

    public Set getWorkspaces() {
        String method = "getWorkspaces()";
        location.entering("getWorkspaces()");
        HashSet set = new HashSet();
        Iterator iter = this.pcs.values().iterator();
        while (iter.hasNext()) {
            PersistenceFS p = (PersistenceFS)iter.next();
            Set s = p.getWorkspaces();
            if (s == null) continue;
            set.addAll(s);
        }
        location.exiting();
        return set;
    }

    public List getWorkspacesAvailableM1(IConnection connection) {
        String method = "getWorkspacesAvailableM1(IConnection connection)";
        location.entering("getWorkspacesAvailableM1(IConnection connection)");
        LinkedList list = new LinkedList();
        Iterator i = this.iteratorForConnection(connection);
        while (i.hasNext()) {
            PersistenceFS p = (PersistenceFS)i.next();
            List l = p.getWorkspacesAvailableM1(connection);
            if (l == null) continue;
            list.addAll(l);
        }
        location.exiting();
        return list;
    }

    public List getWorkspacesAvailableM2(IConnection connection) {
        String method = "getWorkspacesAvailableM2(IConnection connection)";
        location.entering("getWorkspacesAvailableM2(IConnection connection)");
        LinkedList list = new LinkedList();
        Iterator i = this.iteratorForConnection(connection);
        while (i.hasNext()) {
            PersistenceFS p = (PersistenceFS)i.next();
            List l = p.getWorkspacesAvailableM2(connection);
            if (l == null) continue;
            list.addAll(l);
        }
        location.exiting();
        return list;
    }

    public boolean initialize() throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.pcs.values().iterator();
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.initialize()) continue;
            flag = false;
        }
        return flag;
    }

    public Collection insertM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 1, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.insertM1(connection, objects);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        return colFailed;
    }

    public boolean insertM1Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.insertM1Assoc(connection, aoos)) continue;
            res = false;
        }
        return res;
    }

    public Collection insertM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        String method = "insertM2(IConnection connection, Collection modelElements)";
        location.entering("insertM2(IConnection connection, Collection modelElements)");
        LinkedList colFailed = null;
        Iterator i = this.iteratorForConnection(connection, 2, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.insertM2(connection, modelElements);
            if (c == null || c.size() <= 0) continue;
            if (colFailed == null) {
                colFailed = new LinkedList();
            }
            colFailed.addAll(c);
        }
        location.exiting();
        return colFailed;
    }

    public boolean insertM2Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        String method = "insertM2Assoc(IConnection connection, Map aoos)";
        location.entering("insertM2Assoc(IConnection connection, Map aoos)");
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 2, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.insertM2Assoc(connection, aoos)) continue;
            res = false;
        }
        location.exiting();
        return res;
    }

    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        String method = "queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)";
        location.entering("queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)");
        LinkedList list = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            List l = pfs.queryM1(connection, qualifiedNameOfType, filters, includeSubTypes);
            if (l == null || l.size() <= 0) continue;
            if (list == null) {
                list = new LinkedList();
            }
            list.addAll(l);
        }
        location.exiting();
        return list;
    }

    public List queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        String method = "queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)";
        location.entering("queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes)");
        LinkedList list = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            List l = pfs.queryM2(connection, qualifiedNameOfType, filters, includeSubTypes);
            if (l == null || l.size() <= 0) continue;
            if (list == null) {
                list = new LinkedList();
            }
            list.addAll(l);
        }
        location.exiting();
        return list;
    }

    public boolean registerWorkspace(Workspace workspace, int mofLayer) {
        boolean res = false;
        if (!this.pcs.containsKey(workspace.getName())) {
            PersistenceFS pfs = new PersistenceFS(this.repositoryServer, workspace);
            try {
                pfs.initialize();
            }
            catch (BaseRuntimeException e) {
                e.log();
                pfs = null;
            }
            catch (BaseException e) {
                e.log();
                pfs = null;
            }
            if (pfs != null) {
                this.pcs.put(workspace.getName(), pfs);
                res = true;
            }
        }
        return res;
    }

    public Collection resolveFilesM1(IConnection connection, RefObject rbo) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.resolveFilesM1(connection, rbo);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public Collection resolveFilesM2(IConnection connection, ModelElement modelElement) throws BaseException, BaseRuntimeException {
        String method = "resolveFilesM2(IConnection connection, ModelElement modelElement)";
        location.entering("resolveFilesM2(IConnection connection, ModelElement modelElement)");
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.resolveFilesM2(connection, modelElement);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        location.exiting();
        return col;
    }

    public ModelElement resolveQualifiedNameM2(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        String method = "resolveQualifiedNameM2(IConnection connection, List qualifiedName)";
        location.entering("resolveQualifiedNameM2(IConnection connection, List qualifiedName)");
        ModelElement me = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext() && me == null) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            try {
                ModelElement me_ = pfs.resolveQualifiedNameM2(connection, qualifiedName);
                if (me_ == null) continue;
                me = me_;
            }
            catch (BaseException e) {
                me = null;
            }
            catch (BaseRuntimeException e) {
                me = null;
            }
        }
        location.exiting();
        return me;
    }

    public Collection selectM1(IConnection connection, Collection mofIdsOrObjects, boolean forUpdate) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.selectM1(connection, mofIdsOrObjects, forUpdate);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public Collection selectM1AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.selectM1AllOfClass(connection, qualifiedName);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public ListInstanceInfo selectM1InstanceInfos(IConnection connection, List qualifiedName, String pattern) throws BaseException, BaseRuntimeException {
        ListInstanceInfo col = new ListInstanceInfo();
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            ListInstanceInfo c = pfs.selectM1InstanceInfos(connection, qualifiedName, pattern);
            if (c == null || c.size() <= 0) continue;
            col.addAll(c);
        }
        return col;
    }

    public Collection selectM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.selectM1All(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        return col;
    }

    public AssociationsOfObject selectM1Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        AssociationsOfObject aoo = null;
        Iterator i = this.iteratorForConnection(connection, 1, true);
        while (i.hasNext() && aoo == null) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            AssociationsOfObject a = pfs.selectM1Assoc(connection, associationId, mofId);
            if (a == null) continue;
            aoo = a;
        }
        return aoo;
    }

    public Collection selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate) throws BaseException, BaseRuntimeException {
        String method = "selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate)";
        location.entering("selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate)");
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.selectM2(connection, mofIdsOrModelElements, forUpdate);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        location.exiting();
        return col;
    }

    public Collection selectM2AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        String method = "selectM2AllOfClass(IConnection connection, List qualifiedName)";
        location.entering("selectM2AllOfClass(IConnection connection, List qualifiedName)");
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.selectM2AllOfClass(connection, qualifiedName);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        location.exiting();
        return col;
    }

    public Collection selectM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "selectM2All(IConnection connection)";
        location.entering("selectM2All(IConnection connection)");
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.selectM2All(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        location.exiting();
        return col;
    }

    public AssociationsOfObject selectM2Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM2Assoc(IConnection connection, String associationId, String mofId)";
        location.entering("selectM2Assoc(IConnection connection, String associationId, String mofId)");
        AssociationsOfObject aoo = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext() && aoo == null) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            AssociationsOfObject a = pfs.selectM2Assoc(connection, associationId, mofId);
            if (a == null) continue;
            aoo = a;
        }
        location.exiting();
        return aoo;
    }

    public Collection selectM2TopLevelPackages(IConnection connection) throws BaseException, BaseRuntimeException {
        String method = "selectM2TopLevelPackages(IConnection connection)";
        location.entering("selectM2TopLevelPackages(IConnection connection)");
        LinkedList col = null;
        Iterator i = this.iteratorForConnection(connection, 2, true);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            Collection c = pfs.selectM2TopLevelPackages(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new LinkedList();
            }
            col.addAll(c);
        }
        location.exiting();
        return col;
    }

    public boolean transactionBegin(IConnection connection) throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.iteratorForConnection(connection);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.transactionBegin(connection)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean transactionBeforeCommit(IConnection connection, Collection modelElementsInsert, Map modelElementsAssocInsert, Collection modelElementsDelete, Collection objectInsert, Map objectAssocInsert, Collection objectsDelete) throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.iteratorForConnection(connection);
        while (i.hasNext() && flag) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            flag = pfs.transactionBeforeCommit(connection, modelElementsInsert, modelElementsAssocInsert, modelElementsDelete, objectInsert, objectAssocInsert, objectsDelete);
        }
        return flag;
    }

    public boolean transactionCommit(IConnection connection) throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.iteratorForConnection(connection);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.transactionCommit(connection)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean transactionRollback(IConnection connection) throws BaseException, BaseRuntimeException {
        boolean flag = true;
        Iterator i = this.iteratorForConnection(connection);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.transactionRollback(connection)) continue;
            flag = false;
        }
        return flag;
    }

    public boolean writeHierarchyM0(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.writeHierarchyM0(connection, hierarchy)) continue;
            res = false;
        }
        return res;
    }

    public boolean writeHierarchyM1(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        boolean res = true;
        Iterator i = this.iteratorForConnection(connection, 1, false);
        while (i.hasNext()) {
            PersistenceFS pfs = (PersistenceFS)i.next();
            if (pfs.writeHierarchyM1(connection, hierarchy)) continue;
            res = false;
        }
        return res;
    }

    public Collection getWorkspaceAttributeDescriptions() {
        LinkedList col = new LinkedList();
        Iterator i = this.pcs.values().iterator();
        while (i.hasNext()) {
            IPersistence pc = (IPersistence)i.next();
            Collection c = pc.getWorkspaceAttributeDescriptions();
            if (c == null || c.size() <= 0) continue;
            col.addAll(c);
        }
        return col;
    }

    public void workspaceContentHasChanged(IConnection connection, Workspace workspace) {
        Iterator i = this.pcs.values().iterator();
        while (i.hasNext()) {
            IPersistence pc = (IPersistence)i.next();
            pc.workspaceContentHasChanged(connection, workspace);
        }
    }

    public Collection checkPersistence(IConnection connection) {
        ArrayList col = null;
        Iterator i = this.pcs.values().iterator();
        while (i.hasNext()) {
            IPersistence pc = (IPersistence)i.next();
            Collection c = pc.checkPersistence(connection);
            if (c == null || c.size() <= 0) continue;
            if (col == null) {
                col = new ArrayList();
            }
            col.addAll(c);
        }
        return col;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

