/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.persistence;

import com.sap.exception.BaseException;
import com.sap.exception.BaseRuntimeException;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.AssociationsContainer;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.ListInstanceInfo;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.ObjectInputStreamWithClassLoader;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.fs.RepositoryFS;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.persistence.IResourceChangeListener;
import com.sap.ip.mmr.persistence.PersistenceDefault;
import com.sap.ip.mmr.persistence.PersistenceFSCache;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.persistence.WorkspaceMetaInformation;
import com.sap.ip.mmr.persistence.check.ModelVerifier;
import com.sap.ip.mmr.search.AttributesValues;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofPackage;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.RefPackage;
import javax.resource.ResourceException;

public class PersistenceFS
extends PersistenceDefault {
    public static final String XMI_JAR = "mmr_xmi.jar";
    public static final String DIR_M3 = "MMR_M3";
    public static final String DIR_M2 = "MMR_M2";
    public static final String DIR_M1 = "MMR_M1";
    public static final String DIR_M0 = "MMR_M0";
    protected static final int PATH_I = 1;
    protected static final int PATH_A = 2;
    protected static final int PATH_D = 3;
    public static final String SUFFIX_INSTANCE = "_I";
    public static final String SUFFIX_ASSOCIATIONS = "_A";
    public static final String SUFFIX_DELETED = "_D";
    public static final String DIR_HIERARCHIES = "hierarchies";
    public static final String INDEX_SEARCH = "IndexSearch.xml";
    public static final String INDEX_TYPE_INFORMATION = "IndexTypeInformation.properties";
    public static final String INDEX_QUALIFIED_NAMES = "IndexQualifiedName.properties";
    private static final String PERF_COUNTER_M1_SELECT_SER = "M1 select, serialized";
    private static final String PERF_COUNTER_M1_SELECT_XMI = "M1 select, XMI";
    private static final String PERF_COUNTER_M1_INSERT = "M1 insert";
    private static final String PERF_COUNTER_M1_DELETE = "M1 delete";
    private static final String PERF_COUNTER_M1_SELECT_ASSOC_SER = "M1 select associations, serialized";
    private static final String PERF_COUNTER_M1_SELECT_ASSOC_XMI = "M1 select associations, XMI";
    private static final String PERF_COUNTER_M1_INSERT_ASSOC = "M1 insert, associations";
    private static final String PERF_COUNTER_M2_SELECT_SER = "M2 select, serialized";
    private static final String PERF_COUNTER_M2_SELECT_XMI = "M2 select, XMI";
    private static final String PERF_COUNTER_M2_INSERT = "M2 insert";
    private static final String PERF_COUNTER_M2_DELETE = "M2 delete";
    private static final String PERF_COUNTER_M2_SELECT_ASSOC_SER = "M2 select associations, serialized";
    private static final String PERF_COUNTER_M2_SELECT_ASSOC_XMI = "M2 select associations, XMI";
    private static final String PERF_COUNTER_M2_INSERT_ASSOC = "M2 insert, associations";
    protected Set filesDontUse;
    protected Set paths = new TreeSet();
    protected Map hierarchiesM0 = new HashMap();
    protected Map hierarchiesM1 = new HashMap();
    protected Properties typeInformationM1;
    protected Properties typeInformationM2;
    private boolean m1Collected = false;
    private boolean m2Collected = false;
    protected Properties qualifiedNamesM2;
    private boolean collectM2Started = false;
    protected Properties timestampsNew = new Properties();
    protected boolean mustCommit = false;
    protected AttributesValues attributesValuesM1;
    protected AttributesValues attributesValuesM2;
    private boolean packageWasInserted = false;
    protected Workspace workspace;
    private WorkspaceMetaInformation wsMetaInf;
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$persistence$PersistenceFS == null ? (class$com$sap$ip$mmr$persistence$PersistenceFS = PersistenceFS.class$("com.sap.ip.mmr.persistence.PersistenceFS")) : class$com$sap$ip$mmr$persistence$PersistenceFS);
    protected PersistenceFSCache persistenceFSCache;
    static /* synthetic */ Class class$com$sap$ip$mmr$persistence$PersistenceFS;

    public PersistenceFS(IRepositoryServer repositoryServer, Workspace ws) {
        super(repositoryServer);
        this.workspace = ws;
        String method = "PersistenceFS(IRepositoryServer repositoryServer, Workspace ws)";
        location.entering("PersistenceFS(IRepositoryServer repositoryServer, Workspace ws)");
        this.repositoryFS = RepositoryServer.getRepositoryFS();
        this.typeInformationM1 = new Properties();
        this.typeInformationM2 = new Properties();
        this.qualifiedNamesM2 = new Properties();
        this.filesDontUse = new HashSet();
        this.filesDontUse.add(INDEX_SEARCH);
        this.initCache();
        location.exiting("PersistenceFS(IRepositoryServer repositoryServer, Workspace ws)");
    }

    protected void initCache() {
        this.persistenceFSCache = PersistenceFSCache.getPersistenceFSCache();
        if (this.workspace != null) {
            Boolean b = (Boolean)this.workspace.getProperties().get("MMR_USE_CACHE");
            if (b == null || b.equals(Boolean.TRUE)) {
                this.persistenceFSCache.setUsed(true);
            } else {
                this.persistenceFSCache.setUsed(false);
            }
        }
    }

    public void addLog(Log log) {
    }

    public void removeLog(Log log) {
    }

    public List getMofPackageNamesResponsible() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("*");
        return list;
    }

    public boolean transactionBegin(IConnection connection) throws BaseException, BaseRuntimeException {
        return true;
    }

    public boolean transactionCommit(IConnection connection) throws BaseException, BaseRuntimeException {
        if (connection != null) {
            this.collectQualifiedNamesM2(connection);
            this.collectTypeInformationM2(connection);
            this.collectTypeInformationM1(connection);
        }
        if (this.mustCommit) {
            File f;
            if (this.workspace != null && (f = new File(this.workspace.getPath())).exists() && f.isDirectory()) {
                this.updateSearchData(connection);
                this.updateTypeInformation(connection);
                this.updateQualifiedNames(connection);
                this.updateTimestamps(connection);
            }
            this.mustCommit = false;
        }
        return true;
    }

    public boolean transactionRollback(IConnection connection) throws BaseException, BaseRuntimeException {
        this.mustCommit = false;
        return true;
    }

    public void finalizer() throws BaseException, BaseRuntimeException {
        super.finalizer();
        this.transactionCommit(null);
    }

    public void connectionClosed(IConnection connection) throws BaseException, BaseRuntimeException {
        super.connectionClosed(connection);
        this.transactionCommit(connection);
    }

    public RefObject selectM3(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM3(String mofId)";
        RepositoryServer.getCategory().errorT(location, "selectM3(String mofId)", MMRResourceAccessor.getInstance().getMessageText(connection, "0000"));
        return null;
    }

    public RefObject selectM3ByName(IConnection connection, String qualifiedName) throws BaseException, BaseRuntimeException {
        String method = "selectM3ByName(String qualifiedName)";
        RepositoryServer.getCategory().errorT(location, "selectM3ByName(String qualifiedName)", MMRResourceAccessor.getInstance().getMessageText(connection, "0000"));
        return null;
    }

    public AssociationsOfObject selectM3Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM3Assoc(String associationId,String mofId)";
        RepositoryServer.getCategory().errorT(location, "selectM3Assoc(String associationId,String mofId)", MMRResourceAccessor.getInstance().getMessageText(connection, "0000"));
        return null;
    }

    public Collection insertM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        if (modelElements == null || modelElements.size() <= 0) {
            return null;
        }
        LinkedList<IModelElement> colFailed = null;
        this.getAttributesValuesM2(connection);
        Iterator iter = modelElements.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof IModelElement)) continue;
            IModelElement me = (IModelElement)o;
            if (!this.writeModelElement(connection, me)) {
                if (colFailed == null) {
                    colFailed = new LinkedList<IModelElement>();
                }
                colFailed.add(me);
                continue;
            }
            this.mustCommit = true;
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M2_INSERT);
            if (!(me instanceof MofPackage)) continue;
            this.packageWasInserted = true;
        }
        this.getAttributesValuesM2(connection).addInstances(modelElements);
        return colFailed;
    }

    public boolean writeModelElement(IConnection connection, IModelElement me) {
        return this.writeModelElement(connection, me, false);
    }

    public boolean writeModelElement(IConnection connection, IModelElement me, boolean serializedOnly) {
        String method = "writeModelElement(IConnection connection, IModelElement me, boolean serializedOnly)";
        location.entering("writeModelElement(IConnection connection, IModelElement me, boolean serializedOnly)");
        String nameStorageDir = this.workspace.getPath() + '/' + DIR_M2 + '/' + this.getStorageDir(me);
        File f = new File(this.workspace.getPath());
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        if (f.exists() && !f.canWrite()) {
            RepositoryServer.getCategory().errorT(location, "writeModelElement(IConnection connection, IModelElement me, boolean serializedOnly)", MMRResourceAccessor.getInstance().getMessageText(connection, "2057"), new Object[]{f.getAbsolutePath()});
            return false;
        }
        this.repositoryFS.createDirectory(nameStorageDir);
        byte[] data = null;
        String path = this.createFileName(nameStorageDir, me.refMofId());
        boolean res = true;
        try {
            this.collectQualifiedNamesM2(connection);
            this.collectTypeInformationM2(connection);
        }
        catch (BaseRuntimeException e) {
            RepositoryServer.getCategory().errorT(location, "writeModelElement(IConnection connection, IModelElement me, boolean serializedOnly)", e.toString());
        }
        catch (BaseException e) {
            RepositoryServer.getCategory().errorT(location, "writeModelElement(IConnection connection, IModelElement me, boolean serializedOnly)", e.toString());
        }
        if (!serializedOnly) {
            data = this.encodeObject(connection, me);
            String type = this.getStorageDir(me).replace('/', '.');
            this.typeInformationM2.put(me.refMofId(), type);
            this.qualifiedNamesM2.put(Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName()), me.refMofId());
            res = this.repositoryFS.writeString(path, new String(data), "utf-8");
        }
        File fpath = new File(path);
        this.persistenceFSCache.setTimeStamp(connection, this.workspace, path, fpath.lastModified());
        this.persistenceFSCache.writeInstance(connection, this.workspace, (RefBaseObject)me);
        location.exiting();
        return res;
    }

    public boolean writeRefObject(IConnection connection, RefBaseObject ro) {
        return this.writeRefObject(connection, ro, false);
    }

    public boolean writeRefObject(IConnection connection, RefBaseObject ro, boolean serializedOnly) {
        String method = "writeRefObject(IConnection connection, RefBaseObject ro, boolean serializedOnly)";
        String nameStorageDir = this.workspace.getPath() + '/' + DIR_M1 + '/' + this.getStorageDir(ro);
        if (!serializedOnly) {
            File f = new File(this.workspace.getPath());
            if (f.exists() && !f.isDirectory()) {
                return true;
            }
            if (f.exists() && !f.canWrite()) {
                RepositoryServer.getCategory().errorT(location, "writeRefObject(IConnection connection, RefBaseObject ro, boolean serializedOnly)", MMRResourceAccessor.getInstance().getMessageText(connection, "2057"), new Object[]{f.getAbsolutePath()});
                return false;
            }
            this.repositoryFS.createDirectory(nameStorageDir);
        }
        String path = this.createFileName(nameStorageDir, ro.refMofId());
        boolean res = true;
        this.collectTypeInformationM1(connection);
        if (!serializedOnly) {
            byte[] data = this.encodeObject(connection, ro);
            File f = new File(path);
            if (!f.exists() || f.canWrite()) {
                String type = this.getStorageDir(ro).replace('/', '.');
                this.typeInformationM1.put(ro.refMofId(), type);
                res = this.repositoryFS.writeString(path, new String(data), "utf-8");
            }
        }
        File fpath = new File(path);
        this.persistenceFSCache.setTimeStamp(connection, this.workspace, path, fpath.lastModified());
        this.persistenceFSCache.writeInstance(connection, this.workspace, ro);
        return res;
    }

    protected String createFileName(String dir, String mofId) {
        return dir + '/' + mofId + SUFFIX_INSTANCE + ".xml";
    }

    protected String createFileNameAssociations(String dir, String mofId) {
        return dir + '/' + mofId + SUFFIX_ASSOCIATIONS + ".xml";
    }

    private String createFileNameDeletion(String dir, String mofId) {
        return dir + '/' + mofId + SUFFIX_DELETED + ".xml";
    }

    public Collection deleteM2(IConnection connection, Collection modelElements) throws BaseException, BaseRuntimeException {
        ModelElement me;
        if (modelElements == null || modelElements.size() <= 0) {
            return null;
        }
        LinkedList<ModelElement> colFailed = null;
        String method = "deleteM2(IConnection connection,Collection modelElements)";
        if (this.collectTypeInformationM2(connection) == null) {
            return colFailed;
        }
        ArrayList objDel = new ArrayList(modelElements.size());
        objDel.addAll(modelElements);
        Iterator iter = objDel.iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (this.typeInformationM2.containsKey(me.refMofId())) continue;
            iter.remove();
        }
        iter = objDel.iterator();
        while (iter.hasNext()) {
            File f;
            me = (ModelElement)iter.next();
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M2_DELETE);
            this.mustCommit = true;
            String path = this.getPath(this.typeInformationM2, this.workspace.getPath(), me.refMofId(), 1);
            if (path != null && (f = new File(path)).exists()) {
                if (!f.delete()) {
                    RepositoryServer.getCategory().errorT(location, "deleteM2(IConnection connection,Collection modelElements)", MMRResourceAccessor.getInstance().getMessageText(connection, "3000"), new Object[]{path});
                    if (colFailed == null) {
                        colFailed = new LinkedList<ModelElement>();
                    }
                    colFailed.add(me);
                }
                if ((path = this.getPath(this.typeInformationM2, this.workspace.getPath(), me.refMofId(), 3)) != null) {
                    File fdel = new File(path);
                    try {
                        fdel.createNewFile();
                    }
                    catch (IOException e) {
                        RepositoryServer.getCategory().errorT(location, "deleteM2(IConnection connection,Collection modelElements)", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
                    }
                }
            }
            if ((path = this.getPath(this.typeInformationM2, this.workspace.getPath(), me.refMofId(), 2)) != null && (f = new File(path)).exists() && !f.delete()) {
                RepositoryServer.getCategory().errorT(location, "deleteM2(IConnection connection,Collection modelElements)", MMRResourceAccessor.getInstance().getMessageText(connection, "3001"), new Object[]{path});
                if (colFailed == null) {
                    colFailed = new LinkedList();
                }
                colFailed.add(me);
            }
            this.persistenceFSCache.deleteInstance(connection, this.workspace, this.getPath(this.typeInformationM2, null, me.refMofId(), 1));
            this.persistenceFSCache.deleteAssoc(connection, this.workspace, this.getPath(this.typeInformationM2, null, me.refMofId(), 2));
        }
        this.getAttributesValuesM2(connection).deleteInstances(objDel);
        return colFailed;
    }

    public Collection selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate) throws BaseException, BaseRuntimeException {
        String method = "selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate)";
        location.entering("selectM2(IConnection connection, Collection mofIdsOrModelElements, boolean forUpdate)");
        LinkedList<ModelElement> colRead = new LinkedList<ModelElement>();
        if (mofIdsOrModelElements == null || mofIdsOrModelElements.size() <= 0) {
            return colRead;
        }
        if (this.collectTypeInformationM2(connection) == null) {
            return colRead;
        }
        Iterator iter = mofIdsOrModelElements.iterator();
        while (iter.hasNext()) {
            Collection col;
            long lchg;
            Object o = iter.next();
            if (o == null) continue;
            String mofId = null;
            if (o instanceof ModelElement) {
                mofId = ((ModelElement)o).refMofId();
            } else if (o instanceof String) {
                mofId = (String)o;
            }
            if (mofId == null) continue;
            ModelElement me = null;
            String path = this.getPath(this.typeInformationM2, this.workspace.getPath(), mofId, 1);
            if (path != null && (me = this.persistenceFSCache.readModelElement(connection, this.workspace, mofId, path, lchg = this.getLastModified(path))) != null) {
                colRead.add(me);
                connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M2_SELECT_SER);
            }
            if (me != null || path == null || (col = this.readModelElement(connection, mofId, path)) == null) continue;
            colRead.addAll(col);
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M2_SELECT_XMI);
            Iterator i = col.iterator();
            while (i.hasNext()) {
                me = (ModelElement)i.next();
                this.writeModelElement(connection, (IModelElement)me, true);
            }
        }
        IRepository repository = Repository.getInstance(connection);
        iter = colRead.iterator();
        while (iter.hasNext()) {
            ModelElementImpl me = (ModelElementImpl)iter.next();
            me.setRepository(repository);
            me.setMofLayer(2);
            me.setState(StateEnum.STATE_UNCHANGED);
        }
        location.exiting();
        return colRead;
    }

    public ModelElement resolveQualifiedNameM2(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        ModelElement me = null;
        this.collectQualifiedNamesM2(connection);
        String mofId = this.qualifiedNamesM2.getProperty(Utilities.getUtilities().encodeQualifiedName(qualifiedName));
        if (mofId != null) {
            LinkedList<String> l = new LinkedList<String>();
            l.add(mofId);
            Collection c = this.selectM2(connection, l, false);
            if (c != null && c.size() > 0) {
                me = (ModelElement)c.iterator().next();
            }
        }
        return me;
    }

    public Collection selectM2AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        List mofIds = this.selectM2AllOfClassMofIds(connection, qualifiedName);
        return this.selectM2(connection, mofIds, false);
    }

    protected List selectM2AllOfClassMofIds(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        LinkedList<String> mofIds = new LinkedList<String>();
        String path = this.workspace.getPath() + '/' + DIR_M2 + '/' + Utilities.getUtilities().encodeQualifiedName(qualifiedName).replace('.', '/');
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String mofId;
                int idx = files[i].getName().indexOf(".xml");
                if (idx <= 0 || (idx = (mofId = files[i].getName().substring(0, idx)).indexOf(SUFFIX_INSTANCE)) <= 0) continue;
                mofIds.add(mofId.substring(0, idx));
            }
        }
        return mofIds;
    }

    public Collection selectM2TopLevelPackages(IConnection connection) throws BaseException, BaseRuntimeException {
        if (connection == null) {
            return null;
        }
        ArrayList<String> qn = new ArrayList<String>(2);
        qn.add("Model");
        qn.add("Package");
        Collection c = this.selectM2AllOfClass(connection, qn);
        ArrayList<MofPackage> colFound = new ArrayList<MofPackage>(c.size());
        Iterator i = c.iterator();
        while (i.hasNext()) {
            MofPackage mp = (MofPackage)i.next();
            MofPackage pc = (MofPackage)mp.getContainer();
            if (pc != null && pc.refMofId().compareTo("MOF_PACKAGE_M2_ROOT") != 0) continue;
            colFound.add(mp);
        }
        return colFound;
    }

    public Collection selectM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        return this.selectM2(connection, null, null);
    }

    protected Collection selectM2(IConnection connection, Set mofIdsExisting, Properties timestamps) throws BaseException, BaseRuntimeException {
        String mofId;
        Iterator iter;
        String path = this.workspace.getPath() + '/' + DIR_M2 + '/';
        HashSet<String> mofIdsUpdate = new HashSet<String>();
        HashSet allMofIds = new HashSet();
        this.findMofIdsRecursive(this.workspace, path, this.typeInformationM2, mofIdsUpdate, allMofIds, timestamps);
        if (mofIdsExisting != null) {
            iter = allMofIds.iterator();
            while (iter.hasNext()) {
                mofId = (String)iter.next();
                if (mofIdsExisting.contains(mofId)) continue;
                mofIdsUpdate.add(mofId);
            }
        }
        if (mofIdsExisting != null) {
            iter = mofIdsExisting.iterator();
            while (iter.hasNext()) {
                mofId = (String)iter.next();
                if (allMofIds.contains(mofId)) continue;
                mofIdsUpdate.remove(mofId);
            }
        }
        if (mofIdsExisting != null) {
            iter = mofIdsUpdate.iterator();
            while (iter.hasNext()) {
                mofId = (String)iter.next();
                if (!mofIdsExisting.contains(mofId)) continue;
                iter.remove();
            }
        }
        Collection c = null;
        try {
            c = this.selectM2(connection, mofIdsUpdate, false);
        }
        catch (Exception e) {
            c = null;
        }
        return c;
    }

    protected byte[] getFileContent(IConnection connection, String path) {
        File f = new File(path);
        if (!f.exists()) {
            return null;
        }
        return this.repositoryFS.readFileContent(path);
    }

    protected Collection readModelElement(IConnection connection, String mofId, String path) {
        byte[] data = this.getFileContent(connection, path);
        Collection col = this.decodeObject(connection, 2, data);
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                ModelElementImpl me = (ModelElementImpl)iter.next();
                if (mofId != null) {
                    me.setMofId(mofId);
                }
                me.setState(StateEnum.STATE_UNCHANGED);
            }
        }
        return col;
    }

    protected ModelElementImpl readModelElementSerialized(IConnection connection, String mofId, String path) {
        ModelElementImpl me = null;
        byte[] data = this.getFileContent(connection, path);
        if (data == null) {
            return me;
        }
        Object o = this.decodeObjectSer(connection, data);
        if (o != null && o instanceof ModelElementImpl) {
            me = (ModelElementImpl)o;
            if (mofId != null) {
                me.setMofId(mofId);
            }
            me.setRepository(connection.getRepository());
            me.setMofLayer(2);
            me.setState(StateEnum.STATE_UNCHANGED);
        }
        return me;
    }

    protected Collection readRefObject(IConnection connection, String mofId, String path) {
        byte[] data = this.getFileContent(connection, path);
        Collection col = this.decodeObject(connection, 1, data);
        if (col != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                RefObject ro = (RefObject)iter.next();
                if (!(ro instanceof IMMRObject)) continue;
                IMMRObject mdro = (IMMRObject)ro;
                if (mofId != null) {
                    mdro.set___MofId(mofId);
                }
                mdro.set___Repository(connection.getRepository());
                mdro.set___State(StateEnum.STATE_UNCHANGED);
            }
        }
        return col;
    }

    protected RefObject readRefObjectSerialized(IConnection connection, String mofId, String path) {
        RefObject ro = null;
        byte[] data = this.getFileContent(connection, path);
        if (data == null) {
            return ro;
        }
        Object o = this.decodeObjectSer(connection, data);
        if (o != null && o instanceof RefObject && (ro = (RefObject)o) instanceof IMMRObject) {
            IMMRObject mdro = (IMMRObject)ro;
            if (mofId != null) {
                mdro.set___MofId(mofId);
            }
            mdro.set___State(StateEnum.STATE_UNCHANGED);
        }
        return ro;
    }

    public boolean insertM2Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        if (aoos == null || aoos.size() <= 0) {
            return true;
        }
        boolean flag = true;
        File f = new File(this.workspace.getPath());
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        Iterator iter = aoos.values().iterator();
        while (iter.hasNext()) {
            AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
            if (aoo == null || aoo.getMofId() == null || aoo.getMofId().compareTo("MOF_PACKAGE_M2_ROOT") == 0) continue;
            Collection c = new LinkedList<String>();
            c.add(aoo.getMofId());
            try {
                c = this.repositoryServer.selectM2(connection, c, false);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (c.size() >= 1) {
                ModelElement me = (ModelElement)c.iterator().next();
                String nameStorageDir = this.workspace.getPath() + '/' + DIR_M2 + '/' + this.getStorageDir((RefBaseObject)me);
                String path = this.createFileNameAssociations(nameStorageDir, aoo.getMofId());
                if (!this.repositoryFS.writeString(path, aoo.encodeAssocXML(connection), "utf-8")) {
                    flag = false;
                }
                File fpath = new File(path);
                this.persistenceFSCache.setTimeStamp(connection, this.workspace, path, fpath.lastModified());
                this.persistenceFSCache.writeAoo(connection, this.workspace, this.createFileNameAssociations(this.getStorageDir((RefBaseObject)me), aoo.getMofId()), aoo);
            }
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M2_INSERT_ASSOC);
        }
        return flag;
    }

    public boolean deleteM2Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        return true;
    }

    public AssociationsOfObject selectM2Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        String method = "selectM2Assoc(IConnection connection, String associationId, String mofId)";
        location.entering("selectM2Assoc(IConnection connection, String associationId, String mofId)");
        AssociationsOfObject aoo = null;
        if (this.collectTypeInformationM2(connection) == null) {
            return aoo;
        }
        String path = this.getPath(this.typeInformationM2, this.workspace.getPath(), mofId, 2);
        if (path == null) {
            return aoo;
        }
        long lchg = this.getLastModified(path);
        aoo = this.persistenceFSCache.readAoo(connection, this.workspace, path, lchg);
        if (aoo == null) {
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M2_SELECT_ASSOC_XMI);
            aoo = AssociationsOfObject.decodeAssocXML(connection, this.getFileContent(connection, path));
            this.persistenceFSCache.setTimeStamp(connection, this.workspace, path, lchg);
            this.persistenceFSCache.writeAoo(connection, this.workspace, path, aoo);
        } else {
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M2_SELECT_ASSOC_SER);
        }
        location.exiting();
        return aoo;
    }

    public Collection insertM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        if (objects == null || objects.size() <= 0) {
            return null;
        }
        this.getAttributesValuesM1(connection);
        LinkedList<RefObject> colFailed = null;
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof RefObject)) continue;
            RefObject ro = (RefObject)o;
            if (!this.writeRefObject(connection, (RefBaseObject)ro)) {
                if (colFailed == null) {
                    colFailed = new LinkedList<RefObject>();
                }
                colFailed.add(ro);
                continue;
            }
            this.mustCommit = true;
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M1_INSERT);
        }
        this.getAttributesValuesM1(connection).addInstances(objects);
        return colFailed;
    }

    public Collection deleteM1(IConnection connection, Collection objects) throws BaseException, BaseRuntimeException {
        RefObject ro;
        if (objects == null || objects.size() <= 0) {
            return null;
        }
        String method = "deleteM1(IConnection connection, Collection objects)";
        LinkedList<RefObject> colFailed = null;
        if (this.collectTypeInformationM1(connection) == null) {
            return colFailed;
        }
        ArrayList objDel = new ArrayList(objects.size());
        objDel.addAll(objects);
        Iterator iter = objDel.iterator();
        while (iter.hasNext()) {
            ro = (RefObject)iter.next();
            if (this.typeInformationM1.containsKey(ro.refMofId())) continue;
            iter.remove();
        }
        iter = objDel.iterator();
        while (iter.hasNext()) {
            File f;
            ro = (RefObject)iter.next();
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M1_DELETE);
            this.mustCommit = true;
            String path = this.getPath(this.typeInformationM1, this.workspace.getPath(), ro.refMofId(), 1);
            if (path != null && (f = new File(path)).exists() && !f.delete()) {
                RepositoryServer.getCategory().errorT(location, "deleteM1(IConnection connection, Collection objects)", MMRResourceAccessor.getInstance().getMessageText(connection, "3002"), new Object[]{path});
                if (colFailed == null) {
                    colFailed = new LinkedList<RefObject>();
                }
                colFailed.add(ro);
            }
            if ((path = this.getPath(this.typeInformationM1, this.workspace.getPath(), ro.refMofId(), 3)) != null) {
                File fdel = new File(path);
                try {
                    fdel.createNewFile();
                }
                catch (IOException e) {
                    RepositoryServer.getCategory().errorT(location, "deleteM1(IConnection connection, Collection objects)", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
                }
            }
            if ((path = this.getPath(this.typeInformationM1, this.workspace.getPath(), ro.refMofId(), 2)) != null && (f = new File(path)).exists() && !f.delete()) {
                RepositoryServer.getCategory().errorT(location, "deleteM1(IConnection connection, Collection objects)", MMRResourceAccessor.getInstance().getMessageText(connection, "3003"), new Object[]{path});
                if (colFailed == null) {
                    colFailed = new LinkedList();
                }
                colFailed.add(ro);
            }
            this.persistenceFSCache.deleteInstance(connection, this.workspace, this.getPath(this.typeInformationM1, null, ro.refMofId(), 1));
            this.persistenceFSCache.deleteAssoc(connection, this.workspace, this.getPath(this.typeInformationM1, null, ro.refMofId(), 2));
        }
        this.getAttributesValuesM1(connection).deleteInstances(objDel);
        return colFailed;
    }

    public Collection selectM1(IConnection connection, Collection mofIdsOrObjects, boolean forUpdate) throws BaseException, BaseRuntimeException {
        LinkedList<RefObject> colRead = new LinkedList<RefObject>();
        if (mofIdsOrObjects == null || mofIdsOrObjects.size() <= 0) {
            return colRead;
        }
        if (this.collectTypeInformationM1(connection) == null) {
            return colRead;
        }
        Iterator iter = mofIdsOrObjects.iterator();
        while (iter.hasNext()) {
            Collection col;
            long lchg;
            Object o = iter.next();
            if (o == null) continue;
            String mofId = null;
            if (o instanceof RefObject) {
                mofId = ((RefObject)o).refMofId();
            } else if (o instanceof String) {
                mofId = (String)o;
            }
            if (mofId == null) continue;
            RefObject ro = null;
            String path = this.getPath(this.typeInformationM1, this.workspace.getPath(), mofId, 1);
            if (path != null && (ro = this.persistenceFSCache.readRefObject(connection, this.workspace, mofId, path, lchg = this.getLastModified(this.getPath(this.typeInformationM1, this.workspace.getPath(), mofId, 1)))) != null) {
                colRead.add(ro);
                connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M1_SELECT_SER);
            }
            if (ro != null || (path = this.getPath(this.typeInformationM1, this.workspace.getPath(), mofId, 1)) == null || (col = this.readRefObject(connection, mofId, path)) == null) continue;
            colRead.addAll(col);
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M1_SELECT_XMI);
            Iterator i = col.iterator();
            while (i.hasNext()) {
                RefBaseObject rbo = (RefBaseObject)i.next();
                this.writeRefObject(connection, rbo, true);
            }
        }
        IRepository repository = Repository.getInstance(connection);
        iter = colRead.iterator();
        while (iter.hasNext()) {
            Object oo = iter.next();
            IMMRObject o = (IMMRObject)oo;
            o.set___Repository(repository);
            o.set___State(StateEnum.STATE_UNCHANGED);
        }
        return colRead;
    }

    public Collection selectM1AllOfClass(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        List mofIds = this.selectM1AllOfClassMofIds(connection, qualifiedName);
        return this.selectM1(connection, mofIds, false);
    }

    public List selectM1AllOfClassMofIds(IConnection connection, List qualifiedName) throws BaseException, BaseRuntimeException {
        LinkedList<String> mofIds = new LinkedList<String>();
        String path = this.workspace.getPath() + '/' + DIR_M1 + '/' + Utilities.getUtilities().encodeQualifiedName(qualifiedName).replace('.', '/');
        File dir = new File(path);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String mofId;
                int idx = files[i].getName().indexOf(".xml");
                if (idx <= 0 || (idx = (mofId = files[i].getName().substring(0, idx)).indexOf(SUFFIX_INSTANCE)) <= 0) continue;
                mofIds.add(mofId.substring(0, idx));
            }
        }
        return mofIds;
    }

    public ListInstanceInfo selectM1InstanceInfos(IConnection connection, List qualifiedName, String pattern) throws BaseException, BaseRuntimeException {
        Collection col = this.selectM1AllOfClass(connection, qualifiedName);
        ListInstanceInfo lli = new ListInstanceInfo();
        if (col != null) {
            String type = Utilities.getUtilities().encodeQualifiedName(qualifiedName);
            Iterator i = col.iterator();
            while (i.hasNext()) {
                RefBaseObject rbo = (RefBaseObject)i.next();
                String lastChangedAt = "";
                if (rbo instanceof IMMRObject) {
                    lastChangedAt = ((IMMRObject)rbo).get___LastChangedAt();
                }
                ListInstanceInfo.InstanceInfo ii = new ListInstanceInfo.InstanceInfo(rbo.refMofId(), type, null, lastChangedAt, rbo);
                lli.add(ii);
            }
        }
        return lli;
    }

    public Collection selectM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        return this.selectM1(connection, null, null);
    }

    protected Collection selectM1(IConnection connection, Set mofIdsExisting, Properties timestamps) {
        String mofId;
        Iterator iter;
        String path = this.workspace.getPath() + '/' + DIR_M1 + '/';
        HashSet<String> mofIdsUpdate = new HashSet<String>();
        HashSet allMofIds = new HashSet();
        this.findMofIdsRecursive(this.workspace, path, this.typeInformationM1, mofIdsUpdate, allMofIds, timestamps);
        if (mofIdsExisting != null) {
            iter = allMofIds.iterator();
            while (iter.hasNext()) {
                mofId = (String)iter.next();
                if (mofIdsExisting.contains(mofId)) continue;
                mofIdsUpdate.add(mofId);
            }
        }
        if (mofIdsExisting != null) {
            iter = mofIdsExisting.iterator();
            while (iter.hasNext()) {
                mofId = (String)iter.next();
                if (allMofIds.contains(mofId)) continue;
                mofIdsUpdate.remove(mofId);
            }
        }
        if (mofIdsExisting != null) {
            iter = mofIdsUpdate.iterator();
            while (iter.hasNext()) {
                mofId = (String)iter.next();
                if (!mofIdsExisting.contains(mofId)) continue;
                iter.remove();
            }
        }
        Collection c = null;
        try {
            c = this.selectM1(connection, mofIdsUpdate, false);
        }
        catch (Exception e) {
            c = null;
        }
        return c;
    }

    public boolean insertM1Assoc(IConnection connection, Map aoos) throws BaseException, BaseRuntimeException {
        if (aoos == null || aoos.size() <= 0) {
            return true;
        }
        boolean flag = true;
        File f = new File(this.workspace.getPath());
        if (f.exists() && !f.isDirectory()) {
            return true;
        }
        Iterator iter = aoos.values().iterator();
        while (iter.hasNext()) {
            AssociationsOfObject aoo = (AssociationsOfObject)iter.next();
            if (aoo.getMofId().compareTo("MOF_PACKAGE_M1_ROOT") == 0) continue;
            Collection c = new LinkedList<String>();
            c.add(aoo.getMofId());
            try {
                c = this.repositoryServer.selectM1(connection, c, false);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            catch (BaseException e) {
                e.log();
            }
            if (c.size() >= 1) {
                RefObject ro = (RefObject)c.iterator().next();
                String nameStorageDir = this.workspace.getPath() + '/' + DIR_M1 + '/' + this.getStorageDir((RefBaseObject)ro);
                String path = this.createFileNameAssociations(nameStorageDir, aoo.getMofId());
                if (!this.repositoryFS.writeString(path, aoo.encodeAssocXML(connection), "utf-8")) {
                    flag = false;
                }
                File fpath = new File(path);
                this.persistenceFSCache.setTimeStamp(connection, this.workspace, path, fpath.lastModified());
                this.persistenceFSCache.writeAoo(connection, this.workspace, this.createFileNameAssociations(this.getStorageDir((RefBaseObject)ro), aoo.getMofId()), aoo);
            }
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M1_INSERT_ASSOC);
        }
        return flag;
    }

    public boolean deleteM1Assoc(IConnection connection, Collection mofIds) throws BaseException, BaseRuntimeException {
        return true;
    }

    public AssociationsOfObject selectM1Assoc(IConnection connection, String associationId, String mofId) throws BaseException, BaseRuntimeException {
        AssociationsOfObject aoo = null;
        if (this.collectTypeInformationM1(connection) == null) {
            return aoo;
        }
        String path = this.getPath(this.typeInformationM1, this.workspace.getPath(), mofId, 2);
        if (path == null) {
            return aoo;
        }
        long lchg = this.getLastModified(path);
        aoo = this.persistenceFSCache.readAoo(connection, this.workspace, path, lchg);
        if (aoo == null) {
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M1_SELECT_ASSOC_XMI);
            aoo = AssociationsOfObject.decodeAssocXML(connection, this.getFileContent(connection, path));
            this.persistenceFSCache.setTimeStamp(connection, this.workspace, path, lchg);
            this.persistenceFSCache.writeAoo(connection, this.workspace, path, aoo);
        } else {
            connection.incrementCounter(this.getComponentNameMeasurement(this.workspace), PERF_COUNTER_M1_SELECT_ASSOC_SER);
        }
        return aoo;
    }

    public void deleteM2All(IConnection connection) throws BaseException, BaseRuntimeException {
        if (connection != null && this.workspace.getPath() != null) {
            this.repositoryFS.deleteDirectoryContent(this.workspace.getPath() + '/' + DIR_M2, true);
        }
        this.persistenceFSCache.deleteWorkspace(connection, this.workspace);
        if (this.attributesValuesM2 != null) {
            this.attributesValuesM2.clear();
        }
        this.typeInformationM2.clear();
        this.qualifiedNamesM2.clear();
    }

    public void deleteM1All(IConnection connection) throws BaseException, BaseRuntimeException {
        if (connection != null && this.workspace.getPath() != null) {
            this.repositoryFS.deleteDirectoryContent(this.workspace.getPath() + '/' + DIR_M1, true);
        }
        this.persistenceFSCache.deleteWorkspace(connection, this.workspace);
        if (this.attributesValuesM1 != null) {
            this.attributesValuesM1.clear();
        }
        this.typeInformationM1.clear();
        this.hierarchiesM1.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected byte[] encodeObject(IConnection connection, Object o) {
        byte[] bytes;
        block11: {
            bytes = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            LinkedList<Object> objects = new LinkedList<Object>();
            objects.add(o);
            connection.getRepository().write(baos, objects, "SAP_1.0");
            bytes = baos.toByteArray();
            Object var8_6 = null;
            try {
                if (baos != null) {
                    baos.close();
                }
                break block11;
            }
            catch (IOException e1) {
                RepositoryServer.category.errorT(location, e1.toString());
            }
            break block11;
            {
                catch (IOException e) {
                    bytes = null;
                    Object var8_7 = null;
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                        break block11;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (baos != null) {
                        baos.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        return bytes;
    }

    protected Collection decodeObject(IConnection connection, int layer, byte[] data) {
        String method = "decodeObject(IConnection connection, int layer, byte[] data)";
        Collection col = null;
        if (data == null || data.length < 1) {
            return col;
        }
        RefPackage rp = null;
        try {
            switch (layer) {
                case 1: {
                    rp = connection.getTopLevelPackageM1();
                    break;
                }
                case 2: {
                    rp = connection.getTopLevelPackageM2();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (ResourceException e) {
            RepositoryServer.getCategory().errorT(location, "decodeObject(IConnection connection, int layer, byte[] data)", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            col = connection.getRepository().read(bais, null, rp);
            bais.close();
        }
        catch (Exception e) {
            RepositoryServer.getCategory().errorT(location, "decodeObject(IConnection connection, int layer, byte[] data)", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
            return null;
        }
        return col;
    }

    protected String getStorageDir(IModelElement me) {
        String name = "default";
        RefObject ro = me.refMetaObject();
        if (ro != null && ro instanceof ModelElementImpl) {
            name = Utilities.getUtilities().encodeQualifiedName(((ModelElementImpl)ro).getQualifiedName()).replace('.', '/');
        }
        return name;
    }

    protected String getStorageDir(RefBaseObject ro) {
        String name = "default";
        RefObject rom = ro.refMetaObject();
        if (rom != null && rom instanceof ModelElementImpl) {
            name = Utilities.getUtilities().encodeQualifiedName(((ModelElementImpl)rom).getQualifiedName()).replace('.', '/');
        }
        return name;
    }

    protected Map collectTypeInformationM2(IConnection connection) {
        if (!this.m2Collected) {
            this.m2Collected = true;
            Properties timestamps = this.persistenceFSCache.getTypeInformationM2(connection, this.workspace, this.typeInformationM2);
            this.findMofIdsRecursive(this.workspace, this.workspace.getPath() + '/' + DIR_M2, this.typeInformationM2, null, null, timestamps);
        }
        return this.typeInformationM2;
    }

    protected Map collectTypeInformationM1(IConnection connection) {
        if (!this.m1Collected) {
            this.m1Collected = true;
            Properties timestamps = this.persistenceFSCache.getTypeInformationM1(connection, this.workspace, this.typeInformationM1);
            this.findMofIdsRecursive(this.workspace, this.workspace.getPath() + '/' + DIR_M1, this.typeInformationM1, null, null, timestamps);
        }
        return this.typeInformationM1;
    }

    protected void collectQualifiedNamesM2(IConnection connection) throws BaseException, BaseRuntimeException {
        if (this.qualifiedNamesM2.size() <= 0 && !this.collectM2Started) {
            this.collectM2Started = true;
            Properties timestamps = this.persistenceFSCache.getQualifiedNamesM2(connection, this.workspace, this.qualifiedNamesM2);
            HashSet<Object> mofIdsExisting = new HashSet<Object>();
            mofIdsExisting.addAll(this.qualifiedNamesM2.values());
            Collection mes = this.selectM2(connection, mofIdsExisting, timestamps);
            if (mes != null) {
                Iterator iter = mes.iterator();
                while (iter.hasNext()) {
                    ModelElement me = (ModelElement)iter.next();
                    this.qualifiedNamesM2.put(Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName()), me.refMofId());
                    this.mustCommit = true;
                }
            }
        }
    }

    protected void findMofIdsRecursive(Workspace workspace, String dir, Map map, Set mofIds, Set allMofIds, Properties timestamps) {
        File f;
        String dirSearch = DIR_M2;
        if (map == this.typeInformationM1) {
            dirSearch = DIR_M1;
        }
        if ((f = new File(dir)).exists() && f.isDirectory()) {
            File[] files = f.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String name;
                int n;
                if (files[i].isDirectory()) {
                    this.findMofIdsRecursive(workspace, files[i].getAbsolutePath(), map, mofIds, allMofIds, timestamps);
                    continue;
                }
                long timestampIdx = 0L;
                String pathTs = files[i].getAbsolutePath().replace('\\', '/');
                if (timestamps != null) {
                    String s = timestamps.getProperty(pathTs);
                    if (s != null) {
                        timestampIdx = Long.parseLong(s);
                    }
                    this.timestampsNew.put(pathTs, String.valueOf(files[i].lastModified()));
                }
                if ((n = (name = files[i].getName()).lastIndexOf(".xml")) <= 0 || (n = name.lastIndexOf(SUFFIX_INSTANCE)) <= 0) continue;
                String path = files[i].getAbsolutePath().replace('\\', '/');
                String mofId = name.substring(0, n);
                if (path.indexOf(dirSearch) < 0) continue;
                int idx1 = path.indexOf(dirSearch) + dirSearch.length() + 1;
                int idx2 = path.lastIndexOf(name) - 1;
                if (idx1 < 0 || idx2 < 0 || idx1 >= idx2 || this.filesDontUse.contains(mofId)) continue;
                String type = path.substring(idx1, idx2).replace('/', '.');
                if (map != null) {
                    map.put(mofId, type);
                }
                if (allMofIds != null) {
                    allMofIds.add(mofId);
                }
                this.mustCommit = true;
                if (mofIds == null || timestampIdx >= files[i].lastModified()) continue;
                mofIds.add(mofId);
            }
        }
    }

    protected String getPath(Map map, String workspacePath, String mofId, int pathType) {
        String dir = null;
        if (map == this.typeInformationM2) {
            dir = DIR_M2;
        } else if (map == this.typeInformationM1) {
            dir = DIR_M1;
        } else {
            return null;
        }
        String ti = (String)map.get(mofId);
        if (ti == null) {
            return null;
        }
        String suffix = null;
        String suffixType = ".xml";
        switch (pathType) {
            case 1: {
                suffix = SUFFIX_INSTANCE;
                break;
            }
            case 2: {
                suffix = SUFFIX_ASSOCIATIONS;
                break;
            }
            case 3: {
                suffix = SUFFIX_DELETED;
                break;
            }
            default: {
                suffix = SUFFIX_INSTANCE;
            }
        }
        return workspacePath + "/" + dir + "/" + ti.replace('.', '/') + "/" + mofId + suffix + suffixType;
    }

    public List queryM2(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        if (filters == null) {
            if (qualifiedNameOfType == null) {
                ArrayList list = new ArrayList();
                list.addAll(this.selectM2All(connection));
                return list;
            }
            return this.selectM2AllOfClassMofIds(connection, qualifiedNameOfType);
        }
        if (this.getAttributesValuesM2(connection) == null) {
            return null;
        }
        return this.getAttributesValuesM2(connection).query(qualifiedNameOfType, filters);
    }

    public List queryM1(IConnection connection, List qualifiedNameOfType, QueryFilters filters, boolean includeSubTypes) throws BaseException, BaseRuntimeException {
        if (filters == null) {
            if (qualifiedNameOfType == null) {
                ArrayList list = new ArrayList();
                list.addAll(this.selectM1All(connection));
                return list;
            }
            return this.selectM1AllOfClassMofIds(connection, qualifiedNameOfType);
        }
        if (this.getAttributesValuesM1(connection) == null) {
            return null;
        }
        return this.getAttributesValuesM1(connection).query(qualifiedNameOfType, filters);
    }

    protected AttributesValues getAttributesValuesM1(IConnection connection) throws BaseException, BaseRuntimeException {
        if (this.attributesValuesM1 == null || this.attributesValuesM1.size() <= 0) {
            this.attributesValuesM1 = new AttributesValues();
            Properties timestamps = this.persistenceFSCache.getAttributesValuesM1(connection, this.workspace, this.attributesValuesM1);
            Collection c = this.selectM1(connection, this.attributesValuesM1.getMofIds(), timestamps);
            this.attributesValuesM1.addInstances(c);
            this.updateSearchData(connection);
        }
        return this.attributesValuesM1;
    }

    protected AttributesValues getAttributesValuesM2(IConnection connection) throws BaseException, BaseRuntimeException {
        if (this.attributesValuesM2 == null || this.attributesValuesM2.size() <= 0) {
            this.attributesValuesM2 = new AttributesValues();
            Properties timestamps = this.persistenceFSCache.getAttributesValuesM2(connection, this.workspace, this.attributesValuesM2);
            Collection c = this.selectM2(connection, this.attributesValuesM2.getMofIds(), timestamps);
            this.attributesValuesM2.addInstances(c);
            this.updateSearchData(connection);
        }
        return this.attributesValuesM2;
    }

    protected String getPathHierarchy(IConnection connection, int mofLayer, String name) {
        String path = this.getPathHierarchyDirectory(connection, mofLayer);
        if (path != null) {
            path = path + '/' + name + ".xml";
        }
        return path;
    }

    protected String getPathHierarchyDirectory(IConnection connection, int mofLayer) {
        String dir = null;
        switch (mofLayer) {
            case 0: {
                dir = DIR_M0;
                break;
            }
            case 1: {
                dir = DIR_M1;
                break;
            }
            case 2: {
                dir = DIR_M2;
                break;
            }
            case 3: {
                dir = DIR_M3;
                break;
            }
            default: {
                dir = null;
            }
        }
        if (dir != null) {
            File fDir = new File(this.workspace.getPath());
            if (fDir.exists() && !fDir.isDirectory()) {
                return null;
            }
            String path = this.workspace.getPath() + '/' + dir + '/' + DIR_HIERARCHIES;
            this.repositoryFS.createDirectory(path);
            return path;
        }
        return null;
    }

    public Hierarchy getHierarchyM1(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        if (this.hierarchiesM1.containsKey(mofId)) {
            Hierarchy h = (Hierarchy)this.hierarchiesM1.get(mofId);
            return h;
        }
        Hierarchy h = this.getHierarchy(connection, 1, mofId);
        if (h != null) {
            this.hierarchiesM1.put(mofId, h);
        }
        return h;
    }

    public Hierarchy getHierarchyM1ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        Hierarchy h = null;
        Iterator iter = this.hierarchiesM1.values().iterator();
        while (iter.hasNext() && h == null) {
            Hierarchy h_ = (Hierarchy)iter.next();
            if (h_.getName().compareTo(name) != 0) continue;
            h = h_;
        }
        if (h == null && (h = this.getHierarchyByName(connection, 1, name)) != null) {
            this.hierarchiesM1.put(h.getMofId(), h);
        }
        return h;
    }

    public boolean writeHierarchyM1(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        this.hierarchiesM1.put(hierarchy.getMofId(), hierarchy);
        return this.writeHierarchy(connection, 1, hierarchy);
    }

    public Hierarchy getHierarchyM0(IConnection connection, String mofId) throws BaseException, BaseRuntimeException {
        if (this.hierarchiesM0.containsKey(mofId)) {
            return (Hierarchy)this.hierarchiesM0.get(mofId);
        }
        Hierarchy h = this.getHierarchy(connection, 0, mofId);
        if (h != null) {
            this.hierarchiesM0.put(mofId, h);
        }
        return h;
    }

    public Hierarchy getHierarchyM0ByName(IConnection connection, String name) throws BaseException, BaseRuntimeException {
        Hierarchy h = null;
        Iterator iter = this.hierarchiesM0.values().iterator();
        while (iter.hasNext() && h == null) {
            Hierarchy h_ = (Hierarchy)iter.next();
            if (h_.getName().compareTo(name) != 0) continue;
            h = h_;
        }
        if (h == null && (h = this.getHierarchyByName(connection, 0, name)) != null) {
            this.hierarchiesM0.put(h.getMofId(), h);
        }
        return h;
    }

    public boolean writeHierarchyM0(IConnection connection, Hierarchy hierarchy) throws BaseException, BaseRuntimeException {
        this.hierarchiesM0.put(hierarchy.getMofId(), hierarchy);
        return this.writeHierarchy(connection, 0, hierarchy);
    }

    protected Hierarchy getHierarchy(IConnection connection, int mofLayer, String mofId) {
        byte[] xml;
        Hierarchy h = null;
        File f = new File(this.getPathHierarchy(connection, mofLayer, mofId));
        if (f.exists() && (xml = this.repositoryFS.readFileContent(f.getAbsolutePath())) != null) {
            h = Hierarchy.readXML(null, xml);
        }
        return h;
    }

    protected Hierarchy getHierarchyByName(IConnection connection, int mofLayer, String name) {
        Hierarchy h = null;
        String pathDir = this.getPathHierarchyDirectory(connection, mofLayer);
        File dir = new File(pathDir);
        if (dir.exists() && dir.isDirectory()) {
            FilenameFilterXml filter = new FilenameFilterXml();
            File[] f = dir.listFiles(filter);
            for (int i = 0; i < f.length && h == null; ++i) {
                Hierarchy h_;
                byte[] xml = this.repositoryFS.readFileContent(f[i].getAbsolutePath());
                if (xml == null || (h_ = Hierarchy.readXML(null, xml)).getName().compareTo(name) != 0) continue;
                h = h_;
            }
        }
        return h;
    }

    protected boolean writeHierarchy(IConnection connection, int mofLayer, Hierarchy hierarchy) {
        return this.repositoryFS.writeString(this.getPathHierarchy(connection, mofLayer, hierarchy.getMofId()), hierarchy.writeXML(), "utf-8");
    }

    public Collection resolveFilesM2(IConnection connection, ModelElement modelElement) throws BaseException, BaseRuntimeException {
        LinkedList<String> l = new LinkedList<String>();
        String nameStorageDir = this.workspace.getPath() + '/' + DIR_M2 + '/' + this.getStorageDir((RefBaseObject)modelElement);
        String path = this.createFileName(nameStorageDir, modelElement.refMofId());
        l.add(path);
        return l;
    }

    public Collection resolveFilesM1(IConnection connection, RefObject rbo) throws BaseException, BaseRuntimeException {
        LinkedList<String> l = new LinkedList<String>();
        String nameStorageDir = this.workspace.getPath() + '/' + DIR_M1 + '/' + this.getStorageDir((RefBaseObject)rbo);
        String path = this.createFileName(nameStorageDir, rbo.refMofId());
        l.add(path);
        return l;
    }

    protected void updateSearchData(IConnection connection) throws BaseException, BaseRuntimeException {
        this.persistenceFSCache.updateSearchData(connection, this.workspace, this.attributesValuesM1, this.attributesValuesM2);
    }

    protected void updateTypeInformation(IConnection connection) {
        this.persistenceFSCache.updateTypeInformation(connection, this.workspace, this.typeInformationM1, this.typeInformationM2);
    }

    protected void updateQualifiedNames(IConnection connection) {
        this.persistenceFSCache.updateQualifiedNames(connection, this.workspace, this.qualifiedNamesM2);
    }

    protected void updateTimestamps(IConnection connection) {
        this.persistenceFSCache.updateTimestamps(connection, this.workspace, this.timestampsNew);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    protected Object decodeObjectSer(IConnection connection, byte[] data) {
        String method = "decodeObjectSer(IConnection connection, byte data[])";
        location.entering("decodeObjectSer(IConnection connection, byte data[])");
        Object o = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(bais, this.repositoryServer, connection);
            o = ois.readObject();
            ois.close();
            bais.close();
        }
        catch (IOException e) {
            o = null;
        }
        catch (ClassNotFoundException e) {
            o = null;
        }
        location.exiting();
        return o;
    }

    protected byte[] encodeObjectSer(IConnection connection, Object o) {
        String method = "encodeObjectSer(IConnection connection, Object o)";
        location.entering("encodeObjectSer(IConnection connection, Object o)");
        byte[] res = null;
        if (o instanceof Serializable) {
            Serializable oser = (Serializable)o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ObjectOutputStream os = new ObjectOutputStream(baos);
                os.writeObject(oser);
                os.close();
                baos.close();
            }
            catch (IOException e) {
                RepositoryServer.getCategory().errorT(location, "encodeObjectSer(IConnection connection, Object o)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
            }
            res = baos.toByteArray();
        } else {
            res = null;
        }
        location.exiting();
        return res;
    }

    public List getWorkspacesAvailableM1(IConnection connection) {
        return this.getWorkspacesAvailable(connection);
    }

    public List getWorkspacesAvailableM2(IConnection connection) {
        return this.getWorkspacesAvailable(connection);
    }

    private List getWorkspacesAvailable(IConnection connection) {
        LinkedList<Workspace> l = new LinkedList<Workspace>();
        l.add(this.workspace);
        return l;
    }

    public boolean deregisterWorkspace(Workspace workspace, int mofLayer) {
        return true;
    }

    public boolean registerWorkspace(Workspace workspace, int mofLayer) {
        return false;
    }

    public Collection getWorkspaceAttributeDescriptions() {
        if (this.wsMetaInf == null) {
            this.wsMetaInf = new WorkspaceMetaInformation(this.getClass().getName());
            this.wsMetaInf.setPrefix("");
            this.wsMetaInf.setDescription("Filesystem based persistence.");
            this.wsMetaInf.getAttributesAndDescriptions().put("path", "Filesystem path to directory containing MMR_M1 and MMR_M2 directories.");
        }
        LinkedList<WorkspaceMetaInformation> l = new LinkedList<WorkspaceMetaInformation>();
        l.add(this.wsMetaInf);
        return l;
    }

    public Collection checkPersistence(IConnection connection) {
        ModelVerifier verifier;
        Collection c;
        String mofId;
        IConnection.CheckResult cr;
        String method = "checkPersistence()";
        ArrayList<IConnection.CheckResult> col = null;
        File f = new File(this.workspace.getPath());
        if (!f.exists()) {
            RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "1005"), new Object[]{this.workspace.getPath(), "checkPersistence()"});
            return col;
        }
        boolean hasM2Content = false;
        File f_ = new File(this.workspace.getPath() + '/' + DIR_M2);
        if (f_.exists() && f.isDirectory()) {
            hasM2Content = true;
        }
        boolean hasM1Content = false;
        f_ = new File(this.workspace.getPath() + '/' + DIR_M1);
        if (f_.exists() && f.isDirectory()) {
            hasM1Content = true;
        }
        try {
            this.collectQualifiedNamesM2(connection);
            this.collectTypeInformationM1(connection);
            this.collectTypeInformationM2(connection);
            this.getAttributesValuesM1(connection);
            this.getAttributesValuesM2(connection);
        }
        catch (Exception e) {
            RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{e.toString()});
        }
        if (hasM1Content) {
            if (this.typeInformationM1 == null) {
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM1TypeInformation is missing"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"typeInformationM1"});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr);
            }
            if (this.attributesValuesM1 == null) {
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"avM1 is missing"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"attributesValuesM1"});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr);
            }
            HashSet set = new HashSet();
            String path = this.workspace.getPath() + '/' + DIR_M1 + '/';
            this.findMofIdsRecursive(this.workspace, path, this.typeInformationM1, set, null, null);
            Iterator i = set.iterator();
            while (i.hasNext()) {
                mofId = (String)i.next();
                if (this.typeInformationM1.containsKey(mofId)) continue;
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"mofId " + mofId + " missing in indexM1TypeInformation"});
                IConnection.CheckResult cr2 = new IConnection.CheckResult(0);
                cr2.setObjectsInError(new Object[]{"typeInformationM1", mofId});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr2);
            }
        }
        if (hasM2Content) {
            if (this.typeInformationM2 == null) {
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM2TypeInformation is missing"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"typeInformationM2"});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr);
            }
            if (this.qualifiedNamesM2 == null) {
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM2QualifiedName is missing"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"qualifiedNamesM2"});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr);
            }
            if (this.attributesValuesM2 == null) {
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"avM2 is missing"});
                cr = new IConnection.CheckResult(0);
                cr.setObjectsInError(new Object[]{"attributesValuesM2"});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator<Object> i = this.qualifiedNamesM2.keySet().iterator();
            while (i.hasNext()) {
                String qn = (String)i.next();
                mofId = (String)this.qualifiedNamesM2.get(qn);
                map.put(mofId, qn);
            }
            i = this.typeInformationM2.keySet().iterator();
            while (i.hasNext()) {
                String mofId2 = (String)i.next();
                if (map.containsKey(mofId2)) {
                    map.remove(mofId2);
                    continue;
                }
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"mofId " + mofId2 + " is missing in indexM2QualifiedName"});
                IConnection.CheckResult cr3 = new IConnection.CheckResult(0);
                cr3.setObjectsInError(new Object[]{"typeInformationM2", mofId2});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr3);
            }
            if (map.size() > 0) {
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"indexM2QualifiedName contains data which is missing in indexM2TypeInformation"});
            }
            HashSet set = new HashSet();
            String path = this.workspace.getPath() + '/' + DIR_M2 + '/';
            this.findMofIdsRecursive(this.workspace, path, this.typeInformationM2, set, null, null);
            i = set.iterator();
            while (i.hasNext()) {
                String mofId3 = (String)i.next();
                if (this.typeInformationM2.containsKey(mofId3)) continue;
                RepositoryServer.getCategory().errorT(location, "checkPersistence()", MMRResourceAccessor.getInstance().getMessageText(connection, "0003"), new Object[]{"mofId " + mofId3 + " missing in indexM1TypeInformation"});
                IConnection.CheckResult cr4 = new IConnection.CheckResult(0);
                cr4.setObjectsInError(new Object[]{"typeInformationM2", mofId3});
                if (col == null) {
                    col = new ArrayList();
                }
                col.add(cr4);
            }
        }
        if ((c = (verifier = new ModelVerifier(connection)).run(this.workspace)) != null && c.size() > 0) {
            if (col == null) {
                col = new ArrayList<IConnection.CheckResult>();
            }
            col.addAll(c);
        }
        return col;
    }

    protected String getComponentNameMeasurement(Workspace w) {
        return "PersistenceFS::" + w.getName();
    }

    public long getLastModified(String path) {
        long lchg = 0L;
        File f = new File(path);
        if (f.exists() && f.isFile()) {
            lchg = f.lastModified();
        }
        return lchg;
    }

    public boolean transactionBeforeCommit(IConnection connection, Collection modelElementsInsert, Map modelElementsAssocInsert, Collection modelElementsDelete, Collection objectInsert, Map objectAssocInsert, Collection objectsDelete) throws BaseException, BaseRuntimeException {
        IResourceChangeListener.Resource resource;
        String path;
        String nameStorageDir;
        Collection colFound;
        LinkedList<String> colSearch;
        AssociationsOfObject aoo;
        ModelElement me;
        String path2;
        String nameStorageDir2;
        RefObject ro;
        Object o;
        String method = "transactionBeforeCommit(...)";
        boolean res = true;
        IResourceChangeListener rcl = this.workspace.getResourceChangeListener();
        if (rcl == null) {
            return res;
        }
        HashMap resourceDelete = new HashMap();
        HashMap resourceAdd = new HashMap();
        HashMap resourceChange = new HashMap();
        Iterator<Object> iter = objectsDelete.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof RefObject)) continue;
            ro = (RefObject)o;
            nameStorageDir2 = "/MMR_M1/" + this.getStorageDir((RefBaseObject)ro);
            path2 = this.createFileName(nameStorageDir2, ro.refMofId());
            this.addResourceWithCheck(resourceDelete, ro.refMofId(), path2);
            path2 = this.createFileNameAssociations(nameStorageDir2, ro.refMofId());
            this.addResourceWithCheck(resourceDelete, ro.refMofId(), path2);
            this.addResourceWithoutCheck(resourceAdd, ro.refMofId(), this.createFileNameDeletion(nameStorageDir2, ro.refMofId()));
        }
        iter = modelElementsDelete.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof ModelElement)) continue;
            me = (ModelElement)o;
            nameStorageDir2 = "/MMR_M2/" + this.getStorageDir((RefBaseObject)me);
            path2 = this.createFileName(nameStorageDir2, me.refMofId());
            this.addResourceWithCheck(resourceDelete, me.refMofId(), path2);
            path2 = this.createFileNameAssociations(nameStorageDir2, me.refMofId());
            this.addResourceWithCheck(resourceDelete, me.refMofId(), path2);
            this.addResourceWithoutCheck(resourceAdd, me.refMofId(), this.createFileNameDeletion(nameStorageDir2, me.refMofId()));
        }
        iter = objectInsert.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof RefObject)) continue;
            ro = (RefBaseObject)o;
            nameStorageDir2 = "/MMR_M1/" + this.getStorageDir((RefBaseObject)ro);
            path2 = this.createFileName(nameStorageDir2, ro.refMofId());
            this.addResource(resourceAdd, resourceChange, ro.refMofId(), path2);
        }
        iter = modelElementsInsert.iterator();
        while (iter.hasNext()) {
            o = iter.next();
            if (!(o instanceof ModelElement)) continue;
            me = (ModelElement)o;
            nameStorageDir2 = "/MMR_M2/" + this.getStorageDir((RefBaseObject)me);
            path2 = this.createFileName(nameStorageDir2, me.refMofId());
            this.addResource(resourceAdd, resourceChange, me.refMofId(), path2);
        }
        iter = objectAssocInsert.values().iterator();
        while (iter.hasNext()) {
            aoo = (AssociationsOfObject)iter.next();
            if (aoo.getMofId().compareTo("MOF_PACKAGE_M1_ROOT") == 0) continue;
            colSearch = new LinkedList<String>();
            colFound = new LinkedList();
            colSearch.add(aoo.getMofId());
            try {
                colFound = connection.getRepository().selectM1(colSearch, false);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            if (colFound.isEmpty()) continue;
            RefBaseObject ro2 = (RefBaseObject)colFound.iterator().next();
            nameStorageDir = "/MMR_M1/" + this.getStorageDir(ro2);
            path = this.createFileNameAssociations(nameStorageDir, aoo.getMofId());
            this.addResource(resourceAdd, resourceChange, aoo.getMofId(), path);
        }
        this.removeResources(resourceDelete.values(), resourceChange.values());
        iter = modelElementsAssocInsert.values().iterator();
        while (iter.hasNext()) {
            aoo = (AssociationsOfObject)iter.next();
            if (aoo.getMofId().compareTo("MOF_PACKAGE_M2_ROOT") == 0) continue;
            colSearch = new LinkedList();
            colFound = new LinkedList();
            colSearch.add(aoo.getMofId());
            try {
                colFound = connection.getRepository().selectM2(colSearch, false);
            }
            catch (BaseRuntimeException e) {
                e.log();
            }
            if (colFound.isEmpty()) continue;
            ModelElement me2 = (ModelElement)colFound.iterator().next();
            nameStorageDir = "/MMR_M2/" + this.getStorageDir((RefBaseObject)me2);
            path = this.createFileNameAssociations(nameStorageDir, aoo.getMofId());
            this.addResource(resourceAdd, resourceChange, aoo.getMofId(), path);
        }
        ArrayList<String> filesToDelete = new ArrayList<String>();
        iter = resourceAdd.values().iterator();
        while (iter.hasNext()) {
            resource = (IResourceChangeListener.Resource)iter.next();
            Iterator iterRes = resource.pathsRelative.iterator();
            while (iterRes.hasNext()) {
                String pathRel = (String)iterRes.next();
                String path3 = this.workspace.getPath() + '/' + pathRel;
                filesToDelete.add(path3);
                File f = new File(path3);
                try {
                    if (f.exists()) continue;
                    RepositoryFS.createDirsOfPath(path3);
                    f.createNewFile();
                }
                catch (IOException e) {
                    RepositoryServer.getCategory().errorT(location, "transactionBeforeCommit(...)", e.toString());
                }
            }
        }
        if (resourceDelete.values().size() > 0 || resourceAdd.values().size() > 0 || resourceChange.values().size() > 0) {
            res = rcl.toBeModified(resourceDelete.values(), resourceAdd.values(), resourceChange.values());
        }
        if (res) {
            iter = resourceChange.values().iterator();
            while (iter.hasNext() && res) {
                resource = (IResourceChangeListener.Resource)iter.next();
                Iterator iterP = resource.pathsRelative.iterator();
                while (iterP.hasNext() && res) {
                    path2 = this.workspace.getPath() + '/' + (String)iterP.next();
                    File f = new File(path2);
                    if (f.canWrite()) continue;
                    RepositoryServer.getCategory().errorT(location, "transactionBeforeCommit(...)", MMRResourceAccessor.getInstance().getMessageText(connection, "2057"), new Object[]{path2});
                    res = false;
                }
            }
        }
        if (!res) {
            iter = filesToDelete.iterator();
            while (iter.hasNext()) {
                String path4 = (String)iter.next();
                File f = new File(path4);
                if (!f.exists()) continue;
                f.delete();
            }
        }
        return res;
    }

    private void removeResources(Collection firstCol, Collection secondCol) {
        Iterator itSecond = secondCol.iterator();
        while (itSecond.hasNext()) {
            IResourceChangeListener.Resource resSecond;
            Object oSecond = itSecond.next();
            if (!(oSecond instanceof IResourceChangeListener.Resource) || !firstCol.contains(resSecond = (IResourceChangeListener.Resource)oSecond)) continue;
            Iterator itFirst = firstCol.iterator();
            while (itFirst.hasNext()) {
                Object oFirst = itFirst.next();
                if (!oFirst.equals(resSecond)) continue;
                IResourceChangeListener.Resource resFirst = (IResourceChangeListener.Resource)oFirst;
                List pathsSecond = resSecond.pathsRelative;
                List pathsFirst = resFirst.pathsRelative;
                Iterator pathsSecondIt = pathsSecond.iterator();
                while (pathsSecondIt.hasNext()) {
                    String pathSecond = pathsSecondIt.next().toString();
                    if (!pathsFirst.contains(pathSecond)) continue;
                    pathsSecondIt.remove();
                }
                if (!pathsSecond.isEmpty()) continue;
                itSecond.remove();
            }
        }
    }

    private void addResourceWithCheck(Map map, String mofId, String pathRelativeToWorkspace) {
        this.addResource(map, mofId, pathRelativeToWorkspace, true);
    }

    private void addResourceWithoutCheck(Map map, String mofId, String pathRelativeToWorkspace) {
        this.addResource(map, mofId, pathRelativeToWorkspace, false);
    }

    private void addResource(Map map, String mofId, String pathRelativeToWorkspace, boolean checkExistence) {
        String path;
        File f;
        if (map == null) {
            return;
        }
        if (checkExistence && !(f = new File(path = this.workspace.getPath() + '/' + pathRelativeToWorkspace)).exists()) {
            return;
        }
        IResourceChangeListener.Resource resource = (IResourceChangeListener.Resource)map.get(mofId);
        if (resource == null) {
            resource = new IResourceChangeListener.Resource();
            resource.mofId = mofId;
            map.put(mofId, resource);
        }
        resource.pathsRelative.add(pathRelativeToWorkspace);
    }

    private void addResource(Map mInsert, Map mUpdate, String mofId, String pathRelativeToWorkspace) {
        if (mInsert == null || mUpdate == null) {
            return;
        }
        boolean update = false;
        File f = new File(this.workspace.getPath() + '/' + pathRelativeToWorkspace);
        if (f.exists()) {
            update = true;
        }
        if (update) {
            IResourceChangeListener.Resource resource = (IResourceChangeListener.Resource)mUpdate.get(mofId);
            if (resource == null) {
                resource = new IResourceChangeListener.Resource();
                resource.mofId = mofId;
                mUpdate.put(mofId, resource);
            }
            resource.pathsRelative.add(pathRelativeToWorkspace);
        } else {
            IResourceChangeListener.Resource resource = (IResourceChangeListener.Resource)mInsert.get(mofId);
            if (resource == null) {
                resource = new IResourceChangeListener.Resource();
                resource.mofId = mofId;
                mInsert.put(mofId, resource);
            }
            resource.pathsRelative.add(pathRelativeToWorkspace);
        }
    }

    public void workspaceContentHasChanged(IConnection connection, Workspace workspaceChanged) {
        if (workspaceChanged.getName().compareTo(this.workspace.getName()) == 0) {
            AssociationsContainer container;
            try {
                this.updateSearchData(connection);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.updateTypeInformation(connection);
            this.updateQualifiedNames(connection);
            if (this.typeInformationM1 != null) {
                this.typeInformationM1.clear();
            }
            if (this.typeInformationM2 != null) {
                this.typeInformationM2.clear();
            }
            if (this.qualifiedNamesM2 != null) {
                this.qualifiedNamesM2.clear();
            }
            this.m1Collected = false;
            this.collectM2Started = false;
            if (this.attributesValuesM1 != null) {
                this.attributesValuesM1.clear();
            }
            if (this.attributesValuesM2 != null) {
                this.attributesValuesM2.clear();
            }
            if ((container = connection.getRepository().getAssociationsContainer(1)) != null) {
                container.workspaceContentHasChanged();
            }
            if ((container = connection.getRepository().getAssociationsContainer(2)) != null) {
                container.workspaceContentHasChanged();
            }
            this.persistenceFSCache.clear(connection);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected class FilenameFilterXml
    implements FilenameFilter {
        protected FilenameFilterXml() {
        }

        public boolean accept(File dir, String name) {
            return name.indexOf(".xml") > 0;
        }
    }
}

