/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.m2layer.model.FeatureImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl;
import java.util.Collection;
import javax.jmi.model.Classifier;
import javax.jmi.model.MultiplicityType;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.TypedElement;

public abstract class StructuralFeatureImpl
extends FeatureImpl
implements StructuralFeature {
    static final long serialVersionUID = 6344655696101077395L;
    public static final String TYPE = "type";
    public static final String MULTIPLICITY = "multiplicity";
    public static final String ISCHANGEABLE = "isChangeable";
    private boolean changeable = true;
    private MultiplicityType multiplicity = new MultiplicityTypeImpl(1, 1, false, false);

    public StructuralFeatureImpl(IRepository repository) {
        super(repository);
    }

    public StructuralFeatureImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof StructuralFeatureImpl) {
            StructuralFeatureImpl sf = (StructuralFeatureImpl)modelElement;
            this.setMultiplicity(sf.getMultiplicity());
            this.setChangeable(sf.isChangeable());
        }
    }

    public MultiplicityType getMultiplicity() {
        return this.multiplicity;
    }

    public void setMultiplicity(MultiplicityType newValue) {
        if (newValue == null) {
            return;
        }
        boolean dochange = false;
        if (newValue != null && this.multiplicity == null) {
            dochange = true;
        }
        if (this.multiplicity != null && !this.multiplicity.equals(newValue)) {
            dochange = true;
        }
        if (dochange) {
            this.multiplicity = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public void setChangeable(boolean newValue) {
        if (this.changeable != newValue) {
            this.changeable = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(TYPE) == 0) {
            this.setType((Classifier)value);
        }
        if (featureName.compareTo(MULTIPLICITY) == 0) {
            this.setMultiplicity((MultiplicityType)value);
        } else if (featureName.compareTo(ISCHANGEABLE) == 0) {
            if (value instanceof String) {
                this.setChangeable(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setChangeable((Boolean)value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(TYPE) == 0) {
                o = this.getType();
            }
            if (featureName.compareTo(MULTIPLICITY) == 0) {
                o = this.getMultiplicity();
            } else if (featureName.compareTo(ISCHANGEABLE) == 0) {
                o = new Boolean(this.isChangeable());
            }
        }
        return o;
    }

    public Classifier getType() {
        return this.getModelPackage().getIsOfType().getType((TypedElement)this);
    }

    public void setType(Classifier newValue) {
        this.getModelPackage().getIsOfType().add(newValue, (TypedElement)this);
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        col = this.checkMultipliticy(col, this.getMultiplicity());
        return col;
    }
}

