/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.BehavioralFeatureImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.DirectionKindEnum;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofException;
import javax.jmi.model.Parameter;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;

public class MofExceptionImpl
extends BehavioralFeatureImpl
implements MofException {
    static final long serialVersionUID = -1923048835705606567L;
    public static final String VISIBILITY = "visibility";
    public static final String SCOPE = "scope";
    private VisibilityKind visibility = VisibilityKindEnum.PUBLIC_VIS;
    private ScopeKind scope = ScopeKindEnum.INSTANCE_LEVEL;

    public MofExceptionImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public MofExceptionImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public MofExceptionImpl(IRepository repository, String name, String annotation, ScopeKind scope, VisibilityKind visibility) {
        super(repository, name);
        this.initialize();
        this.setAnnotation(annotation);
        this.setScope(scope);
        this.setVisibility(visibility);
    }

    private final void initialize() {
        this.visibility = VisibilityKindEnum.PUBLIC_VIS;
        this.scope = ScopeKindEnum.INSTANCE_LEVEL;
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof MofExceptionImpl) {
            MofExceptionImpl o = (MofExceptionImpl)modelElement;
            this.setVisibility(o.getVisibility());
            this.setScope(o.getScope());
        }
    }

    public ScopeKind getScope() {
        return this.scope;
    }

    public final void setScope(ScopeKind newValue) {
        if (newValue == null) {
            return;
        }
        if (this.scope == null || !this.scope.equals(newValue)) {
            this.scope = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public VisibilityKind getVisibility() {
        return this.visibility;
    }

    public final void setVisibility(VisibilityKind newValue) {
        if (newValue == null) {
            return;
        }
        if (this.visibility == null || !this.visibility.equals(newValue)) {
            this.visibility = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(VISIBILITY) == 0) {
            if (value instanceof String) {
                this.setVisibility(MofExceptionImpl.stringToVisibility((String)value));
            } else {
                this.setVisibility((VisibilityKind)value);
            }
        } else if (featureName.compareTo(SCOPE) == 0) {
            if (value instanceof String) {
                this.setScope(MofExceptionImpl.stringToScope((String)value));
            } else {
                this.setScope((ScopeKind)value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(VISIBILITY) == 0) {
                o = this.getVisibility();
            } else if (featureName.compareTo(SCOPE) == 0) {
                o = this.getScope();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        ModelElement me;
        Collection col = super.refVerifyConstraints(deepVerify);
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (me instanceof Parameter || me instanceof Tag) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_31", new Object[]{this}));
        }
        iter = this.getContents().iterator();
        while (iter.hasNext()) {
            Parameter p;
            me = (ModelElement)iter.next();
            if (!(me instanceof Parameter) || (p = (Parameter)me).getDirection().equals(DirectionKindEnum.OUT_DIR)) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_32", new Object[]{this}));
        }
        return col;
    }
}

