/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;

public class ImportImpl
extends ModelElementImpl
implements Import {
    static final long serialVersionUID = 1976788637979492436L;
    public static final String VISIBILITY = "visibility";
    public static final String ISCLUSTERED = "isClustered";
    public static final String IMPORTEDNAMESPACE = "importedNamespace";
    private VisibilityKind visibility = VisibilityKindEnum.PUBLIC_VIS;
    private boolean clustered = false;

    public ImportImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public ImportImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public ImportImpl(IRepository repository, String name, String annotation, VisibilityKind visibility, boolean isClustered) {
        super(repository, name);
        this.initialize();
        this.setAnnotation(annotation);
        this.setVisibility(visibility);
        this.setClustered(isClustered);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof Import) {
            Import imp = (Import)modelElement;
            this.visibility = imp.getVisibility();
            this.clustered = imp.isClustered();
        }
    }

    private final void initialize() {
        this.visibility = VisibilityKindEnum.PUBLIC_VIS;
    }

    public VisibilityKind getVisibility() {
        return this.visibility;
    }

    public final void setVisibility(VisibilityKind newValue) {
        if (newValue == null) {
            return;
        }
        if (!this.visibility.equals(newValue)) {
            this.visibility = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public final void setClustered(boolean newValue) {
        if (this.clustered != newValue) {
            this.clustered = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public Namespace getImportedNamespace() {
        return this.getModelPackage().getAliases().getImported((Import)this);
    }

    public void setImportedNamespace(Namespace newValue) {
        if (newValue == null) {
            return;
        }
        this.getModelPackage().getAliases().add((Import)this, newValue);
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(VISIBILITY) == 0) {
            if (value instanceof String) {
                this.setVisibility(ImportImpl.stringToVisibility((String)value));
            } else {
                this.setVisibility((VisibilityKind)value);
            }
        } else if (featureName.compareTo(ISCLUSTERED) == 0) {
            if (value instanceof String) {
                this.setClustered(Boolean.getBoolean((String)value));
            }
        } else if (featureName.compareTo(IMPORTEDNAMESPACE) == 0) {
            this.setImportedNamespace((Namespace)value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(VISIBILITY) == 0) {
                o = this.getVisibility();
            } else if (featureName.compareTo(ISCLUSTERED) == 0) {
                o = new Boolean(this.isClustered());
            } else if (featureName.compareTo(IMPORTEDNAMESPACE) == 0) {
                o = this.getImportedNamespace();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        if (!this.getContainer().isVisible((ModelElement)this.getImportedNamespace())) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_45", new Object[]{this}));
        }
        if (!(this.getImportedNamespace() instanceof MofPackage) && !(this.getImportedNamespace() instanceof MofClass)) {
            Object o = this.getImportedNamespace();
            if (o == null) {
                o = "[null]";
            }
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_46", new Object[]{this}));
        }
        if (this.getContainer().equals(this.getImportedNamespace())) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_47", new Object[]{this}));
        }
        if (this.getContainer().getContents().contains(this.getImportedNamespace())) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_48", new Object[]{this}));
        }
        if (this.getContainer() != null) {
            Namespace ns = this.getImportedNamespace();
            Iterator iter = ns.getContents().iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof Import) || me.getContainer().equals(ns)) continue;
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_49", new Object[]{this}));
            }
        }
        return col;
    }
}

