/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.foundation.MofToJavaMappings;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.NamespaceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jmi.model.Classifier;
import javax.jmi.model.Feature;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.NameNotFoundException;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;
import javax.jmi.reflect.RefObject;

public abstract class GeneralizableElementImpl
extends NamespaceImpl
implements GeneralizableElement {
    static final long serialVersionUID = 3747026269137294568L;
    public static final String VISIBILITY = "visibility";
    public static final String ISABSTRACT = "isAbstract";
    public static final String ISROOT = "isRoot";
    public static final String ISLEAF = "isLeaf";
    public static final String SUPERTYPES = "supertypes";
    protected boolean isAbstract = false;
    protected boolean isRoot = false;
    protected boolean isLeaf = false;
    protected VisibilityKind visibility = VisibilityKindEnum.PUBLIC_VIS;

    public GeneralizableElementImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public GeneralizableElementImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public GeneralizableElementImpl(IRepository repository, String name, boolean isAbstract, boolean isRoot, boolean isLeaf, VisibilityKind visibility) {
        super(repository, name);
        this.initialize();
        this.isAbstract = isAbstract;
        this.isRoot = isRoot;
        this.isLeaf = isLeaf;
        this.visibility = visibility;
    }

    private void initialize() {
        this.visibility = VisibilityKindEnum.PUBLIC_VIS;
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof GeneralizableElementImpl) {
            GeneralizableElementImpl ge = (GeneralizableElementImpl)modelElement;
            this.setVisibility(ge.getVisibility());
            this.setAbstract(ge.isAbstract);
            this.setRoot(ge.isRoot);
            this.setLeaf(ge.isLeaf);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(VISIBILITY) == 0) {
            if (value instanceof String) {
                this.setVisibility(GeneralizableElementImpl.stringToVisibility((String)value));
            } else {
                this.setVisibility((VisibilityKind)value);
            }
        } else if (featureName.compareTo(ISABSTRACT) == 0) {
            if (value instanceof String) {
                this.setAbstract(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setAbstract((Boolean)value);
            }
        } else if (featureName.compareTo(ISROOT) == 0) {
            if (value instanceof String) {
                this.setRoot(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setRoot((Boolean)value);
            }
        } else if (featureName.compareTo(ISLEAF) == 0) {
            if (value instanceof String) {
                this.setLeaf(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setLeaf((Boolean)value);
            }
        } else if (featureName.compareTo(SUPERTYPES) == 0) {
            if (value instanceof List) {
                Iterator iter = ((List)value).iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof GeneralizableElement)) continue;
                    this.getSupertypes().add(o);
                }
            } else {
                this.getSupertypes().add(value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(VISIBILITY) == 0) {
                o = this.getVisibility();
            } else if (featureName.compareTo(ISABSTRACT) == 0) {
                o = new Boolean(this.isAbstract());
            } else if (featureName.compareTo(ISROOT) == 0) {
                o = new Boolean(this.isRoot());
            } else if (featureName.compareTo(ISLEAF) == 0) {
                o = new Boolean(this.isLeaf());
            } else if (featureName.compareTo(SUPERTYPES) == 0) {
                o = this.getSupertypes();
            }
        }
        return o;
    }

    public List allSupertypes() {
        ArrayList<ModelElement> listAll = new ArrayList<ModelElement>();
        List list = this.getModelPackage().getGeneralizes().getSupertype((GeneralizableElement)this);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            List l;
            ModelElement me = (ModelElement)iter.next();
            if (!this.equals(me) && me instanceof GeneralizableElement && (l = ((GeneralizableElement)me).allSupertypes()) != null) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    ModelElement m = (ModelElement)i.next();
                    if (this.equals(m)) {
                        i.remove();
                        continue;
                    }
                    if (this.listContainsModelElement(listAll, m)) continue;
                    listAll.add(m);
                }
            }
            if (this.listContainsModelElement(listAll, me)) continue;
            listAll.add(me);
        }
        return listAll;
    }

    public Collection allSubtypes() {
        HashSet set = new HashSet();
        this.allSubtypes(set);
        return set;
    }

    protected void allSubtypes(Set set) {
        Collection list = this.getModelPackage().getGeneralizes().getSubtype((GeneralizableElement)this);
        if (list != null) {
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ModelElement me = (ModelElement)i.next();
                if (!(me instanceof GeneralizableElementImpl) || set.contains(me)) continue;
                set.add(me);
                ((GeneralizableElementImpl)me).allSubtypes(set);
            }
        }
    }

    private boolean listContainsModelElement(List list, ModelElement me) {
        boolean result = false;
        Iterator i = list.iterator();
        while (i.hasNext() && !result) {
            ModelElement m = (ModelElement)i.next();
            if (me.getName().compareTo(m.getName()) != 0) continue;
            result = true;
        }
        return result;
    }

    public boolean refIsInstanceOf(RefObject objType, boolean considerSubtypes) {
        List superTypes;
        boolean res = super.refIsInstanceOf(objType, considerSubtypes);
        if (!res && (superTypes = this.getSupertypes()) != null) {
            Iterator iter = superTypes.iterator();
            while (!res && iter.hasNext()) {
                RefObject o = (RefObject)iter.next();
                res = o.refIsInstanceOf(objType, considerSubtypes);
            }
        }
        return res;
    }

    public ModelElement lookupElementExtended(String name) throws NameNotFoundException {
        String nm = name;
        nm = MofToJavaMappings.getMofToJavaMappings().getJavaType(nm);
        ModelElement me = null;
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext() && me == null) {
            ModelElement m = (ModelElement)iter.next();
            if (m.getName().compareTo(nm) != 0) continue;
            me = m;
        }
        if (me == null) {
            List sp = this.getSupertypes();
            Iterator i = sp.iterator();
            while (i.hasNext() && me == null) {
                ModelElement m = (ModelElement)i.next();
                if (!(m instanceof GeneralizableElement)) continue;
                try {
                    me = ((GeneralizableElement)m).lookupElementExtended(nm);
                }
                catch (NameNotFoundException e) {
                    me = null;
                }
            }
        }
        return me;
    }

    public List findElementsByTypeExtended(MofClass ofType, boolean includeSubtypes) {
        return null;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean newValue) {
        if (this.isRoot != newValue) {
            this.isRoot = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean newValue) {
        if (this.isLeaf != newValue) {
            this.isLeaf = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean newValue) {
        if (this.isAbstract != newValue) {
            this.isAbstract = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public VisibilityKind getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityKind newValue) {
        if (newValue == null) {
            return;
        }
        boolean dochange = true;
        if (this.visibility != null && this.visibility.equals(newValue)) {
            dochange = false;
        }
        if (dochange) {
            this.visibility = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public List getSupertypes() {
        return this.getModelPackage().getGeneralizes().getSupertype((GeneralizableElement)this);
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        ModelElement me;
        Collection col = super.refVerifyConstraints(deepVerify);
        Iterator iter = this.allSupertypes().iterator();
        while (iter.hasNext()) {
            ModelElement me2 = (ModelElement)iter.next();
            if (this.equals(me2)) {
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_6", new Object[]{this}));
            }
            if (me2 instanceof GeneralizableElement) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_7", new Object[]{this}));
        }
        List superTypes = this.getSupertypes();
        if (superTypes != null) {
            ArrayList list = new ArrayList();
            iter = superTypes.iterator();
            while (iter.hasNext()) {
                me = (ModelElement)iter.next();
                if (!(me instanceof Namespace)) continue;
                list.addAll(((Namespace)me).getContents());
            }
            list.addAll(this.getContents());
            iter = list.iterator();
            while (iter.hasNext()) {
                me = (ModelElement)iter.next();
                if (!(me instanceof Operation)) continue;
                iter.remove();
            }
            ComparatorTypeAndName c = new ComparatorTypeAndName(this);
            Collections.sort(list, c);
            for (int i = 0; i < list.size() - 1; ++i) {
                if (c.compare(list.get(i), list.get(i + 1)) != 0) continue;
                LinkedList listc = new LinkedList();
                listc.add(list.get(i));
                listc.add(list.get(i + 1));
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_8", new Object[]{this}));
            }
        }
        HashMap<String, ModelElement> map = new HashMap<String, ModelElement>();
        iter = this.allSupertypes().iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (map.containsKey(me.getName())) {
                ModelElement me_ = (ModelElement)map.get(me.getName());
                if (me_.equals(me)) continue;
                col = this.addException(col, new JmiVerifyException("MOF_CONSTR_9", new Object[]{this}));
                continue;
            }
            map.put(me.getName(), me);
        }
        if (this.isRoot() && this.getSupertypes().size() > 0) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_10", new Object[]{this}));
        }
        iter = this.getSupertypes().iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (me.isVisible((ModelElement)this)) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_11", new Object[]{this}));
        }
        iter = this.getSupertypes().iterator();
        while (iter.hasNext()) {
            GeneralizableElement ge;
            me = (ModelElement)iter.next();
            if (!(me instanceof GeneralizableElement) || !(ge = (GeneralizableElement)me).isLeaf()) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_12", new Object[]{this}));
        }
        return col;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIsLeaf(boolean isLeaf) {
        this.isLeaf = isLeaf;
    }

    public void setIsRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public void toString(StringBuffer sb) {
        ModelElementImpl me;
        Iterator iter;
        super.toString(sb);
        sb.append("   Supertypes:");
        sb.append(Utilities.SystemLineSeparator);
        Collection l = this.allSupertypes();
        if (l.size() == 0) {
            sb.append("      <no supertypes defined>");
            sb.append(Utilities.SystemLineSeparator);
        } else {
            iter = l.iterator();
            while (iter.hasNext()) {
                me = (ModelElementImpl)iter.next();
                sb.append("      ");
                sb.append(me.getModelElementName());
                sb.append("::");
                sb.append(Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName()));
                sb.append(Utilities.SystemLineSeparator);
                if (!(me instanceof Namespace)) continue;
                Namespace ns = (Namespace)me;
                Iterator iter1 = ns.getContents().iterator();
                while (iter1.hasNext()) {
                    ModelElementImpl me1 = (ModelElementImpl)iter1.next();
                    sb.append("         ");
                    sb.append(me1.getModelElementName());
                    sb.append("::");
                    sb.append(me1.getName());
                    sb.append(Utilities.SystemLineSeparator);
                }
            }
        }
        sb.append("   Subtypes:");
        sb.append(Utilities.SystemLineSeparator);
        l = this.allSubtypes();
        if (l.size() == 0) {
            sb.append("      <no subtypes defined>");
            sb.append(Utilities.SystemLineSeparator);
        } else {
            iter = l.iterator();
            while (iter.hasNext()) {
                me = (ModelElementImpl)iter.next();
                sb.append("      ");
                sb.append(me.getModelElementName());
                sb.append("::");
                sb.append(Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName()));
                sb.append(Utilities.SystemLineSeparator);
            }
        }
    }

    protected class ComparatorTypeAndName
    implements Comparator {
        private GeneralizableElement ge;

        public ComparatorTypeAndName(GeneralizableElement ge) {
            this.ge = ge;
        }

        public int compare(Object o1, Object o2) {
            int res = 0;
            if (o1 != null && o2 != null) {
                res = o1.getClass().getName().compareTo(o2.getClass().getName());
                if (this.ge instanceof Classifier && o1 instanceof Feature && o2 instanceof Feature) {
                    if (res == 0) {
                        String name1 = ((Feature)o1).getName();
                        String name2 = ((Feature)o2).getName();
                        res = name1.compareTo(name2);
                    }
                } else {
                    String mofId1 = null;
                    String mofId2 = null;
                    mofId1 = o1 instanceof ModelElement ? ((ModelElement)o1).refMofId() : "";
                    mofId2 = o2 instanceof ModelElement ? ((ModelElement)o2).refMofId() : "";
                    res = mofId1.compareTo(mofId2);
                }
            }
            if (res < 0) {
                res = -1;
            } else if (res > 0) {
                res = 1;
            }
            return res;
        }
    }
}

