/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.Collection;
import javax.jmi.model.Feature;
import javax.jmi.model.ScopeKind;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;

public abstract class FeatureImpl
extends ModelElementImpl
implements Feature {
    static final long serialVersionUID = 8360633024244716703L;
    public static final String VISIBILITY = "visibility";
    public static final String SCOPE = "scope";
    private VisibilityKind visibility = null;
    private ScopeKind scope = null;

    public FeatureImpl(IRepository repository) {
        super(repository);
        this.initialize();
    }

    public FeatureImpl(IRepository repository, String name) {
        super(repository, name);
        this.initialize();
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof FeatureImpl) {
            FeatureImpl f = (FeatureImpl)modelElement;
            this.setVisibility(f.getVisibility());
            this.setScope(f.getScope());
        }
    }

    private void initialize() {
        this.visibility = VisibilityKindEnum.PUBLIC_VIS;
        this.scope = ScopeKindEnum.INSTANCE_LEVEL;
    }

    public ScopeKind getScope() {
        return this.scope;
    }

    public void setScope(ScopeKind newValue) {
        if (this.scope == null || !this.scope.equals(newValue)) {
            this.scope = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public VisibilityKind getVisibility() {
        return this.visibility;
    }

    public void setVisibility(VisibilityKind newValue) {
        if (this.visibility == null || !this.visibility.equals(newValue)) {
            this.visibility = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(VISIBILITY) == 0) {
            if (value instanceof String) {
                this.setVisibility(FeatureImpl.stringToVisibility((String)value));
            } else {
                this.setVisibility((VisibilityKind)value);
            }
        } else if (featureName.compareTo(SCOPE) == 0) {
            if (value instanceof String) {
                this.setScope(FeatureImpl.stringToScope((String)value));
            } else {
                this.setScope((ScopeKind)value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(VISIBILITY) == 0) {
                o = this.getVisibility();
            } else if (featureName.compareTo(SCOPE) == 0) {
                o = this.getScope();
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        if (this.visibility == null) {
            col = this.addException(col, new JmiVerifyException("2610", new Object[]{this}));
        }
        if (this.scope == null) {
            col = this.addException(col, new JmiVerifyException("2611", new Object[]{this}));
        }
        return col;
    }
}

