/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.TypedElementImpl;
import java.util.Collection;
import javax.jmi.model.Constant;
import javax.jmi.model.PrimitiveType;

public class ConstantImpl
extends TypedElementImpl
implements Constant {
    static final long serialVersionUID = 8301664607121483281L;
    public static final String VALUE = "value";
    private String value = null;

    public ConstantImpl(IRepository repository) {
        super(repository);
    }

    public ConstantImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public ConstantImpl(IRepository repository, String name, String annotation, String value) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setValue(value);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof ConstantImpl) {
            ConstantImpl c = (ConstantImpl)modelElement;
            this.setValue(c.value);
        }
    }

    public String getValue() {
        return this.value;
    }

    public final void setValue(String newValue) {
        if (this.value == null || this.value.compareTo(newValue) != 0) {
            this.value = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(VALUE) == 0) {
            this.setValue((String)value);
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null && featureName.compareTo(VALUE) == 0) {
            o = this.getValue();
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        if (!(this.getValue() instanceof String)) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_52", new Object[]{this}));
        }
        if (!(this.getType() instanceof PrimitiveType)) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_53", new Object[]{this}));
        }
        return col;
    }
}

