/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ClassifierImpl;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Constraint;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKind;
import javax.jmi.model.VisibilityKindEnum;
import javax.jmi.reflect.RefAssociation;
import javax.jmi.reflect.RefObject;

public class AssociationImpl
extends ClassifierImpl
implements Association,
RefAssociation {
    static final long serialVersionUID = 7274225349433862521L;
    public static final String ISDERIVED = "isDerived";
    private boolean derived = false;

    public AssociationImpl(IRepository repository) {
        super(repository);
    }

    public AssociationImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public AssociationImpl(IRepository repository, String name, String annotation, boolean isRoot, boolean isLeaf, boolean isAbstract, VisibilityKind visibility, boolean isDerived) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setRoot(isRoot);
        this.setLeaf(isLeaf);
        this.setAbstract(isAbstract);
        this.setVisibility(visibility);
        this.setDerived(isDerived);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof AssociationImpl) {
            AssociationImpl a = (AssociationImpl)modelElement;
            this.setDerived(a.derived);
        }
    }

    public boolean isDerived() {
        return this.derived;
    }

    public final void setDerived(boolean newValue) {
        if (this.derived != newValue) {
            this.derived = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public Collection refAllLinks() {
        return null;
    }

    public boolean refLinkExists(RefObject firstEnd, RefObject secondEnd) {
        return false;
    }

    public Collection refQuery(RefObject queryEnd, RefObject queryObject) {
        return null;
    }

    public Collection refQuery(String endName, RefObject queryObject) {
        return null;
    }

    public boolean refAddLink(RefObject firstEnd, RefObject secondEnd) {
        return true;
    }

    public boolean refRemoveLink(RefObject firstEnd, RefObject secondEnd) {
        return true;
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(ISDERIVED) == 0) {
            if (value instanceof String) {
                this.setDerived(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setDerived((Boolean)value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null && featureName.compareTo(ISDERIVED) == 0) {
            o = new Boolean(this.isDerived());
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        Iterator iter = this.getContents().iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (me instanceof AssociationEnd || me instanceof Constraint || me instanceof Tag) continue;
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_33", new Object[]{this}));
        }
        if (this.getSupertypes() != null && this.getSupertypes().size() > 0) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_34", new Object[]{this}));
        }
        if (this.isAbstract()) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_36", new Object[]{this}));
        }
        if (!this.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_37", new Object[]{this}));
        }
        int n = 0;
        iter = this.getContents().iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof AssociationEnd)) continue;
            ++n;
        }
        if (n != 2) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_38", new Object[]{this}));
        }
        return col;
    }
}

