/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m2layer.model;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl;
import com.sap.ip.mmr.m2layer.model.TypedElementImpl;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.model.AggregationKind;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MultiplicityType;

public class AssociationEndImpl
extends TypedElementImpl
implements AssociationEnd {
    static final long serialVersionUID = 7566396094763028264L;
    public static final String MULTIPLITICY = "multiplicity";
    public static final String AGGREGATION = "aggregation";
    public static final String ISNAVIGABLE = "isNavigable";
    public static final String ISCHANGEABLE = "isChangeable";
    private MultiplicityType multiplicity = new MultiplicityTypeImpl();
    private AggregationKind aggregation = AggregationKindEnum.NONE;
    private boolean navigable = true;
    private boolean changeable = true;

    public AssociationEndImpl(IRepository repository) {
        super(repository);
    }

    public AssociationEndImpl(IRepository repository, String name) {
        super(repository, name);
    }

    public AssociationEndImpl(IRepository repository, String name, String annotation, boolean isNavigable, AggregationKind aggregation, MultiplicityType multiplicity, boolean isChangeable) {
        super(repository, name);
        this.setAnnotation(annotation);
        this.setNavigable(isNavigable);
        this.setAggregation(aggregation);
        this.setMultiplicity(multiplicity);
        this.setChangeable(isChangeable);
    }

    public void copy(ModelElementImpl modelElement) {
        super.copy(modelElement);
        if (modelElement instanceof AssociationEndImpl) {
            AssociationEndImpl ae = (AssociationEndImpl)modelElement;
            this.setMultiplicity(ae.multiplicity);
            this.setAggregation(ae.aggregation);
            this.setNavigable(ae.navigable);
            this.setChangeable(ae.changeable);
        }
    }

    public AssociationEnd otherEnd() {
        AssociationEnd oe = null;
        Iterator iter = this.getContainer().getContents().iterator();
        while (iter.hasNext() && oe == null) {
            AssociationEnd ae;
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof AssociationEnd) || (ae = (AssociationEnd)me).equals(this)) continue;
            oe = ae;
        }
        return oe;
    }

    public boolean isNavigable() {
        return this.navigable;
    }

    public final void setNavigable(boolean newValue) {
        if (this.navigable != newValue) {
            this.navigable = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public AggregationKind getAggregation() {
        return this.aggregation;
    }

    public final void setAggregation(AggregationKind newValue) {
        if (newValue == null) {
            return;
        }
        if (this.aggregation == null || !this.aggregation.equals(newValue)) {
            this.aggregation = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public MultiplicityType getMultiplicity() {
        return this.multiplicity;
    }

    public final void setMultiplicity(MultiplicityType newValue) {
        if (newValue == null) {
            return;
        }
        if (this.multiplicity == null || !this.multiplicity.equals(newValue)) {
            this.multiplicity = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public boolean isChangeable() {
        return this.changeable;
    }

    public final void setChangeable(boolean newValue) {
        if (this.changeable != newValue) {
            this.changeable = newValue;
            this.setState(StateEnum.STATE_CHANGED);
        }
    }

    public void refSetValue(String featureName, Object value) {
        super.refSetValue(featureName, value);
        if (featureName.compareTo(MULTIPLITICY) == 0) {
            this.setMultiplicity((MultiplicityType)value);
        } else if (featureName.compareTo(AGGREGATION) == 0) {
            this.setAggregation(AssociationEndImpl.stringToAggregation((String)value));
        } else if (featureName.compareTo(ISNAVIGABLE) == 0) {
            if (value instanceof String) {
                this.setNavigable(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setNavigable((Boolean)value);
            }
        } else if (featureName.compareTo(ISCHANGEABLE) == 0) {
            if (value instanceof String) {
                this.setChangeable(Boolean.getBoolean((String)value));
            } else if (value instanceof Boolean) {
                this.setChangeable((Boolean)value);
            }
        }
    }

    public Object refGetValue(String featureName) {
        Object o = super.refGetValue(featureName);
        if (o == null) {
            if (featureName.compareTo(MULTIPLITICY) == 0) {
                o = this.getMultiplicity();
            } else if (featureName.compareTo(AGGREGATION) == 0) {
                o = this.getAggregation();
            } else if (featureName.compareTo(ISNAVIGABLE) == 0) {
                o = new Boolean(this.isNavigable());
            } else if (featureName.compareTo(ISCHANGEABLE) == 0) {
                o = new Boolean(this.isChangeable());
            }
        }
        return o;
    }

    public Collection refVerifyConstraints(boolean deepVerify) {
        Collection col = super.refVerifyConstraints(deepVerify);
        if (!(this.getType() instanceof MofClass)) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_39", new Object[]{this}));
        }
        if (!(this.getMultiplicity().getUpper() <= 1 && this.getMultiplicity().getUpper() >= 0 || this.getMultiplicity().isUnique())) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_40", new Object[]{this}));
        }
        if (this.getMultiplicity().isOrdered() && this.otherEnd().getMultiplicity().isOrdered()) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_41", new Object[]{this}));
        }
        if (!this.getAggregation().equals(AggregationKindEnum.NONE) && !this.otherEnd().getAggregation().equals(AggregationKindEnum.NONE)) {
            col = this.addException(col, new JmiVerifyException("MOF_CONSTR_42", new Object[]{this}));
        }
        col = this.checkMultipliticy(col, this.getMultiplicity());
        return col;
    }
}

