/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.m1layer;

import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MultiplicityType;
import javax.jmi.reflect.CompositionCycleException;
import javax.jmi.reflect.RefBaseObject;
import javax.jmi.reflect.RefFeatured;
import javax.jmi.reflect.RefObject;
import javax.jmi.reflect.WrongSizeException;

public class AttributeMultipleValues
implements List,
Serializable {
    static final long serialVersionUID = 105729722091921952L;
    private MultiplicityType multiplicity = null;
    private List list = new ArrayList();
    private boolean readonly = false;
    private RefFeatured composite = null;

    public AttributeMultipleValues() {
        this.multiplicity = new MultiplicityTypeImpl(0, -1, false, false);
        this.setReadonly(false);
    }

    public AttributeMultipleValues(MultiplicityType multiplicity) {
        this.multiplicity = multiplicity;
        this.setReadonly(false);
    }

    public AttributeMultipleValues(MultiplicityType multiplicity, boolean readonly) {
        this.multiplicity = multiplicity;
        this.setReadonly(readonly);
    }

    public AttributeMultipleValues(MultiplicityType multiplicity, boolean readonly, RefFeatured composite) {
        this.multiplicity = multiplicity;
        this.composite = composite;
        this.setReadonly(readonly);
    }

    private boolean checkComposition(Object o) {
        boolean cce = false;
        if (o == null) {
            return cce;
        }
        if (o.equals(this.composite)) {
            cce = true;
        }
        RefFeatured container = null;
        if (this.composite instanceof RefObject) {
            container = ((RefObject)this.composite).refImmediateComposite();
            while (container != null && !cce) {
                if (container.equals(o)) {
                    cce = true;
                }
                if (container instanceof RefObject) {
                    container = ((RefObject)container).refImmediateComposite();
                    continue;
                }
                container = null;
            }
        }
        if (cce) {
            ModelElement me = null;
            if (o instanceof RefBaseObject) {
                me = (ModelElement)((RefBaseObject)o).refMetaObject();
            }
            throw new CompositionCycleException(o, (RefObject)me);
        }
        return cce;
    }

    private boolean outOfRange(int n) {
        boolean flag = false;
        if (n < 0) {
            flag = true;
        } else if (n < this.multiplicity.getLower()) {
            flag = true;
        } else if (this.multiplicity.getUpper() >= 0 && n > this.multiplicity.getUpper()) {
            flag = true;
        }
        return flag;
    }

    public void add(int arg0, Object arg1) throws WrongSizeException {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        if (arg1 == null) {
            return;
        }
        if (arg0 < 0 || this.outOfRange(arg0)) {
            throw new WrongSizeException(null);
        }
        if (this.checkComposition(arg1)) {
            return;
        }
        if (arg1 instanceof IMMRObject) {
            ((IMMRObject)arg1).set___ImmediateComposite(this.composite);
        }
        this.list.add(arg0, arg1);
    }

    public boolean add(Object arg0) throws WrongSizeException {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        if (arg0 == null) {
            return false;
        }
        if (this.outOfRange(this.size() + 1)) {
            throw new WrongSizeException(null);
        }
        if (this.multiplicity.isUnique() && this.list.contains(arg0)) {
            return false;
        }
        if (this.checkComposition(arg0)) {
            return false;
        }
        if (arg0 instanceof IMMRObject) {
            ((IMMRObject)arg0).set___ImmediateComposite(this.composite);
        }
        return this.list.add(arg0);
    }

    public boolean addAll(Collection arg0) throws WrongSizeException {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        if (arg0 == null) {
            return false;
        }
        if (this.outOfRange(this.size() + arg0.size())) {
            throw new WrongSizeException(null);
        }
        Iterator i = arg0.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (this.checkComposition(o)) {
                return false;
            }
            if (!(o instanceof IMMRObject)) continue;
            ((IMMRObject)o).set___ImmediateComposite(this.composite);
        }
        return this.list.addAll(arg0);
    }

    public boolean addAll(int arg0, Collection arg1) throws WrongSizeException {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        if (arg1 == null) {
            return false;
        }
        if (this.outOfRange(arg0 + arg1.size())) {
            throw new WrongSizeException(null);
        }
        Iterator i = arg1.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (this.checkComposition(o)) {
                return false;
            }
            if (!(o instanceof IMMRObject)) continue;
            ((IMMRObject)o).set___ImmediateComposite(this.composite);
        }
        return this.list.addAll(arg0, arg1);
    }

    public Object get(int arg0) throws WrongSizeException {
        if (this.outOfRange(arg0)) {
            throw new WrongSizeException(null);
        }
        return this.list.get(arg0);
    }

    public Object remove(int arg0) throws WrongSizeException {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        if (this.outOfRange(arg0)) {
            throw new WrongSizeException(null);
        }
        return this.list.remove(arg0);
    }

    public Object set(int arg0, Object arg1) throws WrongSizeException {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        if (this.outOfRange(arg0)) {
            throw new WrongSizeException(null);
        }
        if (this.checkComposition(arg1)) {
            return null;
        }
        if (arg1 instanceof IMMRObject) {
            ((IMMRObject)arg1).set___ImmediateComposite(this.composite);
        }
        return this.list.set(arg0, arg1);
    }

    public List subList(int arg0, int arg1) {
        if (this.outOfRange(arg0) || this.outOfRange(arg1)) {
            throw new WrongSizeException(null);
        }
        return this.list.subList(arg0, arg1);
    }

    public void clear() {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        this.list.clear();
    }

    public boolean contains(Object arg0) {
        return this.list.contains(arg0);
    }

    public boolean containsAll(Collection arg0) {
        return this.list.containsAll(arg0);
    }

    public int indexOf(Object arg0) {
        return this.list.indexOf(arg0);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public int lastIndexOf(Object arg0) {
        return this.list.lastIndexOf(arg0);
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public ListIterator listIterator(int arg0) {
        return this.list.listIterator(arg0);
    }

    public boolean remove(Object arg0) {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        return this.list.remove(arg0);
    }

    public boolean removeAll(Collection arg0) {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        return this.list.removeAll(arg0);
    }

    public boolean retainAll(Collection arg0) {
        if (this.readonly) {
            throw new UnsupportedOperationException();
        }
        return this.list.retainAll(arg0);
    }

    public int size() {
        return this.list.size();
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public Object[] toArray(Object[] arg0) {
        return this.list.toArray(arg0);
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean b) {
        this.readonly = b;
        if (this.readonly) {
            this.list = Collections.unmodifiableList(this.list);
        }
    }

    public RefFeatured getComposite() {
        return this.composite;
    }

    public void setComposite(RefFeatured featured) {
        this.composite = featured;
    }
}

