/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.jdo;

import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.ClassLoaderFactory;
import com.sap.ip.mmr.foundation.FileContent;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.foundation.XMLWriter;
import com.sap.ip.mmr.jdo.JDODescriptorField;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Namespace;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JDODescriptor {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$jdo$JDODescriptor == null ? (class$com$sap$ip$mmr$jdo$JDODescriptor = JDODescriptor.class$("com.sap.ip.mmr.jdo.JDODescriptor")) : class$com$sap$ip$mmr$jdo$JDODescriptor);
    public static final String DISCRIMINATOR = "DISCRIMINATOR";
    String className = null;
    String classTableName = null;
    String superClassName = null;
    String superClassTableName = null;
    String topSuperClassName = null;
    String topSuperClassTableName = null;
    String identityType = "application";
    boolean superClass = false;
    List fields = new ArrayList(10);
    boolean isPackage = false;
    int mofLayer = 1;
    static /* synthetic */ Class class$com$sap$ip$mmr$jdo$JDODescriptor;

    public JDODescriptor() {
    }

    public JDODescriptor(String className) {
        this.className = className;
    }

    public static String getPathJDO(ModelElement modelElement) {
        String path = null;
        if (modelElement instanceof Namespace) {
            path = Utilities.getUtilities().encodeQualifiedName(((Namespace)modelElement).getQualifiedName());
            path = path.replace('.', '/') + ".jdo";
        }
        return path;
    }

    public FileContent getFileContentJDODescriptor(String directory) {
        LinkedList<JDODescriptor> l = new LinkedList<JDODescriptor>();
        l.add(this);
        return JDODescriptor.getFileContentJDODescriptor(directory, l);
    }

    public static FileContent getFileContentJDODescriptor(String directory, Collection descriptors) {
        FileContent fc = new FileContent(JDODescriptor.getTopLevelPackage(descriptors).replace('.', '/') + ".jdo", JDODescriptor.getContentJDODescriptor(directory, descriptors));
        fc.setFiletype(1);
        return fc;
    }

    public static List getFileContentJDODescriptors(String directory, Collection descriptors) {
        ArrayList<FileContent> listFc = new ArrayList<FileContent>(descriptors.size());
        ArrayList<JDODescriptor> list = new ArrayList<JDODescriptor>(1);
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            JDODescriptor jdod = (JDODescriptor)iter.next();
            list.clear();
            list.add(jdod);
            String filename = jdod.getClassName().replace('.', '/') + ".jdo";
            FileContent fc = new FileContent(filename, JDODescriptor.getContentJDODescriptor(directory, list));
            fc.setFiletype(1);
            listFc.add(fc);
        }
        return listFc;
    }

    public static String getPathMAP(ModelElement modelElement) {
        String path = null;
        if (modelElement instanceof Namespace) {
            path = Utilities.getUtilities().encodeQualifiedName(((Namespace)modelElement).getQualifiedName());
            path = path.replace('.', '/') + ".map";
        }
        return path;
    }

    public FileContent getFileContentJDOMapper(String directory) {
        LinkedList<JDODescriptor> l = new LinkedList<JDODescriptor>();
        l.add(this);
        return JDODescriptor.getFileContentJDOMapper(directory, l);
    }

    public static FileContent getFileContentJDOMapper(String directory, Collection descriptors) {
        FileContent fc = new FileContent(JDODescriptor.getTopLevelPackage(descriptors).replace('.', '/') + ".map", JDODescriptor.getContentJDOMapper(directory, descriptors));
        fc.setFiletype(1);
        return fc;
    }

    public static List getFileContentJDOMappers(String directory, Collection descriptors) {
        ArrayList<FileContent> listFc = new ArrayList<FileContent>(descriptors.size());
        ArrayList<JDODescriptor> list = new ArrayList<JDODescriptor>(1);
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            JDODescriptor jdod = (JDODescriptor)iter.next();
            list.clear();
            list.add(jdod);
            String filename = jdod.getClassName().replace('.', '/') + ".map";
            FileContent fc = new FileContent(filename, JDODescriptor.getContentJDOMapper(directory, list));
            fc.setFiletype(1);
            listFc.add(fc);
        }
        return listFc;
    }

    protected static String getContentJDODescriptor(String directory, Collection descriptors) {
        Document document = null;
        DocumentBuilderFactory factory = ClassLoaderFactory.getClassLoaderFactory().getDocumentBuilderFactory(RepositoryServer.getRepositoryServer(), null);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            Repository.category.errorT(location, pce.toString());
            return "";
        }
        Element root = document.createElement("jdo");
        document.appendChild(root);
        int mofLayer = 1;
        Collection packages = JDODescriptor.determinePackages(descriptors);
        Iterator iter = packages.iterator();
        while (iter.hasNext()) {
            String pkgName = (String)iter.next();
            Element elemPack = document.createElement("package");
            elemPack.setAttribute("name", pkgName);
            root.appendChild(elemPack);
            Iterator iter1 = descriptors.iterator();
            while (iter1.hasNext()) {
                JDODescriptor desc = (JDODescriptor)iter1.next();
                mofLayer = desc.getMofLayer();
                if (desc.getClassName().indexOf(pkgName) != 0) continue;
                desc.addJDODescriptor(document, elemPack);
            }
        }
        XMLWriter xmlWriter = new XMLWriter(document);
        xmlWriter.setDtd("jdo");
        xmlWriter.setDtdSystemPath(JDODescriptor.getDTDPath(directory, mofLayer));
        return xmlWriter.toString();
    }

    protected void addJDODescriptor(Document document, Element root) {
        Element elemClass = document.createElement("class");
        elemClass.setAttribute("name", this.className.substring(this.className.lastIndexOf(46) + 1));
        elemClass.setAttribute("identity-type", this.identityType);
        if (this.className == null || this.topSuperClassName == null || this.className.compareTo(this.topSuperClassName) == 0) {
            elemClass.setAttribute("objectid-class", this.getObjectIdClass());
        } else {
            elemClass.setAttribute("persistence-capable-superclass", this.superClassName);
        }
        root.appendChild(elemClass);
        Iterator iter = this.fields.iterator();
        while (iter.hasNext()) {
            JDODescriptorField field = (JDODescriptorField)iter.next();
            if (this.className.compareTo(field.getClassName()) != 0 || field.getName().compareTo(DISCRIMINATOR) == 0) continue;
            Element elem = document.createElement("field");
            elem.setAttribute("name", field.getName());
            elem.setAttribute("persistence-modifier", field.getPersistenceModifier());
            elem.setAttribute("primary-key", String.valueOf(field.isPrimaryKey()));
            elem.setAttribute("default-fetch-group", String.valueOf(field.isDefaultFetchGroup()));
            if (!field.isEmbedded()) {
                elem.setAttribute("embedded", "false");
            }
            if (field.getCollectionType() != null) {
                elem.setAttribute("embedded", "false");
                Element elemCT = document.createElement("collection");
                elemCT.setAttribute("element-type", field.getCollectionType());
                elem.appendChild(elemCT);
            }
            elemClass.appendChild(elem);
        }
    }

    protected static String getContentJDOMapper(String directory, Collection descriptors) {
        Document document = null;
        DocumentBuilderFactory factory = ClassLoaderFactory.getClassLoaderFactory().getDocumentBuilderFactory(RepositoryServer.getRepositoryServer(), null);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (ParserConfigurationException pce) {
            Repository.category.errorT(location, pce.toString());
            return "";
        }
        Element root = document.createElement("map");
        root.setAttribute("version", "0.3");
        document.appendChild(root);
        int mofLayer = 1;
        Collection packages = JDODescriptor.determinePackages(descriptors);
        Iterator iter = packages.iterator();
        while (iter.hasNext()) {
            String pkgName = (String)iter.next();
            Element elemPack = document.createElement("package");
            elemPack.setAttribute("name", pkgName);
            root.appendChild(elemPack);
            Iterator iter1 = descriptors.iterator();
            while (iter1.hasNext()) {
                JDODescriptor desc = (JDODescriptor)iter1.next();
                mofLayer = desc.getMofLayer();
                if (desc.getClassName().indexOf(pkgName) != 0) continue;
                desc.addJDOMapper(document, elemPack);
            }
        }
        XMLWriter xmlWriter = new XMLWriter(document);
        xmlWriter.setDtd("map");
        xmlWriter.setDtdSystemPath(JDODescriptor.getDTDPath(directory, mofLayer));
        return xmlWriter.toString();
    }

    protected void addJDOMapper(Document document, Element root) {
        Element elemClass = document.createElement("class");
        elemClass.setAttribute("name", this.className.substring(this.className.lastIndexOf(46) + 1));
        root.appendChild(elemClass);
        if (this.getClassTableName() != null && this.isSuperClass()) {
            Element elemDisc = document.createElement("discriminator");
            elemClass.appendChild(elemDisc);
            Element elem = document.createElement("column");
            elem.setAttribute("name", DISCRIMINATOR);
            elem.setAttribute("table", this.getClassTableName());
            elemDisc.appendChild(elem);
        }
        Iterator iter = this.fields.iterator();
        while (iter.hasNext()) {
            Element elemField;
            JDODescriptorField field = (JDODescriptorField)iter.next();
            if (field.getName().compareTo(DISCRIMINATOR) == 0) continue;
            if (field.isEmbedded()) {
                elemField = document.createElement("field");
                elemField.setAttribute("name", field.getName());
                elemClass.appendChild(elemField);
                Element elem = document.createElement("column");
                elem.setAttribute("table", field.getDbTable());
                elem.setAttribute("name", field.getDbField());
                elemField.appendChild(elem);
                continue;
            }
            elemField = document.createElement("relationship-field");
            elemField.setAttribute("name", field.getName());
            elemField.setAttribute("multiplicity", field.getMultiplicityAsString());
            elemField.setAttribute("update", "true");
            elemClass.appendChild(elemField);
        }
    }

    protected static String getTopLevelPackage(Collection descriptors) {
        String topLevelPackageName = null;
        Collection col = JDODescriptor.determinePackages(descriptors);
        Iterator iter = col.iterator();
        while (iter.hasNext() && topLevelPackageName == null) {
            String top;
            String name = (String)iter.next();
            int n = name.indexOf(46);
            if (n <= 0) continue;
            topLevelPackageName = top = name.substring(0, n);
        }
        if (topLevelPackageName == null) {
            topLevelPackageName = "com";
        }
        return topLevelPackageName;
    }

    protected static Collection determinePackages(Collection descriptors) {
        TreeSet<String> packages = new TreeSet<String>();
        Iterator iter = descriptors.iterator();
        while (iter.hasNext()) {
            JDODescriptor desc = (JDODescriptor)iter.next();
            String name = desc.getClassName();
            int idx = name.lastIndexOf(46);
            String pkgName = idx > 0 ? name.substring(0, idx) : name;
            if (packages.contains(pkgName)) continue;
            packages.add(pkgName);
        }
        return packages;
    }

    protected static String getDTDPath(String directory, int mofLayer) {
        StringBuffer buf = new StringBuffer(128);
        buf.append("file:");
        buf.append(directory);
        buf.append('/');
        return buf.toString().replace('\\', '/');
    }

    public void addField(JDODescriptorField field) {
        this.fields.add(field);
    }

    public void addField(String className, String name, boolean primaryKey, String dbTable, String dbField, String collectionType) {
        JDODescriptorField field = new JDODescriptorField(className, name, null, primaryKey, dbTable, dbField, collectionType);
        this.fields.add(field);
    }

    public void addField(String className, String name, boolean primaryKey, String dbTable, String dbField) {
        JDODescriptorField field = new JDODescriptorField(className, name, null, primaryKey, dbTable, dbField, null);
        this.fields.add(field);
    }

    public void addField(String className, String name, boolean primaryKey) {
        JDODescriptorField field = new JDODescriptorField(className, name, null, primaryKey, null, null, null);
        this.fields.add(field);
    }

    public void addField(String className, String name, String persistenceModifier, boolean primaryKey) {
        JDODescriptorField field = new JDODescriptorField(className, name, persistenceModifier, primaryKey, null, null, null);
        this.fields.add(field);
    }

    public String getClassName() {
        return this.className;
    }

    public String getIdentityType() {
        return this.identityType;
    }

    public String getObjectIdClass() {
        String objectIdClass = this.className.substring(this.className.lastIndexOf(46) + 1);
        return objectIdClass + "$" + objectIdClass + "ID";
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setIdentityType(String identityType) {
        this.identityType = identityType;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public String getTopSuperClassName() {
        return this.topSuperClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public void setTopSuperClassName(String topSuperClassName) {
        this.topSuperClassName = topSuperClassName;
    }

    public String getTopSuperClassTableName() {
        return this.topSuperClassTableName;
    }

    public void setTopSuperClassTableName(String topSuperClassTableName) {
        this.topSuperClassTableName = topSuperClassTableName;
    }

    public String getSuperClassTableName() {
        return this.superClassTableName;
    }

    public void setSuperClassTableName(String superClassTableName) {
        this.superClassTableName = superClassTableName;
    }

    public String getClassTableName() {
        return this.classTableName;
    }

    public void setClassTableName(String classTableName) {
        this.classTableName = classTableName;
    }

    public boolean isSuperClass() {
        return this.superClass;
    }

    public void setSuperClass(boolean superClass) {
        this.superClass = superClass;
    }

    public boolean isPackage() {
        return this.isPackage;
    }

    public void setIsPackage(boolean isPackage) {
        this.isPackage = isPackage;
    }

    public int getMofLayer() {
        return this.mofLayer;
    }

    public void setMofLayer(int mofLayer) {
        this.mofLayer = mofLayer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

