/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.jdo;

import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.FileContent;
import com.sap.ip.mmr.generate.jmi.Generator;
import com.sap.ip.mmr.jdo.JDODescriptor;
import com.sap.ip.mmr.m2layer.IModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jmi.model.Association;
import javax.jmi.model.Classifier;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofPackage;

public class GeneratorDescriptors {
    public static final int FIELD_NAME_MAX_SIZE = 30;
    private List descriptors = new ArrayList(100);
    private IRepositoryServer repositoryServer = RepositoryServer.getRepositoryServer();
    private Map typeToDB = null;
    private Map typeSizeToDB = null;

    public GeneratorDescriptors() {
        this.initialize();
    }

    public static Collection getPathsOfDescriptors(Collection modelElements) {
        ArrayList<String> paths = new ArrayList<String>();
        if (modelElements != null) {
            Iterator iter = modelElements.iterator();
            while (iter.hasNext()) {
                IModelElement me = (IModelElement)iter.next();
                paths.add(JDODescriptor.getPathJDO(me));
                paths.add(JDODescriptor.getPathMAP(me));
            }
        }
        return paths;
    }

    private void initialize() {
        if (this.typeToDB == null) {
            this.typeToDB = new HashMap(30);
            this.typeToDB.put("any", new Integer(7));
            this.typeToDB.put("string", new Integer(1));
            this.typeToDB.put("boolean", new Integer(8));
            this.typeToDB.put("float", new Integer(5));
            this.typeToDB.put("time", new Integer(1));
            this.typeToDB.put("unlimitedinteger", new Integer(1));
            this.typeToDB.put("integer", new Integer(4));
            this.typeToDB.put("name", new Integer(1));
        }
        if (this.typeSizeToDB == null) {
            this.typeSizeToDB = new HashMap(30);
            this.typeSizeToDB.put("any", new Integer(1));
            this.typeSizeToDB.put("string", new Integer(32));
            this.typeSizeToDB.put("boolean", new Integer(1));
            this.typeSizeToDB.put("float", new Integer(14));
            this.typeSizeToDB.put("time", new Integer(32));
            this.typeSizeToDB.put("unlimitedinteger", new Integer(64));
            this.typeSizeToDB.put("integer", new Integer(10));
            this.typeSizeToDB.put("name", new Integer(64));
        }
    }

    private int getTypeOfDB(String typeName) {
        Object o;
        int tp = 1;
        if (typeName != null && (o = this.typeToDB.get(typeName.toLowerCase())) != null) {
            tp = (Integer)o;
        }
        return tp;
    }

    private int getTypeSizeOfDB(String typeName) {
        Object o;
        int size = 32;
        if (typeName != null && (o = this.typeSizeToDB.get(typeName.toLowerCase())) != null) {
            size = (Integer)o;
        }
        return size;
    }

    public void addDescriptor(JDODescriptor descriptor) {
        this.descriptors.add(descriptor);
    }

    public void addModelElements(Collection modelElements) {
        Iterator iter = modelElements.iterator();
        while (iter.hasNext()) {
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof MofClass)) continue;
            this.addMofClass((MofClass)me);
            this.addMofInstance((MofClass)me);
        }
    }

    protected void addMofPackage(MofPackage mofPackage, boolean isInterface) {
        if (mofPackage.getContainer() == null) {
            return;
        }
    }

    protected void addMofClass(MofClass mofClass) {
    }

    protected void addMofInstance(MofClass mofClass) {
    }

    protected int getFieldType(Classifier type) {
        return this.getTypeOfDB(type.getName());
    }

    protected int getFieldTypeSize(Classifier type) {
        return this.getTypeSizeOfDB(type.getName());
    }

    protected void addAssociation(Association association, boolean isInterface) {
    }

    protected void addCommonFields(JDODescriptor jdoDesc, String className, String tableName) {
        jdoDesc.addField(className, Generator.composeVariableName("MofId", true), true, tableName, GeneratorDescriptors.getFieldName(Generator.composeVariableName("MofId", true)));
    }

    public Collection generateFileContents(String directory, boolean separateFiles) {
        int n = 2;
        if (separateFiles) {
            n *= this.descriptors.size();
        }
        ArrayList<FileContent> fcs = new ArrayList<FileContent>(n);
        if (!separateFiles) {
            fcs.add(JDODescriptor.getFileContentJDODescriptor(directory, this.descriptors));
            fcs.add(JDODescriptor.getFileContentJDOMapper(directory, this.descriptors));
        } else {
            fcs.addAll(JDODescriptor.getFileContentJDODescriptors(directory, this.descriptors));
            fcs.addAll(JDODescriptor.getFileContentJDOMappers(directory, this.descriptors));
        }
        return fcs;
    }

    public static String getFieldName(String variableName) {
        String fieldName = null;
        if (variableName != null) {
            fieldName = variableName.toUpperCase().substring("__".length());
        }
        if (fieldName.length() > 30) {
            fieldName = fieldName.substring(0, 30);
        }
        return fieldName;
    }
}

