/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.Generator;
import com.sap.tc.logging.Location;
import java.util.Iterator;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Feature;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Reference;
import javax.jmi.model.VisibilityKindEnum;

public class GeneratorReferenceTemplate {
    protected static final transient Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$generate$jmi$GeneratorReferenceTemplate == null ? (class$com$sap$ip$mmr$generate$jmi$GeneratorReferenceTemplate = GeneratorReferenceTemplate.class$("com.sap.ip.mmr.generate.jmi.GeneratorReferenceTemplate")) : class$com$sap$ip$mmr$generate$jmi$GeneratorReferenceTemplate);
    static /* synthetic */ Class class$com$sap$ip$mmr$generate$jmi$GeneratorReferenceTemplate;

    public void generateTemplate(StringBuffer code, Reference reference, boolean noJavaDocs, boolean generateInterfaces) {
        String typeOfReference = Generator.getReferenceType(reference, true);
        if (reference.getReferencedEnd().isNavigable()) {
            if (reference.getMultiplicity().getUpper() == 1) {
                this.addAccessorTemplate(code, reference, typeOfReference, generateInterfaces);
            } else if (!reference.getMultiplicity().isOrdered()) {
                this.addAccessorTemplate(code, reference, typeOfReference, generateInterfaces);
            } else {
                this.addAccessorTemplate(code, reference, typeOfReference, generateInterfaces);
            }
            if (reference.isChangeable() && reference.getMultiplicity().getUpper() == 1) {
                this.addMutatorTemplate(code, reference, typeOfReference, generateInterfaces);
            }
        }
    }

    private void addAccessorTemplate(StringBuffer code, Reference reference, String referenceType, boolean generateInterfaces) {
        String method = "addAccessorTemplate(StringBuffer code,Reference reference,String referenceType,boolean generateInterfaces)";
        if (!generateInterfaces || reference.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) {
            Generator.generateAnnotationTemplate(code, (ModelElement)reference);
            code.append(Generator.mapVisibilityToJava((Feature)reference));
            code.append(' ');
            code.append(referenceType);
            code.append(" get");
            code.append(Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)reference)));
            code.append(' ');
            if (generateInterfaces) {
                code.append("() throws javax.jmi.reflect.JmiException;");
            } else {
                code.append("() {");
                code.append(Utilities.SystemLineSeparator);
                AssociationEnd ae = reference.getReferencedEnd();
                if (ae == null) {
                    RepositoryServer.getCategory().errorT(location, "addAccessorTemplate(StringBuffer code,Reference reference,String referenceType,boolean generateInterfaces)", MMRResourceAccessor.getInstance().getMessageText("2506"), new Object[]{reference});
                    code.append(" return (" + referenceType + ") null;");
                    code.append(Utilities.SystemLineSeparator);
                } else {
                    code.append("  java.util.List list = ");
                    Association assoc = (Association)ae.getContainer();
                    this.getCallsAssoc(code, assoc);
                    String qn = Utilities.getUtilities().encodeQualifiedName(assoc.getQualifiedName());
                    String methodName = this.isFirstAssocEnd(assoc, reference.getReferencedEnd()) ? "querySecondEnd" : "queryFirstEnd";
                    code.append("." + methodName + "(\"" + qn + "\",this);");
                    code.append(Utilities.SystemLineSeparator);
                    if (ae.getMultiplicity().getUpper() == 1) {
                        code.append("java.lang.Object o = null;");
                        code.append(Utilities.SystemLineSeparator);
                        code.append("if (list != null && list.size() > 0) {");
                        code.append(Utilities.SystemLineSeparator);
                        code.append("    o = list.iterator().next();");
                        code.append(Utilities.SystemLineSeparator);
                        code.append("  }");
                        code.append(Utilities.SystemLineSeparator);
                        code.append(" return (" + referenceType + ") o;");
                        code.append(Utilities.SystemLineSeparator);
                    } else {
                        code.append(" return (" + referenceType + ") list;");
                        code.append(Utilities.SystemLineSeparator);
                    }
                }
                code.append("}");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }

    private void getCallsAssoc(StringBuffer code, Association assoc) {
        code.append("___repository.getAssociationsContainer(IRepositoryConst.LAYER_1)");
    }

    private void addMutatorTemplate(StringBuffer code, Reference reference, String referenceType, boolean generateInterfaces) {
        if (!generateInterfaces || reference.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) {
            Generator.generateAnnotationTemplate(code, (ModelElement)reference);
            code.append(Generator.mapVisibilityToJava((Feature)reference));
            code.append(" void set");
            code.append(Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)reference)));
            code.append(" (");
            code.append(referenceType);
            code.append(" newValue) ");
            if (generateInterfaces) {
                code.append("throws javax.jmi.reflect.JmiException;");
            } else {
                code.append("{");
                Association assoc = (Association)reference.getReferencedEnd().getContainer();
                this.getCallsAssoc(code, assoc);
                String qn = Utilities.getUtilities().encodeQualifiedName(assoc.getQualifiedName());
                if (this.isFirstAssocEnd(assoc, reference.getReferencedEnd())) {
                    code.append(".refAddLink(\"" + qn + "\",newValue,this);");
                } else {
                    code.append(".refAddLink(\"" + qn + "\",this,newValue);");
                }
                code.append("}");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }

    private boolean isFirstAssocEnd(Association assoc, AssociationEnd assocEnd) {
        int n = 0;
        Iterator iter = assoc.getContents().iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof AssociationEnd)) continue;
            ++n;
            if (!assocEnd.equals(o)) continue;
            break;
        }
        return n == 1;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

