/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.Generator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jmi.model.DirectionKindEnum;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofException;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.Parameter;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKindEnum;

public class GeneratorOperationTemplate {
    public static final String TYPE_VOID = "void";

    public void generateTemplate(StringBuffer code, Operation operation, boolean noJavaDocs, boolean generateInterfaces) {
        Generator.generateAnnotationTemplate(code, (ModelElement)operation);
        HashSet<String> namesP = new HashSet<String>();
        HashSet<String> namesE = new HashSet<String>();
        LinkedList<Parameter> parameters = new LinkedList<Parameter>();
        LinkedList exceptions = new LinkedList();
        Iterator iter = Generator.getAllContent((ModelElement)operation).iterator();
        Parameter pReturn = null;
        Tag tagCoding = null;
        while (iter.hasNext()) {
            Tag tag;
            Object o = iter.next();
            if (o instanceof Parameter) {
                Parameter p = (Parameter)o;
                if (!namesP.contains(p.getName())) {
                    if (p.getDirection().equals(DirectionKindEnum.RETURN_DIR)) {
                        pReturn = p;
                    } else {
                        parameters.add(p);
                    }
                }
                namesP.add(p.getName());
                continue;
            }
            if (o instanceof MofException) {
                MofException e = (MofException)o;
                if (namesE.contains(e.getName())) {
                    exceptions.add(o);
                }
                namesE.add(e.getName());
                continue;
            }
            if (!(o instanceof Tag) || (tag = (Tag)o).getTagId().compareTo("com.sap.ip.mmr.OperationCodeJava") != 0) continue;
            tagCoding = tag;
        }
        exceptions.addAll(operation.getExceptions());
        String typeReturn = TYPE_VOID;
        if (pReturn != null) {
            typeReturn = GeneratorOperationTemplate.getParameterType(pReturn);
        }
        String oname = Generator.getJMIIdentifier((ModelElement)operation);
        String operationName = Generator.getOperationPrefix(operation) + Generator.convertFirstCharToLower(oname);
        this.generateOperation(generateInterfaces, code, operation, operationName, typeReturn, parameters, exceptions, tagCoding);
        code.append(Utilities.SystemLineSeparator);
    }

    public static String getParameterType(Parameter p) {
        String type = null;
        type = Generator.isJavaType(p.getType().getName()) ? (p.getDirection().equals(DirectionKindEnum.IN_DIR) || p.getDirection().equals(DirectionKindEnum.RETURN_DIR) ? (p.getMultiplicity().getLower() == 0 && p.getMultiplicity().getUpper() == 1 ? Generator.getJavaTypeClass(Generator.getType(p.getType(), true)) : (p.getMultiplicity().getLower() == 1 && p.getMultiplicity().getUpper() == 1 ? Generator.getType(p.getType(), true) : (p.getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection"))) : (p.getMultiplicity().getLower() == 0 && p.getMultiplicity().getUpper() == 1 ? Generator.getJavaTypeClass(Generator.getType(p.getType(), true)) + "[]" : (p.getMultiplicity().getLower() == 1 && p.getMultiplicity().getUpper() == 1 ? Generator.getType(p.getType(), true) + "[]" : (p.getMultiplicity().isOrdered() ? "java.util.List[]" : "java.util.Collection[]")))) : (p.getDirection().equals(DirectionKindEnum.IN_DIR) || p.getDirection().equals(DirectionKindEnum.RETURN_DIR) ? (p.getMultiplicity().getLower() == 0 && p.getMultiplicity().getUpper() == 1 ? Generator.getType(p.getType(), true) : (p.getMultiplicity().getLower() == 1 && p.getMultiplicity().getUpper() == 1 ? Generator.getType(p.getType(), true) : (p.getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection"))) : (p.getMultiplicity().getLower() == 0 && p.getMultiplicity().getUpper() == 1 ? Generator.getType(p.getType(), true) + "[]" : (p.getMultiplicity().getLower() == 1 && p.getMultiplicity().getUpper() == 1 ? Generator.getType(p.getType(), true) + "[]" : (p.getMultiplicity().isOrdered() ? "java.util.List[]" : "java.util.Collection[]"))));
        return type;
    }

    private void generateOperation(boolean generateInterfaces, StringBuffer code, Operation operation, String operationName, String typeReturn, List parameters, List exceptions, Tag tagCoding) {
        if (generateInterfaces && !operation.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS)) {
            return;
        }
        code.append("public ");
        code.append(typeReturn);
        code.append(' ');
        code.append(operationName);
        code.append('(');
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            Parameter p = (Parameter)iter.next();
            String type = GeneratorOperationTemplate.getParameterType(p);
            code.append(type);
            code.append(' ');
            code.append(Generator.convertFirstCharToLower(Generator.getJMIIdentifier((ModelElement)p)));
            if (!iter.hasNext()) continue;
            code.append(", ");
        }
        code.append(") throws ");
        if (exceptions.size() > 0) {
            iter = exceptions.iterator();
            while (iter.hasNext()) {
                MofException e = (MofException)iter.next();
                code.append(Generator.getJMIIdentifierQualified((Namespace)e));
                code.append(", ");
            }
        }
        code.append("javax.jmi.reflect.JmiException");
        if (generateInterfaces) {
            code.append(';');
            code.append(Utilities.SystemLineSeparator);
        } else {
            code.append(" {");
            code.append(Utilities.SystemLineSeparator);
            if (tagCoding != null) {
                code.append("//MMR This code is included by the Tag tagId=");
                code.append(tagCoding.getTagId());
                code.append(", name=");
                code.append(tagCoding.getName());
                code.append(Utilities.SystemLineSeparator);
                code.append(Utilities.SystemLineSeparator);
                List list = tagCoding.getValues();
                if (list == null) {
                    if (typeReturn.compareTo(TYPE_VOID) != 0) {
                        code.append("  return ");
                        code.append(Generator.getJavaReturnInitialValueByType(typeReturn));
                        code.append(';');
                        code.append(Utilities.SystemLineSeparator);
                    }
                } else {
                    Iterator iterCode = list.iterator();
                    while (iterCode.hasNext()) {
                        Object o = iterCode.next();
                        code.append(o.toString());
                        if (!iterCode.hasNext()) continue;
                        code.append(Utilities.SystemLineSeparator);
                    }
                }
                code.append(Utilities.SystemLineSeparator);
                code.append("//MMR End of code of Tag tagId=");
                code.append(tagCoding.getTagId());
                code.append(", name=");
                code.append(Generator.getJMIIdentifier((ModelElement)tagCoding));
                code.append(Utilities.SystemLineSeparator);
            } else if (typeReturn.compareTo(TYPE_VOID) != 0) {
                code.append("  return ");
                code.append(Generator.getJavaReturnInitialValueByType(typeReturn));
                code.append(';');
                code.append(Utilities.SystemLineSeparator);
            }
            code.append("}");
            code.append(Utilities.SystemLineSeparator);
        }
    }
}

