/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.generate.jmi;

import com.sap.ip.mmr.IRepository;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.generate.jmi.AttributeWithType;
import com.sap.ip.mmr.generate.jmi.CodeContainer;
import com.sap.ip.mmr.generate.jmi.GeneratorAssociation;
import com.sap.ip.mmr.generate.jmi.GeneratorAttributeTemplate;
import com.sap.ip.mmr.generate.jmi.GeneratorClass;
import com.sap.ip.mmr.generate.jmi.GeneratorConstantTemplate;
import com.sap.ip.mmr.generate.jmi.GeneratorDataType;
import com.sap.ip.mmr.generate.jmi.GeneratorEnumerationType;
import com.sap.ip.mmr.generate.jmi.GeneratorException;
import com.sap.ip.mmr.generate.jmi.GeneratorInstance;
import com.sap.ip.mmr.generate.jmi.GeneratorOperationTemplate;
import com.sap.ip.mmr.generate.jmi.GeneratorPackage;
import com.sap.ip.mmr.generate.jmi.GeneratorReferenceTemplate;
import com.sap.ip.mmr.generate.jmi.GeneratorStructureType;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import com.sap.ip.mmr.m2layer.model.NamespaceImpl;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.jmi.model.AggregationKindEnum;
import javax.jmi.model.AliasType;
import javax.jmi.model.Association;
import javax.jmi.model.AssociationEnd;
import javax.jmi.model.Attribute;
import javax.jmi.model.Classifier;
import javax.jmi.model.CollectionType;
import javax.jmi.model.Constant;
import javax.jmi.model.DataType;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.Feature;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.Import;
import javax.jmi.model.ModelElement;
import javax.jmi.model.MofClass;
import javax.jmi.model.MofException;
import javax.jmi.model.MofPackage;
import javax.jmi.model.Namespace;
import javax.jmi.model.Operation;
import javax.jmi.model.PrimitiveType;
import javax.jmi.model.Reference;
import javax.jmi.model.ScopeKindEnum;
import javax.jmi.model.StructuralFeature;
import javax.jmi.model.StructureField;
import javax.jmi.model.StructureType;
import javax.jmi.model.Tag;
import javax.jmi.model.VisibilityKindEnum;

public class Generator {
    public static final String GENERATOR_VERSION = "1.1.1";
    public static final String GENERATOR_VERSION_MIN = "1.1.1";
    public static final String JMI_TAG_PACKAGE_PREFIX = "javax.jmi.packagePrefix";
    public static final String JMI_TAG_SUBSTITUTE_NAME = "javax.jmi.substituteName";
    public static final String JMI_TAG_METHOD_PREFIX = "javax.jmi.methodPrefix";
    public static final String JMI_TAG_LIFECYCLE = "javax.jmi.ignoreLifecycle";
    public static final String EXTENSION_PACKAGE = "Package";
    public static final String EXTENSION_IMPLEMENTATION = "Impl";
    public static final String EXTENSION_CLASS = "Class";
    public static final String EXTENSION_ENUM = "Enum";
    public static final String EXTENSION_EXCEPTION = "Exception";
    public static final String BOOLEAN = "BOOLEAN";
    public static final String VARIABLE_PREFIX = "__";
    public static final String VARIABLE_MOFID = "MofId";
    public static final String VARIABLE_STATE = "state";
    public static final String VARIABLE_GENVERS = "generatorVersion";
    public static final String VARIABLE_REPOSITORY = "repository";
    public static final String VARIABLE_METAOBJECT = "metaObject";
    public static final String VARIABLE_REFINSTANCES = "refInstances";
    public static final String VARIABLE_ASSOCIATIONIMPL = "associationImpl";
    public static final String VARIABLE_ASSOCIATIONID = "associationId";
    public static final String VARIABLE_ASSOCIATION_END_1 = "aeFirst";
    public static final String VARIABLE_ASSOCIATION_END_2 = "aeSecond";
    public static final String VARIABLE_INSTANTIATOR = "instantiator";
    public static final String VARIABLE_LOCATION = "location";
    public static final String VARIABLE_COMPOSITE = "composite";
    public static final String VARIABLE_CREATEDAT = "createdAt";
    public static final String VARIABLE_CREATEDBY = "createdBy";
    public static final String VARIABLE_LASTCHANGEDAT = "lastChangedAt";
    public static final String VARIABLE_LASTCHANGEDBY = "lastChangedBy";
    public static final String VARIABLE_RELEASE = "release";
    public static final String VARIABLE_DEPRECATED = "deprecated";
    private static GeneratorPackage generatorPackage = null;
    private static GeneratorClass generatorClass = null;
    private static GeneratorException generatorException = null;
    private static GeneratorInstance generatorInstance = null;
    private static GeneratorAssociation generatorAssociation = null;
    private static GeneratorDataType generatorDataType = null;
    private static GeneratorEnumerationType generatorEnumerationType = null;
    private static GeneratorStructureType generatorStructureType = null;
    private static GeneratorConstantTemplate generatorConstantTemplate = null;
    private static GeneratorAttributeTemplate generatorAttributeTemplate = null;
    private static GeneratorReferenceTemplate generatorReferenceTemplate = null;
    private static GeneratorOperationTemplate generatorOperationTemplate = null;
    public static final String PREFIX_MOF = "MOF";
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$generate$jmi$Generator == null ? (class$com$sap$ip$mmr$generate$jmi$Generator = Generator.class$("com.sap.ip.mmr.generate.jmi.Generator")) : class$com$sap$ip$mmr$generate$jmi$Generator);
    public static final String[] tableKeywordsJava = new String[]{"abstract", "default", "if", "private", "this", "boolean", "do", "implements", "protected", "throw", "break", "double", "import", "public", "throws", "byte", "else", "instanceof", "return", "transient", "case", "extends", "int", "short", "try", "catch", "final", "interface", "static", "void", "char", "finally", "long", "strictfp", "volatile", "class", "float", "native", "super", "while", "const", "for", "new", "switch", "continue", "goto", "package", "synchronized"};
    private static Set keywordsJava = null;
    public static final String[] tableKeywordsJavaForClass = new String[]{"package", "class", "exception", "interface"};
    private static Set keywordsJavaForClass = null;
    public static final String[] tableDataTypeMappings = new String[]{"any", "java.lang.Object", "boolean", "boolean", "float", "float", "double", "double", "integer", "int", "short", "short", "long", "long", "character", "char", "string", "java.lang.String", "name", "java.lang.String", "time", "java.lang.String", "unlimitedinteger", "int"};
    private static Map dataTypeMappings = null;
    private boolean noJavaDocs = false;
    static /* synthetic */ Class class$com$sap$ip$mmr$generate$jmi$Generator;

    public Generator(boolean noJavaDocs) {
        this.noJavaDocs = noJavaDocs;
        Generator.initialize();
    }

    private static void initialize() {
        int i;
        if (keywordsJava == null) {
            keywordsJava = new HashSet(tableKeywordsJava.length);
            for (i = 0; i < tableKeywordsJava.length; ++i) {
                keywordsJava.add(tableKeywordsJava[i]);
            }
        }
        if (keywordsJavaForClass == null) {
            keywordsJavaForClass = new HashSet(tableKeywordsJavaForClass.length);
            for (i = 0; i < tableKeywordsJavaForClass.length; ++i) {
                keywordsJavaForClass.add(tableKeywordsJavaForClass[i]);
            }
        }
        if (dataTypeMappings == null) {
            dataTypeMappings = new HashMap(tableDataTypeMappings.length);
            for (i = 0; i < tableDataTypeMappings.length; i += 2) {
                dataTypeMappings.put(tableDataTypeMappings[i], tableDataTypeMappings[i + 1]);
            }
        }
    }

    public static boolean getIgnoreLifeCycle(ModelElement me) {
        Tag tag;
        boolean ignoreLifeCycle = false;
        MofPackage p = null;
        for (Namespace ns = me.getContainer(); ns != null && p == null; ns = ns.getContainer()) {
            if (!(ns instanceof MofPackage)) continue;
            p = (MofPackage)ns;
        }
        if (p != null && (tag = Generator.getTag(p, JMI_TAG_LIFECYCLE)) != null) {
            String value = (String)tag.getValues().get(0) + '.';
            if (value.compareToIgnoreCase("true") == 0) {
                ignoreLifeCycle = true;
            } else if (value.compareToIgnoreCase("false") == 0) {
                ignoreLifeCycle = false;
            }
        }
        return ignoreLifeCycle;
    }

    public static String getOperationPrefix(Operation o) {
        Tag tag;
        String prefix = "";
        MofPackage p = null;
        for (Namespace ns = o.getContainer(); ns != null && p == null; ns = ns.getContainer()) {
            if (!(ns instanceof MofPackage)) continue;
            p = (MofPackage)ns;
        }
        if (p != null && (tag = Generator.getTag(p, JMI_TAG_METHOD_PREFIX)) != null) {
            prefix = (String)tag.getValues().get(0) + '.';
        }
        return prefix;
    }

    public static String getSubstituteIdentifier(ModelElement me) {
        Tag tag;
        String ident = null;
        if (me instanceof Namespace && (tag = Generator.getTag((Namespace)me, JMI_TAG_SUBSTITUTE_NAME)) != null) {
            ident = (String)tag.getValues().get(0);
        }
        return ident;
    }

    public static Tag getTag(Namespace ns, String tagId) {
        Tag tag = null;
        Iterator iter = ns.getContents().iterator();
        while (iter.hasNext() && tag == null) {
            Tag t;
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof Tag) || (t = (Tag)me).getTagId().compareTo(tagId) != 0) continue;
            tag = t;
        }
        return tag;
    }

    public Collection getTasksDependsOn() {
        return null;
    }

    public static String getJMIPathOfModelElement(String directory, ModelElement modelElement, boolean forInterface, boolean forClassProxy) {
        String pathSources = directory.replace('\\', '/');
        String fname = null;
        if (modelElement instanceof MofClass) {
            fname = forClassProxy ? (forInterface ? GeneratorClass.getJavaInterfaceNameQualified((MofClass)modelElement) : GeneratorClass.getJavaClassNameQualified((MofClass)modelElement)) : (forInterface ? GeneratorInstance.getJavaInterfaceNameQualified((MofClass)modelElement) : GeneratorInstance.getJavaClassNameQualified((MofClass)modelElement));
        } else if (modelElement instanceof MofPackage) {
            fname = forInterface ? GeneratorPackage.getJavaInterfaceNameQualified((MofPackage)modelElement) : GeneratorPackage.getJavaClassNameQualified((MofPackage)modelElement);
        } else if (modelElement instanceof Association) {
            fname = forInterface ? GeneratorAssociation.getJavaInterfaceNameQualified((Association)modelElement) : GeneratorAssociation.getJavaClassNameQualified((Association)modelElement);
        }
        if (fname == null) {
            return null;
        }
        fname = fname.replace('.', '/') + ".java";
        return pathSources + fname;
    }

    public void generate(String directory, Collection modelElements, boolean noJavaDocs) {
        String method = "generate(String directory, Collection modelElements, boolean noJavaDocs)";
        if (modelElements == null || modelElements.size() < 1) {
            return;
        }
        LinkedList<JavaSource> sources = new LinkedList<JavaSource>();
        for (int i = 0; i <= 1; ++i) {
            boolean generateInterfaces = true;
            if (i > 0) {
                generateInterfaces = false;
            }
            Iterator iter = modelElements.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                sources.clear();
                JavaSource source = null;
                if (me instanceof MofPackage) {
                    if (me.getName().compareTo("MOF_PACKAGE_M2_ROOT") != 0 && (source = Generator.getGeneratorPackage().generateTemplate((MofPackage)me, noJavaDocs, generateInterfaces)) != null) {
                        sources.add(source);
                    }
                } else if (me instanceof MofClass) {
                    source = Generator.getGeneratorClass().generateTemplate((MofClass)me, noJavaDocs, generateInterfaces);
                    if (source != null) {
                        sources.add(source);
                    }
                    if ((source = Generator.getGeneratorInstance().generateTemplate((MofClass)me, noJavaDocs, generateInterfaces)) != null) {
                        sources.add(source);
                    }
                } else if (me instanceof Association) {
                    source = Generator.getGeneratorAssociation().generateTemplate((Association)me, noJavaDocs, generateInterfaces);
                    if (source != null) {
                        sources.add(source);
                    }
                } else if (me instanceof MofException) {
                    source = Generator.getGeneratorException().generateTemplate((MofException)me, noJavaDocs, generateInterfaces);
                    if (source != null) {
                        sources.add(source);
                    }
                } else if (me instanceof DataType) {
                    if (me instanceof EnumerationType) {
                        if (!Generator.isJavaType(((EnumerationType)me).getName())) {
                            source = Generator.getGeneratorEnumerationType().generateTemplate((EnumerationType)me, noJavaDocs, generateInterfaces);
                        }
                    } else if (me instanceof StructureType) {
                        if (!Generator.isJavaType(((StructureType)me).getName())) {
                            source = Generator.getGeneratorStructureType().generateTemplate((StructureType)me, noJavaDocs, generateInterfaces);
                        }
                    } else if (!Generator.isJavaType(((DataType)me).getName())) {
                        source = Generator.getGeneratorDataType().generateTemplate((DataType)me, noJavaDocs, generateInterfaces);
                    }
                    if (source != null) {
                        sources.add(source);
                    }
                }
                Iterator iterSources = sources.iterator();
                while (iterSources.hasNext()) {
                    String s;
                    JavaSource javaSource = (JavaSource)iterSources.next();
                    if (javaSource == null || javaSource.getName() == null || javaSource.getSourceCode() == null) continue;
                    if (me instanceof IModelElement && (s = ((IModelElement)me).getLastChangedAt()) != null && s.length() > 0) {
                        long timestamp = Utilities.getUtilities().getTime(s);
                        javaSource.setTimestamp(timestamp);
                    }
                    if (RepositoryServer.getRepositoryFS().writeJavaSource(directory, javaSource)) continue;
                    RepositoryServer.getCategory().errorT(location, "generate(String directory, Collection modelElements, boolean noJavaDocs)", MMRResourceAccessor.getInstance().getMessageText("2502"), new Object[]{javaSource.getName()});
                }
            }
        }
    }

    public static boolean isJMIGeneratable(ModelElement me) {
        boolean flag = false;
        if (me instanceof MofPackage || me instanceof MofClass || me instanceof Association || me instanceof MofException || me instanceof DataType) {
            flag = true;
        }
        return flag;
    }

    public static List getJMISourceNames(ModelElement me) {
        LinkedList<String> l = new LinkedList<String>();
        if (me instanceof MofPackage) {
            if (me.getName().compareTo("MOF_PACKAGE_M2_ROOT") != 0) {
                l.add(GeneratorPackage.getJavaClassNameQualified((MofPackage)me));
                l.add(GeneratorPackage.getJavaInterfaceNameQualified((MofPackage)me));
            }
        } else if (me instanceof MofClass) {
            l.add(GeneratorClass.getJavaClassNameQualified((MofClass)me));
            l.add(GeneratorClass.getJavaInterfaceNameQualified((MofClass)me));
            l.add(GeneratorInstance.getJavaClassNameQualified((MofClass)me));
            l.add(GeneratorInstance.getJavaInterfaceNameQualified((MofClass)me));
        } else if (me instanceof Association) {
            l.add(GeneratorAssociation.getJavaClassNameQualified((Association)me));
            l.add(GeneratorAssociation.getJavaInterfaceNameQualified((Association)me));
        } else if (me instanceof MofException) {
            l.add(GeneratorException.getJavaClassNameQualified((MofException)me));
        } else if (me instanceof DataType) {
            if (me instanceof EnumerationType) {
                l.add(GeneratorEnumerationType.getJavaClassNameQualified((EnumerationType)me));
                l.add(GeneratorEnumerationType.getJavaInterfaceNameQualified((EnumerationType)me));
            } else if (me instanceof StructureType) {
                l.add(GeneratorStructureType.getJavaClassNameQualified((StructureType)me));
                l.add(GeneratorStructureType.getJavaInterfaceNameQualified((StructureType)me));
            } else if (!Generator.isJavaType(((DataType)me).getName())) {
                l.add(GeneratorDataType.getJavaClassNameQualified((DataType)me));
                l.add(GeneratorDataType.getJavaInterfaceNameQualified((DataType)me));
            }
        }
        return l;
    }

    public static void generatePackageStatement(StringBuffer code, Namespace namespace) {
        String pkgName = Generator.getJMIIdentifierQualified(namespace);
        int idx = pkgName.lastIndexOf(46);
        pkgName = namespace instanceof MofPackage ? pkgName.toLowerCase() : (idx > 0 ? pkgName.substring(0, idx).toLowerCase() : pkgName.toLowerCase());
        code.append("/**");
        code.append(Utilities.SystemLineSeparator);
        code.append(" * THIS FILE IS GENERATED BY SAP BI MMR: JMI GENERATOR VERSION 1.1.1");
        code.append(Utilities.SystemLineSeparator);
        code.append(" * GENERATED AT " + Utilities.getUtilities().getDateTimeFormated(Locale.ENGLISH));
        code.append(Utilities.SystemLineSeparator);
        code.append(" **/");
        code.append(Utilities.SystemLineSeparator);
        code.append("");
        code.append("package ");
        code.append(pkgName);
        code.append(";");
        code.append(Utilities.SystemLineSeparator);
    }

    public static void generateAnnotationTemplate(StringBuffer code, ModelElement modelElement) {
        String annot = modelElement.getAnnotation();
        if (annot != null && annot.length() > 4) {
            String prefix = annot.substring(0, 3);
            if (prefix.compareTo("/**") == 0) {
                code.append(Utilities.SystemLineSeparator);
                code.append(annot);
                code.append(Utilities.SystemLineSeparator);
            } else {
                Generator.generateComment(code, annot);
            }
        }
    }

    public static void generateComment(StringBuffer code, String str) {
        if (str == null || str.length() < 1) {
            return;
        }
        List lines = Generator.splitText(str);
        code.append("/**");
        code.append(Utilities.SystemLineSeparator);
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            code.append(" * ");
            code.append(line);
            code.append(Utilities.SystemLineSeparator);
        }
        code.append(" */");
        code.append(Utilities.SystemLineSeparator);
    }

    private static List splitText(String text) {
        int LINE_SIZE = 70;
        ArrayList<String> list = new ArrayList<String>(100);
        int len = text.length();
        StringBuffer b = new StringBuffer(len);
        int n = 0;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '.') {
                if (i > 0 && i < len - 1 && text.charAt(i - 1) == 'i' && text.charAt(i + 1) == 'e') {
                    b.append("&#46;e&#46;");
                    i += 2;
                    n += 11;
                } else if (i > 0 && i < len - 1 && text.charAt(i - 1) == 'e' && text.charAt(i + 1) == 'g') {
                    b.append("&#46;g&#46;");
                    i += 2;
                    n += 11;
                } else {
                    b.append('.');
                }
            } else if (c != '\r') {
                b.append(c);
            }
            if (n > 70 && c == ' ') {
                b.append('\n');
                n = 0;
            }
            ++n;
        }
        int j = 0;
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            if (c == '\n') {
                list.add(b.substring(j, i));
                j = i + 1;
                continue;
            }
            if (c != '*') continue;
            list.add(b.substring(j, i));
            j = i;
        }
        if (j < b.length()) {
            list.add(b.substring(j));
        }
        return list;
    }

    public static String correctQualifiedName(List qualifiedName) {
        StringBuffer b = new StringBuffer(1024);
        for (int i = 0; i < qualifiedName.size() - 1; ++i) {
            String s = Generator.correctName((String)qualifiedName.get(i));
            b.append(s.toLowerCase());
            b.append('.');
        }
        b.append(Generator.convertFirstCharToUpper(Generator.correctName((String)qualifiedName.get(qualifiedName.size() - 1))));
        return b.toString();
    }

    public static String correctQualifiedName(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() < 3) {
            return name;
        }
        return Generator.correctQualifiedName(Utilities.getUtilities().decodeQualifiedName(name));
    }

    private static String correctName(String name) {
        return Generator.correctNameInternal(name, false);
    }

    public static String correctConstant(String name) {
        return Generator.correctNameInternal(name, true).toUpperCase();
    }

    private static String correctNameInternal(String name, boolean forConstant) {
        if (name == null) {
            return null;
        }
        String nonsigchars = null;
        nonsigchars = forConstant ? " -\n\r\t" : " _-\n\r\t";
        List list = Utilities.getUtilities().splitByChars(name, nonsigchars);
        ArrayList<String> listCorrected = new ArrayList<String>();
        if (list.size() > 0) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                String s = (String)iter.next();
                listCorrected.add(Generator.correctWord(s, forConstant));
            }
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = listCorrected.iterator();
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (s.charAt(0) == '_') {
                s = s.substring(1);
            }
            if (s.charAt(s.length() - 1) == '_') {
                s = s.substring(0, s.length() - 1);
            }
            sb.append(s);
            if (!forConstant || !iter.hasNext()) continue;
            sb.append('_');
        }
        return Generator.checkName(sb.toString(), forConstant);
    }

    private static String correctWord(String word, boolean forConstant) {
        StringBuffer b = new StringBuffer(word.length());
        char cLast = ' ';
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (i == 0) {
                b.append(Character.toUpperCase(c));
            } else if (Character.isUpperCase(c)) {
                if (Character.isUpperCase(cLast)) {
                    b.append(Character.toLowerCase(c));
                } else {
                    if (forConstant) {
                        b.append('_');
                    }
                    b.append(c);
                }
            } else {
                b.append(c);
            }
            cLast = c;
        }
        if (Generator.isBI_UDA_Object(b.toString())) {
            b.setCharAt(0, Character.toUpperCase(b.charAt(0)));
            b.setCharAt(1, Character.toUpperCase(b.charAt(1)));
            b.setCharAt(2, Character.toUpperCase(b.charAt(2)));
            b.setCharAt(3, Character.toUpperCase(b.charAt(3)));
        }
        return b.toString();
    }

    public static boolean isBI_UDA_Object(ModelElement me) {
        return Generator.isBI_UDA_Object(me.getName());
    }

    public static boolean isBI_UDA_Object(String name) {
        return name.length() > 3 && name.substring(0, 3).compareToIgnoreCase("IBI") == 0;
    }

    public static String correctType(String type, boolean isVariable) {
        String type_ = Generator.mapPrimitiveType(type);
        if (type_.compareTo(type) == 0) {
            type_ = Generator.checkName(type, isVariable);
        }
        return type_;
    }

    public static String getType(Classifier classifier, boolean isInterface) {
        String type = "java.lang.String";
        if (classifier instanceof PrimitiveType) {
            type = Generator.mapPrimitiveType(classifier);
        } else if (classifier instanceof AliasType) {
            Classifier c = ((AliasType)classifier).getType();
            type = classifier.equals(c) ? Generator.mapPrimitiveType(classifier) : Generator.getType(c, isInterface);
            type = Generator.mapPrimitiveType(type);
        } else {
            type = classifier instanceof EnumerationType ? GeneratorEnumerationType.getJavaInterfaceNameQualified((EnumerationType)classifier) : (classifier instanceof CollectionType ? (((CollectionType)classifier).getMultiplicity().isOrdered() ? "java.util.List" : "java.util.Collection") : Generator.getJMIIdentifierQualified((Namespace)classifier));
        }
        return type;
    }

    public static void generateStructureTypeTemplate(StringBuffer code, StructureType structureType, boolean generateInterfaces) {
        if (structureType.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS) || !generateInterfaces) {
            AttributeWithType awt;
            ArrayList<AttributeWithType> list = new ArrayList<AttributeWithType>();
            Iterator iter = Generator.getAllContent((ModelElement)structureType).iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof StructureField)) continue;
                StructureField sf = (StructureField)me;
                AttributeWithType awt2 = new AttributeWithType(Generator.getJMIIdentifier((ModelElement)sf), Generator.getType(sf.getType(), generateInterfaces));
                list.add(awt2);
            }
            code.append("public ");
            String qName = Generator.getJMIIdentifierQualified((Namespace)structureType);
            code.append(qName);
            code.append(" create");
            code.append(Generator.getJMIIdentifier((ModelElement)structureType));
            code.append("(");
            iter = list.iterator();
            while (iter.hasNext()) {
                awt = (AttributeWithType)iter.next();
                code.append(awt.getType());
                code.append(' ');
                code.append(awt.getName());
                if (!iter.hasNext()) continue;
                code.append(", ");
            }
            if (generateInterfaces) {
                code.append(") throws javax.jmi.reflect.JmiException;");
            } else {
                code.append(") {");
                code.append(Utilities.SystemLineSeparator);
                code.append("java.util.List args = new java.util.LinkedList();");
                code.append(Utilities.SystemLineSeparator);
                iter = list.iterator();
                while (iter.hasNext()) {
                    awt = (AttributeWithType)iter.next();
                    code.append("args.add(");
                    code.append(Generator.getJavaTypeAsObject(awt.getType(), awt.getName()));
                    code.append(");");
                    code.append(Utilities.SystemLineSeparator);
                }
                code.append("return (" + qName + ") refCreateStruct(\"" + Generator.getJMIIdentifierQualified((Namespace)structureType) + "\",args); } ");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }

    public static void generateEnumerationTypeTemplate(StringBuffer code, EnumerationType enumerationType, boolean generateInterfaces) {
        if (enumerationType.getVisibility().equals(VisibilityKindEnum.PUBLIC_VIS) || !generateInterfaces) {
            code.append("public ");
            String qName = Generator.getJMIIdentifierQualified((Namespace)enumerationType);
            code.append(qName);
            code.append(" create");
            code.append(Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)enumerationType)));
            code.append("(java.lang.String value)");
            if (generateInterfaces) {
                code.append(" throws javax.jmi.reflect.JmiException;");
            } else {
                code.append(" { return (" + qName + ") refGetEnum(\"" + Generator.getJMIIdentifierQualified((Namespace)enumerationType) + "\",value); } ");
            }
            code.append(Utilities.SystemLineSeparator);
        }
    }

    public static GeneratorPackage getGeneratorPackage() {
        if (generatorPackage == null) {
            generatorPackage = new GeneratorPackage();
        }
        return generatorPackage;
    }

    public static GeneratorClass getGeneratorClass() {
        if (generatorClass == null) {
            generatorClass = new GeneratorClass();
        }
        return generatorClass;
    }

    public static GeneratorException getGeneratorException() {
        if (generatorException == null) {
            generatorException = new GeneratorException();
        }
        return generatorException;
    }

    public static GeneratorInstance getGeneratorInstance() {
        if (generatorInstance == null) {
            generatorInstance = new GeneratorInstance();
        }
        return generatorInstance;
    }

    public static GeneratorDataType getGeneratorDataType() {
        if (generatorDataType == null) {
            generatorDataType = new GeneratorDataType();
        }
        return generatorDataType;
    }

    public static GeneratorEnumerationType getGeneratorEnumerationType() {
        if (generatorEnumerationType == null) {
            generatorEnumerationType = new GeneratorEnumerationType();
        }
        return generatorEnumerationType;
    }

    public static GeneratorStructureType getGeneratorStructureType() {
        if (generatorStructureType == null) {
            generatorStructureType = new GeneratorStructureType();
        }
        return generatorStructureType;
    }

    public static GeneratorAssociation getGeneratorAssociation() {
        if (generatorAssociation == null) {
            generatorAssociation = new GeneratorAssociation();
        }
        return generatorAssociation;
    }

    public static GeneratorAttributeTemplate getGeneratorAttributeTemplate() {
        if (generatorAttributeTemplate == null) {
            generatorAttributeTemplate = new GeneratorAttributeTemplate();
        }
        return generatorAttributeTemplate;
    }

    public static GeneratorReferenceTemplate getGeneratorReferenceTemplate() {
        if (generatorReferenceTemplate == null) {
            generatorReferenceTemplate = new GeneratorReferenceTemplate();
        }
        return generatorReferenceTemplate;
    }

    public static GeneratorOperationTemplate getGeneratorOperationTemplate() {
        if (generatorOperationTemplate == null) {
            generatorOperationTemplate = new GeneratorOperationTemplate();
        }
        return generatorOperationTemplate;
    }

    public static GeneratorConstantTemplate getGeneratorConstantTemplate() {
        if (generatorConstantTemplate == null) {
            generatorConstantTemplate = new GeneratorConstantTemplate();
        }
        return generatorConstantTemplate;
    }

    public static String convertFirstCharToUpper(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() < 1) {
            return "";
        }
        String output = input.substring(0, 1).toUpperCase() + input.substring(1);
        return output;
    }

    public static String convertFirstCharToLower(String input) {
        String output = input.substring(0, 1).toLowerCase() + input.substring(1);
        return output;
    }

    private static String checkName(String name, boolean isVariable) {
        return Generator.checkKeyword(name, isVariable);
    }

    private static String checkKeyword(String name, boolean isVariable) {
        if (name == null) {
            return null;
        }
        Generator.initialize();
        if (isVariable) {
            if (keywordsJava.contains(name.toLowerCase())) {
                return PREFIX_MOF + name;
            }
            return name;
        }
        if (keywordsJavaForClass.contains(name.toLowerCase())) {
            return PREFIX_MOF + name;
        }
        return name;
    }

    public static String mapPrimitiveType(Classifier classifier) {
        String qn;
        String javaType = null;
        Namespace container = classifier.getContainer();
        javaType = classifier instanceof PrimitiveType && container != null && container.getName().compareTo("PrimitiveTypes") != 0 ? ((qn = Utilities.getUtilities().encodeQualifiedName(classifier.getQualifiedName())).indexOf("java.lang.") == 0 ? qn : Generator.getJMIIdentifier((ModelElement)classifier)) : Generator.mapPrimitiveType(classifier.getName());
        return javaType;
    }

    public static String mapPrimitiveType(String dataTypeName) {
        String javaType = dataTypeName;
        if (Generator.isJavaType(dataTypeName.toLowerCase()) && dataTypeMappings.containsKey(dataTypeName.toLowerCase())) {
            javaType = (String)dataTypeMappings.get(dataTypeName.toLowerCase());
        }
        return javaType;
    }

    public static boolean isJavaType(String dataTypeName) {
        if (dataTypeName == null) {
            return false;
        }
        if (dataTypeMappings == null) {
            Generator.initialize();
        }
        if (dataTypeName.toLowerCase().compareTo("int") == 0) {
            return true;
        }
        return dataTypeMappings.containsKey(dataTypeName.toLowerCase());
    }

    public static String getJavaTypeClass(String dataTypeName) {
        String dtn = dataTypeName;
        if (Generator.isJavaType(dtn)) {
            if ((dtn = Generator.mapPrimitiveType(dtn)).compareTo("int") == 0) {
                dtn = "java.lang.Integer";
            }
            if (dtn.indexOf(46) >= 0) {
                return dtn;
            }
            return "java.lang." + dtn.substring(0, 1).toUpperCase() + dtn.substring(1).toLowerCase();
        }
        return dtn;
    }

    public static String getJavaReturnInitialValueByType(String type) {
        String str = "null";
        if (type.compareToIgnoreCase("boolean") == 0) {
            str = "false";
        } else if (type.compareToIgnoreCase("unlimitedinteger") == 0) {
            str = "0";
        } else if (type.compareToIgnoreCase("integer") == 0) {
            str = "0";
        } else if (type.compareToIgnoreCase("int") == 0) {
            str = "0";
        } else if (type.compareToIgnoreCase("long") == 0) {
            str = "0l";
        } else if (type.compareToIgnoreCase("float") == 0) {
            str = "0f";
        } else if (type.compareToIgnoreCase("double") == 0) {
            str = "0d";
        }
        return str;
    }

    public static String getJavaTypeGetValue(String type) {
        String str = null;
        if (type.compareToIgnoreCase("boolean") == 0) {
            str = "booleanValue()";
        } else if (type.compareToIgnoreCase("unlimitedinteger") == 0) {
            str = "intValue()";
        } else if (type.compareToIgnoreCase("integer") == 0) {
            str = "intValue()";
        } else if (type.compareToIgnoreCase("int") == 0) {
            str = "intValue()";
        } else if (type.compareToIgnoreCase("long") == 0) {
            str = "longValue()";
        } else if (type.compareToIgnoreCase("float") == 0) {
            str = "floatValue()";
        } else if (type.compareToIgnoreCase("double") == 0) {
            str = "doubleValue()";
        }
        return str;
    }

    public static String getJavaTypeAsObject(String type, String variable) {
        String str = variable;
        if (type == null) {
            str = variable;
        } else if (type.compareToIgnoreCase("boolean") == 0) {
            str = "new Boolean(" + variable + ")";
        } else if (type.compareToIgnoreCase("unlimitedinteger") == 0) {
            str = "new Integer(" + variable + ")";
        } else if (type.compareToIgnoreCase("int") == 0) {
            str = "new Integer(" + variable + ")";
        } else if (type.compareToIgnoreCase("integer") == 0) {
            str = "new Integer(" + variable + ")";
        } else if (type.compareToIgnoreCase("long") == 0) {
            str = "new Long(" + variable + ")";
        } else if (type.compareToIgnoreCase("float") == 0) {
            str = "new Float(" + variable + ")";
        } else if (type.compareToIgnoreCase("double") == 0) {
            str = "new Double(" + variable + ")";
        }
        return str;
    }

    public static List getAllSupertypes(GeneralizableElement generalizableElement) {
        return Utilities.getUtilities().getAllSupertypes(generalizableElement);
    }

    public static List getAllContent(ModelElement modelElement) {
        return Utilities.getUtilities().getAllContent(modelElement);
    }

    public static Collection getAllEnumrationLabels(EnumerationType enumerationType) {
        return Utilities.getUtilities().getAllEnumrationLabels(enumerationType);
    }

    public static String getAttributeType(Attribute attribute, boolean isInterface) {
        String typeOfAttribute = null;
        typeOfAttribute = attribute.getMultiplicity().getUpper() == 1 ? (attribute.getMultiplicity().getLower() == 0 ? Generator.getJavaTypeClass(Generator.getType(attribute.getType(), isInterface)) : Generator.getType(attribute.getType(), isInterface)) : (!attribute.getMultiplicity().isOrdered() ? "java.util.Collection" : "java.util.List");
        return typeOfAttribute;
    }

    public static String getReferenceType(Reference reference, boolean isInterface) {
        String typeOfReference = null;
        String referenceType = Generator.getType(reference.getType(), isInterface);
        typeOfReference = reference.getMultiplicity().getUpper() == 1 ? referenceType : (!reference.getMultiplicity().isOrdered() ? "java.util.Collection" : "java.util.List");
        return typeOfReference;
    }

    public static void generateDefaultIncludes(StringBuffer code) {
        ArrayList<String> l = new ArrayList<String>(100);
        l.add("import java.util.Collection;");
        l.add("import java.util.ArrayList;");
        l.add("import java.util.Iterator;");
        l.add("import java.util.List;");
        l.add("import java.util.HashMap;");
        l.add("");
        l.add("import javax.jmi.reflect.RefBaseObject;");
        l.add("import javax.jmi.reflect.RefObject;");
        l.add("import javax.jmi.reflect.RefClass;");
        l.add("import javax.jmi.reflect.RefAssociation;");
        l.add("import javax.jmi.reflect.RefStruct;");
        l.add("import javax.jmi.reflect.RefEnum;");
        l.add("import javax.jmi.reflect.RefPackage;");
        l.add("import javax.jmi.reflect.RefFeatured;");
        l.add("");
        l.add("");
        l.add("import com.sap.ip.mmr.Repository;");
        l.add("import com.sap.ip.mmr.IRepository;");
        l.add("import com.sap.ip.mmr.IRepositoryConst;");
        l.add("import com.sap.ip.mmr.m1layer.IMMRObject;");
        l.add("import com.sap.ip.mmr.m1layer.IMMRAssociation;");
        l.add("");
        l.add("");
        Generator.addToCode(code, l);
    }

    private static void addSetElseIfStatement(boolean staticOnly, List l, Iterator iter, boolean changeState) {
        String method = "addSetElseIfStatement(List l,Iterator iter)";
        while (iter.hasNext()) {
            StructuralFeature sf = (StructuralFeature)iter.next();
            if (!sf.isChangeable() || (staticOnly || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)sf.getScope())) && (!staticOnly || !ScopeKindEnum.CLASSIFIER_LEVEL.equals((Object)sf.getScope()))) continue;
            l.add("else if (featureName.compareTo(\"" + sf.getName() + "\")  == 0) {");
            if (sf.getType() == null) {
                RepositoryServer.getCategory().errorT(location, "addSetElseIfStatement(List l,Iterator iter)", MMRResourceAccessor.getInstance().getMessageText("2503"), new Object[]{sf});
            } else {
                String variable = Generator.composeVariableName(Generator.getJMIIdentifier((ModelElement)sf), false);
                String typeQualified = null;
                if (sf instanceof Attribute) {
                    typeQualified = Generator.getAttributeType((Attribute)sf, true);
                    l.add(Generator.getDataSetStatement(variable, sf, typeQualified));
                } else if (sf instanceof Reference) {
                    String methodName;
                    typeQualified = Generator.getReferenceType((Reference)sf, true);
                    if (sf.getMultiplicity().getUpper() != 1) {
                        methodName = "get" + Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)sf));
                        l.add("  " + methodName + "().add((" + typeQualified + ")value);");
                    } else {
                        methodName = "set" + Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)sf));
                        l.add("  " + methodName + "((" + typeQualified + ")value);");
                    }
                }
            }
            if (changeState) {
                l.add("   set___State(com.sap.ip.mmr.StateEnum.STATE_CHANGED);");
            }
            l.add("}");
        }
    }

    private static void addGetElseIfStatement(boolean staticOnly, List l, Iterator iter) {
        String method = "addGetElseIfStatement(List l, Iterator iter)";
        while (iter.hasNext()) {
            StructuralFeature sf = (StructuralFeature)iter.next();
            if ((staticOnly || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)sf.getScope())) && (!staticOnly || !ScopeKindEnum.CLASSIFIER_LEVEL.equals((Object)sf.getScope()))) continue;
            l.add("else if (featureName.compareTo(\"" + sf.getName() + "\")  == 0) {");
            if (sf.getType() == null) {
                RepositoryServer.getCategory().errorT(location, "addGetElseIfStatement(List l, Iterator iter)", MMRResourceAccessor.getInstance().getMessageText("2503"), new Object[]{sf});
            } else {
                String variable = Generator.composeVariableName(Generator.getJMIIdentifier((ModelElement)sf), false);
                if (sf instanceof Attribute) {
                    l.add(Generator.getDataReturnStatement(variable, sf));
                } else if (sf instanceof Reference) {
                    String methodName = "get" + Generator.convertFirstCharToUpper(Generator.getJMIIdentifier((ModelElement)sf));
                    l.add("  return " + methodName + "();");
                }
            }
            l.add("}");
        }
    }

    private static String getDataSetStatement(String variable, StructuralFeature sf, String typeQualified) {
        String type = Generator.mapPrimitiveType(sf.getType());
        StringBuffer buf = new StringBuffer(100);
        if (sf.getMultiplicity().getUpper() != 1) {
            buf.append("if (value instanceof java.util.Collection) { ");
            buf.append(variable);
            buf.append(".addAll((java.util.Collection)value); } else { ");
            buf.append(variable);
            buf.append(".add(value); } ");
        } else if (sf.getMultiplicity().getLower() == 0 && sf.getMultiplicity().getUpper() == 1) {
            buf.append(variable);
            buf.append(" = (");
            buf.append(typeQualified);
            buf.append(")value;");
        } else if (Generator.getJavaTypeClass(type).compareToIgnoreCase("any") == 0) {
            buf.append(variable);
            buf.append(" = value;");
        } else if (Generator.isJavaType(type) && type.compareToIgnoreCase("name") != 0 && type.compareToIgnoreCase("string") != 0 && type.compareToIgnoreCase("time") != 0) {
            buf.append(variable);
            buf.append(" = ((");
            buf.append(Generator.getJavaTypeClass(type));
            buf.append(")value)");
            String str = Generator.getJavaTypeGetValue(type);
            if (str != null) {
                buf.append('.');
                buf.append(str);
            }
            buf.append(";");
        } else {
            buf.append(variable);
            buf.append(" = (");
            buf.append(typeQualified);
            buf.append(")value;");
        }
        return buf.toString();
    }

    private static String getDataReturnStatement(String variable, StructuralFeature sf) {
        String type = Generator.mapPrimitiveType(sf.getType());
        StringBuffer buf = new StringBuffer(100);
        if (sf.getMultiplicity().getUpper() != 1 || sf.getMultiplicity().getLower() == 0 && sf.getMultiplicity().getUpper() == 1) {
            buf.append("  return ");
            buf.append(variable);
            buf.append(";");
        } else if (type.compareToIgnoreCase("any") == 0) {
            buf.append("  return ");
            buf.append(variable);
            buf.append(";");
        } else if (Generator.isJavaType(type) && type.compareToIgnoreCase("name") != 0 && type.compareToIgnoreCase("string") != 0 && type.compareToIgnoreCase("time") != 0) {
            buf.append("  return new ");
            buf.append(Generator.getJavaTypeClass(type));
            buf.append("(");
            buf.append(variable);
            buf.append(");");
        } else {
            buf.append("  return ");
            buf.append(variable);
            buf.append(";");
        }
        return buf.toString();
    }

    public static void addToCode(StringBuffer code, List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String str = (String)iter.next();
            code.append(str);
            code.append(Utilities.SystemLineSeparator);
        }
    }

    public static String composeVariableName(String name, boolean isSAPVariable) {
        if (isSAPVariable) {
            return "___" + Generator.convertFirstCharToLower(Generator.checkKeyword(name, true));
        }
        return VARIABLE_PREFIX + Generator.convertFirstCharToLower(Generator.checkKeyword(name, true));
    }

    public static void generateTemplateRefBaseObjectDecl(StringBuffer code, ModelElement modelElement, String javaClassName) {
        ArrayList<String> l = new ArrayList<String>(100);
        l.add("");
        l.add("// Java serialized version UID");
        long svUid = javaClassName.hashCode();
        l.add("static final long serialVersionUID = " + svUid + "L;");
        l.add("");
        l.add("");
        l.add("");
        l.add("\tprotected static final com.sap.tc.logging.Location ___location = com.sap.ip.mmr.foundation.Utilities.getUtilities().getLocation(javax.jmi.reflect.RefBaseObject.class);");
        l.add("");
        l.add("// variables");
        IRepository repository = ((ModelElementImpl)modelElement).getRepository();
        l.add("protected java.lang.String " + Generator.composeVariableName(VARIABLE_MOFID, true) + ";");
        l.add("\t");
        l.add("transient protected com.sap.ip.mmr.StateEnum " + Generator.composeVariableName(VARIABLE_STATE, true) + " = com.sap.ip.mmr.StateEnum.STATE_NEW;");
        l.add("final protected java.lang.String " + Generator.composeVariableName(VARIABLE_GENVERS, true) + " = \"" + "1.1.1" + "\";");
        l.add("transient protected com.sap.ip.mmr.IRepository " + Generator.composeVariableName(VARIABLE_REPOSITORY, true) + ";");
        l.add("transient protected javax.jmi.reflect.RefObject " + Generator.composeVariableName(VARIABLE_METAOBJECT, true) + ";");
        l.add("transient protected javax.jmi.reflect.RefFeatured " + Generator.composeVariableName(VARIABLE_COMPOSITE, true) + " = null;");
        l.add("");
        l.add("transient protected com.sap.ip.mmr.m1layer.IMMRObject " + Generator.composeVariableName(VARIABLE_INSTANTIATOR, true) + ";");
        l.add("");
        l.add("protected java.lang.String " + Generator.composeVariableName(VARIABLE_CREATEDAT, true) + ";");
        l.add("protected java.lang.String " + Generator.composeVariableName(VARIABLE_CREATEDBY, true) + ";");
        l.add("protected java.lang.String " + Generator.composeVariableName(VARIABLE_LASTCHANGEDAT, true) + ";");
        l.add("protected java.lang.String " + Generator.composeVariableName(VARIABLE_LASTCHANGEDBY, true) + ";");
        l.add("protected java.lang.String " + Generator.composeVariableName(VARIABLE_RELEASE, true) + ";");
        l.add("protected int " + Generator.composeVariableName(VARIABLE_DEPRECATED, true) + ";");
        l.add("");
        l.add("");
        l.add("protected java.lang.String ___qualifiedName;");
        l.add("protected java.lang.String ___qualifiedNameImmediatePackage;");
        l.add("transient protected javax.jmi.reflect.RefPackage ___immediatePackage = null;");
        l.add("");
        l.add("");
        l.add("// constructors");
        l.add("public " + javaClassName + "() {");
        if (modelElement instanceof Association) {
            l.add("  super();");
        }
        l.add("}");
        l.add("public " + javaClassName + "(IRepository repository) {");
        if (modelElement instanceof Association) {
            l.add("  super();");
        }
        l.add("  " + Generator.composeVariableName(VARIABLE_REPOSITORY, true) + " = repository;");
        l.add("  " + Generator.composeVariableName(VARIABLE_MOFID, true) + " = com.sap.ip.mmr.Repository.createMofId();");
        l.add("}");
        l.add("");
        Generator.addToCode(code, l);
    }

    public static void generateTemplateRefBaseObject(CodeContainer code, ModelElement modelElement, String javaClassName) {
        CodeContainer.CodeMethod method = null;
        method = CodeContainer.getCodeMethod("toString");
        method.addHeader("// return main object properties as String");
        method.setSignature("public String toString()");
        method.addBody("\treturn ___qualifiedName + \"::\" + " + Generator.composeVariableName(VARIABLE_MOFID, true) + " + \" (\" + super.toString() + \") \";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refMetaObject");
        method.addHeader("// Meta object");
        method.setSignature("public javax.jmi.reflect.RefObject refMetaObject()");
        method.addBody("  return " + Generator.composeVariableName(VARIABLE_REPOSITORY, true) + ".selectM2ByName(" + '\"' + Utilities.getUtilities().encodeQualifiedName(modelElement.getQualifiedName()) + "\", false);");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refImmediatePackage");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefBaseObject#refImmediatePackage()");
        method.addHeader(" */");
        method.setSignature("public javax.jmi.reflect.RefPackage refImmediatePackage()");
        method.addBody("\t\tif (___immediatePackage != null) {");
        method.addBody("\t\t\tif (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) ___immediatePackage).get___QualifiedName())) {");
        method.addBody("\t\t\t\treturn null;");
        method.addBody("\t\t\t}");
        method.addBody("\t    } else {");
        method.addBody("\t\t  if (___qualifiedNameImmediatePackage != null && ___qualifiedNameImmediatePackage.compareTo(com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT) != 0) {");
        method.addBody("\t\t \t// set the package");
        method.addBody("\t\t\t___immediatePackage = ___repository.getTopLevelPackageM1().refPackage(___qualifiedNameImmediatePackage);");
        method.addBody("\t\t  }");
        method.addBody("\t    }");
        method.addBody("\t    return ___immediatePackage;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refOutermostPackage");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefBaseObject#refOutermostPackage()");
        method.addHeader(" */");
        method.setSignature("public javax.jmi.reflect.RefPackage refOutermostPackage()");
        method.addBody("\t\tjavax.jmi.reflect.RefPackage rp = refImmediatePackage();");
        method.addBody("\t\tif (rp == null) {");
        method.addBody("\t\t\treturn (javax.jmi.reflect.RefPackage) this;");
        method.addBody("\t\t} else {");
        method.addBody("\t\t\tif (com.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT.equals(((IMMRObject) rp).get___QualifiedName())) {");
        method.addBody("\t\t\t\treturn (javax.jmi.reflect.RefPackage) this;");
        method.addBody("\t\t\t}");
        method.addBody("\t\t}");
        method.addBody("\t\tif (rp != null && !(rp.equals(this))) {");
        method.addBody("\t\t\tjavax.jmi.reflect.RefPackage rp_ = rp.refOutermostPackage();");
        method.addBody("\t\t\tif (rp_ != null) {");
        method.addBody("\t\t\t\trp = rp_;");
        method.addBody("\t\t\t}");
        method.addBody("\t\t}");
        method.addBody("\t\treturn rp;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refMofId");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefBaseObject#refMofId()");
        method.addHeader(" */");
        method.setSignature("public String refMofId()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_MOFID, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refVerifyConstraints");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefBaseObject#refVerifyConstraints(boolean)");
        method.addHeader(" */");
        method.setSignature("public Collection refVerifyConstraints(boolean deepVerify)");
        method.addBody("\t\tcom.sap.ip.mmr.m1layer.Verifyer v = com.sap.ip.mmr.m1layer.Verifyer.createVerifyer();");
        method.addBody("\t\treturn v.refVerifyConstraints(this,deepVerify);");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___Repository");
        method.addHeader("/**");
        method.addHeader(" * @see com.sap.ip.mmr.m1layer.IMMRObject#get___Repository()");
        method.addHeader(" */");
        method.setSignature("public IRepository get___Repository()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_REPOSITORY, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___Repository");
        method.addHeader("/**");
        method.addHeader(" * @see com.sap.ip.mmr.m1layer.IMMRObject#set___Repository(IRepository)");
        method.addHeader(" */");
        method.setSignature("public void set___Repository(IRepository repository)");
        method.addBody("\t" + Generator.composeVariableName(VARIABLE_REPOSITORY, true) + " = repository;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("equals");
        method.addHeader("// equality of two (IMMRObject) objects ");
        method.setSignature("public boolean equals(java.lang.Object other)");
        method.addBody("    java.lang.String otherMofId = null;");
        method.addBody("\tif (other instanceof javax.jmi.reflect.RefBaseObject) {");
        method.addBody("        otherMofId = ((javax.jmi.reflect.RefBaseObject)other).refMofId();");
        method.addBody("\t} else if (other instanceof java.lang.String) {");
        method.addBody("        otherMofId = (java.lang.String)other;");
        method.addBody("    }");
        method.addBody("    return " + Generator.composeVariableName(VARIABLE_MOFID, true) + ".equals(otherMofId);");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("hashCode");
        method.addHeader("// computes the hasCode of this object");
        method.setSignature("public int hashCode()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_MOFID, true) + ".hashCode();");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("is___Changed");
        method.addHeader("// Was this object changed?");
        method.setSignature("public boolean is___Changed()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_STATE, true) + " == com.sap.ip.mmr.StateEnum.STATE_CHANGED;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("is___New");
        method.addHeader("// Is the instance new or from persistence layer?");
        method.setSignature("public boolean is___New()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_STATE, true) + " == com.sap.ip.mmr.StateEnum.STATE_NEW;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___State");
        method.addHeader("/*");
        method.addHeader(" * @see com.sap.ip.mmr.m1layer.IMMRObject#get___State()");
        method.addHeader("*/");
        method.setSignature("public com.sap.ip.mmr.StateEnum get___State()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_STATE, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___State");
        method.addHeader("/*");
        method.addHeader(" * @see com.sap.ip.mmr.m1layer.IMMRObject#set___State()");
        method.addHeader("*/");
        method.setSignature("public void set___State(com.sap.ip.mmr.StateEnum state)");
        method.addBody("\t___state = com.sap.ip.mmr.StateEnum.changeState(___state,state);");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___GeneratorVersion");
        method.setSignature("public java.lang.String get___GeneratorVersion()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_GENVERS, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___CreatedAt");
        method.setSignature("public void set___CreatedAt(String createdAt)");
        method.addBody("\tthis." + Generator.composeVariableName(VARIABLE_CREATEDAT, true) + " = createdAt;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___CreatedAt");
        method.setSignature("public java.lang.String get___CreatedAt()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_CREATEDAT, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___CreatedBy");
        method.setSignature("public void set___CreatedBy(String createdBy)");
        method.addBody("\tthis." + Generator.composeVariableName(VARIABLE_CREATEDBY, true) + " = createdBy;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___CreatedBy");
        method.setSignature("public java.lang.String get___CreatedBy()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_CREATEDBY, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___LastChangedAt");
        method.setSignature("public void set___LastChangedAt(String lastChangedAt)");
        method.addBody("\tthis." + Generator.composeVariableName(VARIABLE_LASTCHANGEDAT, true) + " = lastChangedAt;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___LastChangedAt");
        method.setSignature("public java.lang.String get___LastChangedAt()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_LASTCHANGEDAT, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___LastChangedBy");
        method.setSignature("public void set___LastChangedBy(String lastChangedBy)");
        method.addBody("\tthis." + Generator.composeVariableName(VARIABLE_LASTCHANGEDBY, true) + " = lastChangedBy;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___LastChangedBy");
        method.setSignature("public java.lang.String get___LastChangedBy()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_LASTCHANGEDBY, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___Release");
        method.setSignature("public void set___Release(String release)");
        method.addBody("\tthis." + Generator.composeVariableName(VARIABLE_RELEASE, true) + " = release;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___Release");
        method.setSignature("public java.lang.String get___Release()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_RELEASE, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___Deprecated");
        method.setSignature("public void set___Deprecated(int deprecated)");
        method.addBody("\tthis." + Generator.composeVariableName(VARIABLE_DEPRECATED, true) + " = deprecated;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___Deprecated");
        method.setSignature("public int get___Deprecated()");
        method.addBody("\treturn " + Generator.composeVariableName(VARIABLE_DEPRECATED, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___ImmediateComposite");
        method.setSignature("public void set___ImmediateComposite(javax.jmi.reflect.RefFeatured feature)");
        method.addBody("\t" + Generator.composeVariableName(VARIABLE_COMPOSITE, true) + " = feature;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("___copy");
        method.addHeader("// copy the attributes of another instance to this instance");
        method.setSignature("public void ___copy(com.sap.ip.mmr.m1layer.IMMRObject o)");
        method.addBody("this.___mofId = o.get___MofId();");
        method.addBody("this.___repository = o.get___Repository();");
        method.addBody("this.___qualifiedName = o.get___QualifiedName();");
        method.addBody("this.___qualifiedNameImmediatePackage = o.get___QualifiedNameImmediatePackage();");
        method.addBody("this.___immediatePackage = o.get___ImmediatePackage();");
        method.addBody("this.___composite = null;");
        method.addBody("this.___createdAt = o.get___CreatedAt();");
        method.addBody("this.___createdBy = o.get___CreatedBy();");
        method.addBody("this.___lastChangedAt = o.get___LastChangedAt();");
        method.addBody("this.___lastChangedBy = o.get___LastChangedBy();");
        method.addBody("this.___release = o.get___Release();");
        method.addBody("this.___deprecated = o.get___Deprecated();");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___MofId");
        method.addHeader("// returns the MOF Id");
        method.setSignature("public String get___MofId()");
        method.addBody("return ___mofId;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___MofId");
        method.addHeader("// set the MOF Id !!! TO BE USED BY MMR ONLY !!!");
        method.setSignature("public void set___MofId(String mofId)");
        method.addBody("this.___mofId = mofId;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___QualifiedName");
        method.addHeader("// returns the qualified name of this class");
        method.setSignature("public java.lang.String get___QualifiedName()");
        method.addBody("return ___qualifiedName;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___QualifiedNameImmediatePackage");
        method.addHeader("// returns the qualified name of the immediate package of this class");
        method.setSignature("public java.lang.String get___QualifiedNameImmediatePackage()");
        method.addBody("return ___qualifiedNameImmediatePackage;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___ImmediatePackage");
        method.addHeader("// returns the immediate package");
        method.setSignature("public javax.jmi.reflect.RefPackage get___ImmediatePackage()");
        method.addBody("return ___immediatePackage;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___QualifiedName");
        method.addHeader("// set the qualified name of this class");
        method.setSignature("public void set___QualifiedName(String qualifiedName)");
        method.addBody("___qualifiedName = qualifiedName;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___QualifiedNameImmediatePackage");
        method.addHeader("// set the qualified name of the immediate package this class");
        method.setSignature("public void set___QualifiedNameImmediatePackage(String qualifiedNameImmediatePackage)");
        method.addBody("___qualifiedNameImmediatePackage = qualifiedNameImmediatePackage;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___ImmediatePackage");
        method.addHeader("// set the immediate package");
        method.setSignature("public void set___ImmediatePackage(javax.jmi.reflect.RefPackage immediatePackage)");
        method.addBody("\t\tif (immediatePackage != null");
        method.addBody("\t\t\t&& ((com.sap.ip.mmr.m1layer.IMMRObject) immediatePackage).get___QualifiedName().equals(");
        method.addBody("\t\t\t\tcom.sap.ip.mmr.Repository.MOF_PACKAGE_M1_ROOT)) {");
        method.addBody("\t\t\t___immediatePackage = null;");
        method.addBody("\t\t} else {");
        method.addBody("\t\t\t___immediatePackage = immediatePackage;");
        method.addBody("\t\t}");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___ListOfInstantiators");
        method.addHeader("// see com.sap.ip.mmr.m1layer.IMMRObject");
        method.setSignature("public List get___ListOfInstantiators()");
        method.addBody("\t\tArrayList list = new ArrayList(1);");
        method.addBody("\t\tIMMRObject parent = get___Instantiator();");
        method.addBody("\t\twhile (parent != null) {");
        method.addBody("\t\t\tif (list.size() == 0) {");
        method.addBody("\t\t\t\tlist.add(parent);");
        method.addBody("\t\t\t} else {");
        method.addBody("\t\t\t\tlist.add(0, parent);");
        method.addBody("\t\t\t}");
        method.addBody("\t\t\tparent = parent.get___Instantiator();");
        method.addBody("\t\t}");
        method.addBody("\t\treturn list;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___Instantiator");
        method.addHeader("// see com.sap.ip.mmr.m1layer.IMMRObject");
        method.setSignature("public IMMRObject get___Instantiator()");
        method.addBody("return ___instantiator;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("set___Instantiator");
        method.addHeader("// see com.sap.ip.mmr.m1layer.IMMRObject");
        method.setSignature("public void set___Instantiator(IMMRObject instantiator)");
        method.addBody("___instantiator = instantiator;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("throwsConstraintViolations");
        method.addHeader("/**");
        method.addHeader("* @see com.sap.ip.mmr.m1layer.IMMRObject#throwsConstraintViolations()");
        method.addHeader("*/");
        method.setSignature("public boolean throwsConstraintViolations()");
        if (Generator.isBI_UDA_Object(modelElement)) {
            method.addBody("return false;");
        } else {
            method.addBody("return true;");
        }
        code.addMethod(method);
    }

    public static void generateTemplateRefAssociationDecl(StringBuffer code, Association association, String javaClassName) {
        Generator.generateTemplateRefBaseObjectDecl(code, (ModelElement)association, javaClassName);
        ArrayList<String> l = new ArrayList<String>(100);
        l.add("");
        l.add("// RefAssociation ");
        l.add("transient protected com.sap.ip.mmr.foundation.AssociationsContainer " + Generator.composeVariableName(VARIABLE_ASSOCIATIONIMPL, true) + ";");
        l.add("transient protected java.lang.String " + Generator.composeVariableName(VARIABLE_ASSOCIATIONID, true) + ";");
        l.add("transient protected javax.jmi.model.AssociationEnd " + Generator.composeVariableName(VARIABLE_ASSOCIATION_END_1, true) + ";");
        l.add("transient protected javax.jmi.model.AssociationEnd " + Generator.composeVariableName(VARIABLE_ASSOCIATION_END_2, true) + ";");
        l.add("");
        l.add("");
        Generator.addToCode(code, l);
    }

    public static void generateTemplateRefAssociation(CodeContainer code, Association association, String javaClassName) {
        Generator.generateTemplateRefBaseObject(code, (ModelElement)association, javaClassName);
        code.addTemplate(IRepositoryConst.PACKAGE_BASE_AS_PATH + "/generate/jmi/RefAssociationTemplate.txt");
        Generator.generateAssociationInitialization(code, association);
        Generator.generateAssociationDynamicTemplates(code, association);
    }

    private static void generateAssociationDynamicTemplates(CodeContainer code, Association association) {
        AssociationEnd ae1 = null;
        AssociationEnd ae2 = null;
        Iterator iter = association.getContents().iterator();
        while (iter.hasNext() && (ae1 == null || ae2 == null)) {
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof AssociationEnd)) continue;
            if (ae1 == null) {
                ae1 = (AssociationEnd)me;
                continue;
            }
            if (ae2 != null) continue;
            ae2 = (AssociationEnd)me;
        }
        String type1 = GeneratorInstance.getJavaInterfaceNameQualified((MofClass)ae1.getType());
        String type2 = GeneratorInstance.getJavaInterfaceNameQualified((MofClass)ae2.getType());
        CodeContainer.CodeMethod method = null;
        method = CodeContainer.getCodeMethod("refQuery");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefAssociation#refQuery(RefObject, RefObject)");
        method.addHeader(" */");
        method.setSignature("public Collection refQuery(RefObject queryEnd, RefObject queryObject)");
        method.addBody("if (!(queryObject instanceof " + type1 + ") && !(queryObject instanceof " + type2 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type1 + ".class, queryObject, queryObject.refMetaObject());");
        method.addBody("}");
        method.addBody("if (___aeFirst.equals(queryEnd) || ___aeSecond.equals(queryEnd)) {");
        method.addBody("\treturn refQuery(((javax.jmi.model.AssociationEnd)queryEnd).getName(), queryObject);");
        method.addBody("} else {");
        method.addBody("\tthrow new javax.jmi.reflect.InvalidCallException(queryEnd, queryEnd.refMetaObject());");
        method.addBody("}");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("queryFirstEnd1");
        method.setSignature("public List queryFirstEnd(RefObject queryObject)");
        method.addBody("if (!(queryObject instanceof " + type1 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type1 + ".class, queryObject, queryObject.refMetaObject());");
        method.addBody("} else {");
        method.addBody("    setAssociationEnds();");
        method.addBody("\treturn ___associationImpl.queryFirstEnd(getAssociationId(), queryObject);");
        method.addBody("}");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("querySecondEnd2");
        method.setSignature("public List querySecondEnd(RefObject queryObject)");
        method.addBody("if (!(queryObject instanceof " + type2 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type1 + ".class, queryObject, queryObject.refMetaObject());");
        method.addBody("} else {");
        method.addBody("    setAssociationEnds();");
        method.addBody("\treturn ___associationImpl.querySecondEnd(getAssociationId(), queryObject);");
        method.addBody("}");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refLinkExists");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefAssociation#refLinkExists(RefObject, RefObject)");
        method.addHeader(" */");
        method.setSignature("public boolean refLinkExists(RefObject firstEnd, RefObject secondEnd)");
        method.addBody("if (firstEnd != null && !(firstEnd instanceof " + type1 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type1 + ".class, firstEnd, firstEnd.refMetaObject());");
        method.addBody("} else if (secondEnd != null && !(secondEnd instanceof " + type2 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type2 + ".class, secondEnd, secondEnd.refMetaObject());");
        method.addBody("} else {");
        method.addBody("    setAssociationEnds();");
        method.addBody("\treturn ___associationImpl.refLinkExists(getAssociationId(), firstEnd, secondEnd);");
        method.addBody("}");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refAddLink");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefAssociation#refAddLink(RefObject, RefObject)");
        method.addHeader(" */");
        method.setSignature("public boolean refAddLink(javax.jmi.reflect.RefObject firstEnd, javax.jmi.reflect.RefObject secondEnd)");
        method.addBody("if (firstEnd != null && !(firstEnd instanceof " + type1 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type1 + ".class, firstEnd, firstEnd.refMetaObject());");
        method.addBody("} else if (secondEnd != null && !(secondEnd instanceof " + type2 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type2 + ".class, secondEnd, secondEnd.refMetaObject());");
        method.addBody("}");
        if (AggregationKindEnum.COMPOSITE.equals((Object)ae1.getAggregation()) || AggregationKindEnum.COMPOSITE.equals((Object)ae2.getAggregation())) {
            method.addBody("// check ClosureViolationException if composite");
            method.addBody("  javax.jmi.reflect.RefBaseObject rbo1 = firstEnd.refOutermostPackage();");
            method.addBody("  javax.jmi.reflect.RefBaseObject rbo2 = secondEnd.refOutermostPackage();");
            method.addBody("  if (rbo1 != rbo2) {");
            method.addBody("    if (firstEnd instanceof com.sap.ip.mmr.m1layer.IMMRObject && secondEnd instanceof com.sap.ip.mmr.m1layer.IMMRObject) {");
            method.addBody("\t  if (((com.sap.ip.mmr.m1layer.IMMRObject) firstEnd).throwsConstraintViolations()");
            method.addBody("\t\t&& ((com.sap.ip.mmr.m1layer.IMMRObject) secondEnd).throwsConstraintViolations()) {");
            method.addBody("        throw new javax.jmi.reflect.ClosureViolationException(firstEnd, secondEnd);");
            method.addBody("\t  }");
            method.addBody("    } else {");
            method.addBody("        throw new javax.jmi.reflect.ClosureViolationException(firstEnd, secondEnd);");
            method.addBody("    }");
            method.addBody("  }");
        }
        method.addBody("setAssociationEnds();");
        method.addBody("return ___associationImpl.refAddLink(getAssociationId(), firstEnd, secondEnd);");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refRemoveLink");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefAssociation#refRemoveLink(RefObject, RefObject)");
        method.addHeader(" */");
        method.setSignature("public boolean refRemoveLink(RefObject firstEnd, RefObject secondEnd)");
        method.addBody("if (firstEnd != null && !(firstEnd instanceof " + type1 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type1 + ".class, firstEnd, firstEnd.refMetaObject());");
        method.addBody("} else if (secondEnd != null && !(secondEnd instanceof " + type2 + ")) {");
        method.addBody("\tthrow new javax.jmi.reflect.TypeMismatchException(" + type2 + ".class, secondEnd, secondEnd.refMetaObject());");
        method.addBody("} else {");
        method.addBody("    setAssociationEnds();");
        method.addBody("\treturn ___associationImpl.refRemoveLink(getAssociationId(), firstEnd, secondEnd);");
        method.addBody("}");
        code.addMethod(method);
    }

    private static void generateAssociationInitialization(CodeContainer code, Association association) {
        CodeContainer.CodeMethod method = null;
        method = CodeContainer.getCodeMethod("setAssociationImpl");
        method.addHeader("/**");
        method.addHeader(" * @see com.sap.ip.mmr.m1layer#setAssociationImpl(com.sap.ip.mmr.foundation.AssociationsContainer)");
        method.addHeader(" */");
        method.setSignature("public void setAssociationImpl(com.sap.ip.mmr.foundation.AssociationsContainer associationImpl)");
        method.addBody("___associationImpl = associationImpl;");
        method.addBody("// set the association Id");
        method.addBody("setAssociationId(___qualifiedName);");
        method.addBody("// add the multiplicities of this association type");
        AssociationEnd ae1 = null;
        AssociationEnd ae2 = null;
        Iterator iter = association.getContents().iterator();
        while (iter.hasNext() && (ae1 == null || ae2 == null)) {
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof AssociationEnd)) continue;
            if (ae1 == null) {
                ae1 = (AssociationEnd)me;
                continue;
            }
            if (ae2 != null) continue;
            ae2 = (AssociationEnd)me;
        }
        String mt1 = "new com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl(" + ae1.getMultiplicity().getLower() + "," + ae1.getMultiplicity().getUpper() + "," + ae1.getMultiplicity().isOrdered() + "," + ae1.getMultiplicity().isUnique() + ")";
        String mt2 = "new com.sap.ip.mmr.m2layer.model.MultiplicityTypeImpl(" + ae2.getMultiplicity().getLower() + "," + ae2.getMultiplicity().getUpper() + "," + ae2.getMultiplicity().isOrdered() + "," + ae2.getMultiplicity().isUnique() + ")";
        String composite1 = String.valueOf(AggregationKindEnum.COMPOSITE.equals((Object)ae1.getAggregation()));
        String composite2 = String.valueOf(AggregationKindEnum.COMPOSITE.equals((Object)ae2.getAggregation()));
        method.addBody("___associationImpl.addAssociationEndInfo(___qualifiedName," + mt1 + "," + mt2 + "," + composite1 + "," + composite2 + ");");
        code.addMethod(method);
    }

    public static void generateTemplateRefClassDecl(StringBuffer code, ModelElement modelElement, String javaClassName, boolean staticOnly) {
        Generator.generateTemplateRefFeaturedDecl(code, modelElement, javaClassName, staticOnly);
        ArrayList<String> l = new ArrayList<String>(100);
        l.add("");
        l.add("// RefClass variables");
        l.add("transient protected List " + Generator.composeVariableName(VARIABLE_REFINSTANCES, true) + " = new java.util.LinkedList();");
        l.add("");
        l.add("");
        Generator.addToCode(code, l);
    }

    public static void generateTemplateRefClass(CodeContainer code, ModelElement modelElement, String javaClassName, boolean staticOnly) {
        Generator.generateTemplateRefFeatured(code, modelElement, javaClassName, staticOnly);
        code.addTemplate(IRepositoryConst.PACKAGE_BASE_AS_PATH + "/generate/jmi/RefClassTemplate.txt");
        Generator.generateRefClassMethods(code, modelElement);
    }

    private static void generateRefClassMethods(CodeContainer code, ModelElement modelElement) {
        CodeContainer.CodeMethod method = CodeContainer.getCodeMethod("correctConstructorArgs");
        method.addHeader("// correct the null values in the constructor arguments list");
        method.setSignature("private java.util.List correctConstructorArgs(java.util.List args)");
        method.addBody("if (args == null) { return null; }");
        method.addBody("java.util.List list = new java.util.LinkedList();");
        method.addBody("java.lang.Object o = null;");
        method.addBody("java.util.Iterator i = args.iterator();");
        Iterator i = Utilities.getUtilities().getAllContent(modelElement).iterator();
        while (i.hasNext()) {
            Classifier type;
            Attribute a;
            ModelElement me = (ModelElement)i.next();
            if (!(me instanceof Attribute) || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)(a = (Attribute)me).getScope())) continue;
            String initStatement = null;
            if (a.getMultiplicity().getLower() == 1 && a.getMultiplicity().getUpper() == 1 && (type = a.getType()).getName().compareToIgnoreCase("string") != 0 && Generator.isJavaType(type.getName())) {
                String var = Generator.getJavaReturnInitialValueByType(type.getName());
                initStatement = Generator.getJavaTypeAsObject(type.getName(), var);
            }
            if (initStatement != null) {
                method.addBody("if (i.hasNext()) {");
                method.addBody("  o = i.next();");
                method.addBody("  if (o == null) {");
                method.addBody("    list.add(" + initStatement + ");");
                method.addBody("  } else {");
                method.addBody("    list.add(o);");
                method.addBody("  }");
                method.addBody("}");
                continue;
            }
            method.addBody("if (i.hasNext()) {");
            method.addBody("  list.add(i.next());");
            method.addBody("}");
        }
        method.addBody("return list;");
        code.addMethod(method);
    }

    public static void generateTemplateRefFeaturedDecl(StringBuffer code, ModelElement modelElement, String javaClassName, boolean staticOnly) {
        Generator.generateTemplateRefBaseObjectDecl(code, modelElement, javaClassName);
    }

    public static void generateTemplateRefFeatured(CodeContainer code, ModelElement modelElement, String javaClassName, boolean staticOnly) {
        Generator.generateTemplateRefBaseObject(code, modelElement, javaClassName);
        ArrayList<ModelElement> listAttr = new ArrayList<ModelElement>();
        ArrayList<ModelElement> listRefs = new ArrayList<ModelElement>();
        MofClass mofClass = null;
        if (modelElement instanceof MofClass) {
            mofClass = (MofClass)modelElement;
        }
        if (mofClass != null) {
            Iterator iter = Generator.getAllContent((ModelElement)mofClass).iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (me instanceof Attribute) {
                    if (staticOnly && !ScopeKindEnum.CLASSIFIER_LEVEL.equals((Object)((Attribute)me).getScope())) continue;
                    listAttr.add(me);
                    continue;
                }
                if (!(me instanceof Reference) || staticOnly && !ScopeKindEnum.CLASSIFIER_LEVEL.equals((Object)((Reference)me).getScope()) || !((Reference)me).getReferencedEnd().isNavigable()) continue;
                listRefs.add(me);
            }
        }
        CodeContainer.CodeMethod method = CodeContainer.getCodeMethod("refSetValue1");
        method.addHeader("// set the value ");
        method.setSignature("public void refSetValue(javax.jmi.reflect.RefObject feature, java.lang.Object value)");
        method.addBody("if (feature != null && feature instanceof javax.jmi.model.ModelElement) {");
        method.addBody(" refSetValue(((javax.jmi.model.ModelElement)feature).getName(),value);");
        method.addBody("}");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refSetValue2");
        method.addHeader("// set the value ");
        method.setSignature("public void refSetValue(String featureName, java.lang.Object value)");
        method.addBody("if (featureName == null) { throw new javax.jmi.reflect.InvalidNameException(featureName); }");
        Generator.addSetElseIfStatement(staticOnly, method.getBody(), listAttr.iterator(), true);
        Generator.addSetElseIfStatement(staticOnly, method.getBody(), listRefs.iterator(), false);
        method.addBody("else { throw new javax.jmi.reflect.InvalidCallException(featureName,null,\"refSetValue()\"); }");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refGetValue1");
        method.addHeader("// get a value");
        method.setSignature("public java.lang.Object refGetValue(javax.jmi.reflect.RefObject feature)");
        method.addBody("if (feature instanceof javax.jmi.model.ModelElement) {");
        method.addBody("   return refGetValue(((javax.jmi.model.ModelElement)feature).getName());");
        method.addBody("} else { return null; }");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refGetValue2");
        method.addHeader("// get a value");
        method.setSignature("public java.lang.Object refGetValue(String featureName)");
        method.addBody("if (featureName == null) { throw new javax.jmi.reflect.InvalidNameException(featureName); }");
        Generator.addGetElseIfStatement(staticOnly, method.getBody(), listAttr.iterator());
        Generator.addGetElseIfStatement(staticOnly, method.getBody(), listRefs.iterator());
        method.addBody("else {");
        method.addBody("   throw new javax.jmi.reflect.InvalidCallException(featureName,null,\"refGetValue\");");
        method.addBody("}");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refInvokeOperation1");
        method.addHeader("// invoke an operation");
        method.setSignature("public java.lang.Object refInvokeOperation(javax.jmi.reflect.RefObject requestedOperation, List args) throws javax.jmi.reflect.RefException");
        method.addBody("  return null;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refInvokeOperation2");
        method.addHeader("// invoke an operation");
        method.setSignature("public java.lang.Object refInvokeOperation(String requestedOperation, List args) throws javax.jmi.reflect.RefException");
        method.addBody("  return null;");
        code.addMethod(method);
        if (mofClass != null) {
            method = code.getMethod("___copy");
            String qName = Generator.getJMIIdentifierQualified((Namespace)mofClass);
            method.addBody("// copy variables of " + mofClass.getName());
            method.addBody("if (o instanceof " + qName + ") {");
            Iterator iter = listAttr.iterator();
            while (iter.hasNext()) {
                Attribute attr = (Attribute)iter.next();
                if (attr.getVisibility().equals(VisibilityKindEnum.PRIVATE_VIS) || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)attr.getScope())) continue;
                String variable = Generator.composeVariableName(Generator.getJMIIdentifier((ModelElement)attr), false);
                if (attr.getMultiplicity().getUpper() != 1) {
                    method.addBody("  " + variable + ".addAll(((" + qName + ")o)." + GeneratorAttributeTemplate.getAccessorName(attr) + "());");
                    continue;
                }
                method.addBody("  " + variable + " = ((" + qName + ")o)." + GeneratorAttributeTemplate.getAccessorName(attr) + "();");
            }
            method.addBody("}");
        }
    }

    public static void generateTemplateRefObjectDecl(StringBuffer code, ModelElement modelElement, String javaClassName, boolean staticOnly) {
        Generator.generateTemplateRefFeaturedDecl(code, modelElement, javaClassName, staticOnly);
    }

    public static void generateTemplateRefObject(CodeContainer code, ModelElement modelElement, String javaClassName, boolean staticOnly) {
        Generator.generateTemplateRefFeatured(code, modelElement, javaClassName, staticOnly);
        CodeContainer.CodeMethod method = CodeContainer.getCodeMethod("refIsInstanceOf");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefObject#refIsInstanceOf(RefObject, boolean)");
        method.addHeader(" */");
        method.setSignature("public boolean refIsInstanceOf(RefObject objType, boolean considerSubtypes)");
        method.addBody("\t\tboolean flag = false;");
        method.addBody("\t\tjavax.jmi.model.MofClass mc = (javax.jmi.model.MofClass) objType;");
        method.addBody("\t\tflag = ");
        method.addBody("\t\t\t___qualifiedName.compareTo(");
        method.addBody("\t\t\t\tcom.sap.ip.mmr.foundation.Utilities.getUtilities().encodeQualifiedName(mc.getQualifiedName()))");
        method.addBody("\t\t\t\t== 0;");
        method.addBody("\t\tif (!flag && considerSubtypes) {");
        method.addBody("\t\t\tjavax.jmi.model.MofClass mo = (javax.jmi.model.MofClass) refMetaObject();");
        method.addBody("\t\t\tjava.util.Iterator i = mo.allSupertypes().iterator();");
        method.addBody("\t\t\twhile (i.hasNext() && !flag) {");
        method.addBody("\t\t\t\tjavax.jmi.model.MofClass mcs = (javax.jmi.model.MofClass) i.next();");
        method.addBody("\t\t\t\tflag = flag = mc.getQualifiedName().equals(mcs.getQualifiedName());");
        method.addBody("\t\t\t}");
        method.addBody("\t\t}");
        method.addBody("\t\treturn flag;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refClass");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefObject#refClass()");
        method.addHeader(" */");
        method.setSignature("public RefClass refClass()");
        method.addBody("\t\tjava.lang.System.err.println(\"RefObjectImpl::refClass not implemented. Must be overwritten.\");");
        method.addBody("\t\treturn null;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refImmediateComposite");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefObject#refImmediateComposite()");
        method.addHeader(" */");
        method.setSignature("public RefFeatured refImmediateComposite()");
        method.addBody("\t\treturn " + Generator.composeVariableName(VARIABLE_COMPOSITE, true) + ";");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refOutermostComposite");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefObject#refOutermostComposite()");
        method.addHeader(" */");
        method.setSignature("public RefFeatured refOutermostComposite()");
        method.addBody("\t\treturn this;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("get___AssociationsContainer");
        method.setSignature("public com.sap.ip.mmr.foundation.AssociationsContainer get___AssociationsContainer()");
        method.addBody("   return null;");
        code.addMethod(method);
        method = CodeContainer.getCodeMethod("refDelete");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefObject#refDelete()");
        method.addHeader(" */");
        method.setSignature("public void refDelete()");
        method.addBody("// clear the Java reference of composites");
        method.addBody("___composite = null;");
        method.addBody("java.util.List list = new java.util.LinkedList();");
        method.addBody("    java.util.Collection c = null;");
        method.addBody("    java.util.Iterator i = null;");
        method.addBody("    javax.jmi.reflect.RefObject ro = null;");
        Iterator i = Utilities.getUtilities().getAllContent(modelElement).iterator();
        while (i.hasNext()) {
            Reference r;
            ModelElement me = (ModelElement)i.next();
            if (me instanceof Attribute) {
                Attribute a = (Attribute)me;
                if (!ScopeKindEnum.INSTANCE_LEVEL.equals((Object)a.getScope()) || !(a.getType() instanceof MofClass)) continue;
                if (a.getMultiplicity().getUpper() < 0 || a.getMultiplicity().getUpper() > 1) {
                    method.addBody("    c = (java.util.Collection) refGetValue(\"" + a.getName() + "\");");
                    method.addBody("\ti = c.iterator();");
                    method.addBody("\twhile (i.hasNext()) {");
                    method.addBody("\t\tro = (javax.jmi.reflect.RefObject) i.next();");
                    method.addBody("\t\tif (ro != null) {");
                    method.addBody("\t       list.add(ro);");
                    method.addBody("\t    }");
                    method.addBody("\t}");
                    method.addBody("    c.clear();");
                    continue;
                }
                if (a.getMultiplicity().getLower() != 0 || a.getMultiplicity().getUpper() != 1) continue;
                method.addBody("    ro = (javax.jmi.reflect.RefObject) refGetValue(\"" + a.getName() + "\");");
                method.addBody("\tif (ro != null) {");
                method.addBody("\t  list.add(ro);");
                method.addBody("    }");
                method.addBody("    refSetValue(\"" + a.getName() + "\",null);");
                continue;
            }
            if (!(me instanceof Reference) || !AggregationKindEnum.COMPOSITE.equals((Object)(r = (Reference)me).getExposedEnd().getAggregation()) || !ScopeKindEnum.INSTANCE_LEVEL.equals((Object)r.getScope()) || !(r.getType() instanceof MofClass)) continue;
            if (r.getMultiplicity().getUpper() < 0 || r.getMultiplicity().getUpper() > 1) {
                method.addBody("    c = (java.util.Collection) refGetValue(\"" + r.getName() + "\");");
                method.addBody("\ti = c.iterator();");
                method.addBody("\twhile (i.hasNext()) {");
                method.addBody("\t\tro = (javax.jmi.reflect.RefObject) i.next();");
                method.addBody("\t    if (ro != null) {");
                method.addBody("\t      list.add(ro);");
                method.addBody("\t    }");
                method.addBody("\t}");
                continue;
            }
            if (r.getMultiplicity().getLower() != 0 || r.getMultiplicity().getUpper() != 1) continue;
            method.addBody("    ro = (javax.jmi.reflect.RefObject) refGetValue(\"" + r.getName() + "\");");
            method.addBody("\tif (ro != null) {");
            method.addBody("\t  list.add(ro);");
            method.addBody("    }");
        }
        method.addBody("list.add(this);");
        method.addBody("i = list.iterator();");
        method.addBody("while (i.hasNext()) {");
        method.addBody("\tro = (javax.jmi.reflect.RefObject) i.next();");
        method.addBody("    if (ro != null) {");
        method.addBody("\t  if (!ro.equals(this)) {");
        method.addBody("\t    ro.refDelete();");
        method.addBody("      }");
        method.addBody("\t  ___repository.removeAllLinksM1(ro);");
        method.addBody("    }");
        method.addBody("}");
        method.addBody(" // delete in class");
        method.addBody(" RefClass rcl = refClass();");
        method.addBody(" ((com.sap.ip.mmr.m1layer.IRefClass)rcl).deleteInstance(this);");
        code.addMethod(method);
    }

    public static void generateTemplateRefPackageDecl(StringBuffer code, MofPackage mofPackage, String javaClassName) {
        Generator.generateTemplateRefBaseObjectDecl(code, (ModelElement)mofPackage, javaClassName);
        ArrayList<String> l = new ArrayList<String>(100);
        l.add("");
        l.add("");
        Generator.addToCode(code, l);
    }

    public static void generateTemplateRefPackage(CodeContainer code, MofPackage mofPackage, String javaClassName) {
        Generator.generateTemplateRefBaseObject(code, (ModelElement)mofPackage, javaClassName);
        code.addTemplate(IRepositoryConst.PACKAGE_BASE_AS_PATH + "/generate/jmi/RefPackageTemplate.txt");
        CodeContainer.CodeMethod method = CodeContainer.getCodeMethod("refGetEnum");
        method.addHeader("/**");
        method.addHeader(" * @see javax.jmi.reflect.RefPackage#refGetEnum(String, String)");
        method.addHeader(" */");
        method.setSignature("public RefEnum refGetEnum(String enumName, String name)");
        method.addBody("   RefEnum re = null;");
        boolean firstEnum = true;
        Iterator iter = Generator.getAllContent((ModelElement)mofPackage).iterator();
        while (iter.hasNext()) {
            EnumerationType et;
            ModelElement me = (ModelElement)iter.next();
            if (!(me instanceof EnumerationType) || Generator.isJavaType((et = (EnumerationType)me).getName())) continue;
            String strIf = "   ";
            if (firstEnum) {
                strIf = strIf + "if";
                firstEnum = false;
            } else {
                strIf = strIf + "else if";
            }
            strIf = strIf + " (enumName.compareTo(\"" + et.getName() + "\") == 0) {";
            method.addBody(strIf);
            boolean firstValue = true;
            Iterator iterV = Generator.getAllEnumrationLabels(et).iterator();
            while (iterV.hasNext()) {
                String label = (String)iterV.next();
                strIf = "      ";
                if (firstValue) {
                    strIf = strIf + "if";
                    firstValue = false;
                } else {
                    strIf = strIf + "else if";
                }
                strIf = strIf + " (name.compareTo(\"" + label + "\") == 0) {";
                method.addBody(strIf);
                String str = "         re = " + GeneratorEnumerationType.getJavaClassNameQualified(et) + "." + Generator.correctConstant(label) + ";";
                method.addBody(str);
                method.addBody("      }");
            }
            method.addBody("   }");
        }
        method.addBody("   return re;");
        code.addMethod(method);
        Generator.generateTemplateRefPackageAddInit(code, mofPackage, javaClassName);
    }

    private static void generateTemplateRefPackageAddInit(CodeContainer code, MofPackage mofPackage, String javaClassName) {
        ModelElement me;
        CodeContainer.CodeMethod method = CodeContainer.getCodeMethod("initialize");
        method.addHeader("/**");
        method.addHeader(" * Initialize the refPackage, refClass and refAssociation information");
        method.addHeader(" */");
        method.setSignature("private void initialize()");
        method.addBody("  if (___refPackages == null) {");
        method.addBody("  \t___refPackages = new java.util.LinkedList();");
        LinkedList<MofPackage> ls = new LinkedList<MofPackage>();
        ls.add(mofPackage);
        ls.addAll(mofPackage.allSupertypes());
        Iterator i1 = ls.iterator();
        while (i1.hasNext()) {
            ModelElement ns = (ModelElement)i1.next();
            if (!(ns instanceof Namespace)) continue;
            Iterator i2 = ((Namespace)ns).getContents().iterator();
            while (i2.hasNext()) {
                Import im;
                ModelElement me2 = (ModelElement)i2.next();
                if (me2 instanceof MofPackage) {
                    method.addBody("\t___refPackages.add(new RefPackageAndName(\"" + me2.getName() + "\",\"" + Utilities.getUtilities().encodeQualifiedName(me2.getQualifiedName()) + "\",false,null));");
                    continue;
                }
                if (!(me2 instanceof Import) || !(im = (Import)me2).isClustered()) continue;
                method.addBody("\t___refPackages.add(new RefPackageAndName(\"" + im.getImportedNamespace().getName() + "\",\"" + Utilities.getUtilities().encodeQualifiedName(im.getImportedNamespace().getQualifiedName()) + "\",true,null));");
            }
        }
        method.addBody("  }");
        method.addBody("  if (___refClasses == null) {");
        method.addBody("  \t___refClasses = new java.util.LinkedList();");
        Iterator iter = Utilities.getUtilities().getAllContent((ModelElement)mofPackage).iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof MofClass)) continue;
            method.addBody("\t___refClasses.add(new RefClassAndName(\"" + me.getName() + "\",\"" + Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName()) + "\",null));");
        }
        method.addBody("  }");
        method.addBody("  if (___refAssociations == null) {");
        method.addBody("  \t___refAssociations = new java.util.LinkedList();");
        iter = Utilities.getUtilities().getAllContent((ModelElement)mofPackage).iterator();
        while (iter.hasNext()) {
            me = (ModelElement)iter.next();
            if (!(me instanceof Association)) continue;
            method.addBody("\t___refAssociations.add(new RefAssociationAndName(\"" + me.getName() + "\",\"" + Utilities.getUtilities().encodeQualifiedName(me.getQualifiedName()) + "\",null));");
        }
        method.addBody("  }");
        code.addMethod(method);
    }

    public static String getJMIIdentifierQualified(Namespace namespace) {
        List prefix;
        List values;
        String value;
        Tag tag;
        StringBuffer b = new StringBuffer(1024);
        LinkedList<String> list = new LinkedList<String>();
        for (Namespace container = namespace.getContainer(); container != null; container = container.getContainer()) {
            if (container instanceof MofPackage) {
                Tag tag2;
                MofPackage mp = (MofPackage)container;
                if (mp.getName().compareTo("MOF_PACKAGE_M2_ROOT") != 0) {
                    list.add(0, mp.getName());
                }
                if ((tag2 = Generator.getTag((Namespace)mp, JMI_TAG_PACKAGE_PREFIX)) != null) {
                    list.addAll(0, Utilities.getUtilities().decodeQualifiedName((String)tag2.getValues().get(0)));
                }
            }
            if (!(container instanceof NamespaceImpl) || (tag = ((NamespaceImpl)container).getTagPrefix()) == null) continue;
            value = null;
            values = tag.getValues();
            if (values != null && values.size() > 0) {
                value = (String)values.get(0);
            }
            if (value == null) continue;
            prefix = Utilities.getUtilities().decodeQualifiedName(value);
            list.addAll(0, prefix);
        }
        if (namespace instanceof NamespaceImpl) {
            tag = ((NamespaceImpl)namespace).getTagPrefix();
            if (tag != null) {
                value = null;
                values = tag.getValues();
                if (values != null && values.size() > 0) {
                    value = (String)values.get(0);
                }
                if (value != null) {
                    prefix = Utilities.getUtilities().decodeQualifiedName(value);
                    list.addAll(0, prefix);
                }
            }
            if ((tag = Generator.getTag(namespace, JMI_TAG_PACKAGE_PREFIX)) != null) {
                list.addAll(0, Utilities.getUtilities().decodeQualifiedName((String)tag.getValues().get(0)));
            }
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            b.append(Generator.correctName((String)iter.next()).toLowerCase());
            b.append('.');
        }
        b.append(Generator.getJMIIdentifier((ModelElement)namespace));
        return b.toString();
    }

    public static String getJMIIdentifier(ModelElement modelElement) {
        String identifier = modelElement.getName();
        String ident = Generator.getSubstituteIdentifier(modelElement);
        if (ident != null) {
            identifier = ident;
        }
        if (modelElement instanceof MofPackage) {
            identifier = Generator.correctName(identifier);
            identifier = Generator.convertFirstCharToUpper(identifier);
        } else if (modelElement instanceof MofClass) {
            identifier = Generator.correctName(identifier);
            identifier = Generator.convertFirstCharToUpper(identifier);
        } else if (modelElement instanceof Operation) {
            identifier = Generator.correctName(identifier);
            identifier = Generator.convertFirstCharToLower(identifier);
        } else if (modelElement instanceof Attribute) {
            identifier = Generator.correctName(identifier);
            identifier = Generator.convertFirstCharToLower(identifier);
        } else if (modelElement instanceof Reference) {
            identifier = Generator.correctName(identifier);
            identifier = Generator.convertFirstCharToLower(identifier);
        } else if (modelElement instanceof Constant) {
            identifier = Generator.correctConstant(identifier);
            identifier = Generator.convertFirstCharToUpper(identifier);
        } else if (modelElement instanceof EnumerationType) {
            identifier = Generator.correctName(identifier);
            identifier = Generator.convertFirstCharToUpper(identifier);
        } else if (modelElement instanceof MofException) {
            identifier = Generator.correctName(identifier);
            if ((identifier = Generator.convertFirstCharToUpper(identifier)).indexOf(EXTENSION_EXCEPTION) < 0) {
                identifier = identifier + EXTENSION_EXCEPTION;
            } else {
                int n = identifier.indexOf(EXTENSION_EXCEPTION);
                if (n + EXTENSION_EXCEPTION.length() != identifier.length()) {
                    identifier = identifier + EXTENSION_EXCEPTION;
                }
            }
        } else {
            identifier = Generator.correctName(identifier);
            identifier = Generator.convertFirstCharToUpper(identifier);
        }
        return identifier;
    }

    public boolean isNoJavaDocs() {
        return this.noJavaDocs;
    }

    public void setNoJavaDocs(boolean noJavaDocs) {
        this.noJavaDocs = noJavaDocs;
    }

    public static String mapVisibilityToJava(Feature feature) {
        String vis = "public";
        if (VisibilityKindEnum.PUBLIC_VIS.equals((Object)feature.getVisibility())) {
            vis = "public";
        } else if (VisibilityKindEnum.PROTECTED_VIS.equals((Object)feature.getVisibility())) {
            vis = "protected";
        } else if (VisibilityKindEnum.PRIVATE_VIS.equals((Object)feature.getVisibility())) {
            vis = "private";
        }
        return vis;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

