/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.fs;

import com.sap.ip.mmr.Configuration;
import com.sap.ip.mmr.IRepositoryServer;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.foundation.ClassLoaderFactory;
import com.sap.ip.mmr.foundation.ClassLoaderMMR;
import com.sap.ip.mmr.foundation.FileContent;
import com.sap.ip.mmr.foundation.JavaSource;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.fs.IRepositoryFS;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class RepositoryFS
implements IRepositoryFS {
    protected static final int debugLevelRead = 1;
    protected static final int debugLevelWrite = 2;
    private Map resBundles;
    private Configuration configuration;
    private IRepositoryServer repositoryServer;
    private static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$fs$RepositoryFS == null ? (class$com$sap$ip$mmr$fs$RepositoryFS = RepositoryFS.class$("com.sap.ip.mmr.fs.RepositoryFS")) : class$com$sap$ip$mmr$fs$RepositoryFS);
    static /* synthetic */ Class class$com$sap$ip$mmr$fs$RepositoryFS;

    public RepositoryFS(IRepositoryServer repositoryServer, Configuration configuration) {
        this.repositoryServer = repositoryServer;
        this.configuration = configuration;
        this.resBundles = new HashMap(10);
    }

    public boolean createDirectory(String path) {
        String path_ = path;
        String method = "";
        path_ = path_.replace('\\', '/');
        boolean res = true;
        File f = new File(path_);
        if (f.exists()) {
            if (!f.isDirectory()) {
                RepositoryServer.getCategory().errorT(location, "", MMRResourceAccessor.getInstance().getMessageText("2050"), new Object[]{path_});
                res = false;
            }
        } else {
            int n = path_.lastIndexOf(47);
            if (n >= 0) {
                res = this.createDirectory(path_.substring(0, n));
            }
            if (res && !f.mkdir()) {
                RepositoryServer.getCategory().errorT(location, "", MMRResourceAccessor.getInstance().getMessageText("2051"), new Object[]{path_});
            }
        }
        return res;
    }

    public boolean deleteDirectory(String path) {
        boolean res = this.deleteDirectoryContent(path, false);
        if (res) {
            File f = new File(path);
            res = f.delete();
        }
        return res;
    }

    public boolean deleteDirectoryContent(String path, boolean filesOnly) {
        File[] files;
        boolean flag = true;
        File fileDir = new File(path);
        if (fileDir.isDirectory() && (files = fileDir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (this.deleteDirectoryContentRec(files[i], filesOnly)) continue;
                flag = false;
            }
        }
        return flag;
    }

    protected boolean deleteDirectoryContentRec(File file, boolean filesOnly) {
        String method = "deleteDirectoryContentRec(File file, boolean filesOnly)";
        boolean flag = true;
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    this.deleteDirectoryContentRec(files[i], filesOnly);
                }
            }
            if (!filesOnly && !file.delete()) {
                RepositoryServer.getCategory().errorT(location, "deleteDirectoryContentRec(File file, boolean filesOnly)", MMRResourceAccessor.getInstance().getMessageText("2052"), new Object[]{file.getAbsolutePath()});
                flag = false;
            }
        } else if (!file.delete()) {
            RepositoryServer.getCategory().errorT(location, "deleteDirectoryContentRec(File file, boolean filesOnly)", MMRResourceAccessor.getInstance().getMessageText("2053"), new Object[]{file.getAbsolutePath()});
            flag = false;
        }
        return flag;
    }

    public String getResourceAsString(String resourceName, boolean noMessages) {
        StringBuffer b;
        block5: {
            String method = "getResourceAsString(String resourceName,boolean noMessages)";
            ClassLoaderMMR cl = ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this.repositoryServer, null);
            InputStream is = ((ClassLoader)cl).getResourceAsStream(resourceName);
            if (is == null) {
                if (!noMessages) {
                    RepositoryServer.getCategory().errorT(location, "getResourceAsString(String resourceName,boolean noMessages)", MMRResourceAccessor.getInstance().getMessageText("2054"), new Object[]{resourceName});
                }
                return null;
            }
            b = new StringBuffer(10000);
            try {
                int n = 0;
                byte[] bytes = new byte[1024];
                do {
                    if ((n = is.read(bytes, 0, 1024)) <= 0) continue;
                    String s = new String(bytes, 0, n);
                    b.append(s);
                } while (n > 0);
                is.close();
            }
            catch (IOException e) {
                if (noMessages) break block5;
                e.printStackTrace(System.err);
            }
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public long getResourceLastChanged(String resourceName) {
        long lastChanged;
        block12: {
            String u;
            block13: {
                JarFile jf;
                block11: {
                    String entryName;
                    JarEntry je;
                    String method = "getResourceLastChanged(String resourceName)";
                    lastChanged = -1L;
                    ClassLoaderMMR cl = ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this.repositoryServer, null);
                    URL url = cl.getResource(resourceName);
                    if (url == null) {
                        return -1L;
                    }
                    u = url.getPath();
                    int n = u.indexOf(33);
                    if (n <= 0) break block13;
                    if ((u = u.substring(0, n)).indexOf("file:") == 0) {
                        u = u.substring("file:".length());
                    }
                    jf = null;
                    jf = new JarFile(u);
                    if (jf == null || (je = jf.getJarEntry(entryName = url.getPath().substring(n + 2).replace('\\', '/'))) == null) break block11;
                    lastChanged = je.getTime();
                }
                Object var13_13 = null;
                try {
                    jf.close();
                }
                catch (IOException e1) {
                    Repository.getCategory().errorT(location, "getResourceLastChanged(String resourceName)", e1.toString());
                }
                break block12;
                {
                    catch (IOException e) {
                        Repository.category.errorT(location, e.toString());
                        Object var13_14 = null;
                        try {
                            jf.close();
                        }
                        catch (IOException e1) {
                            Repository.getCategory().errorT(location, "getResourceLastChanged(String resourceName)", e1.toString());
                        }
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_15 = null;
                    try {
                        jf.close();
                    }
                    catch (IOException e1) {
                        Repository.getCategory().errorT(location, "getResourceLastChanged(String resourceName)", e1.toString());
                    }
                    throw throwable;
                }
            }
            File fsource = new File(u);
            if (fsource.exists()) {
                lastChanged = fsource.lastModified();
            }
        }
        return lastChanged;
    }

    public InputStream getResourceAsStream(String resourceName, boolean noMessages) {
        if (resourceName == null) {
            return null;
        }
        String method = "getResourceAsStream(String resourceName,boolean noMessages)";
        InputStream is = null;
        ClassLoaderMMR cl = ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this.repositoryServer, null);
        is = ((ClassLoader)cl).getResourceAsStream(resourceName);
        if (is == null) {
            if (!noMessages) {
                RepositoryServer.getCategory().errorT(location, "getResourceAsStream(String resourceName,boolean noMessages)", MMRResourceAccessor.getInstance().getMessageText("2055"), new Object[]{resourceName});
            }
            return null;
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        return bis;
    }

    public Object getResourceAsSerializedObject(String resourceName, boolean noMessages) {
        String method = "getResourceAsSerializedObject(String resourceName,boolean noMessages)";
        Object o = null;
        ClassLoaderMMR cl = ClassLoaderFactory.getClassLoaderFactory().getClassLoader(this.repositoryServer, null);
        InputStream is = ((ClassLoader)cl).getResourceAsStream(resourceName);
        if (is == null) {
            if (!noMessages) {
                RepositoryServer.getCategory().errorT(location, "getResourceAsSerializedObject(String resourceName,boolean noMessages)", MMRResourceAccessor.getInstance().getMessageText("2055"), new Object[]{resourceName});
            }
            return o;
        }
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            ObjectInputStream ostream = new ObjectInputStream(bis);
            try {
                o = ostream.readObject();
            }
            catch (ClassNotFoundException e) {
                RepositoryServer.getCategory().errorT(location, "getResourceAsSerializedObject(String resourceName,boolean noMessages)", MMRResourceAccessor.getInstance().getMessageText("2055"), new Object[]{resourceName});
                return null;
            }
            is.close();
        }
        catch (IOException e) {
            Repository.category.errorT(location, e.toString());
        }
        return o;
    }

    public List getFilenames(String path, String filter, boolean includeSubdirectories) {
        ArrayList fnames = new ArrayList(100);
        File dir = new File(path);
        if (dir != null && dir.isDirectory()) {
            this.getFilenames(fnames, dir, filter, includeSubdirectories);
        }
        return fnames;
    }

    protected void getFilenames(List fnames, File directory, String filter, boolean includeSubdirectories) {
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (!includeSubdirectories) continue;
                    this.getFilenames(fnames, files[i], filter, includeSubdirectories);
                    continue;
                }
                String fname = files[i].getName();
                boolean flagAdd = true;
                if (filter != null && fname.indexOf(filter) < 0) {
                    flagAdd = false;
                }
                if (!flagAdd) continue;
                fnames.add(files[i].getAbsolutePath());
            }
        }
    }

    public boolean writeJavaSource(String directory, JavaSource javaSource) {
        boolean res = false;
        if (javaSource == null || javaSource.getName() == null) {
            return res;
        }
        if (this.createDirForClassSource(directory, javaSource.getName())) {
            String filename = this.getFileNameOfClassSource(directory, javaSource.getName());
            res = this.writeFileContent(new FileContent(filename, javaSource.getSourceCode()), false);
        }
        return res;
    }

    public boolean writeFileContents(Collection fileContentCollection, boolean append) {
        String method = "writeFileContents(Collection fileContentCollection,boolean append)";
        boolean flag = true;
        Iterator iter = fileContentCollection.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof FileContent)) continue;
            FileContent fc = (FileContent)o;
            String path = fc.getFilename();
            if (RepositoryFS.createDirsOfPath(path)) {
                if (this.writeFileContent(new FileContent(path, fc.getFilecontent()), append)) continue;
                flag = false;
                continue;
            }
            RepositoryServer.getCategory().errorT(location, "writeFileContents(Collection fileContentCollection,boolean append)", MMRResourceAccessor.getInstance().getMessageText("2056"), new Object[]{path});
            flag = false;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] readFileContent(String filename) {
        byte[] data;
        block14: {
            String method = "readFileContent(String filename";
            data = null;
            FileInputStream fis = null;
            fis = new FileInputStream(filename);
            File f = new File(filename);
            data = new byte[(int)f.length()];
            fis.read(data, 0, (int)f.length());
            Object var7_8 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                break block14;
            }
            catch (IOException e1) {
                RepositoryServer.category.errorT(location, e1.toString());
            }
            break block14;
            {
                catch (FileNotFoundException e) {
                    RepositoryServer.getCategory().errorT(location, "readFileContent(String filename", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
                    Object var7_9 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    break block14;
                }
                catch (IOException e) {
                    RepositoryServer.getCategory().errorT(location, "readFileContent(String filename", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
                    Object var7_10 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block14;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        return data;
    }

    public boolean writeFileContent(FileContent fileContent, boolean append) {
        String method = "writeFileContent(FileContent fileContent, boolean append)";
        boolean res = false;
        File file = new File(fileContent.getFilename());
        try {
            if (!file.exists()) {
                RepositoryFS.createDirsOfPath(file.getAbsolutePath());
                file.createNewFile();
            } else if (!file.canWrite()) {
                RepositoryServer.getCategory().errorT(location, "writeFileContent(FileContent fileContent, boolean append)", MMRResourceAccessor.getInstance().getMessageText("2057"), new Object[]{file.getAbsolutePath()});
                return res;
            }
            FileWriter fwriter = new FileWriter(file.getAbsolutePath(), append);
            if (fwriter == null) {
                fwriter = new FileWriter(file.getAbsolutePath(), false);
            }
            if (fwriter == null) {
                RepositoryServer.getCategory().errorT(location, "writeFileContent(FileContent fileContent, boolean append)", MMRResourceAccessor.getInstance().getMessageText("2056"), new Object[]{file.getAbsolutePath()});
                return false;
            }
            fwriter.write(fileContent.getFilecontent());
            fwriter.flush();
            fwriter.close();
            res = true;
        }
        catch (IOException e) {
            RepositoryServer.getCategory().errorT(location, "writeFileContent(FileContent fileContent, boolean append)", MMRResourceAccessor.getInstance().getMessageText("2058"), new Object[]{file.getAbsolutePath(), e.toString()});
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean writeBinary(String path, byte[] data) {
        boolean res;
        block24: {
            FileOutputStream fos;
            File file;
            block22: {
                block20: {
                    String path_;
                    if (data == null) {
                        return false;
                    }
                    String method = "writeBinary(byte data[])";
                    res = true;
                    String dir = path_ = path.replace('\\', '/');
                    int n = path_.lastIndexOf(47);
                    if (n > 0) {
                        dir = path_.substring(0, n);
                    }
                    this.createDirectory(dir);
                    RepositoryFS.createDirsOfPath(path_);
                    file = new File(path_);
                    fos = null;
                    if (!file.exists()) {
                        file.createNewFile();
                        break block20;
                    }
                    if (file.canWrite()) break block20;
                    RepositoryServer.getCategory().errorT(location, "writeBinary(byte data[])", MMRResourceAccessor.getInstance().getMessageText("2057"), new Object[]{file.getAbsolutePath()});
                    boolean bl = res;
                    Object var12_13 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    return bl;
                }
                fos = new FileOutputStream(file);
                if (fos != null) break block22;
                RepositoryServer.getCategory().errorT(location, "writeBinary(byte data[])", MMRResourceAccessor.getInstance().getMessageText("2056"), new Object[]{file.getAbsolutePath()});
                boolean bl = false;
                Object var12_14 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                return bl;
            }
            fos.write(data);
            res = true;
            Object var12_15 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                break block24;
            }
            catch (IOException e1) {
                RepositoryServer.category.errorT(location, e1.toString());
            }
            break block24;
            {
                catch (IOException e) {
                    RepositoryServer.getCategory().errorT(location, "writeBinary(byte data[])", MMRResourceAccessor.getInstance().getMessageText("2058"), new Object[]{file.getAbsolutePath(), e.toString()});
                    Object var12_16 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block24;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        return res;
    }

    public byte[] readBinary(String path) {
        return this.readFileContent(path);
    }

    public String getDirTempFiles() {
        return System.getProperty("java.io.tmpdir").replace('\\', '/');
    }

    public static boolean createDir(String dirName) {
        String method = "createDir(String dirName)";
        File dir = new File(dirName);
        if (dir.exists()) {
            return true;
        }
        if (dir.mkdir()) {
            return true;
        }
        RepositoryServer.getCategory().errorT(location, "createDir(String dirName)", MMRResourceAccessor.getInstance().getMessageText("2059"), new Object[]{dirName});
        return false;
    }

    public static boolean createDirsOfPath(String path) {
        int n;
        String p = path.replace('\\', '/');
        File file = new File(p.substring(0, n = p.lastIndexOf(47)));
        if (file.exists()) {
            return true;
        }
        String dir = "";
        n = 0;
        int m = 0;
        while (n >= 0 && n < p.length() && (m = p.indexOf(47, n)) >= 0) {
            String dirTmp = p.substring(n, m);
            file = new File(dir = dir + dirTmp + "/");
            if (!file.exists()) {
                file.mkdir();
            }
            n = m + 1;
        }
        return true;
    }

    public boolean createDirForClassSource(String directory, String className) {
        int m = 0;
        String dir = new String(directory);
        m = dir.lastIndexOf(47);
        if (m != dir.length() - 1) {
            dir = dir + "/";
        }
        dir = dir + className.replace('.', '/');
        return RepositoryFS.createDirsOfPath(dir);
    }

    public String getFileNameOfClassSource(String directory, String className) {
        int m = 0;
        String dir = new String(directory);
        m = dir.lastIndexOf(47);
        if (m != dir.length() - 1) {
            dir = dir + "/";
        }
        dir = dir + className.replace('.', '/') + ".java";
        return dir;
    }

    public ResourceBundle getResourceBundle(String id, String language, String country) {
        String lang = language;
        String ctry = country;
        String key = null;
        if (lang == null || lang.length() < 1) {
            key = id + "_EN";
            lang = "EN";
        } else if (ctry == null || ctry.length() < 1) {
            key = id + "_" + lang;
            ctry = "";
        } else {
            key = id + "_" + lang + "_" + ctry;
        }
        ResourceBundle rb = (ResourceBundle)this.resBundles.get(key);
        if (rb == null) {
            Locale currentLocale = new Locale(lang, ctry);
            try {
                rb = ResourceBundle.getBundle(id, currentLocale);
            }
            catch (Exception e) {
                rb = null;
            }
            if (rb != null) {
                this.resBundles.put(key, rb);
            }
        }
        return rb;
    }

    public static boolean deleteDirWithContent(String path) {
        boolean result = true;
        File file = new File(path);
        if (file.exists()) {
            File[] child = file.listFiles();
            for (int i = 0; i < child.length && !(child[i].isDirectory() ? !(result = RepositoryFS.deleteDirWithContent(child[i].getAbsolutePath())) : !(result = child[i].delete())); ++i) {
            }
            result = file.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Properties readPropertiesFile(String path) {
        Properties p;
        block16: {
            FileInputStream fis;
            block14: {
                p = new Properties();
                fis = null;
                File f = new File(path);
                if (f.exists()) break block14;
                Properties properties = p;
                Object var7_7 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                return properties;
            }
            fis = new FileInputStream(path);
            p.load(fis);
            Object var7_8 = null;
            try {
                if (fis != null) {
                    fis.close();
                }
                break block16;
            }
            catch (IOException e1) {
                RepositoryServer.category.errorT(location, e1.toString());
            }
            break block16;
            {
                catch (IOException e) {
                    Repository.category.errorT(location, e.toString());
                    Object var7_9 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                        break block16;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void writePropertiesFile(String path, String comment, Properties properties) {
        block16: {
            String cmnt = comment;
            FileOutputStream fos = null;
            File f = new File(path);
            if (!f.exists()) {
                RepositoryFS.createDirsOfPath(path);
                f.createNewFile();
            }
            fos = new FileOutputStream(path);
            if (cmnt == null) {
                cmnt = "";
            }
            properties.store(fos, cmnt);
            Object var8_9 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                break block16;
            }
            catch (IOException e1) {
                RepositoryServer.category.errorT(location, e1.toString());
            }
            break block16;
            {
                catch (FileNotFoundException e) {
                    Repository.category.errorT(location, e.toString());
                    Object var8_10 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block16;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    break block16;
                }
                catch (IOException e) {
                    Repository.category.errorT(location, e.toString());
                    Object var8_11 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block16;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
    }

    public void deletePropertiesFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            f.delete();
        }
    }

    public List getAllPathsOfDirectory(String path) {
        LinkedList l = new LinkedList();
        this.getAllPathsOfDirectoryRecursive(path, l);
        return l;
    }

    public void getAllPathsOfDirectoryRecursive(String path, List l) {
        File f = new File(path);
        if (f.exists()) {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.getAllPathsOfDirectoryRecursive(files[i].getAbsolutePath(), l);
                }
            } else {
                l.add(path);
            }
        }
    }

    public String readString(String filename, String charsetName) {
        String method = "readString(String path, String charsetName)";
        char[] data = null;
        try {
            FileInputStream fis = new FileInputStream(filename);
            InputStreamReader isr = new InputStreamReader((InputStream)fis, charsetName);
            File f = new File(filename);
            data = new char[(int)f.length()];
            isr.read(data, 0, (int)f.length());
            isr.close();
            fis.close();
        }
        catch (FileNotFoundException e) {
            RepositoryServer.getCategory().errorT(location, "readString(String path, String charsetName)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
        }
        catch (IOException e) {
            RepositoryServer.getCategory().errorT(location, "readString(String path, String charsetName)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
        }
        return new String(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean writeString(String path, String data, String charsetName) {
        boolean res;
        block27: {
            OutputStreamWriter osw;
            FileOutputStream fos;
            File file;
            block25: {
                block23: {
                    String method = "writeString(String path, String dat)";
                    res = true;
                    file = new File(path);
                    fos = null;
                    osw = null;
                    if (!file.exists()) {
                        RepositoryFS.createDirsOfPath(path);
                        file.createNewFile();
                        break block23;
                    }
                    if (file.canWrite()) break block23;
                    RepositoryServer.getCategory().errorT(location, "writeString(String path, String dat)", MMRResourceAccessor.getInstance().getMessageText("2057"), new Object[]{file.getAbsolutePath()});
                    boolean bl = res;
                    Object var11_12 = null;
                    try {
                        if (osw != null) {
                            osw.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                    return bl;
                }
                fos = new FileOutputStream(file);
                if (fos != null) break block25;
                RepositoryServer.getCategory().errorT(location, "writeString(String path, String dat)", MMRResourceAccessor.getInstance().getMessageText("2056"), new Object[]{file.getAbsolutePath()});
                boolean bl = false;
                Object var11_13 = null;
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                return bl;
            }
            osw = new OutputStreamWriter((OutputStream)fos, charsetName);
            osw.write(data);
            res = true;
            Object var11_14 = null;
            try {
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
                break block27;
            }
            catch (IOException e1) {
                RepositoryServer.category.errorT(location, e1.toString());
            }
            break block27;
            {
                catch (IOException e) {
                    RepositoryServer.getCategory().errorT(location, "writeString(String path, String dat)", MMRResourceAccessor.getInstance().getMessageText("2058"), new Object[]{file.getAbsolutePath(), e.toString()});
                    Object var11_15 = null;
                    try {
                        if (osw != null) {
                            osw.close();
                        }
                        if (fos != null) {
                            fos.close();
                        }
                        break block27;
                    }
                    catch (IOException e1) {
                        RepositoryServer.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_16 = null;
                try {
                    if (osw != null) {
                        osw.close();
                    }
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException e1) {
                    RepositoryServer.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

