/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.foundation.Utilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLWriter {
    Document document = null;
    String dtd = null;
    String dtdSystemPath = "";

    public XMLWriter(Document document) {
        this.document = document;
        this.document.getDocumentElement().normalize();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("<?xml version=\"1.0\" encoding=\"utf-16\"?>");
        buf.append(Utilities.SystemLineSeparator);
        if (this.getDtd() != null) {
            buf.append("<!DOCTYPE " + this.getDtd() + " SYSTEM '" + this.getDtdSystemPath() + this.getDtd() + ".dtd'>");
            buf.append(Utilities.SystemLineSeparator);
        }
        if (this.document != null) {
            Element root = (Element)this.document.getFirstChild();
            this.writeElement(root, buf, 0);
        }
        return buf.toString();
    }

    private void writeElement(Element element, StringBuffer buf, int level) {
        buf.append(this.whiteSpace(level));
        buf.append("<");
        buf.append(element.getNodeName());
        NamedNodeMap map = element.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Node node = map.item(i);
            buf.append(' ');
            buf.append(node.getNodeName());
            buf.append("='");
            buf.append(node.getNodeValue());
            buf.append("'");
        }
        buf.append(">");
        buf.append(Utilities.SystemLineSeparator);
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (!(node instanceof Element)) continue;
            this.writeElement((Element)node, buf, level + 1);
        }
        buf.append(this.whiteSpace(level));
        buf.append("</");
        buf.append(element.getNodeName());
        buf.append(">");
        buf.append(Utilities.SystemLineSeparator);
    }

    private String whiteSpace(int n) {
        StringBuffer buf = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public String getDtd() {
        return this.dtd;
    }

    public void setDtd(String dtd) {
        this.dtd = dtd;
    }

    public String getDtdSystemPath() {
        return this.dtdSystemPath;
    }

    public void setDtdSystemPath(String dtdSystemPath) {
        this.dtdSystemPath = dtdSystemPath;
    }
}

