/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.IGeneratorGUID;
import com.sap.ip.mmr.foundation.JmiVerifyException;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.MOFConstraintsResourceAccessor;
import com.sap.ip.mmr.foundation.RandomGUID;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.LogRecord;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.StreamLog;
import com.sap.tc.logging.TraceFormatter;
import java.awt.Font;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TimeZone;
import javax.jmi.model.EnumerationType;
import javax.jmi.model.GeneralizableElement;
import javax.jmi.model.ModelElement;
import javax.jmi.model.Namespace;

public class Utilities {
    protected static final Location location;
    private static Utilities utilities;
    private static IGeneratorGUID generatorGUID;
    private static final String MOF_PREFIX = "MOF_CONSTR_";
    public static final char SystemFileSeparator;
    public static final String SystemPathSeparator;
    public static final String SystemLineSeparator;
    public static final String FontNameSansSerif = "SansSerif";
    public static final String FontNameSerif = "Serif";
    public static final String FontNameMonospaced = "Monospaced";
    public static final int FontDefaultHeightInDots = 10;
    private static int FontSansSerifHeight;
    private static Map fonts;
    static /* synthetic */ Class class$com$sap$ip$mmr$foundation$Utilities;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Utilities() {
        Class clazz = class$com$sap$ip$mmr$foundation$Utilities == null ? (class$com$sap$ip$mmr$foundation$Utilities = Utilities.class$("com.sap.ip.mmr.foundation.Utilities")) : class$com$sap$ip$mmr$foundation$Utilities;
        synchronized (clazz) {
            if (generatorGUID == null) {
                try {
                    Class<?> c;
                    Class<?> cgf = Class.forName("com.sap.guid.GUIDGeneratorFactory");
                    if (cgf != null && (c = Class.forName("com.sap.ip.mmr.foundation.GUIDGeneratorSAP")) != null && (generatorGUID = (IGeneratorGUID)c.newInstance()).getGUID() == null) {
                        generatorGUID = null;
                    }
                }
                catch (Exception e) {
                    generatorGUID = null;
                }
                if (generatorGUID == null) {
                    generatorGUID = new RandomGUID(false);
                }
            }
        }
    }

    public static Utilities getUtilities() {
        if (utilities == null) {
            utilities = new Utilities();
        }
        return utilities;
    }

    public String getDefaultLanguage() {
        return Locale.getDefault().getLanguage();
    }

    public String getDefaultCountry() {
        return Locale.getDefault().getCountry();
    }

    public String getGUID() {
        return generatorGUID.getGUID();
    }

    public List splitClassPath(String path) {
        ArrayList<String> list = new ArrayList<String>();
        if (path == null || path.length() < 1) {
            return list;
        }
        int index0 = 0;
        int index1 = path.indexOf(SystemPathSeparator);
        int maxPaths = 10;
        int n = 0;
        do {
            String p;
            if (index1 > 0) {
                if (index1 > index0) {
                    p = path.substring(index0, index1);
                    list.add(p);
                }
                index0 = index1 + 1;
                index1 = path.indexOf(SystemPathSeparator, index0);
                continue;
            }
            p = path.substring(index0);
            if (p != null && p.length() > 0 && (index1 > index0 || index1 < 0)) {
                list.add(p);
            }
            index0 = -1;
        } while (index0 > 0 && ++n < 10);
        return list;
    }

    public List splitByChar(String value, char c) {
        LinkedList<String> list = new LinkedList<String>();
        if (value != null) {
            int n = 0;
            int m = 0;
            while (m >= 0) {
                m = value.indexOf(c, n);
                if (m <= 0) continue;
                list.add(value.substring(n, m));
                n = m + 1;
            }
            list.add(value.substring(n));
        }
        return list;
    }

    public List splitByChars(String value, String chars) {
        LinkedList<String> list = new LinkedList<String>();
        if (value == null || chars == null) {
            return list;
        }
        StringBuffer b = new StringBuffer(value.length());
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (chars.indexOf(c) >= 0) {
                if (b.length() > 0) {
                    list.add(b.toString());
                }
                b.setLength(0);
                continue;
            }
            b.append(c);
        }
        if (b.length() > 0) {
            list.add(b.toString());
        }
        return list;
    }

    public List splitPackagePrefix(String prefix) {
        return this.splitByChar(prefix, '.');
    }

    public List decodeQualifiedName(String qualifiedName) {
        if (qualifiedName == null) {
            return new LinkedList();
        }
        LinkedList<String> list = new LinkedList<String>();
        int n = 0;
        int m = 0;
        while (n >= 0) {
            n = qualifiedName.indexOf(46, m);
            if (n > 0) {
                list.add(this.decodeName(qualifiedName.substring(m, n)));
            } else {
                list.add(this.decodeName(qualifiedName.substring(m)));
            }
            m = n + 1;
        }
        return list;
    }

    public String encodeQualifiedName(List qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(256);
        Iterator i = qualifiedName.iterator();
        while (i.hasNext()) {
            buf.append(this.encodeName((String)i.next()));
            buf.append('.');
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public String encodeName(String name) {
        StringBuffer b = new StringBuffer(name);
        for (int i = 0; i < b.length(); ++i) {
            if (b.charAt(i) != '.') continue;
            b.replace(i, i + 1, "//");
        }
        return b.toString();
    }

    public String decodeName(String name) {
        String delimiter = String.valueOf('.');
        StringBuffer b = new StringBuffer(name);
        for (int i = 0; i < b.length() - 1; ++i) {
            if (b.charAt(i) != '/' || b.charAt(i + 1) != '/') continue;
            b.replace(i, i + 2, delimiter);
        }
        return b.toString();
    }

    public String getSystemName() {
        String name = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            name = inetAddress.getHostName();
        }
        catch (UnknownHostException e) {
            Repository.category.errorT(location, e.toString());
        }
        return name;
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    public String getTimeSAPInternalFormat() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(new Date());
        double t = 0.0;
        t += (double)cal.get(1) * 1.0E10;
        t += (double)(cal.get(2) + 1) * 1.0E8;
        t += (double)cal.get(5) * 1000000.0;
        t += (double)cal.get(11) * 10000.0;
        t += (double)cal.get(12) * 100.0;
        DecimalFormat df = new DecimalFormat("00000000000000");
        return df.format(t += (double)cal.get(13));
    }

    public long getTime(String sapInternalFormat) {
        long time = -1L;
        if (sapInternalFormat != null && sapInternalFormat.length() > 0) {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            cal.set(Integer.parseInt(sapInternalFormat.substring(0, 4)), Integer.parseInt(sapInternalFormat.substring(4, 6)) - 1, Integer.parseInt(sapInternalFormat.substring(6, 8)), Integer.parseInt(sapInternalFormat.substring(8, 10)), Integer.parseInt(sapInternalFormat.substring(10, 12)), Integer.parseInt(sapInternalFormat.substring(12, 14)));
            time = cal.getTime().getTime();
        }
        return time;
    }

    public String getTimeFormated(String timeSAPInternalFormat) {
        if (timeSAPInternalFormat == null || timeSAPInternalFormat.length() < 1) {
            return "";
        }
        long l = Utilities.getUtilities().getTime(timeSAPInternalFormat);
        Date date = new Date(l);
        DateFormat df = DateFormat.getDateTimeInstance(0, 0);
        return df.format(date);
    }

    public String getDateTimeFormated(Locale locale) {
        Date date = new Date(System.currentTimeMillis());
        DateFormat df = null;
        df = locale == null ? DateFormat.getDateTimeInstance(0, 0) : DateFormat.getDateTimeInstance(0, 0, locale);
        return df.format(date);
    }

    public String getTimeFormated(long seconds) {
        String str = null;
        str = seconds <= 0L ? "0s" : (seconds < 60L ? String.valueOf(seconds) + "s" : (seconds < 3600L ? String.valueOf(seconds / 60L) + "m " + String.valueOf(seconds % 60L) + "s" : String.valueOf(seconds / 3600L) + "h " + String.valueOf(seconds / 60L % 60L) + "m " + String.valueOf(seconds % 60L) + "s"));
        return str;
    }

    public String getTimeFormated(float seconds) {
        String str = null;
        long t_l = (long)seconds;
        str = seconds <= 0.0f ? String.valueOf(seconds) + "s" : (seconds < 60.0f ? String.valueOf(seconds) + "s" : (seconds < 3600.0f ? String.valueOf(t_l / 60L) + "m " + String.valueOf(seconds % 60.0f) + "s" : String.valueOf(t_l / 3600L) + "h " + String.valueOf(t_l / 60L % 60L) + "m " + String.valueOf(seconds % 60.0f) + "s"));
        return str;
    }

    public String getMemoryFormated(long bytes) {
        String str = null;
        str = bytes < 1024L ? bytes + " bytes" : (bytes < 0x100000L ? bytes / 1024L + " kBytes" : bytes / 0x100000L + " MBytes");
        return str;
    }

    private String getFontKey(String name, int style, int size) {
        return name + "__" + String.valueOf(style) + "__" + String.valueOf(size);
    }

    private void initializeFonts() {
        if (fonts == null) {
            fonts = new HashMap(10);
            Font fontSansSerif = new Font(FontNameSansSerif, 0, 10);
            fonts.put(this.getFontKey(FontNameSansSerif, 0, 10), fontSansSerif);
            FontSansSerifHeight = fontSansSerif.getSize();
        }
    }

    public int getFontSansSerifHeight() {
        this.initializeFonts();
        return FontSansSerifHeight;
    }

    public Font getFont(String name, int style, int size) {
        this.initializeFonts();
        Font font = null;
        font = (Font)fonts.get(this.getFontKey(name, style, size));
        if (font == null) {
            font = new Font(name, style, size);
            fonts.put(this.getFontKey(name, style, size), font);
        }
        return font;
    }

    public String getSpaces(int length) {
        if (length <= 0) {
            return "";
        }
        StringBuffer b = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            b.append(" ");
        }
        return b.toString();
    }

    public boolean containsPattern(String value, String pattern) {
        boolean res = true;
        pattern.replace('?', '%');
        if (pattern.indexOf(37) < 0 && pattern.indexOf(42) < 0) {
            res = value.compareTo(pattern) == 0;
        } else {
            int j = 0;
            block4: for (int i = 0; i < pattern.length() && j < value.length() && res; ++j, ++i) {
                char c_p = pattern.charAt(i);
                char c = value.charAt(j);
                switch (c_p) {
                    case '%': 
                    case '?': {
                        continue block4;
                    }
                    case '*': {
                        if (i + 1 == pattern.length()) {
                            i = pattern.length();
                            j = value.length();
                            continue block4;
                        }
                        c_p = pattern.charAt(i + 1);
                        ++j;
                        while (j < value.length() && value.charAt(j) != c_p) {
                            ++j;
                        }
                        if (j < value.length()) continue block4;
                        res = false;
                        continue block4;
                    }
                    default: {
                        if (c == c_p) continue block4;
                        res = false;
                    }
                }
            }
        }
        return res;
    }

    public Location getLocation(Class cl) {
        return Location.getLocation((String)cl.getName());
    }

    public Log getConsoleLog() {
        return this.getConsoleLog(System.out);
    }

    public Log getConsoleLog(PrintStream os) {
        FormatterWithObjects f = new FormatterWithObjects();
        StreamLog log = new StreamLog((OutputStream)os, (Formatter)f);
        return log;
    }

    public MMRResourceAccessor getResourceAccessor(String messageID) {
        MMRResourceAccessor ra = null;
        ra = messageID.indexOf(MOF_PREFIX) == 0 ? MOFConstraintsResourceAccessor.getInstance() : MMRResourceAccessor.getInstance();
        return ra;
    }

    public String getLongTextOfMOFConstraint(JmiVerifyException e) {
        return this.getLongTextOfMOFConstraint(e.getMessageID());
    }

    public String getLongTextOfMOFConstraint(String messageID) {
        String str = null;
        if (messageID.indexOf(MOF_PREFIX) == 0) {
            String s = messageID.substring(MOF_PREFIX.length());
            int i = Integer.parseInt(s);
            String mid = String.valueOf(i + 1000);
            try {
                str = MOFConstraintsResourceAccessor.getInstance().getMessageText(mid);
            }
            catch (MissingResourceException e) {
                str = "";
            }
        }
        return str;
    }

    public List getAllSupertypes(GeneralizableElement generalizableElement) {
        HashSet stypes = new HashSet();
        ArrayList list = new ArrayList();
        this.collectSypertypes(generalizableElement, list, stypes);
        return list;
    }

    public List getAllContent(ModelElement modelElement) {
        List col;
        List listST;
        ArrayList list = new ArrayList();
        if (modelElement instanceof GeneralizableElement && (listST = this.getAllSupertypes((GeneralizableElement)modelElement)) != null) {
            Iterator iter = listST.iterator();
            while (iter.hasNext()) {
                List col2;
                ModelElement st = (ModelElement)iter.next();
                if (!(st instanceof Namespace) || (col2 = ((Namespace)st).getContents()) == null) continue;
                Iterator i = col2.iterator();
                while (i.hasNext()) {
                    list.add(i.next());
                }
            }
        }
        if (modelElement instanceof Namespace && (col = ((Namespace)modelElement).getContents()) != null && col.size() > 0) {
            Iterator i = col.iterator();
            while (i.hasNext()) {
                list.add(i.next());
            }
        }
        return list;
    }

    private void collectSypertypes(GeneralizableElement generalizableElement, List list, Set superTypes) {
        List st = generalizableElement.getSupertypes();
        if (st != null) {
            Iterator iter = st.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (superTypes.contains(me)) continue;
                superTypes.add(me);
                if (me instanceof GeneralizableElement) {
                    this.collectSypertypes((GeneralizableElement)me, list, superTypes);
                }
                list.add(me);
            }
        }
    }

    public Collection getAllEnumrationLabels(EnumerationType enumerationType) {
        HashSet set = new HashSet();
        List st = this.getAllSupertypes((GeneralizableElement)enumerationType);
        if (st != null) {
            Iterator iter = st.iterator();
            while (iter.hasNext()) {
                ModelElement me = (ModelElement)iter.next();
                if (!(me instanceof EnumerationType)) continue;
                set.addAll(((EnumerationType)me).getLabels());
            }
        }
        set.addAll(enumerationType.getLabels());
        return set;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        SystemFileSeparator = System.getProperty("file.separator").charAt(0);
        SystemPathSeparator = System.getProperty("path.separator");
        SystemLineSeparator = System.getProperty("line.separator");
        FontSansSerifHeight = 0;
        fonts = null;
        location = Location.getLocation((Class)(class$com$sap$ip$mmr$foundation$Utilities == null ? (class$com$sap$ip$mmr$foundation$Utilities = Utilities.class$("com.sap.ip.mmr.foundation.Utilities")) : class$com$sap$ip$mmr$foundation$Utilities));
    }

    public class FormatterWithObjects
    extends TraceFormatter {
        public String format(LogRecord record) {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(record.getThreadName());
            sb.append("][");
            sb.append(Severity.toString((int)record.getSeverity()));
            sb.append("][");
            sb.append(record.getLocation());
            sb.append("] ");
            String message = record.getMsgClear();
            if (record.getArgObjs() != null && record.getArgObjs().size() > 0) {
                int n = 0;
                Iterator iter = record.getArgObjs().iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    String var = "{" + n + "}";
                    String value = "'";
                    value = o != null ? value + o.toString() : value + "<null>";
                    value = value + "'";
                    int index = message.indexOf(var);
                    if (index >= 0) {
                        message = message.substring(0, index) + value + message.substring(index + 3);
                    }
                    ++n;
                }
            }
            sb.append(message);
            sb.append('\n');
            return sb.toString();
        }
    }
}

