/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.applications.ProgressMonitorHTML;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

public class ThreadInformation
implements Comparable {
    public static final String STATE_RUNNING = "0running";
    public static final String STATE_INTERRUPTED = "1interrupted";
    public static final String STATE_FINISHED = "2finished";
    public static final String STATE_UNKNOWN = "3unknown";
    private Thread thread = null;
    private String tuid = Utilities.getUtilities().getGUID();
    private String page = "";
    private String description = "";
    private ProgressMonitorHTML pmOverall;
    private ProgressMonitorHTML pmDetail;
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private Log log;

    public ThreadInformation() {
        PrintStream ps = new PrintStream(this.baos);
        this.log = Utilities.getUtilities().getConsoleLog(ps);
    }

    public String getStatus() {
        String status = STATE_UNKNOWN;
        if (this.thread != null) {
            status = this.thread.isAlive() ? (this.thread.isInterrupted() ? STATE_INTERRUPTED : STATE_RUNNING) : STATE_FINISHED;
        }
        return status.substring(1);
    }

    public int compareTo(Object arg0) {
        int res = 0;
        if (arg0 instanceof ThreadInformation) {
            res = this.getStatus().compareTo(((ThreadInformation)arg0).getStatus());
        }
        if (res < 0) {
            res = -1;
        } else if (res > 0) {
            res = 1;
        }
        return res;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getTuid() {
        return this.tuid;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String string) {
        this.page = string;
    }

    public ProgressMonitorHTML getPmDetail() {
        return this.pmDetail;
    }

    public ProgressMonitorHTML getPmOverall() {
        return this.pmOverall;
    }

    public void setPmDetail(ProgressMonitorHTML monitorHTML) {
        this.pmDetail = monitorHTML;
    }

    public void setPmOverall(ProgressMonitorHTML monitorHTML) {
        this.pmOverall = monitorHTML;
    }

    public int getPriority() {
        int p = 0;
        if (this.thread != null) {
            p = this.thread.getPriority();
        }
        return p;
    }

    public Log getLog() {
        return this.log;
    }

    public String getLogAsString() {
        return new String(this.baos.toByteArray());
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setThread(Thread thread) {
        this.thread = thread;
    }
}

