/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.foundation.IGeneratorGUID;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Random;

public class RandomGUID
implements IGeneratorGUID {
    private Random myRand;
    private SecureRandom mySecureRand;
    private boolean secure;
    private String s_id;
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static MessageDigest md5;

    public RandomGUID(boolean secure) {
        this.secure = secure;
        this.initialize();
    }

    private void initialize() {
        if (this.secure) {
            this.mySecureRand = new SecureRandom();
        } else {
            this.myRand = new Random(System.currentTimeMillis());
        }
        this.s_id = null;
        try {
            Enumeration<NetworkInterface> enum1 = NetworkInterface.getNetworkInterfaces();
            while (this.s_id == null && enum1.hasMoreElements()) {
                NetworkInterface ni = enum1.nextElement();
                Enumeration<InetAddress> enum2 = ni.getInetAddresses();
                while (this.s_id == null && enum2.hasMoreElements()) {
                    InetAddress ia = enum2.nextElement();
                    String ha = ia.getHostAddress();
                    if (ha == null || ha.compareTo("127.0.0.1") == 0) continue;
                    this.s_id = ha;
                }
            }
        }
        catch (Exception e) {
            this.s_id = null;
        }
        if (this.s_id == null) {
            this.s_id = "127.0.0.1";
        }
    }

    public String getRandomGUID() {
        StringBuffer sb = this.getRandomGUIDSB();
        return sb == null ? null : sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized StringBuffer getRandomGUIDSB() {
        StringBuffer sb = new StringBuffer(40);
        try {
            long time = System.currentTimeMillis();
            long rand = 0L;
            rand = this.secure ? this.mySecureRand.nextLong() : this.myRand.nextLong();
            sb.append(this.s_id);
            sb.append(':');
            sb.append(Long.toString(time));
            sb.append(':');
            sb.append(Long.toString(rand));
            String valueBeforeMD5 = sb.toString();
            sb = new StringBuffer(36);
            byte[] array = null;
            MessageDigest messageDigest = md5;
            synchronized (messageDigest) {
                md5.update(valueBeforeMD5.getBytes());
                array = md5.digest();
            }
            for (int j = 0; j < array.length; ++j) {
                sb.append(hexChars[(array[j] & 0xF0) >> 4]);
                sb.append(hexChars[array[j] & 0xF]);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return sb;
    }

    public String getGUID() {
        StringBuffer sb = this.getRandomGUIDSB();
        sb.insert(8, '-');
        sb.insert(13, '-');
        sb.insert(18, '-');
        sb.insert(23, '-');
        sb.setLength(36);
        return sb.toString();
    }

    static {
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace(System.err);
        }
    }
}

