/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.foundation.Utilities;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PerformanceData {
    private String name;
    private Map data = new HashMap(128);

    public PerformanceData(String name) {
        this.name = name;
    }

    public void startTimer(String nameOfComponent, String nameOfTimer) {
        Timer timer = this.getTimer(nameOfComponent, nameOfTimer);
        if (timer != null) {
            timer.start();
        }
    }

    public void stopTimer(String nameOfComponent, String nameOfTimer) {
        Timer timer = this.getTimer(nameOfComponent, nameOfTimer);
        if (timer != null) {
            timer.stop();
        }
    }

    public String getElapsedTime(String nameOfComponent, String nameOfTimer) {
        Timer timer = this.getTimer(nameOfComponent, nameOfTimer);
        if (timer != null) {
            return timer.getTimeElapsedAsString();
        }
        return null;
    }

    public float getElapsedTimeAsFloat(String nameOfComponent, String nameOfTimer) {
        Timer timer = this.getTimer(nameOfComponent, nameOfTimer);
        if (timer != null) {
            return timer.getTimeElapsed();
        }
        return 0.0f;
    }

    private Counter getCounter(String nameOfComponent, String nameOfCounter) {
        Counter counter;
        if (nameOfComponent == null || nameOfCounter == null) {
            return null;
        }
        Data d = (Data)this.data.get(nameOfComponent);
        if (d == null) {
            d = new Data();
            this.data.put(nameOfComponent, d);
        }
        if ((counter = (Counter)d.counters.get(nameOfCounter)) == null) {
            counter = new Counter();
            d.counters.put(nameOfCounter, counter);
        }
        return counter;
    }

    private Timer getTimer(String nameOfComponent, String nameOfTimer) {
        Timer timer;
        if (nameOfComponent == null || nameOfTimer == null) {
            return null;
        }
        Data d = (Data)this.data.get(nameOfComponent);
        if (d == null) {
            d = new Data();
            this.data.put(nameOfComponent, d);
        }
        if ((timer = (Timer)d.timers.get(nameOfTimer)) == null) {
            timer = new Timer();
            d.timers.put(nameOfTimer, timer);
        }
        return timer;
    }

    public void incrementCounter(String nameOfComponent, String nameOfCounter) {
        Counter counter = this.getCounter(nameOfComponent, nameOfCounter);
        if (counter != null) {
            ++counter.n;
        }
    }

    public void addToCounter(String nameOfComponent, String nameOfCounter, long number) {
        Counter counter = this.getCounter(nameOfComponent, nameOfCounter);
        if (counter != null) {
            counter.n += number;
        }
    }

    public void subtractFromCounter(String nameOfComponent, String nameOfCounter, long number) {
        Counter counter = this.getCounter(nameOfComponent, nameOfCounter);
        if (counter != null) {
            counter.n -= number;
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("<table border frame=\"box\"  rules=\"cols\">");
        b.append("<tr><th align=\"left\">");
        b.append("Performance data of: " + this.name);
        b.append("</th></tr>");
        b.append(Utilities.SystemLineSeparator);
        Iterator i = this.data.keySet().iterator();
        while (i.hasNext()) {
            String key;
            Iterator j;
            String nameComp = (String)i.next();
            b.append("<tr><td align=\"left\"><table align=\"left\">");
            b.append("<tr><th align=\"left\" colspan=\"2\">");
            b.append("Component: " + nameComp);
            b.append("</th></tr>");
            b.append(Utilities.SystemLineSeparator);
            Data d = (Data)this.data.get(nameComp);
            b.append("<tr><td align=\"left\"><table border frame=\"box\"  rules=\"cols\" align=\"left\">");
            b.append("<tr><th align=\"left\">");
            b.append("Timers:");
            b.append("</th></tr>");
            b.append(Utilities.SystemLineSeparator);
            if (d.timers.size() > 0) {
                j = d.timers.keySet().iterator();
                while (j.hasNext()) {
                    key = (String)j.next();
                    Timer t = (Timer)d.timers.get(key);
                    b.append("<tr><td align=\"left\">");
                    b.append("Elapsed time, " + key + " = " + t.getTimeElapsedAsString());
                    b.append("</td></tr>");
                    b.append("<tr><td align=\"left\">");
                    b.append("Elapsed time [s], " + key + " = " + t.getTimeElapsedAsSecondsAsString());
                    b.append(Utilities.SystemLineSeparator);
                    b.append("</td></tr>");
                }
            }
            b.append("</table></td>");
            b.append("<td align=\"left\"><table border frame=\"box\"  rules=\"cols\" align=\"left\">");
            b.append("<tr><th align=\"left\">");
            b.append("Counters:");
            b.append("</th></tr>");
            b.append(Utilities.SystemLineSeparator);
            if (d.counters.size() > 0) {
                j = d.counters.keySet().iterator();
                while (j.hasNext()) {
                    key = (String)j.next();
                    Counter c = (Counter)d.counters.get(key);
                    b.append("<tr><td align=\"left\">");
                    b.append(key + " = " + c.n);
                    b.append(Utilities.SystemLineSeparator);
                    b.append("</td></tr>");
                }
            }
            b.append("</table></td></tr>");
            b.append("</table></td></tr>");
        }
        b.append("</table>");
        return b.toString();
    }

    private class Timer {
        private long timeStart;
        private long timeEnd;

        private Timer() {
        }

        public void start() {
            this.timeStart = System.currentTimeMillis();
        }

        public void stop() {
            this.timeEnd = System.currentTimeMillis();
        }

        public long getTimeElapsedInMillis() {
            return this.timeEnd - this.timeStart;
        }

        public float getTimeElapsed() {
            return 0.001f * (float)this.getTimeElapsedInMillis();
        }

        public String getTimeElapsedAsString() {
            return Utilities.getUtilities().getTimeFormated(this.getTimeElapsed());
        }

        public String getTimeElapsedAsSecondsAsString() {
            return String.valueOf(this.getTimeElapsed());
        }
    }

    private class Counter {
        public long n = 0L;

        private Counter() {
        }
    }

    private class Data {
        public Map counters = new HashMap(16);
        public Map timers = new HashMap(16);

        private Data() {
        }
    }
}

