/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.Hierarchy;
import com.sap.ip.mmr.foundation.IHierarchyNode;
import com.sap.ip.mmr.foundation.Utilities;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class HierarchyNode
implements IHierarchyNode {
    static final long serialVersionUID = 2224538589019664147L;
    private String mofId = Repository.createMofId();
    private String name;
    private transient boolean changed = true;
    private IHierarchyNode parent;
    private List children;

    protected HierarchyNode(String name) {
        this.name = name;
    }

    public IHierarchyNode getParent() {
        return this.parent;
    }

    public void setParent(IHierarchyNode parent) {
        if (parent != null) {
            this.parent = parent;
            this.setChanged(true, false);
            parent.addChild(this);
        }
    }

    public void addChild(IHierarchyNode node) {
        if (node != null && !this.getChildren().contains(node)) {
            this.setChanged(true, false);
            this.getChildren().add(node);
            ((HierarchyNode)node).setParent(this);
        }
    }

    public void addChild(int index, IHierarchyNode node) {
        if (node != null && !this.getChildren().contains(node)) {
            this.setChanged(true, false);
            this.getChildren().add(index, node);
            ((HierarchyNode)node).setParent(this);
        }
    }

    public void removeChild(IHierarchyNode node) {
        if (node != null) {
            this.setChanged(true, false);
            this.getChildren().remove(node);
        }
    }

    public void removeChild(int index) {
        this.setChanged(true, false);
        this.getChildren().remove(index);
    }

    protected List getChildren() {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        return this.children;
    }

    public void removeAllChildren() {
        this.setChanged(true, false);
        this.getChildren().clear();
    }

    public String getMofId() {
        return this.mofId;
    }

    public Hierarchy getHierarchy() {
        if (this.parent != null) {
            return ((HierarchyNode)this.parent).getHierarchy();
        }
        return null;
    }

    public String getDescription(Locale locale) {
        return this.getMofId();
    }

    public Iterator iterator() {
        return this.getChildren().iterator();
    }

    public void writeXMLTagStart(StringBuffer b) {
        b.append('<');
        b.append("node");
        b.append(' ');
        b.append("mofId");
        b.append("=\"");
        b.append(this.getMofId());
        b.append("\" ");
        b.append("name");
        b.append("=\"");
        b.append(this.getName());
        b.append("\"");
        b.append('>');
    }

    public void writeXMLTagContent(StringBuffer b) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            IHierarchyNode node = (IHierarchyNode)iter.next();
            node.writeXMLTagStart(b);
            node.writeXMLTagContent(b);
            node.writeXMLTagEnd(b);
        }
    }

    public void writeXMLTagEnd(StringBuffer b) {
        b.append("</");
        b.append("node");
        b.append('>');
    }

    public String getName() {
        return this.name;
    }

    public void setMofId(String mofId) {
        this.mofId = mofId;
    }

    public void setName(String name) {
        this.setChanged(true, false);
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }

    public String toString(int level) {
        StringBuffer b = new StringBuffer();
        b.append(Utilities.getUtilities().getSpaces(2 * level));
        String s = this.toString();
        b.append(s);
        int i = 70 - 2 * level - s.length();
        if (i < 0) {
            i = 0;
        }
        b.append(Utilities.getUtilities().getSpaces(i));
        b.append(this.getMofId());
        b.append('\n');
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            IHierarchyNode n = (IHierarchyNode)iter.next();
            b.append(n.toString(level + 1));
        }
        return b.toString();
    }

    public boolean isChanged() {
        if (this.changed) {
            return true;
        }
        boolean b = false;
        Iterator iter = this.iterator();
        while (iter.hasNext() && !b) {
            IHierarchyNode n = (IHierarchyNode)iter.next();
            if (!n.isChanged()) continue;
            b = true;
        }
        return b;
    }

    public void setChanged(boolean changed, boolean deep) {
        this.changed = changed;
        if (deep) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                IHierarchyNode n = (IHierarchyNode)iter.next();
                n.setChanged(changed, deep);
            }
        }
    }
}

