/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.foundation;

import com.sap.ip.mmr.IRepositoryClassLoader;
import com.sap.ip.mmr.Repository;
import com.sap.ip.mmr.foundation.MMRResourceAccessor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassLoaderMMR
extends ClassLoader {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$foundation$ClassLoaderMMR == null ? (class$com$sap$ip$mmr$foundation$ClassLoaderMMR = ClassLoaderMMR.class$("com.sap.ip.mmr.foundation.ClassLoaderMMR")) : class$com$sap$ip$mmr$foundation$ClassLoaderMMR);
    private Set classPaths = new HashSet();
    private Map classesLoaded = new HashMap();
    private ClassLoader clSystem;
    private ClassLoader clThread;
    private ClassLoader clClass;
    private IRepositoryClassLoader rcl;
    private boolean debugMode = false;
    static /* synthetic */ Class class$com$sap$ip$mmr$foundation$ClassLoaderMMR;

    private void println(String str) {
        if (this.debugMode) {
            System.out.println(str);
        }
    }

    public ClassLoaderMMR(ClassLoader parent) {
        super(parent);
    }

    public ClassLoaderMMR(ClassLoader parent, IRepositoryClassLoader rcl) {
        super(parent);
        this.rcl = rcl;
    }

    public void addClassPaths(String paths) {
        String method = "addClassPaths(String paths)";
        location.debugT("addClassPaths(String paths)", MMRResourceAccessor.getInstance().getMessageText("2410"), new Object[]{paths});
        List list = Utilities.getUtilities().splitClassPath(paths);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            this.addClassPath(path);
        }
    }

    public void addClassPath(String path) {
        if (path == null || path.length() < 1) {
            return;
        }
        String method = "addClassPath(String path)";
        File f = new File(path);
        if (f.exists() && f.isFile()) {
            location.debugT("addClassPath(String path)", MMRResourceAccessor.getInstance().getMessageText("2411"), new Object[]{path});
            this.classPaths.add(path);
        }
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        Class<?> result;
        String method = "findClass(String className)";
        location.debugT("findClass(String className)", MMRResourceAccessor.getInstance().getMessageText("2412"), new Object[]{className});
        if (this.clThread != null && !this.clThread.equals(this)) {
            this.println("[ClassLoaderMMR] findClass using clThread=" + this.clThread);
            try {
                result = this.clThread.loadClass(className);
            }
            catch (Exception e) {
                result = null;
            }
            if (result != null) {
                location.debugT("findClass(String className)", MMRResourceAccessor.getInstance().getMessageText("2413"), new Object[]{className});
                this.println("[ClassLoaderMMR] found " + className + " using clThread=" + this.clThread);
                return result;
            }
        }
        if (this.clClass != null && !this.clClass.equals(this) && !this.clClass.equals(this.clThread)) {
            this.println("[ClassLoaderMMR] findClass using clClass=" + this.clClass);
            try {
                result = this.clClass.loadClass(className);
            }
            catch (Exception e) {
                result = null;
            }
            if (result != null) {
                location.debugT("findClass(String className)", MMRResourceAccessor.getInstance().getMessageText("2413"), new Object[]{className});
                this.println("[ClassLoaderMMR] found " + className + " using clClass=" + this.clClass);
                return result;
            }
        }
        if (!(this.clSystem == null || this.clSystem.equals(this) || this.clSystem.equals(this.clThread) || this.clSystem.equals(this.clClass))) {
            this.println("[ClassLoaderMMR] findClass using clSystem=" + this.clSystem);
            try {
                result = this.clSystem.loadClass(className);
            }
            catch (Exception e) {
                result = null;
            }
            if (result != null) {
                location.debugT("findClass(String className)", MMRResourceAccessor.getInstance().getMessageText("2413"), new Object[]{className});
                this.println("[ClassLoaderMMR] found " + className + " using clSystem=" + this.clSystem);
                return result;
            }
        }
        if ((result = (Class<?>)this.classesLoaded.get(className)) != null) {
            location.debugT("findClass(String className)", MMRResourceAccessor.getInstance().getMessageText("2415"), new Object[]{className});
            this.println("[ClassLoaderMMR] found " + className + " using cache of " + this);
            return result;
        }
        byte[] classData = this.loadClassData(className);
        if (classData == null) {
            this.println("[ClassLoaderMMR] NOT found " + className + " by " + this);
            throw new ClassNotFoundException();
        }
        result = this.defineClass(className, classData, 0, classData.length);
        if (result == null) {
            throw new ClassFormatError();
        }
        this.println("[ClassLoaderMMR] found " + className + " using own=" + this);
        this.resolveClass(result);
        this.classesLoaded.put(className, result);
        location.debugT("findClass(String className)", MMRResourceAccessor.getInstance().getMessageText("2416"), new Object[]{className});
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] getBytesOfInputStream(InputStream is) {
        byte[] bytes;
        block9: {
            String method = "getBytesOfInputStream(InputStream is)";
            bytes = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            int size = 4096;
            byte[] data = new byte[4096];
            int n = 0;
            while (n >= 0) {
                n = is.read(data, 0, 4096);
                if (n <= 0) continue;
                baos.write(data, 0, n);
            }
            bytes = baos.toByteArray();
            Object var9_9 = null;
            try {
                is.close();
                baos.close();
            }
            catch (IOException e1) {
                Repository.category.errorT(location, e1.toString());
            }
            break block9;
            {
                catch (IOException e) {
                    bytes = null;
                    Repository.category.errorT(location, "getBytesOfInputStream(InputStream is)", e.toString());
                    Object var9_10 = null;
                    try {
                        is.close();
                        baos.close();
                    }
                    catch (IOException e1) {
                        Repository.category.errorT(location, e1.toString());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    is.close();
                    baos.close();
                }
                catch (IOException e1) {
                    Repository.category.errorT(location, e1.toString());
                }
                throw throwable;
            }
        }
        return bytes;
    }

    private byte[] loadClassData(String name) {
        String method = "loadClassData(String name)";
        JarFile jarFile = null;
        JarEntry je = null;
        byte[] data = null;
        Iterator iter = this.classPaths.iterator();
        while (iter.hasNext() && je == null) {
            String path = (String)iter.next();
            if (path.indexOf(".jar") < 0 && path.indexOf(".zip") < 0) continue;
            try {
                jarFile = new JarFile(path);
            }
            catch (IOException e) {
                Repository.getCategory().errorT(location, "loadClassData(String name)", MMRResourceAccessor.getInstance().getMessageText("2417"), new Object[]{path});
                jarFile = null;
            }
            if (jarFile == null) continue;
            je = jarFile.getJarEntry(name);
            if (je == null) {
                location.debugT("loadClassData(String name)", MMRResourceAccessor.getInstance().getMessageText("2418"), new Object[]{name, path});
            } else {
                try {
                    data = this.getBytesOfInputStream(jarFile.getInputStream(je));
                }
                catch (IOException e) {
                    location.errorT("loadClassData(String name)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
                }
            }
            try {
                jarFile.close();
            }
            catch (IOException e1) {
                Repository.getCategory().errorT(location, "loadClassData(String name)", e1.toString());
            }
        }
        if (data == null && this.rcl != null) {
            data = this.rcl.loadJavaClass(name, this.rcl.getWorkspaces());
        }
        return data;
    }

    protected final Enumeration findResources(String name) {
        String method = "findResources(String name)";
        Vector<URL> v = new Vector<URL>();
        Enumeration<URL> enumeration = null;
        if (this.clThread != null && !this.clThread.equals(this)) {
            try {
                enumeration = this.clThread.getResources(name);
            }
            catch (Exception e) {
                enumeration = null;
            }
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    v.add(enumeration.nextElement());
                }
                enumeration = null;
            }
        }
        if (this.clClass != null && !this.clClass.equals(this) && !this.clClass.equals(this.clThread)) {
            try {
                enumeration = this.clClass.getResources(name);
            }
            catch (Exception e) {
                enumeration = null;
            }
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    v.add(enumeration.nextElement());
                }
                enumeration = null;
            }
        }
        if (!(this.clSystem == null || this.clSystem.equals(this) || this.clSystem.equals(this.clThread) || this.clSystem.equals(this.clClass))) {
            try {
                enumeration = this.clSystem.getResources(name);
            }
            catch (Exception e) {
                enumeration = null;
            }
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    v.add(enumeration.nextElement());
                }
                enumeration = null;
            }
        }
        JarFile jarFile = null;
        JarEntry je = null;
        Iterator iter = this.classPaths.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            try {
                File f = new File(path);
                if (f.exists() && f.isFile()) {
                    jarFile = new JarFile(f);
                }
            }
            catch (IOException e) {
                location.errorT("findResources(String name)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
                jarFile = null;
            }
            if (jarFile == null) continue;
            je = jarFile.getJarEntry(name);
            if (je != null) {
                URL url = null;
                try {
                    url = new URL("file", null, 0, jarFile.getName() + "!/" + je.getName());
                    v.add(url);
                }
                catch (MalformedURLException e1) {
                    location.errorT("findResources(String name)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e1.toString()});
                }
            }
            try {
                jarFile.close();
            }
            catch (IOException e1) {
                Repository.getCategory().errorT(location, "findResources(String name)", e1.toString());
            }
        }
        return v.elements();
    }

    public InputStream getResourceAsStream(String name) {
        String method = "getResourceAsStream(String name)";
        InputStream is = super.getResourceAsStream(name);
        location.debugT("getResourceAsStream(String name)", MMRResourceAccessor.getInstance().getMessageText("2419"), new Object[]{name});
        ClassLoader parent = this.getParent();
        if (is == null && this.clThread != null && !this.clThread.equals(this) && !this.clThread.equals(parent)) {
            try {
                is = this.clThread.getResourceAsStream(name);
            }
            catch (Exception e) {
                is = null;
            }
        }
        if (!(is != null || this.clClass == null || this.clClass.equals(this) || this.clClass.equals(parent) || this.clClass.equals(this.clThread))) {
            try {
                is = this.clClass.getResourceAsStream(name);
            }
            catch (Exception e) {
                is = null;
            }
        }
        if (!(is != null || this.clSystem == null || this.clSystem.equals(this) || this.clThread.equals(parent) || this.clSystem.equals(this.clThread) || this.clSystem.equals(this.clClass))) {
            try {
                is = this.clSystem.getResourceAsStream(name);
            }
            catch (Exception e) {
                is = null;
            }
        }
        if (is == null) {
            JarFile jarFile = null;
            JarEntry je = null;
            Iterator iter = this.classPaths.iterator();
            while (iter.hasNext() && je == null) {
                String path = (String)iter.next();
                try {
                    File f = new File(path);
                    if (f.exists() && f.isFile()) {
                        jarFile = new JarFile(f);
                    }
                }
                catch (IOException e) {
                    location.errorT("getResourceAsStream(String name)", MMRResourceAccessor.getInstance().getMessageText("0003"), new Object[]{e.toString()});
                    jarFile = null;
                }
                if (jarFile == null) continue;
                je = jarFile.getJarEntry(name);
                if (je != null) {
                    location.debugT("getResourceAsStream(String name)", MMRResourceAccessor.getInstance().getMessageText("2419"), new Object[]{name, jarFile.getName()});
                    try {
                        InputStream is_ = jarFile.getInputStream(je);
                        byte[] bytes = new byte[1024];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int n = 0;
                        do {
                            if ((n = is_.read(bytes)) <= 0) continue;
                            baos.write(bytes, 0, n);
                        } while (n > 0);
                        is = new ByteArrayInputStream(baos.toByteArray());
                        is_.close();
                    }
                    catch (IOException e) {
                        Repository.category.errorT(location, e.toString());
                    }
                }
                try {
                    jarFile.close();
                }
                catch (IOException e1) {
                    Repository.getCategory().errorT(location, "getResourceAsStream(String name)", e1.toString());
                }
            }
        }
        return is;
    }

    public ClassLoader getClSystem() {
        return this.clSystem;
    }

    public ClassLoader getClThread() {
        return this.clThread;
    }

    public void setClSystem(ClassLoader loader) {
        this.clSystem = loader;
    }

    public void setClThread(ClassLoader loader) {
        this.clThread = loader;
    }

    public ClassLoader getClClass() {
        return this.clClass;
    }

    public void setClClass(ClassLoader loader) {
        this.clClass = loader;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

