/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.dbmodel;

import com.sap.ip.mmr.dbmodel.Column;
import com.sap.ip.mmr.dbmodel.Index;
import com.sap.ip.mmr.foundation.Utilities;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Table {
    private String tableName = null;
    private LinkedList columns = null;
    private LinkedList indexes = null;

    public Table(String tableName) {
        this.tableName = tableName;
        this.initialize();
    }

    public Table(Table otherTable) {
        this.tableName = otherTable.getName();
        this.initialize();
        for (int i = 0; i < otherTable.getColumnSize(); ++i) {
            this.columns.add(otherTable.getColumn(i));
        }
    }

    private final void initialize() {
        this.columns = new LinkedList();
        this.indexes = new LinkedList();
    }

    public void addColumns(Table otherTable) {
        for (int i = 0; i < otherTable.getColumnSize(); ++i) {
            this.addColumn(otherTable.getColumn(i));
        }
    }

    public String getName() {
        return this.tableName;
    }

    public void addColumn(String columnName, int type, int size, boolean isKey) {
        Column column = new Column(columnName, type, size, isKey);
        this.columns.add(column);
    }

    public void addColumn(Column aColumn) {
        this.addColumn(aColumn.name, aColumn.type, aColumn.size, aColumn.isKey);
    }

    public void removeColumn(int columnIndex) {
        this.columns.remove(columnIndex);
    }

    public int getColumnSize() {
        return this.columns.size();
    }

    public Column getColumn(int index) {
        if (index < 0 || index >= this.columns.size()) {
            return null;
        }
        return (Column)this.columns.get(index);
    }

    public void addIndex(Index index) {
        this.indexes.add(index);
    }

    public void removeIndex(String indexName) {
        Iterator iter = this.indexes.iterator();
        while (iter.hasNext()) {
            Index index = (Index)iter.next();
            if (index.getName().compareTo(indexName) != 0) continue;
            iter.remove();
        }
    }

    public List getIndexes() {
        return this.indexes;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(100);
        b.append("Table: ");
        b.append(this.tableName);
        b.append(Utilities.SystemLineSeparator);
        b.append("  Columns:");
        b.append(Utilities.SystemLineSeparator);
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            Column c = (Column)iter.next();
            b.append("    ");
            b.append(c);
            b.append(Utilities.SystemLineSeparator);
        }
        b.append("  Indexes:");
        b.append(Utilities.SystemLineSeparator);
        iter = this.indexes.iterator();
        while (iter.hasNext()) {
            Index i = (Index)iter.next();
            b.append("    ");
            b.append(i);
            b.append(Utilities.SystemLineSeparator);
        }
        return b.toString();
    }

    public String getColumnList() {
        StringBuffer b = new StringBuffer();
        b.append('(');
        Iterator iter = this.columns.iterator();
        while (iter.hasNext()) {
            Column c = (Column)iter.next();
            b.append(c.name);
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        b.append(')');
        return b.toString();
    }
}

