/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.dbmemory;

import com.sap.ip.mmr.StateEnum;
import com.sap.ip.mmr.foundation.AssociationsOfObject;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.m1layer.IMMRObject;
import com.sap.ip.mmr.m2layer.IModelElement;
import com.sap.ip.mmr.m2layer.model.ModelElementImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefBaseObject;

public class Cache
extends HashMap {
    public static final long FOREVER = 3153600000000L;
    protected long timeToLive = 3153600000000L;
    protected Map timestamps = new HashMap();

    public Cache() {
    }

    public Cache(int size) {
        super(size);
    }

    public Cache(long timeToLive) {
        this.setTimeToLive(timeToLive);
    }

    public Cache(int size, long timeToLive) {
        super(size);
        this.setTimeToLive(timeToLive);
    }

    public Cache(Map m) {
        super(m);
    }

    public synchronized Collection garbageCollector() {
        LinkedList<String> col = new LinkedList<String>();
        ArrayList list = new ArrayList(this.size());
        list.addAll(this.keySet());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String mofId = (String)iter.next();
            if (this.check(mofId) != null) continue;
            col.add(mofId);
        }
        return col;
    }

    public List getAll() {
        ArrayList<RefBaseObject> refBaseObjs = new ArrayList<RefBaseObject>();
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            RefBaseObject rbo = (RefBaseObject)it.next();
            if ((rbo = this.check(rbo)) == null) continue;
            refBaseObjs.add(rbo);
        }
        return refBaseObjs;
    }

    public List getAllChanged() {
        ArrayList<RefBaseObject> refBaseObjs = new ArrayList<RefBaseObject>();
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            RefBaseObject rbo = (RefBaseObject)it.next();
            if ((rbo = this.check(rbo)) == null || rbo instanceof ModelElementImpl && ((ModelElementImpl)rbo).getState() == StateEnum.STATE_UNCHANGED || rbo instanceof IMMRObject && ((IMMRObject)rbo).get___State() == StateEnum.STATE_UNCHANGED) continue;
            refBaseObjs.add(rbo);
        }
        return refBaseObjs;
    }

    public List getByMofIds(Collection mofIds) {
        if (mofIds == null || mofIds.size() <= 0) {
            return null;
        }
        ArrayList<RefBaseObject> refBaseObjs = new ArrayList<RefBaseObject>(mofIds.size());
        Iterator it = mofIds.iterator();
        while (it.hasNext()) {
            String mofId = (String)it.next();
            RefBaseObject rbo = (RefBaseObject)this.get(mofId);
            if ((rbo = this.check(rbo)) == null) continue;
            refBaseObjs.add(rbo);
        }
        return refBaseObjs;
    }

    public List getAll(Collection objects) {
        if (objects == null) {
            return this.getAll();
        }
        ArrayList<RefBaseObject> refBaseObjs = new ArrayList<RefBaseObject>(objects.size());
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            RefBaseObject rbo = (RefBaseObject)it.next();
            RefBaseObject rbo_ = (RefBaseObject)this.get(rbo.refMofId());
            if ((rbo_ = this.check(rbo_)) == null) continue;
            refBaseObjs.add(rbo_);
        }
        return refBaseObjs;
    }

    public List getAllChanged(Collection objects) {
        if (objects == null) {
            return this.getAllChanged();
        }
        ArrayList<RefBaseObject> refBaseObjs = new ArrayList<RefBaseObject>(objects.size());
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            RefBaseObject rbo = (RefBaseObject)it.next();
            RefBaseObject rbo_ = (RefBaseObject)this.get(rbo.refMofId());
            if ((rbo_ = this.check(rbo_)) == null || (rbo_ instanceof ModelElementImpl ? ((ModelElementImpl)rbo_).getState() == StateEnum.STATE_UNCHANGED : rbo_ instanceof IMMRObject && ((IMMRObject)rbo_).get___State() == StateEnum.STATE_UNCHANGED)) continue;
            refBaseObjs.add(rbo_);
        }
        return refBaseObjs;
    }

    public List getAllOfType(String qualifiedNameOfType) {
        ArrayList<RefBaseObject> refBaseObjs = new ArrayList<RefBaseObject>();
        Iterator it = this.values().iterator();
        while (it.hasNext()) {
            RefBaseObject rbo = (RefBaseObject)it.next();
            String cln = this.getQualifiedNameOfType(rbo);
            if (cln.indexOf(qualifiedNameOfType) != 0 || cln.substring(qualifiedNameOfType.length()).indexOf("ClassImpl") == 0 || cln.substring(qualifiedNameOfType.length()).indexOf("PackageImpl") == 0 || (rbo = this.check(rbo)) == null) continue;
            refBaseObjs.add(rbo);
        }
        return refBaseObjs;
    }

    private String getQualifiedNameOfType(RefBaseObject rbo) {
        if (rbo instanceof IMMRObject) {
            IMMRObject mmrObj = (IMMRObject)rbo;
            return mmrObj.get___QualifiedName();
        }
        return rbo.getClass().getName();
    }

    public Collection putAll(Collection collection) {
        Collection colFailed = null;
        if (collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof RefBaseObject) {
                    this.setTimestamp((RefBaseObject)o);
                    this.put(o);
                    continue;
                }
                if (!(o instanceof AssociationsOfObject)) continue;
                AssociationsOfObject aoo = (AssociationsOfObject)o;
                this.setTimestamp(aoo.getMofId());
                this.put(aoo.getMofId(), aoo);
            }
        }
        return colFailed;
    }

    public void putAll(Map map) {
        if (map != null) {
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof RefBaseObject) {
                    this.setTimestamp((RefBaseObject)o);
                    this.put(o);
                    continue;
                }
                if (!(o instanceof AssociationsOfObject)) continue;
                AssociationsOfObject aoo = (AssociationsOfObject)o;
                this.setTimestamp(aoo.getMofId());
                this.put(aoo.getMofId(), aoo);
            }
        }
    }

    public void put(Object object) {
        if (object != null) {
            Object o = this.get(object);
            if (o != null && (o instanceof IMMRObject ? ((IMMRObject)o).get___State().equals(StateEnum.STATE_DELETED) : o instanceof IModelElement && ((IModelElement)o).getState().equals(StateEnum.STATE_DELETED))) {
                return;
            }
            this.remove(object);
            if (object instanceof IModelElement) {
                this.put(((IModelElement)object).refMofId(), object);
                this.setTimestamp(((IModelElement)object).refMofId());
            } else if (object instanceof IMMRObject) {
                this.put(((IMMRObject)object).get___MofId(), object);
                this.setTimestamp(((IMMRObject)object).get___MofId());
            } else if (object instanceof AssociationsOfObject) {
                AssociationsOfObject aoo = (AssociationsOfObject)object;
                this.setTimestamp(aoo.getMofId());
                this.put(aoo.getMofId(), aoo);
            }
        }
    }

    public RefBaseObject get(RefBaseObject refBaseObject) {
        RefBaseObject rbo = null;
        if (refBaseObject != null) {
            rbo = (RefBaseObject)this.get(refBaseObject.refMofId());
            rbo = this.check(rbo);
        }
        return rbo;
    }

    public Object remove(Object object) {
        Object old = null;
        if (object != null) {
            String key = null;
            if (object instanceof String) {
                key = (String)object;
            } else if (object instanceof IModelElement) {
                key = ((IModelElement)object).refMofId();
            } else if (object instanceof IMMRObject) {
                key = ((IMMRObject)object).get___MofId();
            }
            if (key != null) {
                old = super.remove(key);
            }
        }
        return old;
    }

    public Collection remove(Collection modelElements) {
        Collection colFailed = null;
        if (modelElements != null) {
            Iterator iter = modelElements.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof RefBaseObject)) continue;
                RefBaseObject rbo = (RefBaseObject)o;
                this.remove(rbo.refMofId());
            }
        }
        return colFailed;
    }

    public StringBuffer getInfo(StringBuffer sb) {
        StringBuffer info = null;
        info = sb == null ? new StringBuffer(1000) : sb;
        info.append(" # objects: " + this.size() + Utilities.SystemLineSeparator);
        return info;
    }

    public long getTimeToLive() {
        return this.timeToLive / 1000L;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive * 1000L;
    }

    private RefBaseObject check(RefBaseObject rbo) {
        if (rbo == null) {
            return null;
        }
        if (this.check(rbo.refMofId()) == null) {
            return null;
        }
        return rbo;
    }

    private String check(String mofId) {
        Long timestamp = (Long)this.timestamps.get(mofId);
        if (timestamp == null) {
            this.remove(mofId);
            return null;
        }
        long diff = Utilities.getUtilities().getTime() - timestamp;
        if (diff > this.timeToLive) {
            this.remove(mofId);
            return null;
        }
        return mofId;
    }

    public boolean containsKey(Object arg0) {
        if (arg0 instanceof RefBaseObject) {
            this.check((RefBaseObject)arg0);
        } else if (arg0 instanceof String) {
            this.check((String)arg0);
        }
        return super.containsKey(arg0);
    }

    public boolean containsValue(Object arg0) {
        if (arg0 instanceof RefBaseObject) {
            this.check((RefBaseObject)arg0);
        } else if (arg0 instanceof String) {
            this.check((String)arg0);
        }
        return super.containsValue(arg0);
    }

    public Object get(Object arg0) {
        if (arg0 == null) {
            return null;
        }
        if (arg0 instanceof RefBaseObject) {
            this.check((RefBaseObject)arg0);
        } else if (arg0 instanceof String) {
            this.check((String)arg0);
        }
        return super.get(arg0);
    }

    public Object put(Object arg0, Object arg1) {
        this.setTimestamp((String)arg0);
        return super.put(arg0, arg1);
    }

    private void setTimestamp(RefBaseObject rbo) {
        this.setTimestamp(rbo.refMofId());
    }

    private final void setTimestamp(String mofId) {
        this.timestamps.put(mofId, new Long(Utilities.getUtilities().getTime()));
    }

    public final void clear() {
        super.clear();
        this.timestamps.clear();
    }

    public synchronized List getAllDeleted() {
        ArrayList<IMMRObject> list = new ArrayList<IMMRObject>();
        Iterator i = this.values().iterator();
        while (i.hasNext()) {
            IMMRObject mmro;
            Object o = i.next();
            if (!(o instanceof IMMRObject) || !StateEnum.STATE_DELETED.equals((mmro = (IMMRObject)o).get___State())) continue;
            list.add(mmro);
        }
        return list;
    }

    public synchronized void setDeleted(Collection instances) {
        if (instances != null) {
            Iterator i = instances.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof IMMRObject)) continue;
                IMMRObject mmroIn = (IMMRObject)o;
                IMMRObject mmro = (IMMRObject)this.get(mmroIn);
                if (mmro != null) {
                    mmro.set___State(StateEnum.STATE_DELETED);
                }
                mmroIn.set___State(StateEnum.STATE_DELETED);
            }
        }
    }
}

