/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.cache;

import com.sap.ip.mmr.cache.CacheObjectsEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jmi.reflect.RefObject;

public class CacheObjects {
    public static final int noLimit = -1;
    private Map cache = null;
    private int maxNumOfObjects = -1;

    public CacheObjects() {
        this.initialize();
    }

    public CacheObjects(int maxNumOfObjects) {
        this.maxNumOfObjects = maxNumOfObjects;
        this.initialize();
    }

    private final void initialize() {
        int n = this.maxNumOfObjects;
        if (n < 100) {
            n = 100;
        }
        this.cache = new HashMap(n);
    }

    public synchronized void put(String key, Object o) {
        if (key != null && o != null) {
            if (!this.cache.containsKey(key)) {
                CacheObjectsEntry cacheObjectsEntry = new CacheObjectsEntry(o);
                this.cache.put(key, cacheObjectsEntry);
            } else {
                CacheObjectsEntry cacheObjectsEntry = (CacheObjectsEntry)this.cache.get(key);
                cacheObjectsEntry.setObject(o);
            }
        }
    }

    public synchronized void putAll(Collection col) {
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof RefObject)) continue;
            this.put(((RefObject)o).refMofId(), o);
        }
    }

    public synchronized Object get(String key) {
        if (key == null) {
            return null;
        }
        if (this.cache.containsKey(key)) {
            CacheObjectsEntry cacheObjectsEntry = (CacheObjectsEntry)this.cache.get(key);
            return cacheObjectsEntry.getObject();
        }
        return null;
    }

    public synchronized boolean contains(String key) {
        if (key == null) {
            return false;
        }
        return this.cache.containsKey(key);
    }

    public synchronized Collection getAll() {
        ArrayList<Object> list = new ArrayList<Object>(this.cache.size());
        Iterator i = this.cache.keySet().iterator();
        while (i.hasNext()) {
            CacheObjectsEntry cacheObjectsEntry = (CacheObjectsEntry)this.cache.get(i.next());
            list.add(cacheObjectsEntry.getObject());
        }
        return list;
    }

    public synchronized void remove(String key) {
        if (key != null) {
            this.cache.remove(key);
        }
    }

    public synchronized void clear() {
        this.cache.clear();
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("CacheObjects\n");
        buf.append(this.cache.size());
        buf.append("  objects\n");
        Iterator iter = this.cache.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            CacheObjectsEntry cacheObjectsEntry = (CacheObjectsEntry)this.cache.get(key);
            buf.append("    ");
            buf.append(key);
            buf.append(": ");
            buf.append(cacheObjectsEntry.getReads());
            buf.append(" reads, ");
            buf.append(cacheObjectsEntry.getUpdates());
            buf.append(" updates\n");
        }
        return buf.toString();
    }
}

