/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ip.mmr.applications;

import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IRepositoryConst;
import com.sap.ip.mmr.applications.IProgressMonitor;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import java.util.Collection;
import javax.resource.ResourceException;

public class SynchronizeWorkspaces {
    protected static final Location location = Utilities.getUtilities().getLocation(class$com$sap$ip$mmr$applications$SynchronizeWorkspaces == null ? (class$com$sap$ip$mmr$applications$SynchronizeWorkspaces = SynchronizeWorkspaces.class$("com.sap.ip.mmr.applications.SynchronizeWorkspaces")) : class$com$sap$ip$mmr$applications$SynchronizeWorkspaces);
    private Workspace wsSource = null;
    private Workspace wsTarget = null;
    private IConnection conSource = null;
    private IConnection conTarget = null;
    private IProgressMonitor pmOverall = null;
    private IProgressMonitor pmEachType = null;
    static /* synthetic */ Class class$com$sap$ip$mmr$applications$SynchronizeWorkspaces;

    public SynchronizeWorkspaces(Workspace wsSource, Workspace wsTarget, IProgressMonitor pmOverall, IProgressMonitor pmEachType) {
        this.wsSource = wsSource;
        this.wsTarget = wsTarget;
        this.pmOverall = pmOverall;
        this.pmEachType = pmEachType;
    }

    public Collection synchronize(IRepositoryConst.SynchronizationMode mode, Log log) {
        this.addLog(log);
        if (mode == IRepositoryConst.SynchronizationMode.MODE_COPY) {
            this.initConnections(log, true, false);
        } else if (mode == IRepositoryConst.SynchronizationMode.MODE_COMPARE) {
            this.initConnections(log, true, true);
        } else if (mode == IRepositoryConst.SynchronizationMode.MODE_UPDATE) {
            this.initConnections(log, true, false);
        } else if (mode == IRepositoryConst.SynchronizationMode.MODE_SYNCHRONIZE) {
            this.initConnections(log, false, false);
        }
        Collection col = this.conTarget.getRepository().synchronizeWorkspaces(this.conSource, mode);
        this.closeConnections(log);
        this.removeLog(log);
        return col;
    }

    private void addLog(Log log) {
    }

    private void removeLog(Log log) {
    }

    private void initConnections(Log log, boolean sourceReadOnly, boolean targetReadOnly) {
        if (this.conSource != null) {
            try {
                this.conSource.close();
            }
            catch (ResourceException e) {
                location.errorT(e.toString());
            }
        }
        if (this.conTarget != null) {
            try {
                this.conTarget.close();
            }
            catch (ResourceException e) {
                location.errorT(e.toString());
            }
        }
        ConnectionFactory cf = new ConnectionFactory();
        ConnectionSpec cs = new ConnectionSpec();
        cs.getWorkspacesM1().clear();
        cs.getWorkspacesM1().add(this.wsSource);
        if (sourceReadOnly) {
            this.wsSource.setReadOnly(true);
        }
        cs.setLog(log);
        try {
            this.conSource = cf.getConnection(cs);
        }
        catch (ResourceException e) {
            location.errorT(e.toString());
        }
        cs = new ConnectionSpec();
        cs.getWorkspacesM1().clear();
        cs.getWorkspacesM1().add(this.wsTarget);
        cs.setLog(log);
        if (targetReadOnly) {
            this.wsTarget.setReadOnly(true);
        }
        try {
            this.conTarget = cf.getConnection(cs);
        }
        catch (ResourceException e) {
            location.errorT(e.toString());
        }
        this.conSource.getConnectionSpec().setPmOverall(this.pmOverall);
        this.conSource.getConnectionSpec().setPmDetail(this.pmEachType);
    }

    private void closeConnections(Log log) {
        if (this.conSource != null) {
            try {
                this.conSource.close();
            }
            catch (ResourceException e) {
                location.errorT(e.toString());
            }
        }
        if (this.conTarget != null) {
            try {
                this.conTarget.close();
            }
            catch (ResourceException e) {
                location.errorT(e.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static final class SynchronizeWorkspacesThread
    extends Thread {
        private SynchronizeWorkspaces sw = null;
        private IRepositoryConst.SynchronizationMode mode = null;
        private Log log = null;
        private boolean isInterrupted = false;

        public SynchronizeWorkspacesThread(Workspace wsSource, Workspace wsTarget, IProgressMonitor pmOverall, IProgressMonitor pmEachType, IRepositoryConst.SynchronizationMode mode, Log log) {
            this.sw = new SynchronizeWorkspaces(wsSource, wsTarget, pmOverall, pmEachType);
            this.mode = mode;
            this.log = log;
            this.setPriority(1);
        }

        public void destroy() {
            super.destroy();
            this.sw.closeConnections(this.log);
            this.sw = null;
        }

        public void interrupt() {
            super.interrupt();
            this.isInterrupted = true;
        }

        public boolean isInterrupted() {
            if (super.isInterrupted()) {
                this.isInterrupted = true;
            }
            return this.isInterrupted;
        }

        public void run() {
            this.isInterrupted = false;
            this.sw.synchronize(this.mode, this.log);
        }
    }
}

